/* ============================================================
 * File  : prop_menu.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "prop_menu.h"

prop_menu::prop_menu ( QWidget * parent )
    : QFrame(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);

        myeffect = new QGraphicsOpacityEffect();
        myeffect->setOpacity(0.0);
        this->setAttribute(Qt::WA_TranslucentBackground, true);
        this->setGraphicsEffect(myeffect);
}

void prop_menu::letvisible()
{
    QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "opacity");
    animation->setDuration(500);
    animation->setStartValue(qreal(myeffect->opacity()));
    animation->setEndValue(qreal(1.0));
    animation->start();
}

void prop_menu::lethidden()
{
    QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "opacity");
    connect(animation,SIGNAL(finished()),this,SLOT(f_fin_hide()));
    animation->setDuration(500);
    animation->setStartValue(qreal(myeffect->opacity()));
    animation->setEndValue(qreal(0.0));
    animation->start();
}

void prop_menu::f_fin_hide()
{
    this->hide();
}

// ********************************
// *** DESSIN DU FOND DU WIDGET ***
// ********************************

void prop_menu::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);
        p.setPen(Qt::NoPen);
        p.setBrush(QColor(0,0,0,200));
        p.drawRect(0, 0, this->width(), this->height());
	p.end();
}

