/* ============================================================
 * File  : regles.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "regles.h"

regles::regles ( QWidget * parent )
    : QLabel(parent)
{
    this->setAttribute(Qt::WA_DeleteOnClose);
    //this->setMouseTracking(true);
    this->setScaledContents(true);

    QColor wg_color_1 = QApplication::palette().color(QPalette::Normal, QPalette::Highlight);

    myeffect = new QGraphicsColorizeEffect();
    myeffect->setStrength(0);
    myeffect->setColor(wg_color_1);
    this->setAttribute(Qt::WA_TranslucentBackground, true);
    this->setGraphicsEffect(myeffect);
}

// *************************************
// *** GESTION DES EVENEMENTS SOURIS ***
// *************************************

void regles::enterEvent(QEvent *)
{
    QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "strength");
    animation->setDuration(500);
    animation->setStartValue(myeffect->strength());
    animation->setEndValue(0.6);
    animation->start();
}

void regles::leaveEvent(QEvent *)
{
    QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "strength");
    animation->setDuration(500);
    animation->setStartValue(myeffect->strength());
    animation->setEndValue(0.0);
    animation->start();
}

void regles::mouseMoveEvent(QMouseEvent *event)
{
    if (!(event->buttons() & Qt::LeftButton)) return;
    if ( this->statusTip() == "H" )
    {
            if ( event->globalPos().y() - dragPosition.y() < wgheight && event->globalPos().y() - dragPosition.y() >= 0)
            {
                    move(0,event->globalPos().y() - dragPosition.y());
            }
    }
    else
    {
            if ( event->globalPos().x() - dragPosition.x() < wgwidth && event->globalPos().x() - dragPosition.x() >= 0)
            {
                    move(event->globalPos().x() - dragPosition.x(),0);
            }
    }
}

void regles::mousePressEvent ( QMouseEvent * event ) 
{
    dragPosition = event->globalPos() - frameGeometry().topLeft();
}

// *************************
// *** DESSIN DES REGLES ***
// *************************

void regles::paintEvent(QPaintEvent *)
{
    QPainter p;
    p.begin(this);
    if ( this->statusTip() == "H" )
    {
            p.drawTiledPixmap(0,0,this->width(),21,QPixmap(":/Interface/Interface/hruler.png"),0,0);
    }
    else
    {
            p.drawTiledPixmap(0,0,21,this->height(),QPixmap(":/Interface/Interface/vruler.png"),0,0);
    }
    p.end();
}
