/* ============================================================
 * File  : safety.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "safety.h"

safety::safety ( QWidget * parent )
    : QLabel(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
}

// ********************************
// *** DESSIN DU FOND DU WIDGET ***
// ********************************

void safety::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);

	QPen pen;
	pen.setStyle(Qt::SolidLine);
	pen.setColor(QColor(255,255,255));
	p.setPen(pen);

	p.drawRect((this->width()*5)/100,(this->height()*5)/100,this->width()-(((this->width()*5)/100)*2),this->height()-(((this->height()*5)/100)*2));

	pen.setStyle(Qt::DotLine);
	pen.setColor(QColor(0,0,0));
	p.setPen(pen);

	p.drawRect((this->width()*5)/100,(this->height()*5)/100,this->width()-(((this->width()*5)/100)*2),this->height()-(((this->height()*5)/100)*2));

	p.end();
}

