/* ============================================================
 * File  : tetrahedron.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "simple_bt.h"

simple_bt::simple_bt ( QWidget * parent )
    : QPushButton(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
	isover = 0;
	hasback = 0;
	wl_fond.load(":/Interface/Interface/reload.png");
}

void simple_bt::enterEvent ( QEvent * ) 
{
	isover = 1;
}

void simple_bt::leaveEvent ( QEvent * ) 
{
	isover = 0;
}

// ********************************
// *** DESSIN DU FOND DU WIDGET ***
// ********************************

void simple_bt::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);
	if ( hasback == 1 )
	{
		p.drawPixmap(0,0,wl_fond);
	}
	if ( isover == 0 )
	{
		p.drawPixmap(0,0,pixbt);
	}
	else
	{
		p.drawPixmap(0,0,pixbu);
	}
	p.end();
}

