/* ============================================================
 * File  : slide_timeline.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include <QtGui>
#include "slide_timeline.h"

slide_timeline::slide_timeline ( QWidget * parent )
    : QFrame(parent)
{
        //this->setAcceptDrops(true);
        this->setMouseTracking(true);


        pos_x = 10;
        length_diapo = 10;
        is_on_mark = 0;
        grab_position = 0;
        new_position = 0;
        is_object = 0;

        QPalette mypal = QApplication::palette();

        Gradient1 = new QLinearGradient(0.0,0.0,0.0,this->height()+20);

        Gradient1->setColorAt(0.2, QColor(49,74,78));
        Gradient1->setColorAt(1.0, QColor(26,44,44));

        myfont.setBold(true);

        mark_position = new QAction(tr("Definir la position"), this);
        mark_position->setIcon ( QIcon(":/Interface/Interface/select3.png") );

        visible_position = new QAction(tr("Rendre l'image visible"), this);
        visible_position->setIcon ( QIcon(":/Interface/Interface/lumon.png") );     

        visible_1 = new QAction(tr("Depuis droite"), this);
        visible_1->setIcon ( QIcon(":/Interface/Interface/t3.png") );
        visible_2 = new QAction(tr("Depuis gauche"), this);
        visible_2->setIcon ( QIcon(":/Interface/Interface/t1.png") );
        visible_3 = new QAction(tr("Depuis haut"), this);
        visible_3->setIcon ( QIcon(":/Interface/Interface/t2.png") );
        visible_4 = new QAction(tr("Depuis bas"), this);
        visible_4->setIcon ( QIcon(":/Interface/Interface/t4.png") );
        visible_5 = new QAction(tr("Coeur"), this);
        visible_5->setIcon ( QIcon(":/Interface/Interface/t5.png") );
        visible_6 = new QAction(tr("Peinture"), this);
        visible_6->setIcon ( QIcon(":/Interface/Interface/t6.png") );
        visible_7 = new QAction(tr("Rond"), this);
        visible_7->setIcon ( QIcon(":/Interface/Interface/t7.png") );
        visible_8 = new QAction(tr("Vague"), this);
        visible_8->setIcon ( QIcon(":/Interface/Interface/t8.png") );
        visible_9 = new QAction(tr("Tourbillon"), this);
        visible_9->setIcon ( QIcon(":/Interface/Interface/t9.png") );
        visible_10 = new QAction(tr("Blob"), this);
        visible_10->setIcon ( QIcon(":/Interface/Interface/t10.png") );
        visible_11 = new QAction(tr("Vague"), this);
        visible_11->setIcon ( QIcon(":/Interface/Interface/t11.png") );
        visible_12 = new QAction(tr("Ronds"), this);
        visible_12->setIcon ( QIcon(":/Interface/Interface/t12.png") );
        visible_13 = new QAction(tr("Polar"), this);
        visible_13->setIcon ( QIcon(":/Interface/Interface/t13.png") );
        visible_14 = new QAction(tr("Carre 1"), this);
        visible_14->setIcon ( QIcon(":/Interface/Interface/t14.png") );
        visible_15 = new QAction(tr("Carre 2"), this);
        visible_15->setIcon ( QIcon(":/Interface/Interface/t15.png") );

        invisible_1 = new QAction(tr("Depuis droite"), this);
        invisible_1->setIcon ( QIcon(":/Interface/Interface/t3.png") );
        invisible_2 = new QAction(tr("Depuis gauche"), this);
        invisible_2->setIcon ( QIcon(":/Interface/Interface/t1.png") );
        invisible_3 = new QAction(tr("Depuis haut"), this);
        invisible_3->setIcon ( QIcon(":/Interface/Interface/t2.png") );
        invisible_4 = new QAction(tr("Depuis bas"), this);
        invisible_4->setIcon ( QIcon(":/Interface/Interface/t4.png") );
        invisible_5 = new QAction(tr("Coeur"), this);
        invisible_5->setIcon ( QIcon(":/Interface/Interface/t5.png") );
        invisible_6 = new QAction(tr("Peinture"), this);
        invisible_6->setIcon ( QIcon(":/Interface/Interface/t6.png") );
        invisible_7 = new QAction(tr("Rond"), this);
        invisible_7->setIcon ( QIcon(":/Interface/Interface/t7.png") );
        invisible_8 = new QAction(tr("Vague"), this);
        invisible_8->setIcon ( QIcon(":/Interface/Interface/t8.png") );
        invisible_9 = new QAction(tr("Tourbillon"), this);
        invisible_9->setIcon ( QIcon(":/Interface/Interface/t9.png") );
        invisible_10 = new QAction(tr("Blob"), this);
        invisible_10->setIcon ( QIcon(":/Interface/Interface/t10.png") );
        invisible_11 = new QAction(tr("Vague"), this);
        invisible_11->setIcon ( QIcon(":/Interface/Interface/t11.png") );
        invisible_12 = new QAction(tr("Ronds"), this);
        invisible_12->setIcon ( QIcon(":/Interface/Interface/t12.png") );
        invisible_13 = new QAction(tr("Polar"), this);
        invisible_13->setIcon ( QIcon(":/Interface/Interface/t13.png") );
        invisible_14 = new QAction(tr("Carre 1"), this);
        invisible_14->setIcon ( QIcon(":/Interface/Interface/t14.png") );
        invisible_15 = new QAction(tr("Carre 2"), this);
        invisible_15->setIcon ( QIcon(":/Interface/Interface/t15.png") );

        invisible_position = new QAction(tr("Rendre l'image invisible"), this);
        invisible_position->setIcon ( QIcon(":/Interface/Interface/lumoff.png") );

        delete_position = new QAction(tr("Supprimer la position"), this);
        delete_position->setIcon ( QIcon(":/Interface/Interface/trash.png") );

        deplace_position = new QAction(tr("Deplacer l'image clé"), this);
        deplace_position->setIcon ( QIcon(":/Interface/Interface/grab.png") );

        valide_deplace_position = new QAction(tr("Valider le deplacement de l'image clé"), this);
        valide_deplace_position->setIcon ( QIcon(":/Interface/Interface/select1.png") );
        annule_deplace_position = new QAction(tr("Annuler le deplacement de l'image clé"), this);
        annule_deplace_position->setIcon ( QIcon(":/Interface/Interface/cancel.png") );

        connect(mark_position, SIGNAL(triggered()), this, SLOT(f_mark_position()));
        connect(visible_position, SIGNAL(triggered()), this, SLOT(f_mark_visible()));
        connect(invisible_position, SIGNAL(triggered()), this, SLOT(f_mark_invisible()));
        connect(delete_position, SIGNAL(triggered()), this, SLOT(f_delete_position()));
        connect(deplace_position, SIGNAL(triggered()), this, SLOT(f_deplace_position()));
        connect(valide_deplace_position, SIGNAL(triggered()), this, SLOT(f_valide_deplace_position()));
        connect(annule_deplace_position, SIGNAL(triggered()), this, SLOT(f_annule_deplace_position()));

        connect(visible_1, SIGNAL(triggered()), this, SLOT(f_mark_visible_1()));
        connect(visible_2, SIGNAL(triggered()), this, SLOT(f_mark_visible_2()));
        connect(visible_3, SIGNAL(triggered()), this, SLOT(f_mark_visible_3()));
        connect(visible_4, SIGNAL(triggered()), this, SLOT(f_mark_visible_4()));
        connect(visible_5, SIGNAL(triggered()), this, SLOT(f_mark_visible_5()));
        connect(visible_6, SIGNAL(triggered()), this, SLOT(f_mark_visible_6()));
        connect(visible_7, SIGNAL(triggered()), this, SLOT(f_mark_visible_7()));
        connect(visible_8, SIGNAL(triggered()), this, SLOT(f_mark_visible_8()));
        connect(visible_9, SIGNAL(triggered()), this, SLOT(f_mark_visible_9()));
        connect(visible_10, SIGNAL(triggered()), this, SLOT(f_mark_visible_10()));
        connect(visible_11, SIGNAL(triggered()), this, SLOT(f_mark_visible_11()));
        connect(visible_12, SIGNAL(triggered()), this, SLOT(f_mark_visible_12()));
        connect(visible_13, SIGNAL(triggered()), this, SLOT(f_mark_visible_13()));
        connect(visible_14, SIGNAL(triggered()), this, SLOT(f_mark_visible_14()));
        connect(visible_15, SIGNAL(triggered()), this, SLOT(f_mark_visible_15()));

        connect(invisible_1, SIGNAL(triggered()), this, SLOT(f_mark_invisible_1()));
        connect(invisible_2, SIGNAL(triggered()), this, SLOT(f_mark_invisible_2()));
        connect(invisible_3, SIGNAL(triggered()), this, SLOT(f_mark_invisible_3()));
        connect(invisible_4, SIGNAL(triggered()), this, SLOT(f_mark_invisible_4()));
        connect(invisible_5, SIGNAL(triggered()), this, SLOT(f_mark_invisible_5()));
        connect(invisible_6, SIGNAL(triggered()), this, SLOT(f_mark_invisible_6()));
        connect(invisible_7, SIGNAL(triggered()), this, SLOT(f_mark_invisible_7()));
        connect(invisible_8, SIGNAL(triggered()), this, SLOT(f_mark_invisible_8()));
        connect(invisible_9, SIGNAL(triggered()), this, SLOT(f_mark_invisible_9()));
        connect(invisible_10, SIGNAL(triggered()), this, SLOT(f_mark_invisible_10()));
        connect(invisible_11, SIGNAL(triggered()), this, SLOT(f_mark_invisible_11()));
        connect(invisible_12, SIGNAL(triggered()), this, SLOT(f_mark_invisible_12()));
        connect(invisible_13, SIGNAL(triggered()), this, SLOT(f_mark_invisible_13()));
        connect(invisible_14, SIGNAL(triggered()), this, SLOT(f_mark_invisible_14()));
        connect(invisible_15, SIGNAL(triggered()), this, SLOT(f_mark_invisible_15()));

        QColor wg_color_1 = mypal.color(QPalette::Normal, QPalette::Highlight);

        myeffect = new QGraphicsColorizeEffect();
        myeffect->setStrength(0);
        myeffect->setColor(wg_color_1);
        this->setAttribute(Qt::WA_TranslucentBackground, true);
        this->setGraphicsEffect(myeffect);

        f_init_pos();
}

void slide_timeline::f_valide_deplace_position()
{
    grab_position = 0;
    new_position = pos_x;
    this->setCursor(Qt::ArrowCursor);

    emit deplace_keyframe();

    this->repaint();
}

void slide_timeline::f_annule_deplace_position()
{
    grab_position = 0;
    this->setCursor(Qt::ArrowCursor);
    this->repaint();
}

void slide_timeline::f_deplace_position()
{
    save_point = pos_x;
    grab_position = 1;
    this->setCursor(Qt::SizeAllCursor);
}

void slide_timeline::f_delete_position()
{
    // *** RECHERCHE SI SUR UNE POSITION DEJA MARQUEE ***
    wg_int_002 = 0;

    while ( tab_mark[wg_int_002][0] != "" && tab_mark[wg_int_002][0].toInt() != pos_x && wg_int_002 < 20 )
    {
        wg_int_002++;
    }

    if ( tab_mark[wg_int_002][0].toInt() == pos_x )
    {
        while ( tab_mark[wg_int_002+1][0] != "" && wg_int_002 < 20 )
        {
            tab_mark[wg_int_002][0] = tab_mark[wg_int_002+1][0];
            wg_int_002++;
        }
        this->repaint();
    }
    else
    {
        qDebug() << "OOPS CANNOT FIND CONTROL POINT TO DELETE";
    }

    emit s_delete_position(pos_x);
}

void slide_timeline::mousePressEvent(QMouseEvent *event)
{
        /*if ( event->x() < 10 || event->x() > this->width()-10 )
        {
            return;
        }*/

        if ( event->x() < 10 )
        {
            pos_x = 10;
        }

        if ( event->x() > this->width()-10 )
        {
            pos_x = this->width()-10;
        }

        if ( grab_position == 0 && event->buttons() & Qt::LeftButton )
        {
            emit follow(pos_x);
        }
}

void slide_timeline::mouseMoveEvent(QMouseEvent *event)
{
        /*if ( event->x() < 10 || event->x() > this->width()-10 )
        {
            return;
        }*/

        if (event->buttons() & Qt::LeftButton )
        {
            pos_x = event->x();
            if ( pos_x < 10 )
            {
                pos_x = 10;
            }
            if ( pos_x > this->width()-10 )
            {
                pos_x = this->width()-10;
            }
        }
        else
        {
            pos_x = event->x() + (10-(event->x()%10));
            if ( pos_x < 10 )
            {
                pos_x = 10;
            }
            if ( pos_x > this->width()-10 )
            {
                pos_x = this->width()-10;
            }
        }

        if ( grab_position == 0 )
        {
            // *** RECHERCHE SI SUR UNE POSITION DEJA MARQUEE ***
            wg_int_002 = 0;

            while ( tab_mark[wg_int_002][0] != "" && tab_mark[wg_int_002][0].toInt() != pos_x && wg_int_002 < 20 )
            {
                wg_int_002++;
            }

            if ( tab_mark[wg_int_002][0].toInt() == pos_x )
            {
                is_on_mark = 1;
            }
            else
            {
                is_on_mark = 0;
            }

            this->repaint();

            if (event->buttons() & Qt::LeftButton ) // && pos_x > 10 && pos_x < this->width()-10)
            {
                emit follow(pos_x);
                emit update_coo();
            }

            emit position_timeline(pos_x);
        }
        else
        {
            this->repaint();
        }
}

void slide_timeline::enterEvent(QEvent *)
{
    QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "strength");
    animation->setDuration(300);
    animation->setStartValue(myeffect->strength());
    animation->setEndValue(0.3);
    animation->start();

    if ( this->isEnabled() == true )
    {
        emit enter_timeline();
    }
}

void slide_timeline::leaveEvent(QEvent *)
{
    QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "strength");
    animation->setDuration(300);
    animation->setStartValue(myeffect->strength());
    animation->setEndValue(0.0);
    animation->start();

    emit exit_timeline();
}

void slide_timeline::contextMenuEvent(QContextMenuEvent *event)
{
    if ( grab_position == 0 )
    {
        if ( num_select > 0 )
        {
            if ( event->x() < 10 )
            {
                pos_x = 10;
            }
            else
            {
                if ( event->x() > this->width()-10 )
                {
                    pos_x = this->width()-10;
                    if ( pos_x < 10 )
                    {
                        pos_x = 10;
                    }
                    if ( pos_x > this->width()-10 )
                    {
                        pos_x = this->width()-10;
                    }
                }
                else
                {
                    pos_x = event->x() + (10-(event->x()%10));
                    if ( pos_x < 10 )
                    {
                        pos_x = 10;
                    }
                    if ( pos_x > this->width()-10 )
                    {
                        pos_x = this->width()-10;
                    }
                }
            }

            QMenu menu(this);
            menu.addAction(mark_position);

            if ( is_on_mark == 1 )
            {
                QMenu *menualign = menu.addMenu(QIcon(":/Interface/Interface/lumon.png"),tr("Visibilite"));
                menualign->addAction(visible_position);

                if ( is_object == 0 && pos_x < this->width()-10 && pos_x > 10 )
                {
                    menualign->addAction(visible_1);
                    menualign->addAction(visible_2);
                    menualign->addAction(visible_3);
                    menualign->addAction(visible_4);
                    menualign->addAction(visible_5);
                    menualign->addAction(visible_6);
                    menualign->addAction(visible_7);
                    menualign->addAction(visible_8);
                    menualign->addAction(visible_9);
                    menualign->addAction(visible_10);
                    menualign->addAction(visible_11);
                    menualign->addAction(visible_12);
                    menualign->addAction(visible_13);
                    menualign->addAction(visible_14);
                    menualign->addAction(visible_15);
                }

                menualign->addSeparator();

                menualign->addAction(invisible_position);

                if ( is_object == 0 && pos_x > 10 && pos_x < this->width()-10 )
                {
                    menualign->addAction(invisible_1);
                    menualign->addAction(invisible_2);
                    menualign->addAction(invisible_3);
                    menualign->addAction(invisible_4);
                    menualign->addAction(invisible_5);
                    menualign->addAction(invisible_6);
                    menualign->addAction(invisible_7);
                    menualign->addAction(invisible_8);
                    menualign->addAction(invisible_9);
                    menualign->addAction(invisible_10);
                    menualign->addAction(invisible_11);
                    menualign->addAction(invisible_12);
                    menualign->addAction(invisible_13);
                    menualign->addAction(invisible_14);
                    menualign->addAction(invisible_15);
                }

                menu.addSeparator();

                if ( pos_x > 10 && pos_x < this->width()-10 )
                {
                    menu.addAction(deplace_position);
                    menu.addAction(delete_position);
                }
            }

            menu.exec(event->globalPos());
        }
    }
    else
    {
        QMenu menu(this);
        menu.addAction(valide_deplace_position);
        menu.addAction(annule_deplace_position);
        menu.exec(event->globalPos());
    }
}

void slide_timeline::paintEvent(QPaintEvent *)
{
        QPainter p;
        p.begin(this);
        p.setRenderHint(QPainter::Antialiasing,true);

        // *** DESSIN DU FOND DE LA slide_timeline ***
        p.setBrush(*Gradient1);
        p.drawRoundedRect(0,0,this->width(),this->height(),5,5,Qt::AbsoluteSize);

        // *** DESSIN DES INDICATEURS DE POSITION ***
        wl_pos = 10;
        wl_int_001 = 0;
        last_point_x = 10;
        last_point_y = 0;

        last_point_x_blur = 10;
        last_point_y_blur = 0;

        QPen mypen;
        mypen.setWidth(1);
        mypen.setColor(QColor(255,255,255,200));
        mypen.setStyle(Qt::DotLine);
        p.setPen(mypen);

        if ( length_diapo < 38 )
        {
            myfont.setPixelSize ( 18 );
        }
        else
        {
            myfont.setPixelSize ( 12 );
        }

        p.setFont(myfont);

        while ( wl_int_001 <= length_diapo )
        {
            mypen.setColor(QColor(255,255,255,200));
            p.setPen(mypen);
            p.drawLine(wl_pos,1,wl_pos,this->height()-2);
            mypen.setColor(QColor(255,255,255,100));
            p.setPen(mypen);
            p.drawText(QRect(wl_pos-24,0,48,this->height()), Qt::AlignCenter,QString::number(wl_int_001));
            wl_pos += (float)((float)(this->width()-20)/(float)(length_diapo));
            wl_int_001++;
        }

        wl_int_001 = 1;
        mypen.setColor(QColor(255,255,255,50));
        p.setPen(mypen);

        while ( wl_int_001 < 4 )
        {
            p.drawLine(5,wl_int_001*10,this->width()-5,wl_int_001*10);
            wl_int_001++;
        }
        //

        if ( num_select > 0 )
        {
            wg_int_001 = 0;
            p.setBrush(QColor(255,10,10));
            p.setPen(Qt::NoPen);
            while ( tab_mark[wg_int_001][0] != "" && wg_int_001 < 20 )
            {
                if ( pos_x == tab_mark[wg_int_001][0].toInt() )
                {
                    p.setPen(QColor(11,62,184));
                    p.setBrush(QColor(71,122,244));
                }
                else
                {
                    p.setPen(QColor(184,62,11));
                    p.setBrush(QColor(244,122,71));
                }

                if ( tab_mark[wg_int_001][0].toInt() != save_point || grab_position == 0 )
                {
                    p.drawEllipse(tab_mark[wg_int_001][0].toInt()-5,20,10,10);

                    if ( tab_mark[wg_int_001][1].mid(0,1) == "1" )
                    {
                        p.drawPixmap(tab_mark[wg_int_001][0].toInt()-10,0,QPixmap(":/Interface/Interface/lumon.png"));
                    }
                    else
                    {
                        p.drawPixmap(tab_mark[wg_int_001][0].toInt()-10,0,QPixmap(":/Interface/Interface/lumoff.png"));
                    }
                }

                p.setPen(QColor(255,255,255,0));
                p.setBrush(QColor(255,255,255,80));

                points_opa[0].setX(last_point_x);
                points_opa[0].setY(this->height()-(last_point_y*this->height())/100);

                points_opa[1].setX(tab_mark[wg_int_001][0].toInt());
                points_opa[1].setY(this->height()-(tab_mark[wg_int_001][2].toInt()*this->height())/100);

                points_opa[2].setX(tab_mark[wg_int_001][0].toInt());
                points_opa[2].setY(this->height());

                points_opa[3].setX(last_point_x);
                points_opa[3].setY(this->height());

                p.drawPolygon(points_opa,4);

                last_point_x = tab_mark[wg_int_001][0].toInt();
                last_point_y = tab_mark[wg_int_001][2].toInt();

                p.setPen(QColor(255,0,0,0));
                p.setBrush(QColor(255,0,0,80));

                points_opa[0].setX(last_point_x_blur);
                points_opa[0].setY(this->height()-(last_point_y_blur*this->height())/30);

                points_opa[1].setX(tab_mark[wg_int_001][0].toInt());
                points_opa[1].setY(this->height()-(tab_mark[wg_int_001][3].toInt()*this->height())/30);

                points_opa[2].setX(tab_mark[wg_int_001][0].toInt());
                points_opa[2].setY(this->height());

                points_opa[3].setX(last_point_x_blur);
                points_opa[3].setY(this->height());

                p.drawPolygon(points_opa,4);

                last_point_x_blur = tab_mark[wg_int_001][0].toInt();
                last_point_y_blur = tab_mark[wg_int_001][3].toInt();

                wg_int_001++;
            }
        }

        // *** REGLET SUR LA TIMELINE ***
        p.setPen(QColor(255,0,0));
        p.drawLine(pos_x,1,pos_x,this->height()-1);

        if ( grab_position == 1 )
        {
            p.setPen(QColor(11,62,184));
            p.setBrush(QColor(71,122,244));
            p.drawEllipse(pos_x-5,20,10,10);
        }

        p.end();
}

//

void slide_timeline::f_mark_position()
{
        emit mark();
}

void slide_timeline::f_mark_visible()
{
        emit mark_visible(110);
}

void slide_timeline::f_mark_visible_1()
{
        emit mark_visible(112);
}

void slide_timeline::f_mark_visible_2()
{
        emit mark_visible(111);
}

void slide_timeline::f_mark_visible_3()
{
        emit mark_visible(114);
}

void slide_timeline::f_mark_visible_4()
{
        emit mark_visible(113);
}

void slide_timeline::f_mark_visible_5()
{
        emit mark_visible(115);
}

void slide_timeline::f_mark_visible_6()
{
        emit mark_visible(116);
}

void slide_timeline::f_mark_visible_7()
{
        emit mark_visible(117);
}

void slide_timeline::f_mark_visible_8()
{
        emit mark_visible(118);
}

void slide_timeline::f_mark_visible_9()
{
        emit mark_visible(119);
}

void slide_timeline::f_mark_visible_10()
{
        emit mark_visible(120);
}

void slide_timeline::f_mark_visible_11()
{
        emit mark_visible(121);
}

void slide_timeline::f_mark_visible_12()
{
        emit mark_visible(122);
}

void slide_timeline::f_mark_visible_13()
{
        emit mark_visible(123);
}

void slide_timeline::f_mark_visible_14()
{
        emit mark_visible(124);
}

void slide_timeline::f_mark_visible_15()
{
        emit mark_visible(125);
}

void slide_timeline::f_mark_invisible()
{
        emit mark_visible(210);
}

void slide_timeline::f_mark_invisible_1()
{
        emit mark_visible(211);
}

void slide_timeline::f_mark_invisible_2()
{
        emit mark_visible(212);
}

void slide_timeline::f_mark_invisible_3()
{
        emit mark_visible(213);
}

void slide_timeline::f_mark_invisible_4()
{
        emit mark_visible(214);
}

void slide_timeline::f_mark_invisible_5()
{
        emit mark_visible(215);
}

void slide_timeline::f_mark_invisible_6()
{
        emit mark_visible(216);
}

void slide_timeline::f_mark_invisible_7()
{
        emit mark_visible(217);
}

void slide_timeline::f_mark_invisible_8()
{
        emit mark_visible(218);
}

void slide_timeline::f_mark_invisible_9()
{
        emit mark_visible(219);
}

void slide_timeline::f_mark_invisible_10()
{
        emit mark_visible(220);
}

void slide_timeline::f_mark_invisible_11()
{
        emit mark_visible(221);
}

void slide_timeline::f_mark_invisible_12()
{
        emit mark_visible(222);
}

void slide_timeline::f_mark_invisible_13()
{
        emit mark_visible(223);
}

void slide_timeline::f_mark_invisible_14()
{
        emit mark_visible(224);
}

void slide_timeline::f_mark_invisible_15()
{
        emit mark_visible(225);
}

void slide_timeline::f_init_pos()
{
    // *** INITIALISATION DES POSITIONS MARQUEES DANS LA slide_timeline ***
    wl_int_001 = 0;
    while ( wl_int_001 < 20 )
    {
        tab_mark[wl_int_001][0] = "";
        tab_mark[wl_int_001][1] = "1";
        tab_mark[wl_int_001][2] = "0";
        tab_mark[wl_int_001][3] = "0"; // *** BLUR ***
        wl_int_001++;
    }
}
