/* ============================================================
 * File  : standard_list_clq.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "standard_list_clq.h"

standard_list_clq::standard_list_clq(QWidget *parent)
    : QListWidget(parent)
{
        this->setAttribute(Qt::WA_TranslucentBackground, true);
	setSelectionMode(QAbstractItemView::SingleSelection);
        action_delete = new QAction(tr("Supprimer le calque"), this);
	action_delete->setIcon ( QIcon(":/Interface/Interface/trash.png") );
        action_replace = new QAction(tr("Changer l'image de la diapositive"), this);
        action_replace->setIcon ( QIcon(":/Interface/Interface/open.png") );
        action_ef_image = new QAction(tr("Appliquer un effet"), this);
        action_ef_image->setIcon ( QIcon(":/Interface/Interface/scalemedia.png") );
        action_dupliquer = new QAction(tr("Dupliquer le calque"), this);
        action_dupliquer->setIcon ( QIcon(":/Interface/Interface/copy.png") );

        connect(action_delete, SIGNAL(triggered()), this, SLOT(delete_select()));
        connect(action_replace, SIGNAL(triggered()), this, SLOT(f_action_replace()));
        connect(action_ef_image, SIGNAL(triggered()), this, SLOT(f_action_ef_image()));
        connect(action_dupliquer, SIGNAL(triggered()), this, SLOT(f_action_dupliquer()));
}

void standard_list_clq::delete_select()
{
        int wl_int_001 = this->currentRow();
        emit delete_row(wl_int_001+1);
}

void standard_list_clq::f_action_replace()
{
        int wl_int_001 = this->currentRow();
        emit s_action_replace(wl_int_001+1);
}

void standard_list_clq::f_action_dupliquer()
{
        int wl_int_001 = this->currentRow();
        emit s_action_dupliquer(wl_int_001+1);
}

void standard_list_clq::f_action_ef_image()
{
        int wl_int_001 = this->currentRow();
        emit s_action_ef_image(wl_int_001+1);
}

void standard_list_clq::contextMenuEvent(QContextMenuEvent *event)
{
	if (currentItem() == NULL) 
	{
		return;
	}
	else
	{
                emit select_clq(this->currentItem());

                QMenu menu(this);
                menu.addAction(action_replace);
                menu.addAction(action_ef_image);
                menu.addAction(action_dupliquer);
                menu.addSeparator();
		menu.addAction(action_delete);
		menu.exec(event->globalPos());
	}
}

