/* ============================================================
 * File  : toolbar_bt5.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "toolbar_bt5.h"

toolbar_bt5::toolbar_bt5 ( QWidget * parent )
    : QPushButton(parent)
{
    this->setAttribute(Qt::WA_DeleteOnClose);

    QPalette mypal = QApplication::palette();
    myeffect = new QGraphicsColorizeEffect();
    myeffect->setStrength(0);
    myeffect->setColor(mypal.color(QPalette::Normal, QPalette::Highlight));
    this->setAttribute(Qt::WA_TranslucentBackground, true);
    this->setGraphicsEffect(myeffect);
}

void toolbar_bt5::enterEvent ( QEvent * )
{
    QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "strength");
    animation->setDuration(500);
    animation->setStartValue(myeffect->strength());
    animation->setEndValue(1.0);
    animation->start();
}

void toolbar_bt5::leaveEvent ( QEvent * )
{
    QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "strength");
    animation->setDuration(500);
    animation->setStartValue(myeffect->strength());
    animation->setEndValue(0.1);
    animation->start();
}

// ********************************
// *** DESSIN DU FOND DU WIDGET ***
// ********************************

void toolbar_bt5::paintEvent(QPaintEvent *)
{
    QPainter p;
    p.begin(this);
    if ( this->isCheckable() == false )
    {
        if ( this->isEnabled() == true )
        {
                p.drawPixmap(0,0,QPixmap(":/Interface/Interface/" + this->text().mid(2,this->text().length()-2) + ".png").scaled(this->width(),this->height()));
        }
        else
        {
            if ( wl_pix_1.load(":/Interface/Interface/" + this->text().mid(2,this->text().length()-2) + "3.png") == true )
            {
                p.drawPixmap(0,0,QPixmap(":/Interface/Interface/" + this->text().mid(2,this->text().length()-2) + "1.png").scaled(this->width(),this->height()));
            }
            else
            {
                p.drawPixmap(0,0,QPixmap(":/Interface/Interface/" + this->text().mid(2,this->text().length()-2) + ".png").scaled(this->width(),this->height()));
            }
        }
    }
    else
    {
        if ( this->isEnabled() == true )
        {
            if ( this->isChecked() == true )
            {
                p.drawPixmap(0,0,QPixmap(":/Interface/Interface/" + this->text().mid(2,this->text().length()-2) + "2.png").scaled(this->width(),this->height()));
            }
            else
            {
                p.drawPixmap(0,0,QPixmap(":/Interface/Interface/" + this->text().mid(2,this->text().length()-2) + ".png").scaled(this->width(),this->height()));
            }
        }
        else
        {
            p.drawPixmap(0,0,QPixmap(":/Interface/Interface/" + this->text().mid(2,this->text().length()-2) + "3.png").scaled(this->width(),this->height()));
        }
    }
    p.end();
}

