/* ============================================================
 * File  : videowrapper.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 *
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "videowrapper.h"

videowrapper::videowrapper()
{
    av_register_all();
}

void videowrapper::delete_videowrapper()
{
    av_free_packet(&packet);
    avcodec_close(pCodecCtx);
    //av_close_input_file(pFormatCtx);
    avformat_close_input(&pFormatCtx);
}

int videowrapper::load_video(QString filename)
{
    // *** OUVERTURE DU FICHIER VIDEO ***
    #ifdef avformat_open_input
        if (avformat_open_input(&pFormatCtx,filename.toAscii().data(),NULL,NULL)!=0)
        {
    #else
        if (av_open_input_file(&pFormatCtx,filename.toAscii().data(),NULL,0,NULL)!=0)
        {
    #endif
        qDebug() << "CAN'T OPEN VIDEO FILE : " << filename;
        return 1;
    }

    // *** RECUPERATION DES INFORMATIONS DU MEDIA ***
    /*#ifdef av_find_stream_info
    if(av_find_stream_info(pFormatCtx)<0)
    {
    #else*/
    if (avformat_find_stream_info(pFormatCtx, NULL) < 0)
    {
    //#endif
        qDebug() << "CAN'T READ INFORMATION FROM VIDEO FILE : " << filename;
        return 1;
    }

    // *** RECHERCHE STREAM VIDEO ***

    videoStream=-1;
    int StreamNumber = pFormatCtx->nb_streams;
    for( int i=0; i < StreamNumber; i++ )
    {
        if(pFormatCtx->streams[i]->codec->codec_type==AVMEDIA_TYPE_VIDEO)
        {
            videoStream=i;
            break;
        }
    }

    if( videoStream == -1 )
    {
      qDebug() << "CAN'T FIND VIDEO STREAM : " << filename;
      return 1;
    }

    pCodecCtx=pFormatCtx->streams[videoStream]->codec;

    pCodec=avcodec_find_decoder(pCodecCtx->codec_id);
    if( pCodec==NULL )
    {
        qDebug() << "UNSUPPORTED CODEC";
        return 1;
    }

    // *** OUVERTURE DU CODEC ***

    #ifdef av_find_stream_info
    if(avcodec_open(pCodecCtx, pCodec)<0)
    {
    #else
    if (avcodec_open2(pCodecCtx, pCodec, NULL) < 0)
    {
    #endif
        qDebug() << "CAN'T FIND VIDEO CODEC";
        return 1;
    }

    img_convert_ctx = sws_getContext(pCodecCtx->width,
                    pCodecCtx->height, pCodecCtx->pix_fmt, pCodecCtx->width,
                    pCodecCtx->height, PIX_FMT_RGB24, SWS_BICUBIC, NULL,
                    NULL, NULL);

    // *** ON DETERMINE LA TAILLE DU BUFFER ***
    numBytes=avpicture_get_size(PIX_FMT_RGB24, pCodecCtx->width,
                                pCodecCtx->height);
    buffer=(uint8_t *)av_malloc(numBytes*sizeof(uint8_t));
    old_frame = -1;

    img.load(":/Interface/Interface/open.png");
    img = img.convertToFormat(QImage::Format_RGB888,Qt::AutoColor);
    img = img.scaled(pCodecCtx->width,pCodecCtx->height,Qt::IgnoreAspectRatio,Qt::FastTransformation);

    return 0;
}

QImage videowrapper::read_frame(int64_t num_frame)
{
    if ( num_frame != old_frame )
    {
        // *** ALLOCATE VIDEO FRAME ***
        pFrameRGB=avcodec_alloc_frame();
        pFrame=avcodec_alloc_frame();

        avpicture_fill((AVPicture *)pFrameRGB, buffer, PIX_FMT_RGB24,
                        pCodecCtx->width, pCodecCtx->height);
        av_seek_frame(pFormatCtx,videoStream,0, AVSEEK_FLAG_FRAME);
        compte_frame = -1;

        //compte_frame = num_frame-1;
        // num_frame = av_rescale_q(num_frame, AV_TIME_BASE_Q, pFormatCtx->streams[packet.stream_index]->time_base);

        //if ( av_seek_frame(pFormatCtx, videoStream, num_frame, AVSEEK_FLAG_FRAME) < 0 )
        //{
            //return oldimg;
        //    qDebug() << "OOPS";
        //}

        while ( compte_frame < num_frame )
        {
            while(av_read_frame(pFormatCtx, &packet)>=0 )
            {
                if(packet.stream_index == videoStream)
                {
                    avcodec_decode_video2(pCodecCtx, pFrame, &frameFinished, &packet);

                    if(frameFinished)
                    {
                        if ( compte_frame == num_frame )
                        {
                            sws_scale(img_convert_ctx, pFrame->data, pFrame->linesize, 0, pCodecCtx->height, pFrameRGB->data, pFrameRGB->linesize);

                            for(int y=0;y<pCodecCtx->height;y++)
                            {
                                memcpy(img.scanLine(y),pFrameRGB->data[0]+y*pFrameRGB->linesize[0],pCodecCtx->width*3);
                                oldimg = img;
                            }
                            compte_frame = 9999999;
                        }
                        else
                        {
                            av_free_packet(&packet);
                        }
                        compte_frame++;
                    }
                }
            }
            compte_frame++;
        }

        /*if ( compte_frame < 9999999 )
        {
            img = oldimg;
        }*/

        av_free_packet(&packet);
        av_free(pFrame);
        av_free(pFrameRGB);
        avcodec_flush_buffers(pFormatCtx->streams[videoStream]->codec);

        old_frame = num_frame;
        return img;
    }
    else
    {
        return oldimg;
    }
}
