/*

Copyright (C) 2009, Etienne Moutot <e.moutot@gmail.com>
MODIFICATIONS Gibault Stéphane for 2ManDVD (http://2mandvd.tuxfamily.org)

This file is part of colorPickerWidget.

    colorPickerWidget is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    colorPickerWidget is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with colorPickerWidget.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef COLORPICKERWIDGET_H
#define COLORPICKERWIDGET_H

#include <QWidget>
#include <QPushButton>
#include <QGridLayout>
#include "qtcolortriangle.h"
//#include "colorviewer.h"
#include "screen.h"

class ColorPickerWidget : public QWidget
{
    Q_OBJECT

public:
    ColorPickerWidget(QWidget *parent = 0);
    ~ColorPickerWidget();
    int red;
    int green;
    int blue;

    QAction *action_copier;
    QAction *action_coller;
    QAction *action_entervalue;

public slots:
    void setColor(int,int,int);
    void f_copier();
    void f_coller();
    void f_entervalue();

private slots:
    void pickMode();
    void changeColor(QColor);

Q_SIGNALS:
    void finchange();
    void copier(ColorPickerWidget*);
    void coller(ColorPickerWidget*);

private:
    void contextMenuEvent(QContextMenuEvent *);
    QtColorTriangle *colorTriangle;
    //ColorViewer *colorView;
    QPushButton *pickColor;

    //QGridLayout *layout;

    screen *ecran;
};

#endif // COLORPICKERWIDGET_H
