/**
 *  newtab new ui js
 */
var searchEngines = {
    so: {
        type: 'so',
        desc: '360搜索',
        url: 'https://www.so.com/s?src=360chrome_newtab_search&ie=utf-8',
        key: 'q'
    },
    baidu: {
        type: 'baidu',
        desc: '百度',
        url: 'https://www.baidu.com/baidu?&ie=utf-8',
        key: 'word'
    },
    google: {
        type: 'google',
        desc: '谷歌',
        url: 'http://www.google.com.hk/search?client=aff-cs-360chromium&ie=UTF-8',
        key: 'q'
    },
    news_so: {
        type: 'news_so',
        desc: '360搜索',
        url: 'https://news.so.com/ns?ie=utf-8&src=360chrome_newtab_search',
        key: 'q'
    },
    news_baidu: {
        type: 'news_baidu',
        desc: '百度',
        url: 'http://news.baidu.com/ns?&ie=utf-8',
        key: 'word'
    },
    news_google: {
        type: 'news_google',
        desc: '谷歌',
        url: 'http://news.google.com.hk/news/search?client=aff-cs-360chromium&ie=UTF-8',
        key: 'q'
    },

    video_so: {
        type: 'video_so',
        desc: '360搜索',
        url: 'http://video.so.com/mini.php?src=360chrome_newtab_search&ie=utf-8',
        key: 'kw'
    },
    video_baidu: {
        type: 'video_baidu',
        desc: '百度',
        url: 'http://video.baidu.com/v?&ie=utf-8',
        key: 'word'
    },
    video_google: {
        type: 'video_google',
        desc: '谷歌',
        url: 'http://www.google.com.hk/search?client=aff-cs-360chromium&ie=UTF-8&tbm=vid',
        key: 'q'
    },

    image_so: {
        type: 'image_so',
        desc: '360搜索',
        url: 'http://image.so.com/i?src=360chrome_newtab_search&ie=utf-8',
        key: 'q'
    },
    image_baidu: {
        type: 'image_baidu',
        desc: '百度',
        url: 'http://image.baidu.com/i?&ie=utf-8',
        key: 'word'
    },
    image_google: {
        type: 'image_google',
        desc: '谷歌',
        url: 'http://images.google.com.hk/images?client=aff-cs-360chromium&ie=UTF-8',
        key: 'q'
    },

    music_so: {
        type: 'music_so',
        desc: '360搜索',
        url: 'http://s.music.so.com/s?src=360chrome_newtab_search&ie=utf-8',
        key: 'q'
    },
    music_baidu: {
        type: 'music_baidu',
        desc: '百度',
        url: 'http://music.baidu.com/search?&ie=utf-8',
        key: 'key'
    },
    music_sogou: {
        type: 'music_sogou',
        desc: '搜狗',
        url: 'http://mp3.sogou.com/music?ie=UTF-8',
        key: 'query'
    },

    map_so: {
        type: 'map_so',
        desc: '360搜索',
        url: 'http://map.so.com/?src=360chrome_newtab_search&ie=utf-8&t=map',
        key: 'k'
    },
    map_baidu: {
        type: 'map_baidu',
        desc: '百度',
        url: 'http://map.baidu.com/m?&ie=utf-8',
        key: 'word'
    },
    map_google: {
        type: 'map_google',
        desc: '谷歌',
        url: 'http://ditu.google.cn/maps?client=aff-cs-360chromium&ie=UTF-8',
        key: 'q'
    },

    wenda_so: {
        type: 'wenda_so',
        desc: '360搜索',
        url: 'http://wenda.so.com/search/?src=360chrome_newtab_search&ie=utf-8',
        key: 'q'
    },
    wenda_baidu: {
        type: 'wenda_baidu',
        desc: '百度',
        url: 'http://zhidao.baidu.com/search?&ie=utf-8',
        key: 'word'
    }
};

var searchTypeMaps = {
  webpage: ['so', 'google', 'baidu'],
  news: ['news_so', 'news_google', 'news_baidu'],
  video: ['video_so', 'video_google', 'video_baidu'],
  image: ['image_so', 'image_google', 'image_baidu'],
  music: ['music_so', 'music_sogou', 'music_baidu'],
  map: ['map_so', 'map_google', 'map_baidu'],
  wenda: ['wenda_so', 'wenda_baidu']
};

var searchTypeNames = {
  webpage: '网页',
  news: '新闻',
  video: '视频',
  image: '图片',
  music: '音乐',
  map: '地图',
  wenda: '问答'
};

var PIC_TYPE_DATA_CACHE_EXPIRATION = 7 * 24 * 60 * 60 * 1000;
var currentType = 0;
var currentTileIndex = -1;
var currentUrl = "";
var currentTitle = "";
var currentEdit = "";
var wrapperTimeOut;

function setThumbOpacity(op) {
    var thumbList = document.querySelectorAll(".most-visited");
    var thumbLen = thumbList.length;
    var opacity = (100 - op) / 100 ;
    for (var i = 0; i < thumbLen; i++) {
        thumbList[i].style.opacity = opacity;
    }

    if ($("search-form")) $("search-form").style.opacity = opacity;
    localStorage.thumbOpValue = op;
    cacheNTP();
}

function SetEnableHotSuggestion(enabled) {
    ntp.HotKeyword.enable(enabled);
}

function suggest_so(data) {
    var searchSg = $("search-sg");
    if (!data || !data["s"].length) {
        searchSg.innerHTML = "";
        searchSg.style.display = "none";
        return;
    }
    var searchInput = $("search-kw");
    var offset = searchInput.getBoundingClientRect();
    var iptDiv = document.querySelector("#search-form .ipt").getBoundingClientRect();
    searchSg.style.left = iptDiv.left - 8 + "px";
    searchSg.style.top = offset.top + searchInput.clientHeight - 5 + "px";
    var sgList = data["s"];
    var words = data["q"];
    var str = "";
    var searchUrl = $("search-form").getAttribute('action') + "&" + searchInput.name + "=";
    for (var i = 0; i < sgList.length; i++) {
        var search_kw = sgList[i];
        var search_txt = search_kw;
        if (search_kw.indexOf(words) == 0)
            search_txt = "<span class='no-bold'>"+words+"</span>" + search_kw.substring(words.length);
        str += "<a href='" + searchUrl + encodeURIComponent(search_kw) + "' target='_blank'>" + search_txt + "</a>";
    }
    if (str) {
        searchSg.innerHTML = str;
        searchSg.style.display = "block";
    }
}

(function () {
    $("search-menu").addEventListener("click", function (e) {
        var searchItem;
        if (searchItem = searchEngines[e.target.className] || searchEngines[e.target.firstElementChild.className]) {
          if (searchItem.type == 'so') {
            $('s_btn').classList.remove('btn-normal');
          } else {
            $('s_btn').classList.add('btn-normal');
          }
          document.querySelector('#search-switch>a').className = searchItem.type;
          $('search-form').setAttribute('action', searchItem.url);
          $('search-kw').setAttribute('name', searchItem.key);
          //$('search-kw').setAttribute('placeholder', searchItem.desc);
          var from_input = $("from_input");
          if(searchItem.type.indexOf("so") > -1){
            from_input.name = "src";
            from_input.value = "360chrome_newtab_search";
          }else if(searchItem.type.indexOf("google") > -1){
            from_input.name = "client";
            from_input.value = "aff-cs-360chromium";
          }else {
            from_input.name = "";
            from_input.value = "";
          }
          var currentSetting = JSON.parse(localStorage["searchEngine2"]);
          currentSetting.catlist[currentSetting.active] = searchItem.type;
          localStorage["searchEngine2"] = JSON.stringify(currentSetting);
          this.classList.toggle("toggle-display");
          document.querySelector(".search-arr >span").classList.toggle("toggle-triangle");
        }
      });
    $("theme").addEventListener("click", function (e) {
        chrome.send("lightOff");
        chrome.send("skinSetting");
   });

   //add url
   $("latest_select").onclick = function () {
     $("opened_url").style.display = "none";
     $("latest_url").style.display = "block";
     this.classList.add("tab_active");
     $("opened_select").classList.remove("tab_active");
   };

   $("opened_select").onclick = function () {
     $("latest_url").style.display = "none";
     $("opened_url").style.display = "block";
     this.classList.add("tab_active");
     $("latest_select").classList.remove("tab_active");
   };

   $("new_title").addEventListener("blur",function (e) {
        if (!this.value.trim()) {
            this.value = loadTimeData.getString('editInputTitle');
        }
   });

   $("new_url").addEventListener("blur",function () {
        var urlMatch =new RegExp("[a-zA-z]+://[^s]*","i");
        if (!urlMatch.test(this.value)) {
            this.value = "http://"+ this.value;
        }
        if (!this.value || this.value == "http://") {
            $("u_err").style.display = "block";
        }
   });

   $("new_url").addEventListener("keypress",function () {
         $("u_err").style.display = "none";
   });

   $("u_ok").onclick = function () {
     var n_title = $("new_title").value;
     n_title = n_title.trim().xssFilter();
     var n_url = $("new_url").value;
     n_url = n_url.trim().xssFilter();

     if (!n_url || n_url == "http://") {
        $("u_err").style.display = "block";
        return;
     }
     var urlMatch =new RegExp("[a-zA-z]+://[^s]*","i");
     if (!urlMatch.test(n_url)) {
            n_url = "http://"+ n_url;
     }
     if (!n_title || n_title == loadTimeData.getString('editInputTitle')) {
        n_title = "";
     }
     if (currentEdit) {
        chrome.send('blacklistURLFromMostVisited', [currentEdit]);
        currentEdit = "";
     }
     var n_faviconUrl = 'chrome://favicon/' + n_url;
     var n_thumbnailUrl = 'chrome://thumb/' + n_url;
     chrome.send('addPinnedURL', [
          n_url,
          n_title,
          n_faviconUrl || '',
          n_thumbnailUrl || '',
          String(currentTileIndex)
        ]);
     $("user-add-container").style.display = "none";
     $("add-over-layer").style.display ="none";
     var tileList = document.getElementsByClassName("tile real");
     var currentTile = tileList[currentTileIndex].querySelector('.thumbnail');
     currentTile.classList.add("add-loading");
     currentUrl = n_url;
     currentTitle = n_title;
   };

   $("user-add-container").addEventListener("keypress",function (e) {
        if(e.keyCode == 13) {
            $("u_ok").click();
            return false;
        }
   });
   //add url end

})();

function conMoveEvent(e,id){
    if (e.target.id == "thumbnailOpacityRange") {
        return;
    }
    drag = true;
    var xx = e.pageX;
    var yy = e.pageY;
    var left = $(id).offsetLeft;
    var top  = $(id).offsetTop;
    var maxWidth = document.querySelector(".most-visited-page").clientWidth;
    var maxHeight = document.querySelector(".most-visited-page").clientHeight;
    document.onmousemove = function(e) {
        if (drag) {
            x=e.pageX;
            if(x<0 || x>maxWidth) return;
            y=e.pageY;
            if(y<0 || y>maxHeight) return;
            var nowLeft = left-xx+x ;
            var nowTop = top-yy+y;
            if(nowLeft > maxWidth) return;
            if (nowTop > maxHeight) return;
            //nowLeft = (nowLeft < document.body.clientWidth) ? nowLeft : document.body.clientWidth;
            $(id).style.left = nowLeft+"px";
            $(id).style.top  = nowTop +"px";
        }
    }
    document.onmouseup=function(){
        drag = false;
    }
}

function conClose(id) {
    $(id).style.display="none";
    $("add-over-layer").style.display ="none";
    $("u_err").style.display = "none";
    cacheNTP();
}

function cacheNTP() {
    var scoll = document.querySelector(".selected-card .tile-page-scrollbar");
    var scoll_ok = (scoll.style.top == "0px" || !scoll.style.top);
    if (($("add-dot-container").style.display != "block") && scoll_ok) {
        setTimeout(function () {
          // 只有最常访问屏截图，其它页目前存在文字截图模糊的问题
          if ($$('.most-visited-page').classList.contains('selected-card')) {
            chrome.send("cacheNTP");
          }
        }, 1000);
    }
}

String.prototype.trim = function () {
    var str = this,
  str = str.replace(/^\s\s*/, ''),
  ws = /\s/,
  i = str.length;
    while (ws.test(str.charAt(--i)));
    return str.slice(0, i + 1);
}
String.prototype.xssFilter = function () {
    var str = this;
    if (typeof(str) == "string") {
    str = str.substring(0, 200);

    str = str.replace(/&/g, "&amp;");
    /* must do &amp; first */
    str = str.replace(/"/g, "&quot;");
    str = str.replace(/'/g, "&#039;");
    str = str.replace(/</g, "&lt;");
    str = str.replace(/>/g, "&gt;");
    str = str.replace(/@/g, "&#64;");
  }
  return str.toString();
}
NodeList.prototype.foreach = Array.prototype.forEach; 