// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

cr.define('options', function() {

  var OptionsPage = options.OptionsPage;

  //
  // AdvancedOptions class
  // Encapsulated handling of advanced options page.
  //
  function AdvancedOptions() {
    OptionsPage.call(this, 'advanced', templateData.advancedPageTabTitle,
      'advancedPage');
  }

  cr.addSingletonGetter(AdvancedOptions);

  AdvancedOptions.prototype = {
    // Inherit AdvancedOptions from OptionsPage.
    __proto__: options.OptionsPage.prototype,

    /**
     * Initializes the page.
     */
    initializePage: function() {
      // Call base class implementation to starts preference initialization.
      OptionsPage.prototype.initializePage.call(this);

      Preferences.getInstance().addEventListener('profile.switch_mode_type', function(e) {
        if (e.value.value == "1") {
          $('tips-Info').textContent = localStrings.getString("browserSwitchModeAutoDescription");
        }
        if (e.value.value == "2") {
          $('tips-Info').textContent = localStrings.getString("browserSwitchModeIEDescription");
        }
        if (e.value.value == "3") {
          $('tips-Info').textContent = localStrings.getString("browserSwitchModeWebkitDescription");
        }
      });

      //      $('BUTTON_IDS_MORE_SETTING_DLG_SETTING').onclick = function() {
      //            OptionsPage.navigateToPage('tpMoreMouseGesture');
      //      };

      $('SettingbossKeyBtn').onclick = function(event) {
        chrome.send('bosskeySettingDialog');
      };

      this.addEventListener('visibleChange', function(event) {
        tpGetInitOptionsData();
        tpGetInitDownloaderData();

        var align_eles = document.querySelectorAll('.second-align');
        var min_width = 0;
        for (var i = 0; i < align_eles.length; i++) {
          var width = Math.max(align_eles[i].clientWidth, parseInt(align_eles[i].style.minWidth) || 0);
          if (width > min_width) {
            min_width = width;
          }
        }
        for (var i = 0; i < align_eles.length; i++) {
          align_eles[i].style.minWidth = min_width + 'px';
        }
      });

      // Set up click handlers for buttons.
      $('privacyContentSettingsButton').onclick = function(event) {
        OptionsPage.navigateToPage('content');
        OptionsPage.showTab($('cookies-nav-tab'));
        chrome.send('coreOptionsUserMetricsAction', ['Options_ContentSettings']);
      };
      $('privacyClearDataButton').onclick = function(event) {
        chrome.send('tpClearHistoryData');
        //OptionsPage.navigateToPage('clearBrowserData');
        //chrome.send('coreOptionsUserMetricsAction', ['Options_ClearData']);
      };

      // add by huyuguang 2013-01-17 (cache alert)
      if ($('alertClearCacheCheckbox')) {
        Preferences.getInstance().addEventListener($('alertClearCacheCheckbox').pref,
          function() {
            $('alertClearCacheSize').disabled = !$('alertClearCacheCheckbox').checked;
          });
      }
      // add by huyuguang end

      //add by wgt
      $('button_save_images').onclick = function(event) {
        chrome.send('selectSaveImagesQuicklyLocation');
      }
      $('enable_save_images').onchange = function(event) {
          if ($('enable_save_images').checked) {
            $('button_save_images').disabled = false;
            var t = document.getElementsByName('savedir');
            t[0].disabled = false;
            t[1].disabled = false;
            t[2].disabled = false;
          } else {
            $('button_save_images').disabled = true;
            var t = document.getElementsByName('savedir');
            t[0].disabled = true;
            t[1].disabled = true;
            t[2].disabled = true;
          }
        }
        //end
      if ($('alertClearHistoryCheckbox')) {
        Preferences.getInstance().addEventListener($('alertClearHistoryCheckbox').pref,
          function() {
            $('alertClearHistoryRecordCount').disabled = !$('alertClearHistoryCheckbox').checked;
          });
      }

      // 'metricsReportingEnabled' element is only present on Chrome branded
      // builds.
      if ($('metricsReportingEnabled')) {
        $('metricsReportingEnabled').onclick = function(event) {
          chrome.send('metricsReportingCheckboxAction', [String(event.target.checked)]);
          //chrome.send('RestartBrowserToConfig');
        };
      }
      $('auto-open-file-types-label').style.display = "none";
      $('div-autoOpenFileTypesResetToDefault').style.display = "none";
      if (!cr.isChromeOS) {
        $('autoOpenFileTypesResetToDefault').onclick = function(event) {
          chrome.send('autoOpenFileTypesAction');
        };
      }

      $('fontSettingsCustomizeFontsButton').onclick = function(event) {
        OptionsPage.navigateToPage('fonts');
        chrome.send('coreOptionsUserMetricsAction', ['Options_FontSettings']);
      };
      $('defaultFontSize').onchange = function(event) {
        chrome.send('defaultFontSizeAction', [String(event.target.options[event.target.selectedIndex].value)]);
      };
      $('defaultZoomFactor').onchange = function(event) {
        chrome.send('defaultZoomFactorAction', [String(event.target.options[event.target.selectedIndex].value)]);
      };

      $('language-button').onclick = function(event) {
        OptionsPage.navigateToPage('languages');
        chrome.send('coreOptionsUserMetricsAction', ['Options_LanuageAndSpellCheckSettings']);
      };

      $('proxy360Button').onclick = function(event) {
        OptionsPage.navigateToPage('proxy360');
      };

      if (cr.isWindows || cr.isMac) {
        $('certificatesManageButton').onclick = function(event) {
          chrome.send('showManageSSLCertificates');
        };
      } else {
        $('certificatesManageButton').onclick = function(event) {
          OptionsPage.navigateToPage('certificates');
          chrome.send('coreOptionsUserMetricsAction', ['Options_ManageSSLCertificates']);
        };
      }

      $('siteTrustOrBlockButton').onclick = function(event) {
        OptionsPage.navigateToPage('trustedOrBlockedSites');
        //chrome.send('coreOptionsUserMetricsAction', ['Options_???']);
      }

      if (!cr.isChromeOS) {
        $('proxiesConfigureButton').onclick = function(event) {
          chrome.send('showNetworkProxySettings');
        };
        $('downloadLocationChangeButton').onclick = function(event) {
          chrome.send('selectDownloadLocation');
        };
        // This text field is always disabled. Setting ".disabled = true" isn't
        // enough, since a policy can disable it but shouldn't re-enable when
        // it is removed.
        $('downloadLocationPath').setDisabled('readonly', true);

        // add by huyuguang 2012-11-12
        $('cacheLocationChangeButton').onclick = function(event) {
          chrome.send('selectCacheLocation');
        };
        $('cacheLocationPath').setDisabled('readonly', true);
        // add by huyuguang end
      }

      // add by huangximing 2013-04-01
      // $('openGpuAccelerate').onchange = function(event) {
      //   event.preventDefault();
      //   event.stopPropagation();
      //   var text_str = $('open_gpu_confirm_text').innerHTML.replace(/\\n/g,"\n");
      //   if(confirm(text_str)){
      //     this.checked = this.checked?1:0;
      //     chrome.send('openGpuAccelerateAction',
      //         [String($('openGpuAccelerate').checked)]);
      //   }else{
      //     this.checked = !this.checked;
      //   }
      // };

      // $('openSmoothScrolling').onchange = function(event) {
      //  event.preventDefault();
      //  event.stopPropagation();
      //  var text_str = $('open_smooth_scrolling_confirm_text').innerHTML;
      //  if(confirm(text_str)){
      //    this.checked = this.checked?1:0;
      //    chrome.send('enableSmoothScrollingAction',
      //        [String($('openSmoothScrolling').checked)]);
      //  }else{
      //    this.checked = !this.checked;
      //  }
      // };
      // add by huangximing end

      $('sslCheckRevocation').onclick = function(event) {
        chrome.send('checkRevocationCheckboxAction', [String($('sslCheckRevocation').checked)]);
      };

      if ($('backgroundModeCheckbox')) {
        $('backgroundModeCheckbox').onclick = function(event) {
          chrome.send('backgroundModeAction', [String($('backgroundModeCheckbox').checked)]);
        };
      }

      // 'cloudPrintProxyEnabled' is true for Chrome branded builds on
      // certain platforms, or could be enabled by a lab.
      /*<if expr="not pp_ifdef('USE_360HACK')">
      if (!cr.isChromeOS) {
        $('cloudPrintConnectorSetupButton').onclick = function(event) {
          if ($('cloudPrintManageButton').style.display == 'none') {
            // Disable the button, set it's text to the intermediate state.
            $('cloudPrintConnectorSetupButton').textContent =
              localStrings.getString('cloudPrintConnectorEnablingButton');
            $('cloudPrintConnectorSetupButton').disabled = true;
            chrome.send('showCloudPrintSetupDialog');
          } else {
            chrome.send('disableCloudPrintConnector');
          }
        };
      }
      $('cloudPrintManageButton').onclick = function(event) {
        chrome.send('showCloudPrintManagePage');
      };
      </if>*/

      //      $('CHECKBOX_IDS_SHOW_BAR_ON_VIDEO').onclick = function(event) {
      //        chrome.send('checkShowBarOnVideo', 
      //            [String($('CHECKBOX_IDS_SHOW_BAR_ON_VIDEO').checked)]);
      //      };
    }
  };

  //
  // Chrome callbacks
  //

  // Set the checked state of the metrics reporting checkbox.
  AdvancedOptions.SetMetricsReportingCheckboxState = function(
    checked, disabled) {
    $('metricsReportingEnabled').checked = checked;
    $('metricsReportingEnabled').disabled = disabled;
    if (disabled)
      $('metricsReportingEnabledText').className = 'disable-services-span';
  }

  AdvancedOptions.SetMetricsReportingSettingVisibility = function(visible) {
    if (visible) {
      $('metricsReportingSetting').style.display = 'block';
    } else {
      $('metricsReportingSetting').style.display = 'none';
    }
  }

  // Set the font size selected item.
  AdvancedOptions.SetFontSize = function(font_size_value) {
    var selectCtl = $('defaultFontSize');
    for (var i = 0; i < selectCtl.options.length; i++) {
      if (selectCtl.options[i].value == font_size_value) {
        selectCtl.selectedIndex = i;
        if ($('Custom'))
          selectCtl.remove($('Custom').index);
        return;
      }
    }

    // Add/Select Custom Option in the font size label list.
    if (!$('Custom')) {
      var option = new Option(localStrings.getString('fontSizeLabelCustom'), -1, false, true);
      option.setAttribute("id", "Custom");
      selectCtl.add(option);
    }
    $('Custom').selected = true;
  };

  /**
   * Populate the page zoom selector with values received from the caller.
   * @param {Array} items An array of items to populate the selector.
   *     each object is an array with three elements as follows:
   *       0: The title of the item (string).
   *       1: The value of the item (number).
   *       2: Whether the item should be selected (boolean).
   */
  AdvancedOptions.SetupPageZoomSelector = function(items) {
    var element = $('defaultZoomFactor');

    // Remove any existing content.
    element.textContent = '';

    // Insert new child nodes into select element.
    var value, title, selected;
    for (var i = 0; i < items.length; i++) {
      title = items[i][0];
      value = items[i][1];
      selected = items[i][2];
      element.appendChild(new Option(title, value, false, selected));
    }
  };

  // Set the enabled state for the autoOpenFileTypesResetToDefault button.
  AdvancedOptions.SetAutoOpenFileTypesDisabledAttribute = function(disabled) {
    if (!cr.isChromeOS) {
      $('autoOpenFileTypesResetToDefault').disabled = disabled;

      if (disabled)
        $('auto-open-file-types-label').classList.add('disabled');
      else
        $('auto-open-file-types-label').classList.remove('disabled');
    }
  };

  // Set the enabled state for the proxy settings button.
  AdvancedOptions.SetupProxySettingsSection = function(disabled, label) {
    if (!cr.isChromeOS) {
      $('proxiesConfigureButton').disabled = disabled;
      $('proxiesLabel').textContent = label;
    }
  };

  // Set the checked state for the sslCheckRevocation checkbox.
  AdvancedOptions.SetCheckRevocationCheckboxState = function(
    checked, disabled) {
    $('sslCheckRevocation').checked = checked;
    $('sslCheckRevocation').disabled = disabled;
  };

  // Set the checked state for the backgroundModeCheckbox element.
  AdvancedOptions.SetBackgroundModeCheckboxState = function(checked) {
    $('backgroundModeCheckbox').checked = checked;
  };

  // Set the checked state for the GPUCheckboxState element.
  AdvancedOptions.SetGpuCheckboxState = function(checked, gpu0) {
    // $('openGpuAccelerate').checked = checked;
  };
  AdvancedOptions.SetSmoothScrollingCheckboxState = function(checked) {
    $('openSmoothScrolling').checked = checked;
  };

  // Set the Cloud Print proxy UI to enabled, disabled, or processing.
  AdvancedOptions.SetupCloudPrintConnectorSection = function(
    disabled, label, allowed) {
    if (!cr.isChromeOS) {
      $('cloudPrintConnectorLabel').textContent = label;
      if (disabled || !allowed) {
        $('cloudPrintConnectorSetupButton').textContent =
          localStrings.getString('cloudPrintConnectorDisabledButton');
        $('cloudPrintManageButton').style.display = 'none';
      } else {
        $('cloudPrintConnectorSetupButton').textContent =
          localStrings.getString('cloudPrintConnectorEnabledButton');
        $('cloudPrintManageButton').style.display = 'inline';
      }
      $('cloudPrintConnectorSetupButton').disabled = !allowed;
    }
  };

  AdvancedOptions.RemoveCloudPrintConnectorSection = function() {
    if (!cr.isChromeOS) {
      var connectorSectionElm = $('cloud-print-connector-section');
      if (connectorSectionElm)
        connectorSectionElm.parentNode.removeChild(connectorSectionElm);
    }
  };

  AdvancedOptions.SetBlackWhiteUrlList = function(strBlackUrls, strWhiteUrls) {
    var list = [{
        sites: strBlackUrls.split('\n'),
        setting: 'block',
        source: 'preference'
      }, {
        sites: strWhiteUrls.split('\n'),
        setting: 'trust',
        source: 'preference'
      }],
      entries = [];

    for (var i = 0; i < list.length; i++) {
      for (var j = 0; j < list[i].sites.length; j++) {
        if (list[i].sites[j])
          entries.push({
            displayPattern: list[i].sites[j],
            setting: list[i].setting,
            source: list[i].source
          });
      }
    }
    var siteList = document.querySelector('div[contentType=trusted_or_blocked_site] list');
    siteList.setTrustedOrBlockedSites(entries);
  }

  // Export
  return {
    AdvancedOptions: AdvancedOptions
  };

});