// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

cr.define('options', function() {
  var OptionsPage = options.OptionsPage;

  function ManageKandatuListOverlay() {
    OptionsPage.call(this,
      'manageKandatuList',
      '选项 - 实验室',
      'manage-kandatu-list-overlay');
  }

  cr.addSingletonGetter(ManageKandatuListOverlay);

  ManageKandatuListOverlay.prototype = {
    // Inherit from OptionsPage.
    __proto__: OptionsPage.prototype,

    /**
     * Initialize the page.
     */
    initializePage: function() {

      // Call base class implementation to start preference initialization.
      OptionsPage.prototype.initializePage.call(this);
      var self = this;

      var eles = $('manage-kandatu-list-overlay').querySelectorAll('.btn-close');
      for (var i = 0; i < eles.length; i++) {
        eles[i].onclick = function() {
          OptionsPage.closeOverlay();
        };
      }

      $$('#manage-kandatu-list-overlay .btn-ok').onclick = function() {
        var listWrap = $$('#manage-kandatu-list-overlay .content-area');
        var eles = listWrap.querySelectorAll('li');
        if (eles.length > 0) {
          var enabledList = [];
          for (var i = 0; i < eles.length; i++) {
            if (eles[i].className == 'checked') {
              enabledList.push(eles[i].getAttribute('_id'));
            }
          }
          chrome.send('setKandatuEnableList', enabledList);
        }

        OptionsPage.closeOverlay();
      }

    },

    /**
     * onShowPage
     */
    didShowPage: function() {
      chrome.send('getKandatuList', ['ManageKandatuListOverlay.onGetList']);
    }
  };

  ManageKandatuListOverlay.onGetList = function(json) {
    var titles = {
      shopping: '购物类网站：',
      social: '社交类网站：'
    };
    var sb = [];
    for (var key in json) {
      var val = json[key];
      if (val.length > 0) {
        sb.push('<div class="category"><h3>' + (titles[key] || '') + '</h3><ul>');
        val.forEach(function(item) {
          var url = item.url;
          if (url.substr(-1, 1) != '/') {
            url += '/';
          }
          // var icon = 'chrome://favicon/iconurl/' + url + 'favicon.ico';
          var icon = 'chrome://favicon/regexp/' + url;
          sb.push('<li class="' + (item.checked ? 'checked' : '') + '" _id="' + item.name + '"><img src="' + icon + '">' + item.title + '</li> ');
        });
        sb.push('</ul></div>');
      }
    }
    var listWrap = $$('#manage-kandatu-list-overlay .content-area');
    listWrap.innerHTML = sb.join('');
    var eles = listWrap.querySelectorAll('li');
    for (var i = 0; i < eles.length; i++) {
      eles[i].onclick = function() {
        var checked = this.className == 'checked';
        this.className = checked ? '' : 'checked';
        // chrome.send('setKandatuEnable', [this.getAttribute('_id'), !checked]);
      };
    }

  };

  // Export
  return {
    ManageKandatuListOverlay: ManageKandatuListOverlay
  };
});