// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

cr.define('options', function() {
  var OptionsPage = options.OptionsPage;

  /**
   * Sync360Setting class
   * Encapsulated handling of the 'Manage profile...' overlay page.
   * @constructor
   * @class
   */
  function Sync360SettingOverlay() {
    OptionsPage.call(this,
      'sync360',
      templateData.sync360SettingOverlayTabTitle,
      'sync360-setting-overlay');
  }

  cr.addSingletonGetter(Sync360SettingOverlay);

  Sync360SettingOverlay.prototype = {
    // Inherit from OptionsPage.
    __proto__: OptionsPage.prototype,

    /**
     * Initialize the page.
     */
    initializePage: function() {
      // Call base class implementation to start preference initialization.
      OptionsPage.prototype.initializePage.call(this);

      var self = this;

      $('sync360-setting-ok').onclick = function() {
        chrome.send('sync360SettingChange', [
          ($('sync360-bookmarks').checked), ($('sync360-preference').checked), ($('sync360-extension').checked), ($('sync360-theme').checked), ($('sync360-switcher').checked), ($('sync360-autofill').checked)
        ]);
        OptionsPage.closeOverlay();
      };

      $('sync360-setting-cancel').onclick = function() {
        OptionsPage.closeOverlay();
      };
    },
    showSync360SettingPage_: function(value) {
      // Intentionally don't show the URL in the location bar as we don't want
      // people trying to navigate here by hand.
      var checkboxes =
        document.querySelectorAll('#sync360-setting-checkboxes input[type=checkbox]');
      for (var i = 0; i < checkboxes.length; i++) {
        checkboxes[i].checked = value[i];
      }
      $('sync360-bookmarks').checked = true;
      $('sync360-bookmarks').disabled = true;
      OptionsPage.showPageByName('sync360', false);
    },
    closeSync360SettingPage_: function(value) {
      if (location.pathname != '/importExportBookmark' &&
        location.pathname != '/manageKandatuList') //add by huangximing , importExportBookmark for not login 
        OptionsPage.closeOverlay();
    },
    setSync360TitlePage_: function(value) {
      $("sync360SettingOverlay").innerText = localStrings.getStringF("sync360SettingOverlay", value);
    },
  };
  // Forward public APIs to private implementations.
  [
    'showSync360SettingPage',
    'closeSync360SettingPage',
    'setSync360TitlePage'
  ].forEach(function(name) {
    Sync360SettingOverlay[name] = function() {
      var instance = Sync360SettingOverlay.getInstance();
      return instance[name + '_'].apply(instance, arguments);
    };
  });
  // Export
  return {
    Sync360SettingOverlay: Sync360SettingOverlay
  };
});