#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=7Prompt.ico
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_Res_Comment=7Prompt
#AutoIt3Wrapper_Res_Description=7Prompt
#AutoIt3Wrapper_Res_Fileversion=1.0.0.0
#AutoIt3Wrapper_Res_LegalCopyright=Michael Michta
#AutoIt3Wrapper_Res_Language=1033
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#NoAutoIt3Execute

Global Const $VerInfo = "1.0"

;Put command line args into a string if they are passed
$Args = " /k  echo 7Prompt V" & $VerInfo & "&& echo (c) 2010 Michael Michta"
If $CmdLine[0] <> 0 Then
	$Args = " "
	For $X = 1 To $CmdLine[0]
		$Args &= $CmdLine[$X] & " "
	Next
	$Args = StringTrimRight($Args, 1)
EndIf

;start command prompt hidden
$PID = Run(@ComSpec & $Args, @WorkingDir, @SW_HIDE)

;Wait for the console window to appear and then get a list so the correct can be found
WinWait("[CLASS:ConsoleWindowClass]")
$List = WinList("[CLASS:ConsoleWindowClass]")

;Loop through list of console windows
For $X = 1 To $List[0][0]
	If WinGetProcess($List[$X][1]) = $PID Then ; Find console window attached to spawned command prompt

		WinSetState($List[$X][1], "", @SW_SHOW) ; Show the console
		EnableBlurBehind($List[$X][1])
		WinActivate($List[$X][1])
		Exit
	EndIf
Next

;Errors
ProcessClose($PID)
MsgBox(0, "7Prompt:Error", "Failed to find console window.")
Exit





Func EnableBlurBehind($hWnd)
	Const $DWM_BB_ENABLE = 0x00000001
	$Struct = DllStructCreate("dword;int;ptr;int")
	DllStructSetData($Struct, 1, $DWM_BB_ENABLE)
	DllStructSetData($Struct, 2, "1")
	DllStructSetData($Struct, 4, "1")
	DllCall("dwmapi.dll", "int", "DwmEnableBlurBehindWindow", "hwnd", $hWnd, "ptr", DllStructGetPtr($Struct))
EndFunc   ;==>EnableBlurBehind