/*
 * Decompiled with CFR 0.152.
 */
package matchit2;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import matchit2.DoublyLinkedList;
import matchit2.GameScreen;
import matchit2.Spark;

class FireworksCanvas
extends GameCanvas
implements Runnable {
    private static final int KEY_SOFTKEY1 = -6;
    private static final int KEY_SOFTKEY2 = -7;
    private static final int KEY_SOFTKEY3 = -5;
    private int x = 0;
    private int len;
    private Image cong;
    private Image won;
    static final int FIXED_POINT_SHIFT = 8;
    private static final int MILLIS_PER_TICK = 100;
    private static final int TICKS_PER_EXPLOSION = 5;
    private static final int SPARK_LIFE_IN_TICKS = 30;
    private static final int SPARK_RANDOM_LIFE_IN_TICKS = 20;
    private static final int SPARK_VELOCITY = 2;
    private static final int[] colours = new int[]{0xFF0000, 65280, 0xFFFF00, 0xFF00FF, 65535};
    private final GameScreen gamescreen;
    private final boolean useColour;
    private final Random random = new Random();
    private final DoublyLinkedList sparkList = new DoublyLinkedList();
    private volatile Thread animationThread = null;
    private static final int[] SINES = new int[]{0, 44, 88, 128, 165, 196, 222, 241, 252, 256};

    FireworksCanvas(GameScreen g) {
        super(false);
        this.setFullScreenMode(true);
        this.gamescreen = g;
        this.useColour = true;
        try {
            this.won = Image.createImage((String)"/res/img/wonall.png");
            Image img = Image.createImage((String)"/res/img/cong.png");
            this.len = img.getWidth();
            this.cong = Image.createImage((int)(this.len + this.getWidth() * 2), (int)img.getHeight());
            this.cong.getGraphics().setColor(0);
            this.cong.getGraphics().fillRect(0, 0, this.cong.getWidth(), this.cong.getHeight());
            this.cong.getGraphics().drawImage(img, this.getWidth(), 0, 0);
            img = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.x = this.getWidth();
    }

    synchronized void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    synchronized void stop() {
        this.animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread currentThread = Thread.currentThread();
        try {
            while (true) {
                if (currentThread != this.animationThread) {
                    return;
                }
                long startTime = System.currentTimeMillis();
                this.tick();
                this.repaint(0, 0, this.getWidth(), this.getHeight());
                this.serviceRepaints();
                long timeTaken = System.currentTimeMillis() - startTime;
                if (timeTaken < 100L) {
                    FireworksCanvas fireworksCanvas = this;
                    synchronized (fireworksCanvas) {
                        this.wait(100L - timeTaken);
                        ++this.x;
                        if (this.x > this.getWidth() + this.len) {
                            this.x = 0;
                        }
                        continue;
                    }
                }
                currentThread.yield();
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0xFFFF00);
        Image img = Image.createImage((Image)this.cong, (int)this.x, (int)0, (int)this.getWidth(), (int)this.cong.getHeight(), (int)0);
        g.drawImage(img, 0, 25, 0);
        img = null;
        g.drawImage(this.won, (this.getWidth() - this.won.getWidth()) / 2, 55, 0);
        g.setColor(65535);
        g.drawString("By Xinyun Liu", 5, this.getHeight() - 55, 0);
        g.drawString("robotskin@hotmail.com", 5, this.getHeight() - 40, 0);
        g.drawString("Nov.2004. All rights reserved", 5, this.getHeight() - 25, 0);
        this.drawAllSparks(g);
    }

    protected void pointerPressed(int x, int y) {
        this.gamescreen.goMain();
    }

    public void keyPressed(int keyCode) {
        if ((keyCode = this.getGameAction(keyCode)) == 8) {
            this.gamescreen.goMain();
        }
    }

    private synchronized void tick() {
        Spark currentSpark = (Spark)this.sparkList.getFirst();
        while (currentSpark != null) {
            Spark nextSpark = (Spark)this.sparkList.getNext(currentSpark);
            currentSpark.tick();
            currentSpark = nextSpark;
        }
        if (this.sparkList.isEmpty() || this.rand(5) == 0) {
            this.explode();
        }
    }

    private void explode() {
        int colour = this.useColour ? colours[this.rand(colours.length)] : 0xFFFFFF;
        int x = this.rand(this.getWidth() / 2) + this.getWidth() / 4 << 8;
        int y = this.rand(this.getHeight() / 2) + this.getHeight() / 4 << 8;
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 6) {
                int projectedAngle = i * 3 + this.rand(3);
                int planeAngle = j * 3 + this.rand(3);
                int magnitudeTimes256 = 2 * FireworksCanvas.cosineTimes256(planeAngle);
                int vx = FireworksCanvas.cosineTimes256(projectedAngle) * magnitudeTimes256 << 8 >> 16;
                int vy = FireworksCanvas.sineTimes256(projectedAngle) * magnitudeTimes256 << 8 >> 16;
                int timeToLive = 30 + this.rand(30);
                Spark spark = new Spark(x, y, vx, vy, colour, timeToLive);
                this.sparkList.addFirst(spark);
                ++j;
            }
            ++i;
        }
    }

    private synchronized void drawAllSparks(Graphics g) {
        Spark currentSpark = (Spark)this.sparkList.getFirst();
        while (currentSpark != null) {
            Spark nextSpark = (Spark)this.sparkList.getNext(currentSpark);
            currentSpark.draw(g);
            currentSpark = nextSpark;
        }
    }

    private int rand(int scale) {
        return (this.random.nextInt() << 1 >>> 1) % scale;
    }

    private static int sineTimes256(int angle) {
        if ((angle %= 36) <= 9) {
            return SINES[angle];
        }
        if (angle <= 18) {
            return SINES[18 - angle];
        }
        if (angle <= 27) {
            return -SINES[angle - 18];
        }
        return -SINES[36 - angle];
    }

    private static int cosineTimes256(int angle) {
        return FireworksCanvas.sineTimes256(angle + 9);
    }
}

