/*
 * Decompiled with CFR 0.152.
 */
package matchit2;

import java.util.Random;

public class GameMatrix {
    private int[][] matrix;
    private int VSize = 0;
    private int HSize = 0;
    private int SeedCount = 0;
    private int Score1 = 10;
    private int Score2 = 20;
    private int Score3 = 50;
    public int VConn = -10;
    public int HConn = -11;
    public int SConn = -10;
    public int LDConn = -12;
    public int LUConn = -13;
    public int RDConn = -14;
    public int RUConn = -15;

    public GameMatrix(int h, int v, int s) {
        if (v * h % 2 == 0) {
            this.VSize = v;
            this.HSize = h;
            this.SeedCount = s;
            this.initMatrix(this.HSize, this.VSize);
        }
    }

    public void end() {
        this.matrix = null;
    }

    public int getAt(int x, int y) {
        if (x > this.HSize || x < 1 || y > this.VSize || y < 1) {
            return -1;
        }
        return this.matrix[x - 1][y - 1];
    }

    public int setAt(int x, int y, int b) {
        if (x > this.HSize || x < 1 || y > this.VSize || y < 1) {
            return 0;
        }
        this.matrix[x - 1][y - 1] = b;
        return 1;
    }

    public void shuffleMatrix() {
        Random r = new Random();
        this.clearTrace();
        int x = 0;
        while (x < this.HSize) {
            int y = 0;
            while (y < this.VSize) {
                int xx = Math.abs(r.nextInt()) % this.HSize;
                int yy = Math.abs(r.nextInt()) % this.VSize;
                int b = this.matrix[x][y];
                this.matrix[x][y] = this.matrix[xx][yy];
                this.matrix[xx][yy] = b;
                ++y;
            }
            ++x;
        }
    }

    public void clearTrace() {
        int x = 0;
        while (x < this.HSize) {
            int y = 0;
            while (y < this.VSize) {
                if (this.matrix[x][y] < -1) {
                    this.matrix[x][y] = -1;
                }
                ++y;
            }
            ++x;
        }
    }

    public int judge(int x, int y, int xx, int yy, boolean mark) {
        int x2;
        int x1;
        int j;
        int y2;
        int y1;
        int i;
        int a;
        int c;
        if (--x == --xx && --y == --yy) {
            return 0;
        }
        if (x < 0 || x > this.HSize - 1 || y < 0 || y > this.VSize - 1 || xx < 0 || xx > this.HSize - 1 || yy < 0 || yy > this.VSize - 1) {
            return 0;
        }
        if (this.matrix[x][y] != this.matrix[xx][yy]) {
            return 0;
        }
        if (this.matrix[x][y] < 0 || this.matrix[xx][yy] < 0) {
            return 0;
        }
        if (x == xx) {
            if (y > yy) {
                c = y;
                y = yy;
                yy = c;
            }
            a = 0;
            i = y + 1;
            while (i < yy) {
                a += this.matrix[x][i];
                ++i;
            }
            if (-a == yy - y - 1) {
                if (mark) {
                    i = y + 1;
                    while (i < yy) {
                        this.matrix[x][i] = this.VConn;
                        ++i;
                    }
                }
                return this.Score1;
            }
        }
        if (y == yy) {
            if (x > xx) {
                c = x;
                x = xx;
                xx = c;
            }
            a = 0;
            i = x + 1;
            while (i < xx) {
                a += this.matrix[i][y];
                ++i;
            }
            if (-a == xx - x - 1) {
                if (mark) {
                    i = x + 1;
                    while (i < xx) {
                        this.matrix[i][y] = this.HConn;
                        ++i;
                    }
                }
                return this.Score1;
            }
        }
        a = 0;
        if (x > xx) {
            c = x;
            x = xx;
            xx = c;
            c = y;
            y = yy;
            yy = c;
        }
        if (y < yy) {
            i = x + 1;
            while (i <= xx) {
                a += this.matrix[i][y];
                ++i;
            }
            i = y + 1;
            while (i < yy) {
                a += this.matrix[xx][i];
                ++i;
            }
            if (-a == xx - x + yy - y - 1) {
                if (mark) {
                    i = x + 1;
                    while (i <= xx) {
                        this.matrix[i][y] = this.HConn;
                        ++i;
                    }
                    i = y + 1;
                    while (i < yy) {
                        this.matrix[xx][i] = this.VConn;
                        ++i;
                    }
                    this.matrix[xx][y] = this.LDConn;
                }
                return this.Score2;
            }
            a = 0;
            i = x;
            while (i < xx) {
                a += this.matrix[i][yy];
                ++i;
            }
            i = y + 1;
            while (i < yy) {
                a += this.matrix[x][i];
                ++i;
            }
            if (-a == xx - x + yy - y - 1) {
                if (mark) {
                    i = x;
                    while (i < xx) {
                        this.matrix[i][yy] = this.HConn;
                        ++i;
                    }
                    i = y + 1;
                    while (i < yy) {
                        this.matrix[x][i] = this.VConn;
                        ++i;
                    }
                    this.matrix[x][yy] = this.RUConn;
                }
                return this.Score2;
            }
        } else {
            i = x + 1;
            while (i <= xx) {
                a += this.matrix[i][y];
                ++i;
            }
            i = yy + 1;
            while (i < y) {
                a += this.matrix[xx][i];
                ++i;
            }
            if (-a == xx - x + y - yy - 1) {
                if (mark) {
                    i = x + 1;
                    while (i <= xx) {
                        this.matrix[i][y] = this.HConn;
                        ++i;
                    }
                    i = yy + 1;
                    while (i < y) {
                        this.matrix[xx][i] = this.VConn;
                        ++i;
                    }
                    this.matrix[xx][y] = this.LUConn;
                }
                return this.Score2;
            }
            a = 0;
            i = x;
            while (i < xx) {
                a += this.matrix[i][yy];
                ++i;
            }
            i = yy + 1;
            while (i < y) {
                a += this.matrix[x][i];
                ++i;
            }
            if (-a == xx - x + y - yy - 1) {
                if (mark) {
                    i = x;
                    while (i < xx) {
                        this.matrix[i][yy] = this.HConn;
                        ++i;
                    }
                    i = yy + 1;
                    while (i < y) {
                        this.matrix[x][i] = this.VConn;
                        ++i;
                    }
                    this.matrix[x][yy] = this.RDConn;
                }
                return this.Score2;
            }
        }
        if (y > yy) {
            y1 = yy;
            y2 = y;
        } else {
            y1 = y;
            y2 = yy;
        }
        i = x;
        int s = 0;
        while (Math.abs(s) < this.HSize) {
            if ((s = -s) >= 0) {
                ++s;
            }
            if ((i = x + s) >= this.HSize || i < 0) continue;
            a = 0;
            j = y1;
            while (j <= y2) {
                a += this.matrix[i][j];
                ++j;
            }
            if (-a != y2 - y1 + 1) continue;
            a = 0;
            if (x > i) {
                c = i;
                while (c < x) {
                    a += this.matrix[c][y];
                    ++c;
                }
            } else {
                c = x + 1;
                while (c <= i) {
                    a += this.matrix[c][y];
                    ++c;
                }
            }
            if (-a != Math.abs(x - i)) continue;
            a = 0;
            if (xx > i) {
                c = i;
                while (c < xx) {
                    a += this.matrix[c][yy];
                    ++c;
                }
            } else {
                c = xx + 1;
                while (c <= i) {
                    a += this.matrix[c][yy];
                    ++c;
                }
            }
            if (-a != Math.abs(xx - i)) continue;
            if (mark) {
                if (x > i) {
                    c = i;
                    while (c < x) {
                        this.matrix[c][y] = this.HConn;
                        ++c;
                    }
                    this.matrix[i][y] = y < yy ? this.RDConn : this.RUConn;
                } else {
                    c = x + 1;
                    while (c <= i) {
                        this.matrix[c][y] = this.HConn;
                        ++c;
                    }
                    this.matrix[i][y] = y < yy ? this.LDConn : this.LUConn;
                }
                if (xx > i) {
                    c = i;
                    while (c < xx) {
                        this.matrix[c][yy] = this.HConn;
                        ++c;
                    }
                    this.matrix[i][yy] = y < yy ? this.RUConn : this.RDConn;
                } else {
                    c = xx + 1;
                    while (c <= i) {
                        this.matrix[c][yy] = this.HConn;
                        ++c;
                    }
                    this.matrix[i][yy] = y < yy ? this.LUConn : this.LDConn;
                }
                c = y1 + 1;
                while (c < y2) {
                    this.matrix[i][c] = this.VConn;
                    ++c;
                }
            }
            return this.Score3;
        }
        a = 0;
        i = 0;
        while (i < x) {
            a += this.matrix[i][y];
            ++i;
        }
        if (-a == x) {
            a = 0;
            i = 0;
            while (i < xx) {
                a += this.matrix[i][yy];
                ++i;
            }
            if (-a == xx) {
                if (mark) {
                    i = 0;
                    while (i < x) {
                        this.matrix[i][y] = this.HConn;
                        ++i;
                    }
                    if (x == 0) {
                        this.matrix[0][y] = -this.matrix[0][y] + this.SConn + this.HConn * 100;
                    }
                    i = 0;
                    while (i < xx) {
                        this.matrix[i][yy] = this.HConn;
                        ++i;
                    }
                    if (xx == 0) {
                        this.matrix[0][yy] = -this.matrix[0][yy] + this.SConn + this.HConn * 100;
                    }
                }
                return this.Score3;
            }
        }
        a = 0;
        i = x + 1;
        while (i < this.HSize) {
            a += this.matrix[i][y];
            ++i;
        }
        if (-a == this.HSize - x - 1) {
            a = 0;
            i = xx + 1;
            while (i < this.HSize) {
                a += this.matrix[i][yy];
                ++i;
            }
            if (-a == this.HSize - xx - 1) {
                if (mark) {
                    i = x + 1;
                    while (i < this.HSize) {
                        this.matrix[i][y] = this.HConn;
                        ++i;
                    }
                    if (x == this.HSize - 1) {
                        this.matrix[x][y] = -this.matrix[x][y] + this.SConn + this.HConn * 100;
                    }
                    i = xx + 1;
                    while (i < this.HSize) {
                        this.matrix[i][yy] = this.HConn;
                        ++i;
                    }
                    if (xx == this.HSize - 1) {
                        this.matrix[xx][yy] = -this.matrix[xx][yy] + this.SConn + this.HConn * 100;
                    }
                }
                return this.Score3;
            }
        }
        if (x > xx) {
            x1 = xx;
            x2 = x;
        } else {
            x1 = x;
            x2 = xx;
        }
        i = y;
        s = 0;
        while (Math.abs(s) < this.VSize) {
            if ((s = -s) >= 0) {
                ++s;
            }
            if ((i = y + s) >= this.VSize || i < 0) continue;
            a = 0;
            j = x1;
            while (j <= x2) {
                a += this.matrix[j][i];
                ++j;
            }
            if (-a != x2 - x1 + 1) continue;
            a = 0;
            if (y > i) {
                c = i;
                while (c < y) {
                    a += this.matrix[x][c];
                    ++c;
                }
            } else {
                c = y + 1;
                while (c <= i) {
                    a += this.matrix[x][c];
                    ++c;
                }
            }
            if (-a != Math.abs(y - i)) continue;
            a = 0;
            if (yy > i) {
                c = i;
                while (c < yy) {
                    a += this.matrix[xx][c];
                    ++c;
                }
            } else {
                c = yy + 1;
                while (c <= i) {
                    a += this.matrix[xx][c];
                    ++c;
                }
            }
            if (-a != Math.abs(yy - i)) continue;
            if (mark) {
                if (y > i) {
                    c = i;
                    while (c < y) {
                        this.matrix[x][c] = this.VConn;
                        ++c;
                    }
                    this.matrix[x][i] = x < xx ? this.RDConn : this.LDConn;
                } else {
                    c = y + 1;
                    while (c <= i) {
                        this.matrix[x][c] = this.VConn;
                        ++c;
                    }
                    this.matrix[x][i] = x < xx ? this.RUConn : this.LUConn;
                }
                if (yy > i) {
                    c = i;
                    while (c < yy) {
                        this.matrix[xx][c] = this.VConn;
                        ++c;
                    }
                    this.matrix[xx][i] = x < xx ? this.LDConn : this.RDConn;
                } else {
                    c = yy + 1;
                    while (c <= i) {
                        this.matrix[xx][c] = this.VConn;
                        ++c;
                    }
                    this.matrix[xx][i] = x < xx ? this.LUConn : this.RUConn;
                }
                c = x1 + 1;
                while (c < x2) {
                    this.matrix[c][i] = this.HConn;
                    ++c;
                }
            }
            return this.Score3;
        }
        a = 0;
        i = 0;
        while (i < y) {
            a += this.matrix[x][i];
            ++i;
        }
        if (-a == y) {
            a = 0;
            i = 0;
            while (i < yy) {
                a += this.matrix[xx][i];
                ++i;
            }
            if (-a == yy) {
                if (mark) {
                    i = 0;
                    while (i < y) {
                        this.matrix[x][i] = this.VConn;
                        ++i;
                    }
                    if (y == 0) {
                        this.matrix[x][0] = -this.matrix[x][0] + this.SConn + this.VConn * 100;
                    }
                    i = 0;
                    while (i < yy) {
                        this.matrix[xx][i] = this.VConn;
                        ++i;
                    }
                    if (yy == 0) {
                        this.matrix[xx][0] = -this.matrix[xx][0] + this.SConn + this.VConn * 100;
                    }
                }
                return this.Score3;
            }
        }
        a = 0;
        i = y + 1;
        while (i < this.VSize) {
            a += this.matrix[x][i];
            ++i;
        }
        if (-a == this.VSize - y - 1) {
            a = 0;
            i = yy + 1;
            while (i < this.VSize) {
                a += this.matrix[xx][i];
                ++i;
            }
            if (-a == this.VSize - yy - 1) {
                if (mark) {
                    i = y + 1;
                    while (i < this.VSize) {
                        this.matrix[x][i] = this.VConn;
                        ++i;
                    }
                    if (y == this.VSize - 1) {
                        this.matrix[x][y] = -this.matrix[x][y] + this.SConn + this.VConn * 100;
                    }
                    i = yy + 1;
                    while (i < this.VSize) {
                        this.matrix[xx][i] = this.VConn;
                        ++i;
                    }
                    if (yy == this.VSize - 1) {
                        this.matrix[xx][yy] = -this.matrix[xx][yy] + this.SConn + this.VConn * 100;
                    }
                }
                return this.Score3;
            }
        }
        return 0;
    }

    public void initMatrix(int hs, int vs) {
        this.HSize = hs;
        this.VSize = vs;
        this.matrix = new int[this.HSize][this.VSize];
        int j = 0;
        int b = 0;
        int x = 0;
        while (x < this.HSize) {
            int y = 0;
            while (y < this.VSize) {
                if ((j = 1 - j) == 1) {
                    b = (x * this.HSize + y) / 2 % this.SeedCount;
                }
                this.matrix[x][y] = b;
                ++y;
            }
            ++x;
        }
        do {
            this.shuffleMatrix();
        } while (this.find() == 0);
    }

    public int find() {
        int i = 0;
        while (i < this.HSize * this.VSize) {
            int j = i + 1;
            while (j < this.HSize * this.VSize) {
                if (this.judge(i % this.HSize + 1, i / this.HSize + 1, j % this.HSize + 1, j / this.HSize + 1, false) > 0) {
                    return i * 1000 + j;
                }
                ++j;
            }
            ++i;
        }
        return 0;
    }

    public int getRest() {
        int k = 0;
        int x = 0;
        while (x < this.HSize) {
            int y = 0;
            while (y < this.VSize) {
                if (this.matrix[x][y] >= 0) {
                    ++k;
                }
                ++y;
            }
            ++x;
        }
        return k;
    }

    private void dropdown() {
        int x = 0;
        while (x < this.HSize) {
            int y = 0;
            while (y < this.VSize) {
                if (this.matrix[x][y] < 0) {
                    int i = y;
                    while (i > 0) {
                        this.matrix[x][i] = this.matrix[x][i - 1];
                        --i;
                    }
                    this.matrix[x][0] = -1;
                }
                ++y;
            }
            ++x;
        }
    }

    private void leftdownrightup() {
        int i;
        int y;
        int x = 0;
        while (x < this.HSize / 2) {
            y = 0;
            while (y < this.VSize) {
                if (this.matrix[x][y] < 0) {
                    i = y;
                    while (i > 0) {
                        this.matrix[x][i] = this.matrix[x][i - 1];
                        --i;
                    }
                    this.matrix[x][0] = -1;
                }
                ++y;
            }
            ++x;
        }
        x = this.HSize / 2;
        while (x < this.HSize) {
            y = this.VSize - 1;
            while (y >= 0) {
                if (this.matrix[x][y] < 0) {
                    i = y;
                    while (i < this.VSize - 1) {
                        this.matrix[x][i] = this.matrix[x][i + 1];
                        ++i;
                    }
                    this.matrix[x][this.VSize - 1] = -1;
                }
                --y;
            }
            ++x;
        }
    }

    private void goleft() {
        int y = 0;
        while (y < this.VSize) {
            int x = this.HSize - 1;
            while (x >= 0) {
                if (this.matrix[x][y] < 0) {
                    int i = x;
                    while (i < this.HSize - 1) {
                        this.matrix[i][y] = this.matrix[i + 1][y];
                        ++i;
                    }
                    this.matrix[this.HSize - 1][y] = -1;
                }
                --x;
            }
            ++y;
        }
    }

    private void upleftdownright() {
        int i;
        int x;
        int y = 0;
        while (y < this.VSize / 2) {
            x = this.HSize - 1;
            while (x >= 0) {
                if (this.matrix[x][y] < 0) {
                    i = x;
                    while (i < this.HSize - 1) {
                        this.matrix[i][y] = this.matrix[i + 1][y];
                        ++i;
                    }
                    this.matrix[this.HSize - 1][y] = -1;
                }
                --x;
            }
            ++y;
        }
        y = this.VSize / 2;
        while (y < this.VSize) {
            x = 0;
            while (x < this.HSize) {
                if (this.matrix[x][y] < 0) {
                    i = x;
                    while (i > 0) {
                        this.matrix[i][y] = this.matrix[i - 1][y];
                        --i;
                    }
                    this.matrix[0][y] = -1;
                }
                ++x;
            }
            ++y;
        }
    }

    private void raiseup() {
        int x = 0;
        while (x < this.HSize) {
            int y = this.VSize - 1;
            while (y >= 0) {
                if (this.matrix[x][y] < 0) {
                    int i = y;
                    while (i < this.VSize - 1) {
                        this.matrix[x][i] = this.matrix[x][i + 1];
                        ++i;
                    }
                    this.matrix[x][this.VSize - 1] = -1;
                }
                --y;
            }
            ++x;
        }
    }

    private void updown() {
        int x = 0;
        while (x < this.HSize) {
            int i;
            int y = this.VSize / 2 - 1;
            while (y >= 0) {
                if (this.matrix[x][y] < 0) {
                    i = y;
                    while (i < this.VSize / 2 - 1) {
                        this.matrix[x][i] = this.matrix[x][i + 1];
                        ++i;
                    }
                    this.matrix[x][this.VSize / 2 - 1] = -1;
                }
                --y;
            }
            y = this.VSize / 2;
            while (y < this.VSize) {
                if (this.matrix[x][y] < 0) {
                    i = y;
                    while (i > this.VSize / 2) {
                        this.matrix[x][i] = this.matrix[x][i - 1];
                        --i;
                    }
                    this.matrix[x][this.VSize / 2] = -1;
                }
                ++y;
            }
            ++x;
        }
    }

    private void leftright() {
        int y = 0;
        while (y < this.VSize) {
            int i;
            int x = this.HSize / 2 - 1;
            while (x >= 0) {
                if (this.matrix[x][y] < 0) {
                    i = x;
                    while (i < this.HSize / 2 - 1) {
                        this.matrix[i][y] = this.matrix[i + 1][y];
                        ++i;
                    }
                    this.matrix[this.HSize / 2 - 1][y] = -1;
                }
                --x;
            }
            x = this.HSize / 2;
            while (x < this.HSize) {
                if (this.matrix[x][y] < 0) {
                    i = x;
                    while (i > this.HSize / 2) {
                        this.matrix[i][y] = this.matrix[i - 1][y];
                        --i;
                    }
                    this.matrix[this.HSize / 2][y] = -1;
                }
                ++x;
            }
            ++y;
        }
    }

    private void updowncenter() {
        int x = 0;
        while (x < this.HSize) {
            int i;
            int y = 0;
            while (y <= this.VSize / 2 - 1) {
                if (this.matrix[x][y] < 0) {
                    i = y;
                    while (i > 0) {
                        this.matrix[x][i] = this.matrix[x][i - 1];
                        --i;
                    }
                    this.matrix[x][0] = -1;
                }
                ++y;
            }
            y = this.VSize - 1;
            while (y >= this.VSize / 2) {
                if (this.matrix[x][y] < 0) {
                    i = y;
                    while (i < this.VSize - 1) {
                        this.matrix[x][i] = this.matrix[x][i + 1];
                        ++i;
                    }
                    this.matrix[x][this.VSize - 1] = -1;
                }
                --y;
            }
            ++x;
        }
    }

    private void leftrightcenter() {
        int y = 0;
        while (y < this.VSize) {
            int i;
            int x = 0;
            while (x <= this.HSize / 2 - 1) {
                if (this.matrix[x][y] < 0) {
                    i = x;
                    while (i > 0) {
                        this.matrix[i][y] = this.matrix[i - 1][y];
                        --i;
                    }
                    this.matrix[0][y] = -1;
                }
                ++x;
            }
            x = this.HSize - 1;
            while (x >= this.HSize / 2) {
                if (this.matrix[x][y] < 0) {
                    i = x;
                    while (i < this.HSize - 1) {
                        this.matrix[i][y] = this.matrix[i + 1][y];
                        ++i;
                    }
                    this.matrix[this.HSize - 1][y] = -1;
                }
                --x;
            }
            ++y;
        }
    }

    public void rearrange(int rnd) {
        switch (rnd) {
            case 1: {
                return;
            }
            case 2: {
                this.dropdown();
                break;
            }
            case 3: {
                this.goleft();
                break;
            }
            case 4: {
                this.updown();
                break;
            }
            case 5: {
                this.leftright();
                break;
            }
            case 6: {
                this.updowncenter();
                break;
            }
            case 7: {
                this.leftrightcenter();
                break;
            }
            case 8: {
                this.upleftdownright();
                break;
            }
            case 9: {
                this.leftdownrightup();
                break;
            }
            case 10: {
                this.updown();
                this.leftright();
                break;
            }
            case 11: {
                this.updowncenter();
                this.leftrightcenter();
            }
        }
    }
}

