/*
 * Decompiled with CFR 0.152.
 */
package matchit2;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Timer;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;
import matchit2.FireworksCanvas;
import matchit2.GameMatrix;
import matchit2.GameWin;
import matchit2.MainMenu;
import matchit2.MatchIt2;
import matchit2.TimerTask;

public class GameScreen
extends GameCanvas {
    public boolean HASSOUND = false;
    public boolean HASTEST = false;
    private static final int KEY_SOFTKEY1 = -6;
    private static final int KEY_SOFTKEY2 = -7;
    private static final int KEY_SOFTKEY3 = -5;
    private int ScreenHeight;
    private int ScreenWidth;
    private int X = 1;
    private int Y = 1;
    private int XX = -1;
    private int YY = -1;
    private int X1 = -1;
    private int X2 = -1;
    private int Y1 = -1;
    private int Y2 = -1;
    private int VStep = 1;
    private int HStep = 1;
    private int[] VSizes = new int[]{25, 25, 25};
    private int[] HSizes = new int[]{25, 25, 25};
    private int[] VCounts = new int[]{8, 10, 12};
    private int[] HCounts = new int[]{8, 8, 8};
    public int VSize = 22;
    public int HSize = 22;
    private int VCount = 14;
    private int HCount = 9;
    private int[] SeedCounts = new int[]{20, 27, 35};
    public int SeedCount = 35;
    public int ImageCount = 35;
    private int[] XMargins = new int[]{4, 4, 4};
    private int[] YMargins = new int[]{4, 4, 4};
    private int XMargin = 2;
    private int YMargin = 2;
    private int HintOffset = 100;
    private int LineSize = 2;
    private int LineColor = 0xFFFFFF;
    private int BackColor = 0;
    private int RectColor = 0xFF0000;
    private int SeleColor = 65280;
    private int OuterColor = 0xFFFFFF;
    private int HintColor = 0x2200FF;
    private int TimeColor = 65280;
    private Player player;
    private VolumeControl vc;
    private byte[] bs_error;
    private byte[] bs_clear;
    private byte[] bs_shuffle;
    private byte[] bs_global;
    private String s_win;
    private String s_gameover;
    private int SoundVolume = 100;
    public Image[] SoundImages;
    private int CurrentRound = 1;
    private int Score;
    private int ScoreColor = 0x7777FF;
    private MatchIt2 parent;
    private MainMenu myparent;
    private int RestShuffle = 4;
    private int RestHint = 6;
    private int TimeLeft;
    private int TimeTotal = 360;
    private int TimeWidth = 60;
    private TimerTask timertask = new TimerTask(this);
    private Timer timer = new Timer();
    public int Level = 0;
    public boolean Paused = true;
    public boolean Ended = false;
    public Image[] images;
    public Image HintImage;
    public Image ShuffleImage;
    public Image PauseImage;
    private GameMatrix matrix;
    private GameWin gamewin;
    private FireworksCanvas fireworks;

    public GameScreen(MatchIt2 m, MainMenu mp, int lvl) {
        super(false);
        this.setFullScreenMode(true);
        try {
            this.parent = m;
            this.myparent = mp;
            this.Level = lvl;
            this.HSize = this.HSizes[this.Level];
            this.VSize = this.VSizes[this.Level];
            this.HCount = this.HCounts[this.Level];
            this.VCount = this.VCounts[this.Level];
            this.XMargin = this.XMargins[this.Level];
            this.YMargin = this.YMargins[this.Level];
            this.SeedCount = this.SeedCounts[this.Level];
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        if (this.HASSOUND) {
            this.bs_error = new byte[8470];
            this.bs_clear = new byte[8470];
            this.bs_shuffle = new byte[8470];
            this.bs_global = new byte[20000];
            try {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/res/sounds/1.wav");
                is.read(this.bs_clear);
                is.close();
                is = ((Object)((Object)this)).getClass().getResourceAsStream("/res/sounds/3.wav");
                is.read(this.bs_error);
                is.close();
                is = ((Object)((Object)this)).getClass().getResourceAsStream("/res/sounds/5.wav");
                is.read(this.bs_shuffle);
                is.close();
                this.s_gameover = "/res/sounds/6.wav";
                this.s_win = "/res/sounds/2.wav";
            }
            catch (Exception pe) {
                pe.printStackTrace();
            }
        }
        this.ScreenHeight = this.getHeight();
        this.ScreenWidth = this.getWidth();
        this.X = 1;
        this.Y = 1;
        this.matrix = new GameMatrix(this.HCount, this.VCount, this.SeedCount);
        this.Score = 0;
        this.TimeLeft = this.TimeTotal;
        this.timer.schedule((java.util.TimerTask)this.timertask, 0L, 1000L);
        this.Paused = false;
    }

    public void TimeDown() {
        if (this.Paused) {
            return;
        }
        --this.TimeLeft;
        if (this.TimeLeft <= 0) {
            this.timer.cancel();
            this.GameEnd();
        }
        this.repaint();
    }

    private void plays(String s) {
        if (!this.HASSOUND) {
            return;
        }
        try {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(s);
            is.read(this.bs_global);
            is.close();
            this.playbs(this.bs_global);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void playbs(byte[] bs) {
        if (!this.HASSOUND) {
            return;
        }
        if (this.SoundVolume == 0) {
            return;
        }
        try {
            if (this.player != null) {
                this.player.close();
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bs);
            this.player = Manager.createPlayer((InputStream)bis, (String)"audio/x-wav");
            this.player.realize();
            this.vc = (VolumeControl)this.player.getControl("VolumeControl");
            this.vc.setLevel(this.SoundVolume);
            this.player.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void GameEnd() {
        this.timertask.cancel();
        this.Ended = true;
        this.repaint();
    }

    public void removeImages() {
        int i = 1;
        while (i <= this.SeedCount) {
            this.images[i - 1] = null;
            ++i;
        }
    }

    public void goMain() {
        this.removeImages();
        if (this.fireworks != null) {
            this.fireworks.stop();
        }
        this.fireworks = null;
        if (this.gamewin != null) {
            this.gamewin.stop();
        }
        this.gamewin = null;
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.myparent);
    }

    private void Success() {
        this.Paused = true;
        ++this.CurrentRound;
        this.plays(this.s_win);
        if (this.CurrentRound >= 12) {
            this.removeImages();
            if (this.Level < 2) {
                this.timer.cancel();
                if (this.gamewin == null) {
                    this.gamewin = new GameWin(this, this.Level);
                }
                Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.gamewin);
                this.gamewin.start();
            } else {
                if (this.fireworks == null) {
                    this.fireworks = new FireworksCanvas(this);
                }
                Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.fireworks);
                this.fireworks.start();
            }
        }
        ++this.RestShuffle;
        ++this.RestHint;
        this.matrix.initMatrix(this.HCount, this.VCount);
        this.TimeLeft = this.TimeTotal;
        this.Paused = false;
    }

    private void ShowHint() {
        int i = this.matrix.find();
        if (i > 0) {
            this.X1 = i / 1000 % this.HCount;
            this.Y1 = i / 1000 / this.HCount;
            this.X2 = i % 1000 % this.HCount;
            this.Y2 = i % 1000 / this.HCount;
        }
    }

    protected void keyRepeated(int keyCode) {
        int j = this.getGameAction(keyCode);
        switch (j) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                this.keyPressed(keyCode);
            }
        }
    }

    public void goPause() {
        this.Paused = true;
        this.repaint();
    }

    public void goActive(boolean resume) {
        this.Paused = !resume;
        this.repaint();
    }

    protected void pointerPressed(int x, int y) {
        if (this.Ended) {
            this.goMain();
            return;
        }
        int xx = x / this.HSizes[this.Level];
        int yy = y / this.VSizes[this.Level];
        if (x > this.ScreenWidth - 10 && y > this.ScreenHeight - 10) {
            this.goMain();
            return;
        }
        if (x > 50 && y > this.ScreenHeight - 13 && x < 50 + this.TimeWidth) {
            if (this.Paused) {
                this.goActive(true);
                return;
            }
            this.goPause();
            return;
        }
        if (xx < this.HCounts[this.Level] && yy < this.VCounts[this.Level]) {
            this.X = xx + 1;
            this.Y = yy + 1;
            this.keyPressed(this.getKeyCode(8));
            return;
        }
        if (x > this.ScreenWidth - 67 && y > this.ScreenHeight - 13 && x < this.ScreenWidth - 54) {
            this.keyPressed(57);
            return;
        }
        if (x > this.ScreenWidth - 33 && y > this.ScreenHeight - 13 && x < this.ScreenWidth - 23) {
            this.keyPressed(35);
            return;
        }
        if (x > 53 + this.TimeWidth && y > this.ScreenHeight - 13 && x < 68 + this.TimeWidth) {
            this.keyPressed(55);
            return;
        }
    }

    public void keyPressed(int keyCode) {
        if (this.Paused) {
            if (this.getGameAction(keyCode) == 8) {
                this.goActive(true);
            }
            return;
        }
        switch (keyCode) {
            case 48: {
                if (!this.HASTEST) break;
                this.CurrentRound = 12;
                this.Success();
                break;
            }
            case 49: {
                if (!this.HASTEST) break;
                this.GameEnd();
                break;
            }
            case 42: {
                this.goPause();
                break;
            }
            case 35: {
                if (this.X1 >= 0) break;
                if (this.RestHint > 0) {
                    this.ShowHint();
                    --this.RestHint;
                }
                this.repaint();
                break;
            }
            case 57: {
                if (this.RestShuffle > 0) {
                    do {
                        this.matrix.shuffleMatrix();
                    } while (this.matrix.find() == 0);
                    --this.RestShuffle;
                    this.matrix.rearrange(this.CurrentRound);
                    this.playbs(this.bs_shuffle);
                }
                this.repaint();
                break;
            }
            case 55: {
                this.SoundVolume -= 25;
                if (this.SoundVolume < 0) {
                    this.SoundVolume = 100;
                }
                this.repaint();
            }
        }
        keyCode = this.getGameAction(keyCode);
        switch (keyCode) {
            case 8: {
                if (this.Ended) {
                    this.goMain();
                    return;
                }
                if (this.matrix.getAt(this.X, this.Y) < 0) break;
                if (this.XX == this.X && this.YY == this.Y) {
                    this.XX = -1;
                    this.YY = -1;
                } else if (this.XX < 0 || this.YY < 0) {
                    this.XX = this.X;
                    this.YY = this.Y;
                    this.playbs(this.bs_error);
                } else {
                    int j = this.matrix.judge(this.X, this.Y, this.XX, this.YY, true);
                    if (j > 0) {
                        this.Score += j;
                        this.repaint();
                        this.serviceRepaints();
                        j = 0;
                        this.playbs(this.bs_clear);
                        if (this.SoundVolume == 0) {
                            int i = 0;
                            while (i < 262143) {
                                ++j;
                                ++i;
                            }
                        }
                        this.matrix.setAt(this.X, this.Y, -1);
                        this.matrix.setAt(this.XX, this.YY, -1);
                        if (this.X == this.X1 + 1 && this.Y == this.Y1 + 1 || this.X == this.X2 + 1 && this.Y == this.Y2 + 1 || this.XX == this.X1 + 1 && this.YY == this.Y1 + 1 || this.XX == this.X2 + 1 && this.YY == this.Y2 + 1) {
                            this.X1 = -1;
                            this.Y1 = -1;
                            this.X2 = -1;
                            this.Y2 = -1;
                        }
                        this.XX = -1;
                        this.YY = -1;
                        this.matrix.clearTrace();
                        this.TimeLeft += 2;
                        if (this.TimeLeft > this.TimeTotal) {
                            this.TimeLeft = this.TimeTotal;
                        }
                        if (this.matrix.getRest() == 0) {
                            this.Success();
                        }
                        this.matrix.rearrange(this.CurrentRound);
                        if (this.matrix.find() == 0) {
                            if (this.RestShuffle > 0) {
                                do {
                                    this.matrix.shuffleMatrix();
                                } while (this.matrix.find() == 0);
                                --this.RestShuffle;
                                this.matrix.rearrange(this.CurrentRound);
                                this.playbs(this.bs_shuffle);
                            } else {
                                this.plays(this.s_gameover);
                                this.GameEnd();
                            }
                        }
                        this.repaint();
                    } else {
                        this.XX = -1;
                        this.YY = -1;
                        this.playbs(this.bs_error);
                    }
                }
                this.repaint();
                break;
            }
            case 1: {
                --this.Y;
                if (this.Y < 1) {
                    this.Y = this.VCount;
                }
                this.repaint();
                break;
            }
            case 6: {
                ++this.Y;
                if (this.Y > this.VCount) {
                    this.Y = 1;
                }
                this.repaint();
                break;
            }
            case 2: {
                --this.X;
                if (this.X < 1) {
                    this.X = this.HCount;
                }
                this.repaint();
                break;
            }
            case 5: {
                ++this.X;
                if (this.X > this.HCount) {
                    this.X = 1;
                }
                this.repaint();
            }
        }
    }

    public void paint(Graphics g) {
        if (this.Ended) {
            this.endpaint();
        } else if (!this.Paused) {
            this.activepaint();
        } else {
            this.pausepaint();
        }
        this.flushGraphics();
    }

    private void pausepaint() {
        Graphics g = this.getGraphics();
        g.setColor(0);
        g.fillRect(0, 0, this.ScreenWidth, this.ScreenHeight);
        g.setColor(255, 255, 255);
        g.drawImage(this.PauseImage, (this.ScreenWidth - this.PauseImage.getWidth()) / 2, (this.ScreenHeight - this.PauseImage.getHeight()) / 2 - 14, 0);
        this.paintscoreboard(g);
    }

    private void activepaint() {
        Graphics g = this.getGraphics();
        this.paintbackground(g);
        this.paintmaze(g);
        this.paintscoreboard(g);
    }

    private void endpaint() {
        Graphics g = this.getGraphics();
        g.setColor(0);
        g.fillRect(0, 0, this.ScreenWidth, this.ScreenHeight);
        g.setColor(255, 255, 255);
        try {
            Image img = Image.createImage((String)"/res/img/gameover.png");
            g.drawImage(img, (this.ScreenWidth - img.getWidth()) / 2, (this.ScreenHeight - img.getHeight()) / 2, 0);
            img = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.paintscoreboard(g);
    }

    private void paintbackground(Graphics g) {
        g.setColor(this.BackColor);
        g.fillRect(0, 0, this.ScreenWidth, this.ScreenHeight);
    }

    private void paintmaze(Graphics g) {
        boolean h1 = false;
        boolean v1 = false;
        boolean h2 = false;
        boolean v2 = false;
        int x = 0;
        while (x < this.HCount) {
            int y = 0;
            while (y < this.VCount) {
                int b = this.matrix.getAt(x + 1, y + 1);
                if (x == 0) {
                    if (h1) {
                        if (b == this.matrix.HConn || b / 100 == this.matrix.HConn) {
                            h1 = false;
                            g.setColor(this.LineColor);
                            g.fillRect(0, y * this.VSize + this.YMargin, this.LineSize, this.VSize / 2);
                            g.fillRect(0, y * this.VSize + this.YMargin + this.VSize / 2 - 1, this.XMargin - 1, this.LineSize);
                        } else {
                            g.setColor(this.LineColor);
                            g.fillRect(0, y * this.VSize + this.YMargin, this.LineSize, this.VSize - 1);
                        }
                    } else if (b == this.matrix.HConn || b / 100 == this.matrix.HConn) {
                        h1 = true;
                        g.setColor(this.LineColor);
                        g.fillRect(0, y * this.VSize + this.YMargin + this.VSize / 2 - 1, this.LineSize, this.VSize / 2);
                        g.fillRect(0, y * this.VSize + this.YMargin + this.VSize / 2 - 1, this.XMargin - 1, this.LineSize);
                    }
                }
                if (x == this.HCount - 1) {
                    if (h2) {
                        if (b == this.matrix.HConn || b / 100 == this.matrix.HConn) {
                            h2 = false;
                            g.setColor(this.LineColor);
                            g.fillRect(this.HCount * this.HSize + this.XMargin * 2 - 4, y * this.VSize + this.YMargin, this.LineSize, this.VSize / 2);
                            g.fillRect(this.HCount * this.HSize + this.XMargin, y * this.VSize + this.YMargin + this.VSize / 2 - 1, this.XMargin - 1, this.LineSize);
                        } else {
                            g.setColor(this.LineColor);
                            g.fillRect(this.HCount * this.HSize + this.XMargin * 2 - 4, y * this.VSize + this.YMargin, this.LineSize, this.VSize - 1);
                        }
                    } else if (b == this.matrix.HConn || b / 100 == this.matrix.HConn) {
                        h2 = true;
                        g.setColor(this.LineColor);
                        g.fillRect(this.HCount * this.HSize + this.XMargin * 2 - 4, y * this.VSize + this.YMargin + this.VSize / 2 - 1, this.LineSize, this.VSize / 2);
                        g.fillRect(this.HCount * this.HSize + this.XMargin, y * this.VSize + this.YMargin + this.VSize / 2 - 1, this.XMargin - 1, this.LineSize);
                    }
                }
                if (y == 0) {
                    if (v1) {
                        if (b == this.matrix.VConn || b / 100 == this.matrix.VConn) {
                            v1 = false;
                            g.setColor(this.LineColor);
                            g.fillRect(x * this.HSize + this.XMargin, 0, this.HSize / 2, this.LineSize);
                            g.fillRect(x * this.HSize + this.XMargin + this.HSize / 2 - 1, 0, this.LineSize, this.YMargin - 1);
                        } else {
                            g.setColor(this.LineColor);
                            g.fillRect(x * this.HSize + this.XMargin, 0, this.HSize - 1, this.LineSize);
                        }
                    } else if (b == this.matrix.VConn || b / 100 == this.matrix.VConn) {
                        v1 = true;
                        g.setColor(this.LineColor);
                        g.fillRect(x * this.HSize + this.XMargin + this.HSize / 2 - 1, 0, this.LineSize, this.YMargin - 1);
                        g.fillRect(x * this.HSize + this.XMargin + this.HSize / 2 - 1, 0, this.HSize / 2, this.LineSize);
                    }
                }
                if (y == this.VCount - 1) {
                    if (v2) {
                        if (b == this.matrix.VConn || b / 100 == this.matrix.VConn) {
                            v2 = false;
                            g.setColor(this.LineColor);
                            g.fillRect(x * this.HSize + this.XMargin, this.VSize * this.VCount + this.YMargin * 2 - 4, this.HSize / 2, this.LineSize);
                            g.fillRect(x * this.HSize + this.XMargin + this.HSize / 2 - 1, this.VSize * this.VCount + this.YMargin, this.LineSize, this.YMargin - 1);
                        } else {
                            g.setColor(this.LineColor);
                            g.fillRect(x * this.HSize + this.XMargin, this.VSize * this.VCount + this.YMargin * 2 - 4, this.HSize - 1, this.LineSize);
                        }
                    } else if (b == this.matrix.VConn || b / 100 == this.matrix.VConn) {
                        v2 = true;
                        g.setColor(this.LineColor);
                        g.fillRect(x * this.HSize + this.XMargin + this.HSize / 2 - 1, this.VSize * this.VCount + this.YMargin, this.LineSize, this.YMargin - 1);
                        g.fillRect(x * this.HSize + this.XMargin + this.HSize / 2 - 1, this.VSize * this.VCount + this.YMargin * 2 - 4, this.HSize / 2, this.LineSize);
                    }
                }
                if (b < this.matrix.SConn * 100) {
                    b = -b % 100 + this.matrix.SConn;
                }
                if (b >= 0 && b < this.SeedCount) {
                    if (!(this.X1 == x && this.Y1 == y || this.X2 == x && this.Y2 == y)) {
                        g.setColor(this.OuterColor);
                        g.drawImage(this.images[b], x * this.HSize + this.XMargin + 1, y * this.VSize + this.YMargin + 1, 0);
                        g.drawRect(x * this.HSize + this.XMargin, y * this.VSize + this.YMargin, this.HSize, this.VSize);
                    } else {
                        g.setColor(this.HintColor);
                        g.drawImage(this.images[b], x * this.HSize + this.XMargin + 1, y * this.VSize + this.YMargin + 1, 0);
                        g.drawRect(x * this.HSize + this.XMargin, y * this.VSize + this.YMargin, this.HSize - 2, this.VSize - 2);
                        g.drawRect(x * this.HSize + this.XMargin + 1, y * this.VSize + this.YMargin + 1, this.HSize - 3, this.VSize - 3);
                    }
                }
                if (b <= this.matrix.VConn) {
                    g.setColor(this.LineColor);
                    if (b == this.matrix.VConn) {
                        g.fillRect(x * this.HSize + this.XMargin + this.HSize / 2 - 1, y * this.VSize + this.YMargin, this.LineSize, this.VSize - 1);
                    }
                    if (b == this.matrix.HConn) {
                        g.fillRect(x * this.HSize + this.XMargin, y * this.VSize + this.YMargin + this.VSize / 2 - 1, this.HSize - 1, this.LineSize);
                    }
                    if (b == this.matrix.LDConn) {
                        g.fillRect(x * this.HSize + this.XMargin, y * this.VSize + this.YMargin + this.VSize / 2 - 1, this.HSize / 2, this.LineSize);
                        g.fillRect(x * this.HSize + this.XMargin + this.HSize / 2 - 1, y * this.VSize + this.YMargin + this.VSize / 2 - 1, this.LineSize, this.VSize / 2);
                    }
                    if (b == this.matrix.LUConn) {
                        g.fillRect(x * this.HSize + this.XMargin, y * this.VSize + this.YMargin + this.VSize / 2 - 1, this.HSize / 2, this.LineSize);
                        g.fillRect(x * this.HSize + this.XMargin + this.HSize / 2 - 1, y * this.VSize + this.YMargin, this.LineSize, this.VSize / 2);
                    }
                    if (b == this.matrix.RDConn) {
                        g.fillRect(x * this.HSize + this.XMargin + this.HSize / 2 - 1, y * this.VSize + this.YMargin + this.VSize / 2 - 1, this.HSize / 2, this.LineSize);
                        g.fillRect(x * this.HSize + this.XMargin + this.HSize / 2 - 1, y * this.VSize + this.YMargin + this.VSize / 2 - 1, this.LineSize, this.VSize / 2);
                    }
                    if (b == this.matrix.RUConn) {
                        g.fillRect(x * this.HSize + this.XMargin + this.HSize / 2 - 1, y * this.VSize + this.YMargin + this.VSize / 2 - 1, this.HSize / 2, this.LineSize);
                        g.fillRect(x * this.HSize + this.XMargin + this.HSize / 2 - 1, y * this.VSize + this.YMargin, this.LineSize, this.VSize / 2);
                    }
                }
                ++y;
            }
            ++x;
        }
        g.setColor(this.RectColor);
        g.drawRect((this.X - 1) * this.HSize - 1 + this.XMargin, (this.Y - 1) * this.VSize - 1 + this.YMargin, this.HSize - 1, this.VSize - 1);
        g.drawRect((this.X - 1) * this.HSize + this.XMargin, (this.Y - 1) * this.VSize + this.YMargin, this.HSize - 1, this.VSize - 1);
        g.setColor(this.SeleColor);
        g.drawRect((this.XX - 1) * this.HSize + 1 + this.XMargin, (this.YY - 1) * this.VSize + 1 + this.YMargin, this.HSize - 3, this.VSize - 3);
        g.drawRect((this.XX - 1) * this.HSize + this.XMargin, (this.YY - 1) * this.VSize + this.YMargin, this.HSize - 3, this.VSize - 3);
    }

    private void paintscoreboard(Graphics g) {
        g.setColor(this.ScoreColor);
        g.drawString("$" + this.Score, 5, this.ScreenHeight - 12, 0);
        g.drawImage(this.ShuffleImage, this.ScreenWidth - 67, this.ScreenHeight - 13, 0);
        if (this.RestShuffle < 100) {
            g.drawString(this.RestShuffle + " ", this.ScreenWidth - 54, this.ScreenHeight - 13, 0);
        } else {
            g.drawString("99", this.ScreenWidth - 54, this.ScreenHeight - 13, 0);
        }
        g.drawImage(this.HintImage, this.ScreenWidth - 33, this.ScreenHeight - 13, 0);
        if (this.RestHint < 100) {
            g.drawString(this.RestHint + " ", this.ScreenWidth - 23, this.ScreenHeight - 13, 0);
        } else {
            g.drawString("99", this.ScreenWidth - 23, this.ScreenHeight - 13, 0);
        }
        g.setColor(this.TimeColor);
        g.fillRect(50, this.ScreenHeight - 13, this.TimeWidth * this.TimeLeft / this.TimeTotal + 1, 12);
        g.setColor(0);
        g.drawString("Round " + this.CurrentRound, 52, this.ScreenHeight - 13, 0);
        g.setColor(0xFFFFFF);
        g.drawRect(50, this.ScreenHeight - 13, this.TimeWidth, 12);
        if (this.HASSOUND) {
            g.drawImage(this.SoundImages[this.SoundVolume / 25], 53 + this.TimeWidth, this.ScreenHeight - 13, 0);
        }
        g.setColor(255, 255, 255);
        g.drawRect(this.ScreenWidth - 10, this.ScreenHeight - 10, 9, 9);
        g.drawLine(this.ScreenWidth - 10, this.ScreenHeight - 10, this.ScreenWidth, this.ScreenHeight);
        g.drawLine(this.ScreenWidth - 10, this.ScreenHeight, this.ScreenWidth, this.ScreenHeight - 10);
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
    }
}

