/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.games.score;

import com.ixisoft.games.score.ScoreEntry;
import com.ixisoft.games.score.ScoreEntryFactory;
import com.ixisoft.games.score.ScoreRankerListener;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;

public class ScoreRanker {
    private String dbName;
    private ScoreEntryFactory factory;
    private int capacity;
    Vector rankList;
    Vector idList;
    private RecordStore store;
    private boolean closed = false;
    private boolean accessed = false;

    public ScoreRanker(String string, ScoreEntryFactory scoreEntryFactory, int n) {
        if (string == null || scoreEntryFactory == null || n <= 0) {
            throw new IllegalArgumentException("Illegal Ranker Argument");
        }
        this.dbName = string;
        this.factory = scoreEntryFactory;
        this.capacity = n;
        this.rankList = new Vector(n);
        this.idList = new Vector(n);
    }

    private synchronized void open(ScoreRankerListener scoreRankerListener) throws RecordStoreException {
        this.store = RecordStore.openRecordStore((String)this.dbName, (boolean)true);
    }

    public synchronized void close() throws RecordStoreException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (this.store != null) {
                this.store.closeRecordStore();
            }
        }
        finally {
            this.store = null;
        }
    }

    public synchronized int rankOf(ScoreEntry scoreEntry) {
        if (!this.accessed) {
            this.accessed = true;
        }
        int n = -1;
        int n2 = this.rankList.size();
        if (this.rankList.size() == 0) {
            return 0;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (scoreEntry.compareTo(this.rankList.elementAt(n3)) > 0) {
                n = n3;
                break;
            }
            ++n3;
        }
        if (n2 < this.capacity && n < 0) {
            return n2;
        }
        return n;
    }

    public synchronized void load(ScoreRankerListener scoreRankerListener) throws RecordStoreException, RecordStoreFullException, IOException {
        if (this.accessed) {
            return;
        }
        this.accessed = true;
        if (!this.closed) {
            this.open(scoreRankerListener);
        }
        if (!this.isConnected()) {
            return;
        }
        if (scoreRankerListener != null) {
            scoreRankerListener.scoreLoading();
        }
        Vector<ScoreEntry> vector = new Vector<ScoreEntry>(this.capacity);
        Vector<Integer> vector2 = new Vector<Integer>(this.capacity);
        RecordEnumeration recordEnumeration = null;
        try {
            recordEnumeration = this.store.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                byte[] byArray = this.store.getRecord(n);
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                ScoreEntry scoreEntry = this.factory.readEntry(dataInputStream);
                dataInputStream.close();
                boolean bl = false;
                int n2 = 0;
                while (n2 < vector.size()) {
                    if (scoreEntry.compareTo(vector.elementAt(n2)) > 0) {
                        vector.insertElementAt(scoreEntry, n2);
                        vector2.insertElementAt(new Integer(n), n2);
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (bl) continue;
                vector.insertElementAt(scoreEntry, vector.size());
                vector2.insertElementAt(new Integer(n), vector2.size());
            }
            if (vector.size() > this.capacity) {
                vector.setSize(this.capacity);
                vector2.setSize(this.capacity);
            }
            this.rankList = vector;
            this.idList = vector2;
        }
        catch (RecordStoreException recordStoreException) {
            try {
                this.close();
            }
            catch (RecordStoreException recordStoreException2) {
                // empty catch block
            }
            throw recordStoreException;
        }
        catch (IOException iOException) {
            try {
                this.close();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            throw iOException;
        }
        finally {
            if (recordEnumeration != null) {
                recordEnumeration.destroy();
            }
            if (scoreRankerListener != null) {
                scoreRankerListener.scoreLoaded();
            }
        }
    }

    private synchronized boolean isConnected() {
        return !this.closed && this.store != null;
    }

    public synchronized void removeAllScores(ScoreRankerListener scoreRankerListener) throws RecordStoreException {
        if (!this.accessed) {
            this.accessed = true;
        }
        this.rankList.setSize(0);
        this.idList.setSize(0);
        if (!this.isConnected()) {
            return;
        }
        RecordEnumeration recordEnumeration = null;
        try {
            if (scoreRankerListener != null) {
                scoreRankerListener.scoreUpdating();
            }
            recordEnumeration = this.store.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                this.store.deleteRecord(n);
            }
        }
        catch (RecordStoreException recordStoreException) {
            try {
                this.close();
            }
            catch (RecordStoreException recordStoreException2) {}
        }
        finally {
            if (recordEnumeration != null) {
                recordEnumeration.destroy();
            }
            if (scoreRankerListener != null) {
                scoreRankerListener.scoreUpdated();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int recordScore(ScoreRankerListener var1_1, ScoreEntry var2_2) throws RecordStoreException {
        if (!this.accessed) {
            this.accessed = true;
        }
        if ((var3_3 = this.rankOf(var2_2)) < 0) {
            return var3_3;
        }
        if (var1_1 != null) {
            var1_1.scoreUpdating();
        }
        try {
            if (this.rankList.size() >= this.capacity) {
                var4_4 = (Integer)this.idList.lastElement();
                this.rankList.removeElementAt(this.capacity - 1);
                this.idList.removeElementAt(this.capacity - 1);
                this.rankList.insertElementAt(var2_2, var3_3);
                this.idList.insertElementAt(new Integer(var4_4), var3_3);
                if (this.isConnected()) {
                    var5_7 = var2_2.toByteArray();
                    this.store.setRecord(var4_4, var5_7, 0, var5_7.length);
                }
            } else {
                this.rankList.insertElementAt(var2_2, var3_3);
                if (this.isConnected()) {
                    var4_5 = var2_2.toByteArray();
                    var5_8 = this.store.addRecord(var4_5, 0, var4_5.length);
                    this.idList.insertElementAt(new Integer(var5_8), var3_3);
                }
            }
            var4_4 = var3_3;
            ** try [egrp 1[TRYBLOCK] [4 : 217->234)] { 
        }
lbl34:
        // 1 sources

        catch (Throwable var6_10) {
            throw var6_10;
        }
        finally {
            if (var1_1 != null) {
                var1_1.scoreUpdated();
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                return var4_4;
            }
            catch (RecordStoreException var4_6) {
                try {
                    this.close();
                }
                catch (RecordStoreException var5_9) {
                    // empty catch block
                }
                throw var4_6;
            }
        }
    }

    public synchronized int getScoreCount() {
        if (!this.accessed) {
            this.accessed = true;
        }
        return this.rankList.size();
    }

    public synchronized ScoreEntry getScore(int n) {
        if (!this.accessed) {
            this.accessed = true;
        }
        return (ScoreEntry)this.rankList.elementAt(n);
    }
}

