/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.games.swappuz;

import com.ixisoft.games.swappuz.PuzzleCanvas;
import com.ixisoft.midlet.util.MIDletUtils;

public class GameModel {
    private final int[] puzzles;
    private int selectedPos;
    private PuzzleCanvas listener;

    public GameModel(int n) {
        this.puzzles = new int[n];
        this.reset();
    }

    public synchronized void reset() {
        int n = 0;
        while (n < this.puzzles.length) {
            this.puzzles[n] = n;
            ++n;
        }
        this.selectedPos = -1;
    }

    public void shuffle() {
        int n = 0;
        while (n < this.puzzles.length) {
            int n2 = this.puzzles[n];
            int n3 = MIDletUtils.getRandomInt(this.puzzles.length);
            this.puzzles[n] = this.puzzles[n3];
            this.puzzles[n3] = n2;
            ++n;
        }
    }

    public void setPuzzleListener(PuzzleCanvas puzzleCanvas) {
        this.listener = puzzleCanvas;
    }

    public synchronized int getValue(int n) {
        return this.puzzles[n];
    }

    public synchronized void swap(int n, int n2) {
        int n3 = this.puzzles[n];
        this.puzzles[n] = this.puzzles[n2];
        this.puzzles[n2] = n3;
        this.firePuzzleChanged(n);
        this.firePuzzleChanged(n2);
    }

    public synchronized boolean isSelected(int n) {
        return n == this.selectedPos;
    }

    public synchronized int getSelected() {
        return this.selectedPos;
    }

    public synchronized void setSelected(int n) {
        if (n < 0) {
            n = -1;
        }
        if (this.selectedPos == n) {
            return;
        }
        if (this.selectedPos >= 0) {
            this.firePuzzleChanged(this.selectedPos);
        }
        this.selectedPos = n;
        this.firePuzzleChanged(this.selectedPos);
    }

    public synchronized void unselect() {
        this.setSelected(-1);
    }

    public synchronized boolean isMatched(int n) {
        return this.puzzles[n] == n;
    }

    public synchronized boolean isFinished() {
        int n = 0;
        while (n < this.puzzles.length) {
            if (this.puzzles[n] != n) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void firePuzzleChanged(int n) {
        if (this.listener != null) {
            this.listener.puzzleChanged(n);
        }
    }
}

