/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.games.swappuz;

import com.ixisoft.games.score.ScoreRanker;
import com.ixisoft.games.score.ScoreRankerListener;
import com.ixisoft.games.swappuz.GameModel;
import com.ixisoft.games.swappuz.PieceRegion;
import com.ixisoft.games.swappuz.SwapPuzzleMIDlet;
import com.ixisoft.games.swappuz.TimeScore;
import com.ixisoft.midlet.imageloader.ImageLoader;
import com.ixisoft.midlet.region.BorderRegion;
import com.ixisoft.midlet.region.ImageRegion;
import com.ixisoft.midlet.region.StringRegion;
import com.ixisoft.midlet.util.ContainerCanvas;
import com.ixisoft.midlet.util.MIDletContext;
import com.ixisoft.midlet.util.MIDletUtils;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStoreException;

public class PuzzleCanvas
extends ContainerCanvas
implements CommandListener,
ScoreRankerListener {
    private Timer timer;
    private static final Command CMD_HINTS = new Command("\u63d0\u793a", 5, 1);
    private static final Command CMD_END = new Command("\u7ed3\u675f", 6, 0);
    private static final Command CMD_NEW_GAME = new Command("\u91cd\u73a9", 4, 11);
    private static Alert hintsAlert;
    static Image IMG_PUZZLE_CURRENT;
    static Image IMG_SELECTED;
    static Image IMG_UNMATCHED;
    static final int IMAGES = 12;
    private static final int LOCAL_IMAGES = 3;
    private static boolean classImagesLoaded;
    static final int ROWS = 4;
    static final int COLS = 5;
    static final int PIECE_W = 40;
    static final int PIECE_H = 40;
    private GameModel model;
    private PieceRegion[] pieceRegion;
    private ImageRegion winImageRegion;
    private StringRegion statusRegion;
    private BorderRegion statusBorderRegion;
    private static final int PUZZLE_X = 20;
    private static final int PUZZLE_Y = 25;
    private static final int STATUS_X = 20;
    private static final int STATUS_Y = 195;
    private static final int STATUS_W = 200;
    private static final int STATUS_H = 25;
    private ScoreRanker ranker;
    private final Object notifier = new Object();
    private boolean enableGameInput = false;
    private TimerTask winningTask = null;
    boolean playing = false;
    private long gameStartTime;
    Image offImage;
    CommandListener listener = null;

    private static synchronized void loadClassImages() throws IOException {
        if (classImagesLoaded) {
            return;
        }
        ImageLoader imageLoader = ImageLoader.getInstance();
        StringBuffer stringBuffer = new StringBuffer().append("PUZZLE-");
        MIDletUtils.getInstance();
        IMG_PUZZLE_CURRENT = imageLoader.getImage(stringBuffer.append(MIDletUtils.getRandomInt(5)).toString());
        IMG_SELECTED = Image.createImage((String)"/puzzle/selected.png");
        IMG_UNMATCHED = Image.createImage((String)"/puzzle/unmatched.png");
        classImagesLoaded = true;
    }

    public PuzzleCanvas() throws IOException {
        this.timer = new Timer();
        this.model = new GameModel(20);
        this.pieceRegion = new PieceRegion[20];
        this.winImageRegion = new ImageRegion(null);
        this.statusRegion = new StringRegion();
        this.statusBorderRegion = new BorderRegion(3);
        PuzzleCanvas.loadClassImages();
        this.model.setPuzzleListener(this);
        this.winImageRegion.setVisible(false);
        this.addRegion(this.winImageRegion, 20, 25, 200, 160);
        int n = 0;
        while (n < 4) {
            int n2 = 0;
            while (n2 < 5) {
                int n3 = n * 5 + n2;
                this.pieceRegion[n3] = new PieceRegion(this.model, 4, 5, n3);
                int n4 = n2 * 40;
                int n5 = n * 40;
                this.addRegion(this.pieceRegion[n3], 20 + n4, 25 + n5, 40, 40);
                ++n2;
            }
            ++n;
        }
        super.setCommandListener((CommandListener)this);
        BorderRegion borderRegion = new BorderRegion(3);
        this.addRegion(borderRegion, 18, 23, 204, 164);
        this.statusRegion.setFont(SwapPuzzleMIDlet.SMALL_FONT);
        this.statusRegion.setHorizontalAlignment(1);
        this.statusRegion.setVerticalAlignment(16);
        this.statusRegion.setValue("\u70b9\u51fb\"\u5f00\u59cb\"");
        this.addRegion(this.statusRegion, 20, 195, 200, 25);
        this.addRegion(this.statusBorderRegion, 18, 193, 204, 29);
        this.resetGame();
    }

    public void init(MIDletContext mIDletContext) {
        this.setMIDletContext(mIDletContext);
        this.ranker = (ScoreRanker)mIDletContext.getAttribute("ranker");
    }

    public void nextPuzzle() {
        try {
            ImageLoader imageLoader = ImageLoader.getInstance();
            StringBuffer stringBuffer = new StringBuffer().append("PUZZLE-");
            MIDletUtils.getInstance();
            IMG_PUZZLE_CURRENT = imageLoader.getImage(stringBuffer.append(MIDletUtils.getRandomInt(5)).toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void paintBackground(Graphics graphics) {
        int n = graphics.getColor();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(n);
    }

    public void puzzleChanged(int n) {
        if (n < 0) {
            return;
        }
        PieceRegion pieceRegion = this.pieceRegion[n];
        this.repaint(pieceRegion.getX(), pieceRegion.getY(), pieceRegion.getWidth(), pieceRegion.getHeight());
    }

    protected void pointerReleased(int n, int n2) {
        boolean bl = false;
        if (!this.enableGameInput) {
            return;
        }
        GameModel gameModel = this.model;
        synchronized (gameModel) {
            if (!this.enableGameInput) {
                return;
            }
            this.enableGameInput = false;
            MIDletUtils mIDletUtils = MIDletUtils.getInstance();
            int n3 = 0;
            while (n3 < this.pieceRegion.length) {
                PieceRegion pieceRegion = this.pieceRegion[n3];
                if (MIDletUtils.rectangleContains(pieceRegion.getX(), pieceRegion.getY(), pieceRegion.getWidth(), pieceRegion.getHeight(), n, n2)) {
                    if (this.model.isMatched(n3)) break;
                    int n4 = this.model.getSelected();
                    if (n4 < 0) {
                        this.model.setSelected(n3);
                        break;
                    }
                    if (n4 == n3) {
                        this.model.unselect();
                        break;
                    }
                    this.model.unselect();
                    this.model.swap(n3, n4);
                    if (this.isGameFinished()) {
                        this.gameWon();
                        bl = true;
                        break;
                    }
                    int n5 = 0;
                    n5 += this.model.isMatched(n3) ? 1 : 0;
                    if ((n5 += this.model.isMatched(n4) ? 1 : 0) == 2) {
                        this.statusRegion.setValue("\u68d2\u6781\u4e86");
                    } else if (n5 == 1) {
                        this.statusRegion.setValue("\u5e72\u5f97\u4e0d\u9519");
                    } else {
                        this.statusRegion.setValue("\u518d\u8bd5\u4e00\u4e0b");
                    }
                    this.statusRegion.repaintRegion();
                    break;
                }
                ++n3;
            }
            if (!bl) {
                this.enableGameInput = true;
            }
        }
        this.serviceRepaints();
    }

    private boolean isGameFinished() {
        return this.model.isFinished();
    }

    public void destroy() {
        this.timer.cancel();
        super.destroy();
    }

    public void gameWon() {
        long l = System.currentTimeMillis();
        long l2 = l - this.gameStartTime;
        long l3 = l2 / 1000L;
        long l4 = l2 % 1000L;
        TimeScore timeScore = new TimeScore(l2);
        int n = -1;
        try {
            n = this.ranker.recordScore(this, timeScore);
        }
        catch (RecordStoreException recordStoreException) {
            this.statusRegion.setValue("\u51fa\u9519.\u6ca1\u6709\u8bb0\u5f55\u88ab\u4fdd\u5b58.");
        }
        if (n < 0) {
            this.statusRegion.setValue("\u65f6\u95f4: " + l3 + "." + l4 / 10L + "\u79d2");
        } else {
            this.statusRegion.setValue("\u65b0\u8bb0\u5f55: " + l3 + "." + l4 / 10L + "\u79d2");
        }
        this.statusRegion.repaintRegion();
        this.removeCommand(CMD_HINTS);
        this.removeCommand(CMD_END);
        this.addCommand(SwapPuzzleMIDlet.CMD_RETURN);
        this.addCommand(CMD_NEW_GAME);
        this.serviceRepaints();
        AlertType.ERROR.playSound(Display.getDisplay((MIDlet)this.getMIDletContext().getMIDlet()));
        this.winImageRegion.setVisible(true);
        this.winImageRegion.setImageLocator("/puzzle/win1.png");
    }

    private void endGame() {
        this.playing = false;
        this.enableGameInput = false;
        if (this.winningTask != null) {
            this.winningTask.cancel();
            this.winningTask = null;
        }
        this.removeCommand(CMD_HINTS);
        this.removeCommand(CMD_END);
        this.removeCommand(CMD_NEW_GAME);
        this.repaint();
        SwapPuzzleMIDlet swapPuzzleMIDlet = (SwapPuzzleMIDlet)this.getMIDletContext().getMIDlet();
        Display.getDisplay((MIDlet)swapPuzzleMIDlet).setCurrent((Displayable)swapPuzzleMIDlet.openScreen);
    }

    public void quitGame() {
        this.endGame();
    }

    private void resetGame() {
        if (this.winningTask != null) {
            this.winningTask.cancel();
            this.winningTask = null;
        }
        this.winImageRegion.setVisible(false);
        int n = 0;
        while (n < this.pieceRegion.length) {
            this.pieceRegion[n].setVisible(true);
            ++n;
        }
        this.statusRegion.setValue("\u70b9\u51fb\"\u5f00\u59cb\"");
        this.playing = true;
        this.enableGameInput = true;
        this.model.reset();
        this.removeCommand(CMD_NEW_GAME);
        this.removeCommand(CMD_HINTS);
        this.removeCommand(CMD_END);
        this.addCommand(SwapPuzzleMIDlet.CMD_PLAY);
        this.addCommand(SwapPuzzleMIDlet.CMD_RETURN);
        this.repaint();
    }

    public void startGame() {
        this.resetGame();
        this.addCommand(CMD_HINTS);
        this.addCommand(CMD_END);
        this.removeCommand(CMD_NEW_GAME);
        this.removeCommand(SwapPuzzleMIDlet.CMD_PLAY);
        this.removeCommand(SwapPuzzleMIDlet.CMD_RETURN);
        this.model.shuffle();
        this.statusRegion.setVisible(true);
        this.statusRegion.setValue("\u6e38\u620f\u5f00\u59cb");
        this.statusBorderRegion.setVisible(true);
        this.repaint();
        this.serviceRepaints();
        this.gameStartTime = System.currentTimeMillis();
    }

    public void paint(Graphics graphics) {
        if (this.offImage == null) {
            this.offImage = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        }
        Graphics graphics2 = this.offImage.getGraphics();
        graphics2.setClip(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
        super.paint(graphics2);
        graphics.drawImage(this.offImage, 0, 0, 20);
    }

    public void removeCommandListener() {
        this.listener = null;
    }

    public void setCommandListener(CommandListener commandListener) {
        this.listener = commandListener;
    }

    public synchronized void commandAction(Command command, Displayable displayable) {
        if (command == CMD_HINTS) {
            if (hintsAlert == null) {
                hintsAlert = new Alert("\u63d0\u793a", null, IMG_PUZZLE_CURRENT, AlertType.INFO);
                hintsAlert.setTimeout(-2);
            }
            Display.getDisplay((MIDlet)this.getMIDletContext().getMIDlet()).setCurrent((Displayable)hintsAlert);
        } else if (command == CMD_END) {
            this.quitGame();
        } else if (command == CMD_NEW_GAME) {
            if (this.winningTask != null) {
                this.winningTask.cancel();
                this.winningTask = null;
            }
            this.statusRegion.setValue("\u52a0\u8f7d\u56fe\u7247 \u8bf7\u7a0d\u7b49...");
            this.statusRegion.repaintRegion();
            this.serviceRepaints();
            this.nextPuzzle();
            hintsAlert = null;
            this.resetGame();
        } else if (this.listener != null) {
            this.listener.commandAction(command, displayable);
        }
    }

    public void scoreUpdating() {
        this.statusRegion.setValue("\u66f4\u65b0\u8bb0\u5f55\u4e2d");
        this.statusRegion.repaintRegion();
    }

    public void scoreUpdated() {
        this.statusRegion.setValue("\u8bb0\u5f55\u88ab\u66f4\u65b0");
        this.statusRegion.repaintRegion();
    }

    public void scoreLoading() {
    }

    public void scoreLoaded() {
    }

    static {
        IMG_PUZZLE_CURRENT = null;
        IMG_SELECTED = null;
        IMG_UNMATCHED = null;
        classImagesLoaded = false;
    }
}

