/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.games.swappuz;

import com.ixisoft.games.score.ScoreRanker;
import com.ixisoft.games.score.ScoreRankerListener;
import com.ixisoft.games.swappuz.BestTimeScreen;
import com.ixisoft.games.swappuz.PuzzleCanvas;
import com.ixisoft.games.swappuz.TimeScoreFactory;
import com.ixisoft.midlet.imageloader.ImageLoader;
import com.ixisoft.midlet.region.StringRegion;
import com.ixisoft.midlet.util.MIDletContext;
import com.ixisoft.midlet.util.MIDletContextImpl;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class SwapPuzzleMIDlet
extends MIDlet
implements CommandListener,
ScoreRankerListener {
    Display display;
    private final MIDletContext context = new MIDletContextImpl(this);
    ScoreRanker ranker;
    Form openScreen = new Form("\u62fc\u56fe\u6e38\u620f");
    private static final String RMS_PUZZLE_SCORE = "puzzle-time";
    static final String KEY_RANKER = "ranker";
    boolean justCreated;
    BestTimeScreen scoreScreen;
    StringRegion status;
    private static final int HELP_PAGES = 2;
    private static final int ABOUT_PAGES = 2;
    private Vector helpScreens;
    private Vector aboutScreens;
    private PuzzleCanvas gameScreen;
    private static Command CMD_GAME = new Command("\u5f00\u59cb", 4, 1);
    private static Command CMD_QUIT = new Command("\u9000\u51fa", 6, 0);
    private static Command CMD_HELP = new Command("\u5e2e\u52a9", 5, 2);
    private static Command CMD_ABOUT = new Command("\u5173\u4e8e", 5, 3);
    private static Command CMD_NEXT = new Command("\u7ee7\u7eed", 4, 101);
    static Command CMD_MAIN = new Command("\u4e3b\u9875", 6, 102);
    private static Command CMD_PREV = new Command("\u5411\u524d", 2, 103);
    static Command CMD_SCORE = new Command("\u8bb0\u5f55", 1, 140);
    static Command CMD_RESET = new Command("\u6e05\u7a7a", 1, 150);
    static Command CMD_RETURN = new Command("\u8fd4\u56de", 2, 10);
    static Command CMD_PLAY = new Command("\u5f00\u59cb", 4, 20);
    static final Font SMALL_FONT = Font.getFont((int)64, (int)0, (int)8);

    public SwapPuzzleMIDlet() {
        this.openScreen.append("  \n");
        try {
            Image image = Image.createImage((String)"/puzzle/game-logo.png");
            this.openScreen.append((Item)new ImageItem(null, image, 3, "SwapPuzzle"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.openScreen.append("  \n");
        this.openScreen.append("  \n");
        this.openScreen.append("    Version 1.0.2 \n");
        this.openScreen.append("    Created By \n");
        this.openScreen.append("     ToneHub  Corp.\n");
        this.openScreen.append("Email:tonehub@yahoo.com\n");
        this.openScreen.addCommand(CMD_GAME);
        this.openScreen.addCommand(CMD_QUIT);
        this.openScreen.addCommand(CMD_HELP);
        this.openScreen.addCommand(CMD_SCORE);
        this.openScreen.setCommandListener((CommandListener)this);
        this.display = Display.getDisplay((MIDlet)this);
        this.justCreated = true;
        this.status = new StringRegion();
        this.helpScreens = new Vector();
        this.aboutScreens = new Vector();
        this.status.setFont(SMALL_FONT);
        this.status.setHorizontalAlignment(1);
        this.ranker = new ScoreRanker("\u62fc\u56fe\u65f6\u95f4", new TimeScoreFactory(), 3);
        this.context.puAttribute(KEY_RANKER, this.ranker);
    }

    protected void startApp() {
        this.display.setCurrent((Displayable)this.openScreen);
        this.openScreen.setCommandListener((CommandListener)this);
        if (this.justCreated) {
            this.justCreated = false;
            ImageLoader imageLoader = ImageLoader.getInstance();
            imageLoader.putAlias("PUZZLE-0", "/puzzle/puz1.png");
            imageLoader.putAlias("PUZZLE-1", "/puzzle/puz2.png");
            imageLoader.putAlias("PUZZLE-2", "/puzzle/puz3.png");
            imageLoader.putAlias("PUZZLE-3", "/puzzle/puz4.png");
            imageLoader.putAlias("PUZZLE-4", "/puzzle/puz5.png");
            imageLoader.putAlias("PUZZLE-5", "/puzzle/puz1.png");
            imageLoader.putAlias("PUZZLE-6", "/puzzle/puz2.png");
            imageLoader.putAlias("PUZZLE-7", "/puzzle/puz3.png");
            imageLoader.putAlias("PUZZLE-8", "/puzzle/puz4.png");
            imageLoader.putAlias("PUZZLE-9", "/puzzle/puz5.png");
            imageLoader.putAlias("PUZZLE-10", "/puzzle/puz1.png");
            imageLoader.putAlias("PUZZLE-11", "/puzzle/puz2.png");
            try {
                this.ranker.load(this);
                this.status.setValue("");
            }
            catch (Exception exception) {
                this.status.setValue("\u51fa\u9519.\u6ca1\u6709\u8bb0\u5f55\u88ab\u4fdd\u5b58.");
            }
            this.status.repaintRegion();
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean bl) {
        if (this.gameScreen != null) {
            this.gameScreen.destroy();
        }
        this.display.setCurrent(null);
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            int n = this.helpScreens.indexOf(displayable);
            if (n >= 0) {
                this.commandHelpAction(command, n);
            } else {
                n = this.aboutScreens.indexOf(displayable);
                if (n >= 0) {
                    this.commandAboutAction(command, n);
                } else if (command == CMD_QUIT) {
                    this.notifyDestroyed();
                } else if (command == CMD_ABOUT) {
                    this.prepareAboutScreen(0);
                    this.display.setCurrent((Displayable)this.aboutScreens.firstElement());
                } else if (command == CMD_HELP) {
                    this.prepareHelpScreen(0);
                    this.display.setCurrent((Displayable)this.helpScreens.firstElement());
                } else if (command == CMD_GAME) {
                    this.prepareGameScreen();
                    this.display.setCurrent((Displayable)this.gameScreen);
                    this.gameScreen.repaint();
                } else if (command == CMD_RETURN) {
                    this.display.setCurrent((Displayable)this.openScreen);
                } else if (command == CMD_PLAY) {
                    this.gameScreen.startGame();
                } else if (command == CMD_SCORE) {
                    this.prepareScoreScreen();
                    this.scoreScreen.refresh();
                    this.display.setCurrent((Displayable)this.scoreScreen);
                } else if (command == CMD_RESET) {
                    this.scoreScreen.reset();
                } else if (command == CMD_MAIN) {
                    this.display.setCurrent((Displayable)this.openScreen);
                }
            }
        }
        catch (IOException iOException) {
            this.status.setValue("\u52a0\u8f7d\u9519\u8bef.\u7a0d\u5019\u518d\u8bd5");
            this.status.repaintRegion();
        }
        catch (Exception exception) {
            this.showError(exception);
        }
    }

    private void commandHelpAction(Command command, int n) throws IOException {
        if (command == CMD_MAIN) {
            this.display.setCurrent((Displayable)this.openScreen);
        } else if (command == CMD_NEXT) {
            this.prepareHelpScreen(n + 1);
            this.display.setCurrent((Displayable)this.helpScreens.elementAt(n + 1));
        } else if (command == CMD_PREV) {
            this.display.setCurrent((Displayable)this.helpScreens.elementAt(n - 1));
        }
    }

    private void commandAboutAction(Command command, int n) throws IOException {
        if (command == CMD_MAIN) {
            this.display.setCurrent((Displayable)this.openScreen);
        } else if (command == CMD_NEXT) {
            this.prepareAboutScreen(n + 1);
            this.display.setCurrent((Displayable)this.aboutScreens.elementAt(n + 1));
        } else if (command == CMD_PREV) {
            this.display.setCurrent((Displayable)this.aboutScreens.elementAt(n - 1));
        }
    }

    private void showError(Exception exception) {
        this.showError(exception, null);
    }

    private void showError(Exception exception, String string) {
        Form form = new Form("Error");
        if (string != null) {
            form.append((Item)new StringItem(null, string));
        }
        if (exception != null) {
            form.append((Item)new StringItem(exception.getClass().getName(), exception.getMessage()));
        }
        form.addCommand(CMD_QUIT);
        this.display.setCurrent((Displayable)form);
        form.setCommandListener((CommandListener)this);
    }

    private void prepareOpenScreen() throws IOException {
        if (this.openScreen != null) {
            return;
        }
    }

    private void prepareHelpScreen(int n) throws IOException {
        Vector vector = this.helpScreens;
        synchronized (vector) {
            if (this.helpScreens.size() > n) {
                return;
            }
            Form form = new Form("\u5e2e\u52a9 " + (n + 1) + "/" + 2);
            switch (n) {
                case 0: {
                    form.append((Item)new StringItem(null, "\u6e38\u620f\u5f00\u59cb\u663e\u793a\u4e00\u5e45\u968f\u673a\u7684\u56fe\u7247\u3002\u5355\u51fb\"\u5f00\u59cb\"\u6309\u94ae\u5f00\u59cb\u62fc\u56fe\u3002\u56fe\u7247\u88ab\u5206\u621020\u5757\uff0c\u968f\u673a\u6392\u5217\u3002\u70b9\u51fb\u4e00\u5757\u56fe\u7247\uff0c\u7136\u540e\u9009\u62e9\u53e6\u4e00\u5757\u56fe\u7247\u8fdb\u884c\u4ea4\u6362\u3002\u518d\u70b9\u51fb\u4e00\u6b21\u53ef\u53d6\u6d88\u5bf9\u8be5\u56fe\u7247\u7684\u9009\u62e9\u3002\u56fe\u7247\u5982\u679c\u6240\u5904\u4f4d\u7f6e\u6b63\u786e\uff0c\u5c31\u9501\u5b9a\u5728\u8fd9\u4e2a\u4f4d\u7f6e\u3002"));
                    break;
                }
                case 1: {
                    form.append((Item)new StringItem(null, "\u5f53\u6240\u6709\u56fe\u7247\u6392\u5217\u6b63\u786e\u540e\u4f1a\u663e\u793a\u6240\u82b1\u7684\u65f6\u95f4\u3002\u70b9\u51fb\"\u91cd\u73a9\"\u5f00\u59cb\u65b0\u7684\u6e38\u620f\u3002\u5728\u6e38\u620f\u8fc7\u7a0b\u4e2d\u4f60\u53ef\u4ee5\u70b9\u51fb\"\u63d0\u793a\"\u770b\u521d\u59cb\u7684\u56fe\u7247\uff0c\u70b9\u51fb\"Done\"\u7ee7\u7eed\u6e38\u620f\u3002"));
                }
            }
            if (n < 1) {
                form.addCommand(CMD_NEXT);
            }
            if (n > 0) {
                form.addCommand(CMD_PREV);
            }
            form.addCommand(CMD_MAIN);
            form.setCommandListener((CommandListener)this);
            this.helpScreens.addElement(form);
        }
    }

    private void prepareAboutScreen(int n) throws IOException {
        Vector vector = this.aboutScreens;
        synchronized (vector) {
            if (this.aboutScreens.size() > n) {
                return;
            }
            Form form = new Form("About Page " + (n + 1) + "/" + 2);
            switch (n) {
                case 0: {
                    form.append((Item)new StringItem("Product: ", "  SwapPuzzle"));
                    form.append((Item)new StringItem("Version: ", "  v 1.0"));
                    form.append((Item)new StringItem("Created-by:", "   ToneHub  Corp."));
                    break;
                }
                case 1: {
                    form.append((Item)new StringItem("Company:", "  ToneHub  Corp Ltd."));
                    form.append((Item)new StringItem("Email: ", "  tonehub@yahoo.com"));
                }
            }
            if (n < 1) {
                form.addCommand(CMD_NEXT);
            }
            if (n > 0) {
                form.addCommand(CMD_PREV);
            }
            form.addCommand(CMD_MAIN);
            form.setCommandListener((CommandListener)this);
            this.aboutScreens.addElement(form);
        }
    }

    private void prepareGameScreen() throws IOException {
        PuzzleCanvas puzzleCanvas = new PuzzleCanvas();
        puzzleCanvas.addCommand(CMD_PLAY);
        puzzleCanvas.addCommand(CMD_RETURN);
        puzzleCanvas.setCommandListener(this);
        puzzleCanvas.init(this.context);
        this.gameScreen = puzzleCanvas;
        this.status.setValue(null);
    }

    private void prepareScoreScreen() {
        BestTimeScreen bestTimeScreen = new BestTimeScreen(this.ranker);
        bestTimeScreen.addCommand(CMD_MAIN);
        bestTimeScreen.addCommand(CMD_RESET);
        bestTimeScreen.setCommandListener(this);
        this.scoreScreen = bestTimeScreen;
    }

    public void scoreUpdating() {
    }

    public void scoreUpdated() {
    }

    public void scoreLoading() {
        this.status.setValue("\u52a0\u8f7d\u8bb0\u5f55\u4e2d...");
        this.status.repaintRegion();
    }

    public void scoreLoaded() {
        this.status.setValue("\u8bb0\u5f55\u5df2\u52a0\u8f7d...");
        this.status.repaintRegion();
    }
}

