/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.midlet.region;

import com.ixisoft.midlet.util.Region;
import javax.microedition.lcdui.Graphics;

public class BorderRegion
extends Region {
    public static final int PLAIN = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    public static final int DARKER_RAISED = 3;
    public static final int DARKER_LOWERED = 4;
    public static final int DARK_GREY = 0x555555;
    public static final int LIGHT_GREY = 0xAAAAAA;
    public static final int BLACK = 0;
    public static final int WHITE = 0xFFFFFF;
    private int borderType;
    private int color1;
    private int color2;
    private int color3;
    private boolean transparent = true;
    private int bgColor = 0xFFFFFF;

    public BorderRegion() {
        this(1);
    }

    public BorderRegion(int n) {
        this.borderType = n;
        switch (n) {
            case 3: {
                this.color2 = 0xFFFFFF;
                this.color3 = 0;
                this.color1 = 0x555555;
                break;
            }
            case 4: {
                this.color2 = 0;
                this.color3 = 0xFFFFFF;
                this.color1 = 0x555555;
                break;
            }
            case 1: {
                this.color2 = 0xFFFFFF;
                this.color3 = 0x555555;
                this.color1 = 0xAAAAAA;
                break;
            }
            case 2: {
                this.color2 = 0x555555;
                this.color3 = 0xFFFFFF;
                this.color1 = 0xAAAAAA;
                break;
            }
            default: {
                this.color2 = 0xAAAAAA;
                this.color3 = 0xAAAAAA;
                this.color1 = 0xAAAAAA;
            }
        }
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    public void setBackground(int n) {
        this.bgColor = n;
        this.setTransparent(false);
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (!this.transparent) {
            graphics.setColor(this.bgColor);
            graphics.fillRect(0, 0, n, n2);
        }
        graphics.setColor(this.color1);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        graphics.drawRect(1, 1, n - 3, n2 - 3);
        if (this.borderType != 0) {
            graphics.setColor(this.color2);
            graphics.drawLine(1, 1, n - 3, 1);
            graphics.drawLine(1, 1, 1, n2 - 3);
            graphics.setColor(this.color3);
            graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
        }
    }
}

