/*
 * Decompiled with CFR 0.152.
 */
package com.lunagames.atc;

import com.lunagames.atc.AtcGame;
import com.lunagames.atc.PhysicsObject;
import com.lunagames.dig.DigGame;

public class Airplane
extends PhysicsObject {
    private boolean m_collision;
    public static final int STATE_FLIGHT = 0;
    public static final int STATE_TAXIIN = 1;
    public static final int STATE_TAXIOUT = 2;
    public static final int STATE_EXIT = 3;
    public static final int STATE_LANDING = 4;
    public static final int STATE_TAKEOFF = 5;
    public static final int STATE_TAKEOFF_DONE = 6;
    public static final int DEST_EXIT1 = 8;
    public static final int DEST_EXIT2 = 9;
    public static final int DEST_EXIT3 = 10;
    public static final int DEST_EXIT4 = 11;
    public static final int DEST_LAND = 12;
    static final int FLIGHT_ALT = 10;
    static final int LANDING_SPEED = 600;
    static final int TAXI_SPEED = 350;
    static final int DECENT_TM = 7000;
    static final int CLIMB_TM = 3000;
    static final int TAKEOFF_TM = 6000;
    static final int WAIT_TAKEOFF_TM = 5000;
    static final int LIGHT_TM = 1800;
    private long m_lightTm;
    private long m_timeInState;
    private long m_stateTm;
    private int m_state;
    private int m_destination;
    private boolean m_active;
    private int m_altitude;

    public void reset() {
        super.reset();
        this.m_collision = false;
        this.m_destination = 0;
        this.m_active = true;
        this.m_altitude = 10;
        this.setState(0);
        this.m_lightTm = System.currentTimeMillis() + (long)DigGame.getRandom(1000);
    }

    public boolean getLight(boolean bl, int[] nArray) {
        if (this.m_lightTm + 1800L < System.currentTimeMillis()) {
            this.m_lightTm = System.currentTimeMillis();
        }
        long l = System.currentTimeMillis() - this.m_lightTm;
        if (bl && l > 0L && l < 300L) {
            if (this.getDirection() == 0) {
                nArray[0] = nArray[0] + 3;
                nArray[1] = nArray[1] + 6;
            } else if (this.getDirection() == 45) {
                nArray[0] = nArray[0] + 5;
                nArray[1] = nArray[1] + 5;
            } else if (this.getDirection() == 90) {
                nArray[0] = nArray[0] + 5;
                nArray[1] = nArray[1] + 4;
            } else if (this.getDirection() == 135) {
                nArray[0] = nArray[0] + 7;
                nArray[1] = nArray[1] + 5;
            } else if (this.getDirection() == 180) {
                nArray[0] = nArray[0] + 8;
                nArray[1] = nArray[1] + 5;
            } else if (this.getDirection() == 225) {
                nArray[0] = nArray[0] + 7;
                nArray[1] = nArray[1] + 7;
            } else if (this.getDirection() == 270) {
                nArray[0] = nArray[0] + 7;
                nArray[1] = nArray[1] + 7;
            } else if (this.getDirection() == 315) {
                nArray[0] = nArray[0] + 5;
                nArray[1] = nArray[1] + 7;
            }
            return true;
        }
        if (!bl && l > 400L && l < 700L) {
            if (this.getDirection() == 0) {
                nArray[0] = nArray[0] + 7;
                nArray[1] = nArray[1] + 6;
            } else if (this.getDirection() == 45) {
                nArray[0] = nArray[0] + 7;
                nArray[1] = nArray[1] + 7;
            } else if (this.getDirection() == 90) {
                nArray[0] = nArray[0] + 5;
                nArray[1] = nArray[1] + 8;
            } else if (this.getDirection() == 135) {
                nArray[0] = nArray[0] + 5;
                nArray[1] = nArray[1] + 7;
            } else if (this.getDirection() == 180) {
                nArray[0] = nArray[0] + 4;
                nArray[1] = nArray[1] + 5;
            } else if (this.getDirection() == 225) {
                nArray[0] = nArray[0] + 5;
                nArray[1] = nArray[1] + 5;
            } else if (this.getDirection() == 270) {
                nArray[0] = nArray[0] + 7;
                nArray[1] = nArray[1] + 3;
            } else if (this.getDirection() == 315) {
                nArray[0] = nArray[0] + 7;
                nArray[1] = nArray[1] + 5;
            }
            return true;
        }
        return false;
    }

    public void startLanding() {
        this.setState(4);
        this.setSpeed(600 * AtcGame.getSpeedMultiplier());
    }

    public void startTaxiout() {
        this.m_altitude = 1;
        this.setSpeed(0);
        this.setState(2);
    }

    public void startTakeoff() {
        this.m_altitude = 1;
        this.setSpeed(0);
        this.setState(5);
    }

    public void startExit() {
        this.setState(3);
    }

    public void startFlight() {
        this.setState(0);
    }

    public boolean isActive() {
        return this.m_active;
    }

    public void setActive(boolean bl) {
        this.m_active = bl;
    }

    private void setState(int n) {
        this.m_state = n;
        this.m_timeInState = System.currentTimeMillis();
        this.m_stateTm = 0L;
    }

    public int getState() {
        return this.m_state;
    }

    public long getTimeInState() {
        return System.currentTimeMillis() - this.m_timeInState;
    }

    public int getDestination() {
        return this.m_destination;
    }

    public void setDestination(int n) {
        this.m_destination = n;
    }

    public int getAltitude() {
        return this.m_altitude;
    }

    public void calcPhysics() {
        super.calcPhysics();
        if (this.m_state == 4 && this.m_stateTm < System.currentTimeMillis()) {
            this.m_stateTm = System.currentTimeMillis() + 7000L;
            --this.m_altitude;
            if (this.m_altitude == 1) {
                this.setState(1);
                this.setSpeed(350 * AtcGame.getSpeedMultiplier());
            }
        }
        if (this.m_state == 2 && this.getTimeInState() > 5000L) {
            this.startTakeoff();
        }
        if (this.m_state == 5) {
            this.setSpeed(300 * AtcGame.getSpeedMultiplier());
            if (this.getTimeInState() > 15000L) {
                this.setSpeed(600 * AtcGame.getSpeedMultiplier());
            }
            if (this.getTimeInState() > 20000L) {
                this.setSpeed(800 * AtcGame.getSpeedMultiplier());
                if (this.m_stateTm < System.currentTimeMillis()) {
                    this.m_stateTm = System.currentTimeMillis() + 3000L;
                    ++this.m_altitude;
                    if (this.m_altitude == 10) {
                        this.setState(6);
                    }
                }
            }
        }
    }

    public void setWarning(boolean bl) {
        this.m_collision = bl;
    }

    public boolean isWarning() {
        return this.m_collision;
    }
}

