/*
 * Decompiled with CFR 0.152.
 */
package com.lunagames.atc;

import com.lunagames.atc.Airplane;
import com.lunagames.atc.PhysicsObject;
import com.lunagames.dig.DigGame;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public final class AtcGame
extends DigGame {
    private boolean m_helpSkipped;
    static final int VIEW_CMCC = 1000;
    static final int VIEW_BBX = 1000;
    static final int VIEW_INTRO = 50;
    static final int VIEW_MAIN = 100;
    static final int VIEW_LANGUAGES = 51;
    static final int VIEW_PRELEVEL = 101;
    static final int VIEW_COMPLETED = 133;
    static final int VIEW_LOST = 111;
    static final int VIEW_CRASH = 122;
    static final int VIEW_LEVEL = 105;
    static final int VIEW_HELP = 148;
    static final int VIEW_PRACTICE = 149;
    static final int VIEW_EXIT = 150;
    static final int VIEW_HOLD = 151;
    static final int VIEW_OPTIONS = 102;
    static final int VIEW_KEFU = 222;
    static final int VIEW_VIEWTODISP = 250;
    static final int VIEW_DISPCONFIRM_OK = 252;
    static final int VIEW_DISPCONFIRM_NG = 255;
    static final int VIEW_CONGRATION = 300;
    static final int VIEW_TOTALPOINT = 301;
    static final int VIEW_TOTALPAIHA = 302;
    static final int VIEW_HISCUPLOAD = 303;
    static final int VIEW_MYACCOUNTT = 304;
    static final int VIEW_TOTALPHELP = 305;
    static final int VIEW_ACCOUNT_MNG = 400;
    static final int MAX_PLAINS = 14;
    static final int FLASH_OBJECT_TIME = 5000;
    static final int EXIT_BOX_SIZE = 10;
    static final int INNER_PLANE_BOX = 4;
    static final int LIGHT_SPEED = 600;
    static final int PL_LEFT1 = 0;
    static final int PL_LEFT_SELECT = 56;
    static final int PL_RIGHT_SELECT = 115;
    static final int PL_LEFT2 = 60;
    static final int PL_LEFT3 = 116;
    static final int PL_YOFFSET_SELECT = 5;
    static final int PL_BAR1 = 1;
    static final int PL_BAR2 = 22;
    static final int PL_BAR3 = 43;
    static final int PL_BAR_HEIGHT = 20;
    static final int POPUP_TEXTOFFSET_X = 8;
    static final int POPUP_TEXTOFFSET_Y = 4;
    static final int MENU_LEFT = 10;
    static final int MENU_OFFSET = 5;
    static final int MENU_HEIGHT = 20;
    static final int MENU_SPACE = 0;
    static final int MENU_WIDTH = 48;
    static final int IMG_FIRST_EXIT = 8;
    static final int IMG_FIRST_PLANE = 0;
    static final int IMG_POPUP = 13;
    static final int IMG_FIRST_HELP = 22;
    static final int X_POSTLEVEL_TEXT = 0;
    static final int Y_POSTLEVEL_TEXT = 6;
    static final int BG_INTRO = 50;
    static final int BG_MAIN = 100;
    static final int BG_LEVEL = 105;
    static final int BG_FAIL = 111;
    static final int BG_SUCCEED = 122;
    static final int IMG_CRASH_POPUP = 31;
    static final int IMG_LOST_POPUP = 30;
    static final int POPUP_TIME = 3000;
    static final int SCROLLTEXT_HELPYOFFSET = 20;
    static final int SCROLLTEXT_STEPS = 4;
    static final int SCROLLTEXT_SPEED = 100;
    static final int SCROLLTEXT_HEIGHT = 22;
    static final int SCROLLTEXT_TEXTOFFSET = 3;
    static final int SCROLLTEXT_LETTERWIDTH = 4;
    static final int CONFIRM_TEXT_BOX_WIDTH = 120;
    static final int CONFIRM_TEXT_BOX_HEIGHT = 70;
    static int m_scrollTextX;
    static int m_scrollTextY;
    static String m_scrollText;
    static long m_scrollTm;
    static int m_scrollPos;
    static long m_menuSelTm;
    static int m_menuSelStep;
    static final int TM_MENU_TRACESTEP = 500;
    static long m_popupTm;
    static int m_popUp;
    static Airplane m_planePopUp;
    static int m_levelTick;
    long m_levelTm;
    long m_spare;
    int m_newPlaneInterval;
    int m_newDepartureInterval;
    long m_newPlainTm;
    long m_newDepartureTm;
    int m_baseSpeed;
    int m_planesDone;
    int m_planesLost;
    int m_planesCrashed;
    int m_maxLevel = 1;
    int m_practiceLevel = 10;
    int m_planeToDo;
    boolean m_practice;
    boolean m_planeInWarning;
    int m_selected;
    Airplane[] m_plains;
    int m_enum;
    int m_rw_x;
    int m_rw_y;
    int m_rw_w;
    int m_rw_h;
    int m_landbox_x;
    int m_landbox_y;
    int m_landbox_x2;
    int m_landbox_y2;
    int m_rw2_x;
    int m_rw2_y;
    long m_rwLightsTm;
    int m_rwLightsTick;
    int m_displaySize;
    boolean m_help;
    int m_helpStep;
    long m_helpStepTm;
    long m_helpActionTm;
    int m_helpx;
    int m_helpy;
    int m_helpbox;
    boolean m_helpStepDone;
    static final int LANG_NONE = -1;
    static final int LANG_NOTLOADED = -2;
    static final int NR_LANGUAGE = 5;
    static int m_language;
    static final String[] LANGUAGES;
    static final String[][] GAMETEXT;
    static final int GT_WAIT = 0;
    static final int GT_SELECT = 1;
    static final int GT_BACK = 2;
    static final int GT_CONTINUE = 3;
    static final int GT_EXIT = 4;
    static final int GT_START = 5;
    static final int GT_MENU_PLAY = 6;
    static final int GT_MENU_PRACTICE = 7;
    static final int GT_MENU_HELP = 8;
    static final int GT_LEVEL = 9;
    static final int GT_BUSY = 10;
    static final int GT_CLEAR1 = 11;
    static final int GT_CLEAR2 = 12;
    static final int GT_MENU_OPTIONS = 13;
    static final int GT_POPUP_LOST = 14;
    static final int GT_POPUP_CRASH = 15;
    static final int GT_HELP0 = 16;
    static final int GT_HELP1 = 17;
    static final int GT_HELP2 = 18;
    static final int GT_HELP3 = 19;
    static final int GT_HELP4 = 20;
    static final int GT_HELP5 = 21;
    static final int GT_HELP6 = 22;
    static final int GT_NEXT = 23;
    static final int GT_FAIL_LOST = 24;
    static final int GT_FAIL_CRASH = 25;
    static final int GT_LEVEL_WIN = 26;
    static final int GT_LANGUAGE = 29;
    static final int GT_CONLAVEL = 30;
    static final int GT_QUITLAVEL = 31;
    static final int GT_KEFU = 32;
    static final int GT_TTSC = 33;
    static final int GT_TT34 = 34;
    static final int GT_TT35 = 35;
    static final int GT_TT36 = 36;
    static final int GT_TT37 = 37;
    static final int GT_TT38 = 38;
    static final int GT_TT39 = 39;
    static final int GT_TT40 = 40;
    static final int GT_TT41 = 41;
    static final int GT_TT42 = 42;
    static final int GT_TT43 = 43;
    static final int GT_TT44 = 44;
    static final int GT_TT45 = 45;

    int getTickerTime() {
        return 200;
    }

    public void initSpeedAndTimers(int n) {
        this.m_baseSpeed = 900 + n * 8;
        this.m_newPlaneInterval = 44000 - n * 380;
        this.m_newDepartureInterval = 70000 - n * 450;
        if (this.m_newPlaneInterval < 6000) {
            this.m_newPlaneInterval = 6000;
        }
        if (this.m_newDepartureInterval < 25000) {
            this.m_newDepartureInterval = 25000;
        }
    }

    public int LevelTOScore(int n) {
        int n2 = 0;
        if (this.m_level == 1) {
            n2 = 3;
        }
        if (this.m_level == 2) {
            n2 = 5;
        }
        if (this.m_level == 3) {
            n2 = 10;
        }
        if (this.m_level > 3 && n <= 10) {
            n2 = 20;
        }
        if (this.m_level > 10 && n <= 20) {
            n2 = 25;
        }
        if (this.m_level > 20 && n <= 30) {
            n2 = 30;
        }
        if (this.m_level > 30) {
            n2 = 40;
        }
        if (this.m_level >= 100) {
            n2 = 100;
        }
        return n2;
    }

    public void initLevel(int n) {
        this.m_planeToDo = this.LevelTOScore(n);
        this.initSpeedAndTimers(n);
        this.clearPlains();
        this.m_selected = -1;
        m_levelTick = this.getTickerTime();
        this.m_levelTm = 0L;
        this.m_newPlainTm = 0L;
        this.m_newDepartureTm = System.currentTimeMillis() + (long)this.m_newDepartureInterval;
        this.m_planesDone = 0;
        this.m_planesLost = 0;
        this.m_planesCrashed = 0;
        this.m_rwLightsTm = 0L;
        this.m_planeInWarning = false;
        this.m_practice = false;
        this.m_help = false;
    }

    public void initPractice(int n) {
        this.initLevel(n);
        this.initSpeedAndTimers(n);
        this.m_planeToDo = 1000;
        this.m_practice = true;
    }

    String getGameText(int n) {
        return GAMETEXT[m_language][n];
    }

    public void initHelp() {
        this.initLevel(1);
        this.initSpeedAndTimers(1);
        this.m_planeToDo = 1000;
        this.clearPlains();
        this.m_selected = -1;
        m_levelTick = 100;
        this.m_levelTm = 0L;
        this.m_newPlainTm = 0L;
        this.m_newDepartureTm = System.currentTimeMillis() + (long)this.m_newDepartureInterval;
        this.m_planesDone = 0;
        this.m_planesLost = 0;
        this.m_planesCrashed = 0;
        this.m_practice = true;
        this.m_help = true;
        this.m_helpStep = 0;
        this.m_helpStepTm = 0L;
        this.m_helpActionTm = 0L;
        this.m_helpx = 0;
        this.m_helpy = 0;
        this.m_helpbox = -1;
        this.m_helpStepDone = false;
        this.m_helpSkipped = false;
        this.initScrollText("", 0, 0);
    }

    void initScrollText(String string, int n, int n2) {
        m_scrollText = string;
        m_scrollTextX = n;
        m_scrollTextY = n2;
        m_scrollTm = System.currentTimeMillis();
        m_scrollPos = 0;
    }

    void paintScrollText() {
        this.setColor(255, 255, 255);
        if (m_scrollTm < System.currentTimeMillis()) {
            m_scrollTm = System.currentTimeMillis() + 100L;
            m_scrollPos += 4;
        }
        int n = this.getStringWidth(m_scrollText);
        int n2 = m_scrollTextX - m_scrollPos + (this.getDisplayWidth() - m_scrollTextX);
        this.setClip(m_scrollTextX, m_scrollTextY, this.getDisplayWidth(), 22);
        this.drawString(m_scrollText, n2, m_scrollTextY + 4);
        if (this.getCurrentView() == 148) {
            if (m_scrollPos > n + (this.getDisplayWidth() - m_scrollTextX)) {
                m_scrollPos = 0;
                System.out.println("TEXT SCOLL DONE");
                if (this.m_helpStep != 9 && this.m_helpStep != 0) {
                    ++this.m_helpStep;
                    this.m_helpStepDone = false;
                    System.out.println("NEXT STEP (TEXT READY)");
                } else if (this.m_helpStep == 9 && this.m_helpStepDone) {
                    ++this.m_helpStep;
                    this.m_helpStepDone = false;
                }
            }
        } else if (m_scrollPos - this.getDisplayWidth() > n + (this.getDisplayWidth() - m_scrollTextX)) {
            m_scrollPos = 0;
        }
        this.setClip(0, 0, this.getDisplayWidth(), this.getDisplayHeight());
    }

    public void clearPlains() {
        for (int i = 0; i < 14; ++i) {
            this.m_plains[i].setActive(false);
        }
    }

    public void initPlains() {
        this.m_plains = new Airplane[14];
        for (int i = 0; i < 14; ++i) {
            this.m_plains[i] = new Airplane();
            this.m_plains[i].setActive(false);
        }
    }

    public int addPlain() {
        for (int i = 0; i < 14; ++i) {
            if (this.m_plains[i].isActive()) continue;
            this.m_plains[i].reset();
            return i;
        }
        return -1;
    }

    public Airplane getPlain(int n) {
        if (n >= 0 && n < 14) {
            if (this.m_plains[n].isActive()) {
                return this.m_plains[n];
            }
            return null;
        }
        return null;
    }

    public void removePlain(int n) {
        if (n == this.m_selected) {
            this.m_selected = -1;
        }
        this.m_plains[n].setActive(false);
    }

    public int enumPlains() {
        this.m_enum = 14;
        this.m_enum = this.enumNextPlain();
        return this.m_enum;
    }

    public int enumNextPlain() {
        if (this.m_enum > 0) {
            for (int i = this.m_enum - 1; i >= 0; --i) {
                if (!this.m_plains[i].isActive()) continue;
                this.m_enum = i;
                return i;
            }
        }
        this.m_enum = -1;
        return this.m_enum;
    }

    public void clearSelection() {
        this.m_selected = -1;
    }

    public void selectNext() {
        int n;
        for (n = this.m_selected + 1; n < 14; ++n) {
            if (!this.m_plains[n].isActive() || this.m_plains[n].getState() != 0) continue;
            this.m_selected = n;
            return;
        }
        for (n = 0; n < this.m_selected; ++n) {
            if (!this.m_plains[n].isActive() || this.m_plains[n].getState() != 0) continue;
            this.m_selected = n;
            return;
        }
    }

    public void selectPrevious() {
        int n;
        for (n = this.m_selected - 1; n >= 0; --n) {
            if (!this.m_plains[n].isActive() || this.m_plains[n].getState() != 0) continue;
            this.m_selected = n;
            return;
        }
        for (n = 13; n > this.m_selected; --n) {
            if (!this.m_plains[n].isActive() || this.m_plains[n].getState() != 0) continue;
            this.m_selected = n;
            return;
        }
    }

    public int getSelected() {
        return this.m_selected;
    }

    public Airplane getSelectedPlane() {
        return this.getPlain(this.getSelected());
    }

    public void addRandomPlain() {
        int n = DigGame.getRandom(8);
        int n2 = PhysicsObject.getWorldScale() / 4;
        int n3 = PhysicsObject.screenToWorld(this.getDisplayHeight()) / 4;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = DigGame.getRandom(5) + 8;
        switch (n) {
            case 0: {
                n4 = n2;
                n5 = 0;
                n6 = 180;
                if (n7 != 8) break;
                n7 = 12;
                break;
            }
            case 1: {
                n4 = n2 * 3;
                n5 = 0;
                n6 = 180;
                if (n7 != 8) break;
                n7 = 12;
                break;
            }
            case 2: {
                n4 = PhysicsObject.getWorldScale();
                n5 = n3;
                n6 = 270;
                if (n7 != 9) break;
                n7 = 12;
                break;
            }
            case 3: {
                n4 = PhysicsObject.getWorldScale();
                n5 = n3 * 3;
                n6 = 270;
                if (n7 != 9) break;
                n7 = 12;
                break;
            }
            case 4: {
                n4 = n2 * 3;
                n5 = PhysicsObject.screenToWorld(this.getDisplayHeight());
                n6 = 0;
                if (n7 != 10) break;
                n7 = 12;
                break;
            }
            case 5: {
                n4 = n2;
                n5 = PhysicsObject.screenToWorld(this.getDisplayHeight());
                n6 = 0;
                if (n7 != 10) break;
                n7 = 12;
                break;
            }
            case 6: {
                n4 = 0;
                n5 = n3 * 3;
                n6 = 90;
                if (n7 != 11) break;
                n7 = 12;
                break;
            }
            case 7: {
                n4 = 0;
                n5 = n3;
                n6 = 90;
                if (n7 != 11) break;
                n7 = 12;
            }
        }
        int n8 = this.addPlain();
        if (n8 != -1) {
            Airplane airplane = this.getPlain(n8);
            airplane.setX(n4);
            airplane.setY(n5);
            airplane.setDirection(n6);
            airplane.setDestination(n7);
            this.planeStartFlight(airplane);
        }
    }

    public void addDeparture() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n = PhysicsObject.screenToWorld(this.m_rw_x + 1);
        n2 = PhysicsObject.screenToWorld(this.m_rw_y + 2);
        n3 = 180;
        int n4 = this.addPlain();
        if (n4 != -1) {
            Airplane airplane = this.getPlain(n4);
            airplane.setX(n);
            airplane.setY(n2);
            airplane.setDirection(n3);
            airplane.setDestination(DigGame.getRandom(5) + 8);
            if (airplane.getDestination() == 12) {
                airplane.setDestination(9);
            }
            airplane.startTaxiout();
        }
    }

    public static int getSpeedMultiplier() {
        return m_levelTick / 100;
    }

    int getLevelFlightSpeed() {
        return this.m_baseSpeed * AtcGame.getSpeedMultiplier();
    }

    protected boolean onSample() {
        if (this.getCurrentView() == 105 || this.getCurrentView() == 148) {
            if (this.m_levelTm < System.currentTimeMillis()) {
                if (m_popupTm == 0L) {
                    this.m_levelTm = System.currentTimeMillis() + (long)m_levelTick;
                    int n = this.enumPlains();
                    while (n != -1) {
                        Airplane airplane = this.getPlain(n);
                        airplane.calcPhysics();
                        airplane.setWarning(false);
                        switch (airplane.getState()) {
                            case 0: {
                                this.sampleFlightState(airplane);
                                break;
                            }
                            case 3: {
                                this.sampleExitState(airplane);
                                break;
                            }
                            case 6: {
                                this.sampleTakeoffDoneState(airplane);
                                break;
                            }
                            case 1: {
                                this.sampleTaxiinState(airplane);
                            }
                        }
                        n = this.enumNextPlain();
                    }
                    this.checkCollisionsAndLost();
                    if (this.getCurrentView() == 105) {
                        if (this.m_newPlainTm < System.currentTimeMillis()) {
                            this.m_newPlainTm = System.currentTimeMillis() + (long)this.m_newPlaneInterval;
                            this.addRandomPlain();
                        }
                        if (this.m_newDepartureTm < System.currentTimeMillis()) {
                            this.m_newDepartureTm = System.currentTimeMillis() + (long)this.m_newDepartureInterval;
                            this.addDeparture();
                        }
                    } else if (this.getCurrentView() == 148) {
                        this.sampleHelp();
                    }
                }
            } else {
                try {
                    this.m_spare = this.m_levelTm - System.currentTimeMillis();
                    Thread.sleep(this.m_spare);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    private void sampleTakeoffDoneState(Airplane airplane) {
        this.planeStartFlight(airplane);
    }

    private void sampleTaxiinState(Airplane airplane) {
        if (airplane.getTimeInState() > 5000L) {
            this.planeLanded(airplane);
        }
    }

    private void sampleExitState(Airplane airplane) {
        if (airplane.getTimeInState() > 5000L) {
            this.planeExit(airplane);
        }
    }

    private void sampleFlightState(Airplane airplane) {
        if (airplane.getDestination() == 12 && airplane.getDirection() == 270 && airplane.getDisplayX() >= this.m_landbox_x && airplane.getDisplayX() <= this.m_landbox_x2 && airplane.getDisplayY() >= this.m_landbox_y && airplane.getDisplayY() <= this.m_landbox_y2) {
            this.planeStartLanding(airplane);
        }
        for (int i = 0; i < 4; ++i) {
            if (airplane.getDestination() != 8 + i || !this.isPlaneInExit(airplane, 8 + i)) continue;
            airplane.startExit();
        }
    }

    void sampleHelp() {
        if (!this.m_helpStepDone) {
            this.m_helpStepDone = true;
            switch (this.m_helpStep) {
                case 0: {
                    int n = this.addPlain();
                    Airplane airplane = this.getPlain(n);
                    airplane.setX(PhysicsObject.screenToWorld((this.getDisplaySize() >> 1) - (this.getDisplaySize() >> 2)));
                    if (this.getDisplayHeight() > 220) {
                        airplane.setY(PhysicsObject.screenToWorld((this.getDisplayHeight() >> 1) + 55));
                    } else {
                        airplane.setY(PhysicsObject.screenToWorld((this.getDisplayHeight() >> 1) + 20));
                    }
                    airplane.setDirection(0);
                    airplane.setDestination(8);
                    airplane.setSpeed(550 * AtcGame.getSpeedMultiplier());
                    n = this.addPlain();
                    airplane = this.getPlain(n);
                    if (this.getDisplayHeight() > 220) {
                        airplane.setX(PhysicsObject.screenToWorld((this.getDisplayHeight() >> 1) - 20));
                    } else {
                        airplane.setX(PhysicsObject.screenToWorld((this.getDisplayHeight() >> 1) - 5));
                    }
                    if (this.getDisplayHeight() > 220) {
                        airplane.setY(PhysicsObject.screenToWorld((this.getDisplayHeight() >> 1) + 60));
                    } else {
                        airplane.setY(PhysicsObject.screenToWorld((this.getDisplayHeight() >> 1) + 25));
                    }
                    airplane.setDirection(45);
                    airplane.setDestination(12);
                    airplane.setSpeed(550 * AtcGame.getSpeedMultiplier());
                    break;
                }
                case 1: {
                    this.m_helpStepTm = -1L;
                    this.initScrollText(this.getGameText(16), 0, this.getDisplayHeight() - 22 - 20);
                    break;
                }
                case 2: {
                    this.m_helpStepTm = -1L;
                    this.initScrollText(this.getGameText(17), 0, this.getDisplayHeight() - 22 - 20);
                    break;
                }
                case 3: {
                    this.selectNext();
                    this.m_helpStepTm = -1L;
                    this.initScrollText(this.getGameText(18), 0, this.getDisplayHeight() - 22 - 20);
                    break;
                }
                case 4: {
                    this.m_helpStepTm = -1L;
                    this.m_helpStepDone = false;
                    ++this.m_helpStep;
                    this.initScrollText(this.getGameText(19), 0, this.getDisplayHeight() - 22 - 20);
                    break;
                }
                case 5: {
                    this.m_helpStepTm = -1L;
                    this.m_helpStepDone = false;
                    if (this.m_helpActionTm >= System.currentTimeMillis()) break;
                    this.m_helpActionTm = System.currentTimeMillis() + 2200L;
                    this.selectNext();
                    break;
                }
                case 6: {
                    this.m_helpStepTm = -1L;
                    ++this.m_helpStep;
                    this.m_helpStepDone = false;
                    this.initScrollText(this.getGameText(20), 0, this.getDisplayHeight() - 22 - 20);
                    break;
                }
                case 7: {
                    this.m_helpStepDone = false;
                    Airplane airplane = this.getSelectedPlane();
                    this.selectNext();
                    Airplane airplane2 = this.getSelectedPlane();
                    if (airplane.getX() < airplane2.getX()) {
                        this.selectNext();
                    }
                    if (this.m_helpActionTm >= System.currentTimeMillis()) break;
                    this.getSelectedPlane().rotate(45);
                    this.m_helpActionTm = System.currentTimeMillis() + 2500L;
                    break;
                }
                case 8: {
                    int n = this.enumPlains();
                    while (n != -1) {
                        this.getPlain(n).setSpeed(1200 * AtcGame.getSpeedMultiplier());
                        n = this.enumNextPlain();
                    }
                    if (this.getSelectedPlane().getDisplayY() > this.getDisplayHeight() >> 1) {
                        this.getSelectedPlane().setDirection(0);
                        this.getSelectedPlane().setSpeed(400 * AtcGame.getSpeedMultiplier());
                    } else {
                        this.getSelectedPlane().setDirection(180);
                        this.getSelectedPlane().setSpeed(400 * AtcGame.getSpeedMultiplier());
                    }
                    this.m_helpStepTm = -1L;
                    this.selectNext();
                    Airplane airplane = this.getSelectedPlane();
                    if (this.m_helpSkipped || airplane.getDisplayX() <= this.m_landbox_x2) {
                        airplane.setX(PhysicsObject.screenToWorld(this.m_landbox_x2 + 10));
                        if (airplane.getDisplayY() > this.getDisplayHeight() >> 1) {
                            airplane.setY(PhysicsObject.screenToWorld((this.getDisplayHeight() >> 1) - 3));
                        }
                    }
                    ++this.m_helpStep;
                    this.m_helpStepDone = false;
                    this.initScrollText(this.getGameText(21), 0, this.getDisplayHeight() - 22 - 20);
                    break;
                }
                case 9: {
                    this.m_helpStepTm = -1L;
                    this.m_helpStepDone = false;
                    Airplane airplane = this.getSelectedPlane();
                    if (airplane == null) {
                        this.m_helpStepDone = true;
                        break;
                    }
                    if (airplane.getDisplayY() < this.m_landbox_y) {
                        if (this.m_helpActionTm >= System.currentTimeMillis() || airplane.getDirection() == 180) break;
                        this.getSelectedPlane().rotate(45);
                        this.m_helpActionTm = System.currentTimeMillis() + 1200L;
                        break;
                    }
                    if (airplane.getDisplayY() > this.m_landbox_y2) {
                        if (this.m_helpActionTm >= System.currentTimeMillis() || airplane.getDirection() == 0) break;
                        this.getSelectedPlane().rotate(-45);
                        this.m_helpActionTm = System.currentTimeMillis() + 1200L;
                        break;
                    }
                    if (this.m_helpActionTm >= System.currentTimeMillis() || airplane.getDirection() == 270) break;
                    this.getSelectedPlane().rotate(-45);
                    this.m_helpActionTm = System.currentTimeMillis() + 900L;
                    break;
                }
                case 10: {
                    this.m_helpStepTm = -1L;
                    Airplane airplane = this.getSelectedPlane();
                    if (airplane != null) {
                        airplane.setX(PhysicsObject.screenToWorld(this.m_landbox_x2 - 1));
                        airplane.setY(PhysicsObject.screenToWorld(this.m_landbox_y + 2));
                        airplane.setDirection(270);
                    }
                    this.initScrollText(this.getGameText(22), 0, this.getDisplayHeight() - 22 - 20);
                    break;
                }
                case 11: {
                    this.activateView(100);
                }
            }
        }
        if (this.m_helpStepTm != -1L && this.m_helpStepTm < System.currentTimeMillis()) {
            ++this.m_helpStep;
            this.m_helpStepDone = false;
        }
    }

    private void checkCollisionsAndLost() {
        this.m_planeInWarning = false;
        int n = PhysicsObject.screenToWorld(this.getImageWidth(0, 0));
        int n2 = this.enumPlains();
        Airplane airplane = null;
        n2 = this.enumPlains();
        while (n2 != -1) {
            int n3;
            airplane = this.getPlain(n2);
            for (n3 = 0; n3 < 14; ++n3) {
                Airplane airplane2 = this.getPlain(n3);
                if (airplane2 == null || n2 == n3 || airplane2.isWarning() || airplane.getAltitude() != airplane2.getAltitude() || airplane2.getAltitude() == 1 || airplane.getState() == 5) continue;
                long l = airplane2.getX() - (long)n;
                long l2 = airplane2.getX() + (long)n;
                long l3 = airplane2.getY() - (long)n;
                long l4 = airplane2.getY() + (long)n;
                if (airplane.getX() <= l || airplane.getX() >= l2 || airplane.getY() <= l3 || airplane.getY() >= l4) continue;
                this.m_planeInWarning = true;
                airplane.setWarning(true);
                airplane2.setWarning(true);
                long l5 = airplane.getX() - airplane2.getX();
                long l6 = airplane.getY() - airplane2.getY();
                long l7 = PhysicsObject.screenToWorld(4);
                if (l5 <= -l7 || l5 >= l7 || l6 <= -l7 || l6 >= l7) continue;
                this.planeCollision(airplane, airplane2);
            }
            if ((airplane.getX() <= 0L || airplane.getX() >= (long)PhysicsObject.getWorldScale() || airplane.getY() <= 0L || airplane.getY() >= (long)PhysicsObject.screenToWorld(this.getDisplayHeight())) && airplane.getTimeInState() > 5000L) {
                this.m_planeInWarning = true;
                airplane.setWarning(true);
                n3 = PhysicsObject.screenToWorld(2);
                if (airplane.getX() <= (long)(-n3) || airplane.getX() >= (long)(PhysicsObject.getWorldScale() + n3) || airplane.getY() <= (long)(-n3) || airplane.getY() >= (long)(PhysicsObject.screenToWorld(this.getDisplayHeight()) + n3)) {
                    this.planeLost(airplane);
                }
            }
            n2 = this.enumNextPlain();
        }
    }

    private boolean isPlaneInExit(Airplane airplane, int n) {
        boolean bl = false;
        switch (n) {
            case 8: {
                int n2 = (this.getDisplaySize() >> 1) - (this.getImageWidth(8, 0) >> 1);
                int n3 = 0;
                if (airplane.getDisplayX() < n2 || airplane.getDisplayX() > n2 + this.getImageWidth(8, 0) || airplane.getDisplayY() < n3 || airplane.getDisplayY() > n3 + this.getImageHeight(8, 0)) break;
                bl = true;
                break;
            }
            case 9: {
                int n4 = this.getDisplaySize() - this.getImageWidth(9, 0);
                int n5 = (this.getDisplayHeight() >> 1) - (this.getImageHeight(9, 0) >> 1);
                if (airplane.getDisplayX() < n4 || airplane.getDisplayX() > n4 + this.getImageWidth(9, 0) || airplane.getDisplayY() < n5 || airplane.getDisplayY() > n5 + this.getImageHeight(9, 0)) break;
                bl = true;
                break;
            }
            case 10: {
                int n6 = (this.getDisplaySize() >> 1) - (this.getImageWidth(10, 0) >> 1);
                int n7 = this.getDisplayHeight() - this.getImageHeight(10, 0);
                if (airplane.getDisplayX() < n6 || airplane.getDisplayX() > n6 + this.getImageWidth(10, 0) || airplane.getDisplayY() < n7 || airplane.getDisplayY() > n7 + this.getImageHeight(10, 0)) break;
                bl = true;
                break;
            }
            case 11: {
                int n8 = 0;
                int n9 = (this.getDisplayHeight() >> 1) - (this.getImageHeight(11, 0) >> 1);
                if (airplane.getDisplayX() < n8 || airplane.getDisplayX() > n8 + this.getImageWidth(11, 0) || airplane.getDisplayY() < n9 || airplane.getDisplayY() > n9 + this.getImageHeight(11, 0)) break;
                bl = true;
            }
        }
        return bl;
    }

    private void paintMenuSelectIcon(int n, int n2, int n3, int n4) {
        if (this.isFlashed()) {
            this.setColor(255, 255, 255);
            this.drawLine(n, n2 + 1, n, n2 + 1);
            this.drawLine(n + 1, n2, n + 1, n2 + 2);
            this.drawLine(n3, n4, n3, n4 + 2);
            this.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
        }
    }

    protected void onPaint() {
        if (this.isLoading() && this.getCurrentView() != 0 && this.getCurrentView() != 105) {
            int n = (this.getDisplayWidth() >> 1) - (this.getImageWidth(13, 0) >> 1);
            int n2 = (this.getDisplayHeight() >> 1) - (this.getImageHeight(13, 0) >> 1);
            this.drawImage(13, n, n2);
            this.setColor(255, 255, 255);
            this.drawString(this.getGameText(0), n + 8, n2 + 4);
        } else {
            switch (this.getCurrentView()) {
                case 1000: {
                    this.setColor(0, 0, 0);
                    this.fillRect(0, 0, this.getDisplayWidth(), this.getDisplayHeight());
                    this.drawImageEx(0, 0, (this.getDisplayHeight() >> 1) - (this.getImageHeight(0, 1) >> 1), 1);
                    break;
                }
                case 50: {
                    this.setColor(0, 0, 0);
                    this.fillRect(0, 0, this.getDisplayWidth(), this.getDisplayHeight());
                    this.drawImageEx(0, 0, (this.getDisplayHeight() >> 1) - (this.getImageHeight(0, 1) >> 1), 1);
                    break;
                }
                case 100: {
                    this.setColor(0, 0, 0);
                    this.fillRect(0, 0, this.getDisplayWidth(), this.getDisplayHeight());
                    this.drawImageEx(0, this.getDisplayWidth() - this.getImageWidth(0, 1), this.getDisplayHeight() - this.getImageHeight(0, 1), 1);
                    break;
                }
                case 151: {
                    this.setColor(0, 0, 0);
                    break;
                }
                case 101: {
                    this.setColor(0, 0, 0);
                    this.fillRect(0, 0, this.getDisplayWidth(), this.getDisplayHeight());
                    this.drawImageEx(0, this.getDisplayWidth() - this.getImageWidth(0, 1), this.getDisplayHeight() - this.getImageHeight(0, 1), 1);
                    this.setColor(0, 100, 0);
                    this.fillRect(0, 1, 59, 20);
                    this.fillRect(0, 22, 59, 20);
                    this.fillRect(0, 43, 59, 40);
                    this.fillRect(60, 1, 116, 20);
                    this.fillRect(60, 22, 116, 20);
                    this.fillRect(60, 43, 116, 40);
                    this.setColor(255, 255, 255);
                    this.drawString(this.getGameText(9), 2, 3);
                    this.drawString(this.getGameText(10), 2, 24);
                    this.drawString(this.getGameText(11), 2, 45);
                    this.drawString(this.getGameText(12), 2, 63);
                    this.setColor(0, 255, 0);
                    this.drawString("" + this.m_level, 62, 3);
                    this.drawString("" + this.m_planeToDo, 62, 45);
                    this.setColor(0, 32, 0);
                    this.fillRect(63, 25, 50, 14);
                    int n = (this.m_level >> 1) + 1;
                    if (n > 50) {
                        n = 50;
                    }
                    int n3 = 63;
                    for (int i = 0; i < n; ++i) {
                        int n4 = n3 + i;
                        if (i < 25) {
                            this.setColor(i * 10, 255, 0);
                        } else {
                            this.setColor(255, 255 - (i - 25) * 10, 0);
                        }
                        this.drawLine(n4, 25, n4, 38);
                    }
                    if (this.m_maxLevel <= 1) break;
                    this.paintMenuSelectIcon(56, 6, 115, 6);
                    break;
                }
                case 149: {
                    this.setColor(0, 0, 0);
                    this.fillRect(0, 0, this.getDisplayWidth(), this.getDisplayHeight());
                    this.drawImageEx(0, this.getDisplayWidth() - this.getImageWidth(0, 1), this.getDisplayHeight() - this.getImageHeight(0, 1), 1);
                    this.setColor(0, 255, 0);
                    this.setColor(0, 100, 0);
                    this.fillRect(0, 1, 59, 20);
                    this.fillRect(0, 22, 59, 20);
                    this.fillRect(0, 43, 59, 40);
                    this.fillRect(60, 1, 116, 20);
                    this.fillRect(60, 22, 116, 20);
                    this.fillRect(60, 43, 116, 40);
                    this.setColor(255, 255, 255);
                    this.drawString(this.getGameText(9), 2, 3);
                    this.drawString(this.getGameText(10), 2, 24);
                    this.drawString(this.getGameText(11), 2, 45);
                    this.drawString(this.getGameText(12), 2, 63);
                    this.setColor(0, 255, 0);
                    this.drawString("-", 62, 3);
                    this.drawString("1000", 62, 45);
                    this.setColor(0, 32, 0);
                    this.fillRect(63, 25, 50, 14);
                    int n = this.m_practiceLevel >> 1;
                    int n5 = 63;
                    for (int i = 0; i < n; ++i) {
                        int n6 = n5 + i;
                        if (i < 25) {
                            this.setColor(i * 10, 255, 0);
                        } else {
                            this.setColor(255, 255 - (i - 25) * 10, 0);
                        }
                        this.drawLine(n6, 25, n6, 38);
                    }
                    this.paintMenuSelectIcon(56, 27, 115, 27);
                    break;
                }
                case 122: {
                    this.drawImageEx(0, 0, 0, 1);
                    this.paintScrollText();
                    break;
                }
                case 148: {
                    this.paintLevel();
                    this.paintScrollText();
                    break;
                }
                case 133: {
                    this.drawImageEx(0, 0, 0, 1);
                    this.paintScrollText();
                    break;
                }
                case 111: {
                    this.drawImageEx(0, 0, 0, 1);
                    this.paintScrollText();
                    break;
                }
                case 105: {
                    this.paintLevel();
                    break;
                }
                case 102: {
                    this.setColor(0, 0, 0);
                    this.fillRect(0, 0, this.getDisplayWidth(), this.getDisplayHeight());
                    break;
                }
                case 222: {
                    this.setColor(0, 0, 0);
                    this.fillRect(0, 0, this.getDisplayWidth(), this.getDisplayHeight());
                    this.setColor(96, 180, 96);
                    this.drawString("\u5ba2\u670d\u7535\u8bdd:", 120, 50, 17);
                    this.drawString("95105981", 120, 68, 17);
                    this.drawString("\u5ba2\u670d\u90ae\u4ef6:", 120, 92, 17);
                    this.drawString("help@enorbus.com.cn", 120, 110, 17);
                    break;
                }
                case 51: {
                    this.setColor(0, 0, 0);
                    this.fillRect(0, 0, this.getDisplayWidth(), this.getDisplayHeight());
                    break;
                }
                case 300: {
                    int n = this.getDisplayWidth() - 120 >> 1;
                    int n7 = this.getDisplayHeight() - 70 >> 1;
                    int n8 = this.getDisplayWidth() >> 1;
                    this.drawImageEx(0, this.getDisplayWidth() - this.getImageWidth(0, 1), this.getDisplayHeight() - this.getImageHeight(0, 1), 1);
                    this.setColor(128, 128, 128);
                    this.fillRect(n + 4, n7 + 4, 120, 70);
                    this.setColor(64, 128, 128);
                    this.fillRect(n, n7, 120, 70);
                    this.setColor(255, 255, 255);
                    this.drawString("\u606d\u559c\u60a8!", n8, n7 + 5, 17);
                    this.drawString("\u521b\u9020\u4e86\u65b0\u7684\u8bb0\u5f55", n8, n7 + 25, 17);
                    this.drawString("\u8981\u4e0a\u4f20\u8bb0\u5f55\u5417?", n8, n7 + 45, 17);
                    break;
                }
                case 301: {
                    String string = "Player";
                    this.setColor(0, 0, 0);
                    this.fillRect(0, 0, this.getDisplayWidth(), this.getDisplayHeight());
                    this.drawImageEx(0, this.getDisplayWidth() - this.getImageWidth(0, 1), this.getDisplayHeight() - this.getImageHeight(0, 1), 1);
                    this.setColor(255, 255, 255);
                    this.drawString("\u60a8\u7684\u540d\u5b57:", 88, 10, 17);
                    this.setColor(255, 255, 0);
                    if (this.name_str != null && this.name_str != "") {
                        string = this.name_str;
                    }
                    this.drawString(string, 88, 30, 17);
                    this.setColor(255, 255, 255);
                    this.drawString("\u73b0\u5728\u6700\u9ad8\u8bb0\u5f55\u662f:", 88, 50, 17);
                    this.setColor(255, 255, 0);
                    this.drawString(String.valueOf(this.m_hightScore), 88, 70, 17);
                }
            }
        }
    }

    void paintPlaneDirection(Airplane airplane) {
        this.setColor(100, 255, 100);
        int n = airplane.getDisplayX();
        int n2 = airplane.getDisplayY();
        switch (airplane.getDirection()) {
            case 0: {
                this.drawLine(n - 2, n2, n + 2, n2);
                this.drawLine(n - 1, n2 - 1, n + 1, n2 - 1);
                this.drawLine(n, n2 - 2, n, n2 - 2);
                break;
            }
            case 45: {
                this.drawLine(n - 2, n2 - 2, n + 2, n2 - 2);
                this.drawLine(n - 1, n2 - 1, n + 2, n2 - 1);
                this.drawLine(n, n2, n + 2, n2);
                this.drawLine(n + 1, n2 + 1, n + 2, n2 + 1);
                this.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
                break;
            }
            case 90: {
                this.drawLine(n, n2 - 2, n, n2 + 2);
                this.drawLine(n + 1, n2 - 1, n + 1, n2 + 1);
                this.drawLine(n + 2, n2, n + 2, n2);
                break;
            }
            case 135: {
                this.drawLine(n - 2, n2 + 2, n + 2, n2 + 2);
                this.drawLine(n - 1, n2 + 1, n + 2, n2 + 1);
                this.drawLine(n, n2, n + 2, n2);
                this.drawLine(n + 1, n2 - 1, n + 2, n2 - 1);
                this.drawLine(n + 2, n2 - 2, n + 2, n2 - 2);
                break;
            }
            case 180: {
                this.drawLine(n - 2, n2, n + 2, n2);
                this.drawLine(n - 1, n2 + 1, n + 1, n2 + 1);
                this.drawLine(n, n2 + 2, n, n2 + 2);
                break;
            }
            case 225: {
                this.drawLine(n - 2, n2 + 2, n + 2, n2 + 2);
                this.drawLine(n - 2, n2 + 1, n + 1, n2 + 1);
                this.drawLine(n - 2, n2, n, n2);
                this.drawLine(n - 2, n2 - 1, n - 1, n2 - 1);
                this.drawLine(n - 2, n2 - 2, n - 2, n2 - 2);
                break;
            }
            case 270: {
                this.drawLine(n, n2 - 2, n, n2 + 2);
                this.drawLine(n - 1, n2 - 1, n - 1, n2 + 1);
                this.drawLine(n - 2, n2, n - 2, n2);
                break;
            }
            case 315: {
                this.drawLine(n - 2, n2 - 2, n + 2, n2 - 2);
                this.drawLine(n - 2, n2 - 1, n + 1, n2 - 1);
                this.drawLine(n - 2, n2, n, n2);
                this.drawLine(n - 2, n2 + 1, n - 1, n2 + 1);
                this.drawLine(n - 2, n2 + 2, n - 2, n2 + 2);
            }
        }
    }

    protected void paintLevel() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.drawImageEx(0, 0, 0, 1);
        if (this.m_rwLightsTm < System.currentTimeMillis()) {
            this.m_rwLightsTm = System.currentTimeMillis() + 600L;
            ++this.m_rwLightsTick;
            if (this.m_rwLightsTick >= 3) {
                this.m_rwLightsTick = 0;
            }
        }
        this.setColor(233, 223, 79);
        for (n5 = this.m_rw2_x + this.m_rw_h; n5 >= this.m_rw2_x; n5 -= 3) {
            this.drawLine(n5, this.m_rw2_y, n5, this.m_rw2_y);
            this.drawLine(n5, this.m_rw2_y + this.m_rw_w, n5, this.m_rw2_y + this.m_rw_w);
        }
        if (this.m_rwLightsTick == 0) {
            this.drawLine(this.m_rw2_x + this.m_rw_h + 12, this.m_rw2_y - 5, this.m_rw2_x + this.m_rw_h + 12, this.m_rw2_y - 5);
            this.drawLine(this.m_rw2_x + this.m_rw_h + 12, this.m_rw2_y - 3, this.m_rw2_x + this.m_rw_h + 12, this.m_rw2_y - 3);
            this.drawLine(this.m_rw2_x + this.m_rw_h + 12, this.m_rw2_y - 1, this.m_rw2_x + this.m_rw_h + 12, this.m_rw2_y - 1);
            this.drawLine(this.m_rw2_x + this.m_rw_h + 12, this.m_rw2_y + 1, this.m_rw2_x + this.m_rw_h + 12, this.m_rw2_y + 1);
            this.drawLine(this.m_rw2_x + this.m_rw_h + 12, this.m_rw2_y + 3, this.m_rw2_x + this.m_rw_h + 12, this.m_rw2_y + 3);
            this.drawLine(this.m_rw2_x + this.m_rw_h + 12, this.m_rw2_y + 5, this.m_rw2_x + this.m_rw_h + 12, this.m_rw2_y + 5);
            this.drawLine(this.m_rw2_x + this.m_rw_h + 12, this.m_rw2_y + 7, this.m_rw2_x + this.m_rw_h + 12, this.m_rw2_y + 7);
            this.drawLine(this.m_rw2_x + this.m_rw_h + 14, this.m_rw2_y + 1, this.m_rw2_x + this.m_rw_h + 14, this.m_rw2_y + 1);
            this.drawLine(this.m_rw2_x + this.m_rw_h + 16, this.m_rw2_y + 1, this.m_rw2_x + this.m_rw_h + 16, this.m_rw2_y + 1);
        }
        if (this.m_rwLightsTick == 1) {
            this.drawLine(this.m_rw2_x + this.m_rw_h + 6, this.m_rw2_y - 3, this.m_rw2_x + this.m_rw_h + 6, this.m_rw2_y - 3);
            this.drawLine(this.m_rw2_x + this.m_rw_h + 6, this.m_rw2_y - 1, this.m_rw2_x + this.m_rw_h + 6, this.m_rw2_y - 1);
            this.drawLine(this.m_rw2_x + this.m_rw_h + 6, this.m_rw2_y + 1, this.m_rw2_x + this.m_rw_h + 6, this.m_rw2_y + 1);
            this.drawLine(this.m_rw2_x + this.m_rw_h + 6, this.m_rw2_y + 3, this.m_rw2_x + this.m_rw_h + 6, this.m_rw2_y + 3);
            this.drawLine(this.m_rw2_x + this.m_rw_h + 6, this.m_rw2_y + 5, this.m_rw2_x + this.m_rw_h + 6, this.m_rw2_y + 5);
            this.drawLine(this.m_rw2_x + this.m_rw_h + 8, this.m_rw2_y + 1, this.m_rw2_x + this.m_rw_h + 8, this.m_rw2_y + 1);
            this.drawLine(this.m_rw2_x + this.m_rw_h + 10, this.m_rw2_y + 1, this.m_rw2_x + this.m_rw_h + 10, this.m_rw2_y + 1);
        }
        if (this.m_rwLightsTick == 2) {
            this.drawLine(this.m_rw2_x + this.m_rw_h, this.m_rw2_y - 1, this.m_rw2_x + this.m_rw_h, this.m_rw2_y - 1);
            this.drawLine(this.m_rw2_x + this.m_rw_h, this.m_rw2_y + 1, this.m_rw2_x + this.m_rw_h, this.m_rw2_y + 1);
            this.drawLine(this.m_rw2_x + this.m_rw_h, this.m_rw2_y + 3, this.m_rw2_x + this.m_rw_h, this.m_rw2_y + 3);
            this.drawLine(this.m_rw2_x + this.m_rw_h + 2, this.m_rw2_y + 1, this.m_rw2_x + this.m_rw_h + 2, this.m_rw2_y + 1);
            this.drawLine(this.m_rw2_x + this.m_rw_h + 4, this.m_rw2_y + 1, this.m_rw2_x + this.m_rw_h + 4, this.m_rw2_y + 1);
        }
        for (n5 = this.m_rw_y; n5 <= this.m_rw_y + this.m_rw_h; n5 += 3) {
            this.drawLine(this.m_rw_x, n5, this.m_rw_x, n5);
            this.drawLine(this.m_rw_x + this.m_rw_w, n5, this.m_rw_x + this.m_rw_w, n5);
        }
        Airplane airplane = this.getPlain(this.getSelected());
        int n6 = this.getImageWidth(8, 0) - 10 >> 1;
        if (!this.m_help || this.m_helpStep == 1 && this.isFlashed() || this.m_helpStep != 1) {
            this.drawImage(8, (this.getDisplaySize() >> 1) - (this.getImageWidth(8, 0) >> 1), 0 - n6);
            this.drawImage(9, this.getDisplaySize() - this.getImageWidth(9, 0) + n6, (this.getDisplayHeight() >> 1) - (this.getImageHeight(9, 0) >> 1));
            this.drawImage(10, (this.getDisplaySize() >> 1) - (this.getImageWidth(10, 0) >> 1), this.getDisplayHeight() - this.getImageHeight(10, 0) + n6);
            this.drawImage(11, 0 - n6, (this.getDisplayHeight() >> 1) - (this.getImageHeight(11, 0) >> 1));
        }
        if (!this.m_help || this.m_helpStep == 2 && this.isFlashed() || this.m_helpStep != 2) {
            this.drawImage(12, this.m_rw2_x + this.m_rw_h + 9, this.m_rw2_y + this.m_rw_w + 3);
        }
        int n7 = this.enumPlains();
        while (n7 != -1) {
            airplane = this.getPlain(n7);
            if (airplane.getTimeInState() < 5000L && this.isFlashed() && (airplane.getState() == 1 || airplane.getState() == 0 || airplane.getState() == 2 || airplane.getState() == 3 || airplane.getState() == 4) || airplane.getTimeInState() > 5000L || airplane.getState() == 5) {
                int[] nArray = new int[]{airplane.getDisplayX() - (this.getImageWidth(0, 0) >> 1), airplane.getDisplayY() - (this.getImageHeight(0, 0) >> 1)};
                this.drawImage(airplane.getDirection() / 45, nArray[0], nArray[1]);
                if (airplane.getState() == 4 && this.isFlashed()) {
                    this.setColor(60, 255, 60);
                    this.drawLine(nArray[0] + 1, nArray[1] + 1, nArray[0] + 1, nArray[1] + 4);
                    this.drawLine(nArray[0] + 2, nArray[1] + 4, nArray[0] + 3, nArray[1] + 4);
                }
                if ((airplane.getState() == 5 || airplane.getState() == 2) && this.isFlashed()) {
                    this.setColor(60, 255, 60);
                    this.drawLine(nArray[0] + 1, nArray[1] + 1, nArray[0] + 3, nArray[1] + 1);
                    this.drawLine(nArray[0] + 2, nArray[1] + 2, nArray[0] + 2, nArray[1] + 4);
                }
                if (airplane.getLight(true, nArray)) {
                    this.setColor(255, 128, 128);
                    this.drawLine(nArray[0] - 1, nArray[1], nArray[0] + 1, nArray[1]);
                    this.drawLine(nArray[0], nArray[1] - 1, nArray[0], nArray[1] + 1);
                    this.setColor(255, 255, 255);
                    this.drawLine(nArray[0], nArray[1], nArray[0], nArray[1]);
                }
                nArray[0] = airplane.getDisplayX() - (this.getImageWidth(0, 0) >> 1);
                nArray[1] = airplane.getDisplayY() - (this.getImageHeight(0, 0) >> 1);
                if (airplane.getLight(false, nArray)) {
                    this.setColor(128, 128, 255);
                    this.drawLine(nArray[0] - 1, nArray[1], nArray[0] + 1, nArray[1]);
                    this.drawLine(nArray[0], nArray[1] - 1, nArray[0], nArray[1] + 1);
                    this.setColor(255, 255, 255);
                    this.drawLine(nArray[0], nArray[1], nArray[0], nArray[1]);
                }
                if (airplane.isWarning() && this.isFlashed()) {
                    n4 = this.getImageWidth(airplane.getDirection() / 45, 0);
                    n3 = airplane.getDisplayX() - (this.getImageWidth(0, 0) >> 1);
                    n2 = airplane.getDisplayY() - (this.getImageHeight(0, 0) >> 1);
                    this.setColor(255, 255, 0);
                    this.drawRect(n3, n2, n4, n4);
                }
            }
            n7 = this.enumNextPlain();
        }
        airplane = this.getPlain(this.getSelected());
        if (airplane != null) {
            int n8 = airplane.getDisplayX();
            n4 = airplane.getDisplayY();
            n3 = this.getImageWidth(airplane.getDirection() / 45, 0);
            n2 = n8 - (this.getImageWidth(0, 0) >> 1);
            n = n4 - (this.getImageHeight(0, 0) >> 1);
            if (!airplane.isWarning() || !this.isFlashed()) {
                this.setColor(10, 255, 10);
                this.drawRect(n2, n, n3, n3);
            }
            if (n8 < this.getDisplayWidth() >> 1) {
                n2 += n3;
                n2 -= this.getImageWidth(airplane.getDestination(), 0) - 10;
            } else {
                n2 -= this.getImageHeight(airplane.getDestination(), 0);
                n2 += this.getImageWidth(airplane.getDestination(), 0) - 10;
            }
            if (n4 < this.getDisplayHeight() >> 1) {
                n += n3;
                n -= this.getImageHeight(airplane.getDestination(), 0) - 10;
            } else {
                n -= this.getImageHeight(airplane.getDestination(), 0);
                n += this.getImageHeight(airplane.getDestination(), 0) - 10;
            }
            if (!this.m_help || this.m_helpStep == 3 && this.isFlashed() || this.m_helpStep != 3) {
                this.drawImage(airplane.getDestination(), n2, n);
            }
            if (this.isFlashed()) {
                this.paintPlaneDirection(airplane);
            }
        }
        if (!this.m_help) {
            this.setColor(0, 255, 0);
            this.drawString(this.m_planesDone + "/" + this.m_planeToDo, 1, this.getDisplayHeight() - 18);
        }
        if (m_popupTm != 0L) {
            if (m_popupTm > System.currentTimeMillis()) {
                if (!this.isFlashed()) {
                    int n9 = (this.getDisplayWidth() >> 1) - (this.getImageWidth(13, 0) >> 1);
                    n4 = (this.getDisplayHeight() >> 1) - (this.getImageHeight(13, 0) >> 1);
                    this.drawImage(13, n9, n4);
                    this.setColor(255, 255, 255);
                    if (m_popUp == 30) {
                        this.drawString(this.getGameText(14), n9 + 8, n4 + 4);
                    } else {
                        this.drawString(this.getGameText(15), n9 + 8, n4 + 4);
                    }
                }
                int n10 = m_planePopUp.getDisplayX();
                n4 = m_planePopUp.getDisplayY();
                n3 = this.getImageWidth(m_planePopUp.getDirection() / 45, 0);
                n2 = n10 - (this.getImageWidth(0, 0) >> 1);
                n = n4 - (this.getImageHeight(0, 0) >> 1);
                if (this.isFlashed()) {
                    this.setColor(255, 0, 0);
                    this.drawRect(n2 - 1, n - 1, n3 + 2, n3 + 2);
                }
            } else {
                m_popupTm = 0L;
                if (!this.m_practice) {
                    if (m_popUp == 30) {
                        this.gameOverLost();
                    } else {
                        this.gameOverCrash();
                    }
                } else {
                    m_planePopUp.setActive(false);
                }
            }
        }
    }

    private int getDisplaySize() {
        return this.m_displaySize;
    }

    protected void onStart() {
        this.m_displaySize = this.getDisplayWidth();
        PhysicsObject.setScale(this.m_displaySize);
        this.initPlains();
        this.m_rw_x = PhysicsObject.worldToScreen(PhysicsObject.getWorldScale() / 2) - 1;
        this.m_rw_y = PhysicsObject.worldToScreen(PhysicsObject.getWorldScale() / 3) + 2 - 25;
        this.m_rw_w = 3;
        this.m_rw_h = PhysicsObject.worldToScreen(PhysicsObject.getWorldScale() / 4);
        this.m_rw2_x = PhysicsObject.worldToScreen(PhysicsObject.getWorldScale() / 4);
        this.m_rw2_y = PhysicsObject.worldToScreen(PhysicsObject.getWorldScale() / 4) - 17;
        this.m_landbox_x = this.m_rw2_x + this.m_rw_h + (this.m_rw_h >> 1);
        this.m_landbox_x2 = this.m_rw2_x + this.m_rw_h * 2;
        this.m_landbox_y = this.m_rw2_y - 1;
        this.m_landbox_y2 = this.m_rw2_y + this.m_rw_w + 1;
        try {
            this.loadGame(1);
        }
        catch (Exception exception) {
            this.m_hightScore = 0;
            this.m_level = 1;
            this.m_maxLevel = 1;
            m_language = -1;
            this.name_str = "";
            this.pswd_str = "";
        }
        this.m_OldhightScore = this.m_hightScore;
        this.loadImages("/", 14, 0, 0);
        m_language = 0;
        this.activateView(50);
    }

    protected void onPause() {
        if (this.getCurrentView() != 105) {
            try {
                this.saveGame(1);
            }
            catch (Exception exception) {}
        } else {
            this.activateView(151);
        }
    }

    protected void onResume() {
        if (this.getCurrentView() == 151) {
            this.m_newPlainTm = System.currentTimeMillis() + (long)this.m_newPlaneInterval;
            this.m_newDepartureTm = System.currentTimeMillis() + (long)this.m_newDepartureInterval;
        } else if (this.getCurrentView() != 105 && this.getCurrentView() == 252) {
            this.m_HaveHiSrcFlg = 0;
            this.activateView(100);
        }
    }

    protected void onEnd() {
        try {
            this.saveGame(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onKeyEvent(int n, int n2) {
        int n3 = this.getCurrentView();
        if (n == DigGame.KEY_PRESSED_EVENT) {
            m_menuSelStep = 0;
            if (n2 == DigGame.KEY_0) {
                this.activateView(50);
            }
            if (n2 == DigGame.KEY_SOFT1) {
                System.out.println("current view:" + n3);
                if (n3 == 100) {
                    System.out.println("VIEW_EXIT");
                    this.activateView(150);
                } else if (n3 == 148 || n3 == 222) {
                    this.activateView(100);
                } else if (n3 == 101 || n3 == 149) {
                    this.activateView(100);
                } else if (n3 == 302) {
                    this.activateView(301);
                } else if (n3 == 303) {
                    this.activateView(301);
                } else if (n3 == 304) {
                    this.activateView(301);
                } else if (n3 == 305) {
                    this.activateView(301);
                } else if (n3 == 300) {
                    this.activateView(100);
                } else if (this.getCurrentView() == 105) {
                    this.activateView(151);
                }
            }
            if (!(n2 != DigGame.KEY_SOFT2 && n2 != DigGame.KEY_SELECT || n2 == DigGame.KEY_SOFT2 && this.getCurrentView() == 105)) {
                if (n3 == 148) {
                    this.m_helpStepDone = true;
                    this.m_helpStepTm = System.currentTimeMillis();
                    this.m_helpSkipped = true;
                }
                if (n3 == 300) {
                    this.activateView(252);
                }
                if (this.getCurrentView() == 111 || this.getCurrentView() == 122 || this.getCurrentView() == 133) {
                    this.activateView(101);
                }
                if (this.getCurrentView() == 101 || this.getCurrentView() == 149) {
                    this.activateView(105);
                }
                if (n3 == 303) {
                    this.activateView(301);
                }
                if (this.getCurrentView() == 50) {
                    this.activateView(100);
                }
            }
        }
        if (n == DigGame.KEY_RELEASED_EVENT) {
            if (this.getCurrentView() == 105) {
                Airplane airplane = this.getPlain(this.m_selected);
                if (airplane != null) {
                    if (n2 == DigGame.KEY_LEFT) {
                        airplane.rotate(-45);
                    }
                    if (n2 == DigGame.KEY_RIGHT) {
                        airplane.rotate(45);
                    }
                }
                if (n2 == DigGame.KEY_UP) {
                    this.selectPrevious();
                }
                if (n2 == DigGame.KEY_DOWN) {
                    this.selectNext();
                }
            }
            if (this.getCurrentView() == 101 && (n2 == DigGame.KEY_LEFT || n2 == DigGame.KEY_RIGHT)) {
                if (n2 == DigGame.KEY_LEFT) {
                    --this.m_level;
                }
                if (n2 == DigGame.KEY_RIGHT) {
                    ++this.m_level;
                }
                if (this.m_level <= 0) {
                    this.m_level = 1;
                }
                if (this.m_level > this.m_maxLevel) {
                    this.m_level = this.m_maxLevel;
                }
                this.initLevel(this.m_level);
            }
            if (this.getCurrentView() == 149 && (n2 == DigGame.KEY_LEFT || n2 == DigGame.KEY_RIGHT)) {
                if (n2 == DigGame.KEY_LEFT) {
                    this.m_practiceLevel -= 2;
                }
                if (n2 == DigGame.KEY_RIGHT) {
                    this.m_practiceLevel += 2;
                }
                if (this.m_practiceLevel <= 0) {
                    this.m_practiceLevel = 1;
                }
                if (this.m_practiceLevel > 100) {
                    this.m_practiceLevel = 100;
                }
                this.initPractice(this.m_practiceLevel);
            }
        }
    }

    private void HightScoreAlert() {
    }

    protected boolean onMenuEvent(int n, int n2) {
        if (this.getCurrentView() == 51) {
            m_language = n;
            return true;
        }
        if (this.getCurrentView() != 102 || n == 0) {
            // empty if block
        }
        if (this.getCurrentView() == 151) {
            this.m_newPlainTm = System.currentTimeMillis() + (long)this.m_newPlaneInterval;
            this.m_newDepartureTm = System.currentTimeMillis() + (long)this.m_newDepartureInterval;
        }
        System.out.println("onMenuEvent " + this.getCurrentView() + " Item:" + n);
        if (this.getCurrentView() == 151 && n == 0) {
            this.activateView(100);
            return true;
        }
        return true;
    }

    protected void onPaintMenuItem(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isLoading()) {
            return;
        }
        if (this.getCurrentView() == 301) {
            n3 = this.getDisplayWidth() - 110 >> 1;
            n4 += 80;
        } else if (this.getCurrentView() == 304) {
            n3 = this.getDisplayWidth() - 110 >> 1;
            n4 += 40;
        }
        this.setColor(0, 0, 0);
        this.fillRect(n3, n4 + 4, n5, 20);
        this.setColor(110, 210, 110);
        if (n2 != -1) {
            if (this.getCurrentView() == 51) {
                this.drawString(LANGUAGES[n2], n3 + 17, n4 + 4);
            } else {
                this.drawString(this.getGameText(n2), n3 + 17, n4 + 4);
            }
        }
        if (this.getSelectedMenu() == n) {
            this.setColor(255, 250, 250);
            for (int i = 0; i < 3; ++i) {
                if (m_menuSelStep == 0 && i == 0) {
                    this.setColor(100, 250, 100);
                }
                if (m_menuSelStep == 1 && i == 0) {
                    this.setColor(96, 180, 96);
                }
                if (m_menuSelStep == 2 && i == 0) {
                    this.setColor(0, 96, 0);
                }
                if (m_menuSelStep == 3 && i == 0) {
                    this.setColor(0, 0, 0);
                }
                if (m_menuSelStep == 4 && i == 0) {
                    this.setColor(0, 0, 0);
                }
                if (m_menuSelStep == 0 && i == 1) {
                    this.setColor(0, 0, 0);
                }
                if (m_menuSelStep == 1 && i == 1) {
                    this.setColor(100, 250, 100);
                }
                if (m_menuSelStep == 2 && i == 1) {
                    this.setColor(96, 180, 96);
                }
                if (m_menuSelStep == 3 && i == 1) {
                    this.setColor(0, 96, 0);
                }
                if (m_menuSelStep == 4 && i == 1) {
                    this.setColor(0, 0, 0);
                }
                if (m_menuSelStep == 0 && i == 2) {
                    this.setColor(0, 0, 0);
                }
                if (m_menuSelStep == 1 && i == 2) {
                    this.setColor(0, 0, 0);
                }
                if (m_menuSelStep == 2 && i == 2) {
                    this.setColor(100, 250, 100);
                }
                if (m_menuSelStep == 3 && i == 2) {
                    this.setColor(96, 180, 96);
                }
                if (m_menuSelStep == 4 && i == 2) {
                    this.setColor(0, 96, 0);
                }
                this.drawLine(n3 + 3, n4 + 8, n3 + 3, n4 + 12);
                this.drawLine(n3 + 4, n4 + 9, n3 + 4, n4 + 11);
                this.drawLine(n3 + 5, n4 + 10, n3 + 5, n4 + 10);
                n3 += 4;
            }
        }
        if (m_menuSelTm < System.currentTimeMillis()) {
            if (++m_menuSelStep > 4) {
                m_menuSelStep = 0;
            }
            m_menuSelTm = System.currentTimeMillis() + 500L;
        }
    }

    protected void onViewChange(int n) {
        switch (n) {
            case 50: {
                this.loadImages("/", 1, 50, 1);
                DigGame.activateSoftKey(1);
                break;
            }
            case 100: {
                this.loadImages("/", 1, 100, 1);
                this.initMenu(4, 5, 0, this.getDisplayWidth(), 20, -1);
                this.setMenuItemTarget(0, 101, 6);
                this.setMenuItemTarget(1, 149, 7);
                this.setMenuItemTarget(2, 148, 8);
                this.setMenuItemTarget(3, 222, 32);
                DigGame.activateSoftKey(2);
                break;
            }
            case 151: {
                this.initMenu(2, 5, 0, this.getDisplayWidth(), 20, -1);
                this.setMenuItemTarget(0, -1, 31);
                this.setMenuItemTarget(1, 105, 30);
                break;
            }
            case 102: {
                this.initMenu(1, 5, 0, this.getDisplayWidth(), 20, 100);
                this.setMenuItemTarget(0, 102, -1);
                break;
            }
            case 222: {
                DigGame.activateSoftKey(2);
                break;
            }
            case 51: {
                int n2 = m_language;
                if (m_language == -1) {
                    m_language = 0;
                }
                if (n2 == -1) {
                    this.initMenu(5, 5, 0, this.getDisplayWidth(), 20, -1);
                } else {
                    this.initMenu(5, 5, 0, this.getDisplayWidth(), 20, 102);
                }
                for (int i = 0; i < 5; ++i) {
                    this.setMenuItemTarget(i, 50, i);
                }
                break;
            }
            case 101: {
                this.loadImages("/", 1, 100, 1);
                this.initLevel(this.m_level);
                DigGame.activateSoftKey(1);
                DigGame.activateSoftKey(2);
                break;
            }
            case 149: {
                this.loadImages("/", 1, 100, 1);
                this.initPractice(this.m_practiceLevel);
                DigGame.activateSoftKey(1);
                DigGame.activateSoftKey(2);
                break;
            }
            case 105: {
                this.loadImages("/", 1, 105, 1);
                DigGame.activateSoftKey(2);
                break;
            }
            case 133: {
                this.loadImages("/", 1, 122, 1);
                this.initScrollText(this.getGameText(26), 0, 6);
                DigGame.activateSoftKey(1);
                break;
            }
            case 122: {
                this.loadImages("/", 1, 111, 1);
                this.initScrollText(this.getGameText(25), 0, 6);
                DigGame.activateSoftKey(1);
                break;
            }
            case 111: {
                this.loadImages("/", 1, 111, 1);
                this.initScrollText(this.getGameText(24), 0, 6);
                DigGame.activateSoftKey(1);
                break;
            }
            case 148: {
                this.initHelp();
                this.loadImages("/", 1, 105, 1);
                DigGame.activateSoftKey(2);
                DigGame.activateSoftKey(1);
                break;
            }
            case 150: {
                this.terminate();
                break;
            }
            case 400: {
                break;
            }
            case 250: {
                break;
            }
            case 300: {
                this.loadImages("/", 1, 105, 1);
                DigGame.activateSoftKey(2);
                DigGame.activateSoftKey(1);
                break;
            }
            case 252: {
                this.HightScoreAlert();
                break;
            }
        }
    }

    protected void onSerialize(DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws Exception {
        if (dataInputStream != null) {
            this.m_level = dataInputStream.readInt();
            this.m_maxLevel = dataInputStream.readInt();
            this.m_hightScore = dataInputStream.readInt();
            m_language = dataInputStream.readInt();
            this.name_str = dataInputStream.readUTF();
            this.pswd_str = dataInputStream.readUTF();
        }
        if (dataOutputStream != null) {
            dataOutputStream.writeInt(this.m_level);
            dataOutputStream.writeInt(this.m_maxLevel);
            dataOutputStream.writeInt(this.m_hightScore);
            dataOutputStream.writeInt(m_language);
            dataOutputStream.writeUTF(this.name_str);
            dataOutputStream.writeUTF(this.pswd_str);
        }
    }

    void gameOverCrash() {
        this.activateView(122);
    }

    void gameOverLost() {
        this.initLevel(this.m_level);
        this.activateView(111);
    }

    void levelComplete() {
        this.m_hightScore = this.LevelTOScore(this.m_level);
        ++this.m_level;
        if (this.m_level > this.m_maxLevel) {
            this.m_maxLevel = this.m_level;
        }
        this.activateView(133);
    }

    void planeStartLanding(Airplane airplane) {
        airplane.startLanding();
        Airplane airplane2 = this.getSelectedPlane();
        if (airplane2 != null && airplane2 == airplane) {
            this.clearSelection();
        }
    }

    void planeStartFlight(Airplane airplane) {
        if (!this.m_planeInWarning) {
            // empty if block
        }
        airplane.startFlight();
        airplane.setSpeed(this.getLevelFlightSpeed());
    }

    void planeLanded(Airplane airplane) {
        this.planeDoneOk(airplane);
    }

    void planeExit(Airplane airplane) {
        this.planeDoneOk(airplane);
    }

    void planeDoneOk(Airplane airplane) {
        ++this.m_planesDone;
        airplane.setActive(false);
        ++this.m_hightScore;
        if (this.m_planesDone >= this.m_planeToDo) {
            this.levelComplete();
        }
    }

    void planeLost(Airplane airplane) {
        Airplane airplane2 = this.getSelectedPlane();
        if (airplane2 != null && airplane2 == airplane) {
            this.clearSelection();
        }
        ++this.m_planesLost;
        m_planePopUp = airplane;
        m_popupTm = System.currentTimeMillis() + 3000L;
        m_popUp = 30;
    }

    void planeCollision(Airplane airplane, Airplane airplane2) {
        Airplane airplane3 = this.getSelectedPlane();
        if (airplane3 != null) {
            if (airplane3 == airplane) {
                this.clearSelection();
            }
            if (airplane3 == airplane2) {
                this.clearSelection();
            }
        }
        this.m_planesLost += 2;
        m_planePopUp = airplane;
        airplane2.setActive(false);
        m_popupTm = System.currentTimeMillis() + 3000L;
        m_popUp = 31;
    }

    protected String onGetSystemString(int n, int n2) {
        if (m_language == -2) {
            try {
                this.loadGame(1);
            }
            catch (Exception exception) {
                m_language = -1;
            }
        }
        if (m_language == -1 && n == -1) {
            return "\u8bf7\u7a0d\u540e...";
        }
        if (n == -1 && n2 == -1) {
            return this.getGameText(0);
        }
        if (n == 50 && this.isFlashed() && n2 == 1) {
            return this.getGameText(5);
        }
        if (n == 50 && !this.isFlashed() && n2 == 1) {
            return "";
        }
        if (n == 50 && n2 == 2) {
            return "";
        }
        if (n == 100 && n2 == 2) {
            return this.getGameText(4);
        }
        if (n == 101 && n2 == 1) {
            return this.getGameText(5);
        }
        if (n == 149 && n2 == 1) {
            return this.getGameText(5);
        }
        if (n == 133 && n2 == 1) {
            return this.getGameText(3);
        }
        if (n == 122 && n2 == 1) {
            return this.getGameText(3);
        }
        if (n == 111 && n2 == 1) {
            return this.getGameText(3);
        }
        if (n == 105 && n2 == 2) {
            return "";
        }
        if (n == 148 && n2 == 1) {
            return this.getGameText(23);
        }
        if (n == 303 && n2 == 1) {
            return "\u53d1\u9001";
        }
        if (n == 304 && n2 == 1) {
            return "\u786e\u5b9a";
        }
        if (n == 300 && n2 == 1) {
            return "\u662f";
        }
        if (n == 300 && n2 == 2) {
            return "\u5426";
        }
        if (n2 == 1) {
            return this.getGameText(1);
        }
        if (n2 == 2) {
            return this.getGameText(2);
        }
        return "";
    }

    protected int getMenuItemMAXWidth(int n) {
        if (n == 100) {
            return 70;
        }
        if (n == 151) {
            return 100;
        }
        if (n == 301) {
            return 110;
        }
        return 80;
    }

    static /* synthetic */ void access$000(AtcGame atcGame) {
        atcGame.HightScoreAlert();
    }

    static {
        m_language = -2;
        LANGUAGES = new String[]{"English", "Deutsch", "Fran\ufffdais", "Italiano", "Espanol"};
        GAMETEXT = new String[][]{{"\u88c5\u8f7d\u4e2d...", "\u9009\u62e9", "\u8fd4\u56de", "\u7ee7\u7eed", "\u9000\u51fa", "\u5f00\u59cb", "\u5f00\u59cb", "\u8bad\u7ec3", "\u5e2e\u52a9", "\u7b49\u7ea7:", "\u7e41\u5fd9\u5ea6:", "\u98de\u673a\u7684", "\u603b\u6570:", "\u8bbe\u7f6e", "\u98de\u673a\u5931\u4e8b\uff01", "\u98de\u673a\u76f8\u649e\uff01", "\u5c06\u6bcf\u4e00\u67b6\u98de\u673a\u5f00\u5f80\u5b83\u4eec\u7684\u76ee\u7684\u5730\u3002", "L\u8868\u793a\u8dd1\u9053\u3002\u8981\u5230\u8fbe\u6b64\u76ee\u7684\u5730\u7684\u98de\u673a\u9700\u8981\u964d\u843d\u5728\u8fd9\u4e2a\u673a\u573a\u3002", "\u98de\u673a\u7684\u76ee\u7684\u5730\u663e\u793a\u5728\u98de\u673a\u9009\u62e9\u6846\u8fb9\u4e0a\u3002", "\u70b9\u4e0a\u4e0b\u952e\u6216\u6309\u4e0a\u4e0b\u5bfc\u822a\u952e\u66f4\u6539\u9009\u62e9\u98de\u673a\u3002", "\u6309\u5de6\u53f3\u952e\u6216\u6309\u5de6\u53f3\u5bfc\u822a\u952e\u65cb\u8f6c\u98de\u673a\u3002", "\u964d\u843d\uff1a\u60a8\u5fc5\u987b\u4f7f\u98de\u673a\u5728\u8dd1\u9053\u8303\u56f4\u5916\u5bf9\u51c6\u6a2a\u5411\u8dd1\u9053\u3002", "\u9a7e\u9a76\u5458\u4f1a\u81ea\u52a8\u964d\u843d\u98de\u673a\u3002\u6e38\u620f\u4e2d\uff0c\u70b9\u5de6\u952e\u6682\u505c\uff01", "\u4e0b\u4e00\u9875", "\u6e38\u620f\u7ed3\u675f--\u4f60\u7684\u98de\u673a\u5931\u4e8b\uff01", "\u6e38\u620f\u7ed3\u675f--\u4f60\u7684\u98de\u673a\u76f8\u649e\uff01", "\u795d\u8d3a--\u4f60\u5b8c\u6210\u4e86\u8be5\u96be\u5ea6\u7b49\u7ea7\uff01", "\u97f3\u4e50 \u5173", "\u97f3\u4e50 \u5f00", "\u8bed\u8a00", "\u7ee7\u7eed\u6e38\u620f", "\u4e3b\u83dc\u5355", "\u5ba2\u670d", "\u9ad8\u5206\u699c", "MyAccount", "HightScore", "\u79ef\u5206\u4e0a\u4f20", "\u5e10\u6237\u7ba1\u7406", "\u6d4f\u89c8\u6392\u884c", "\u9ad8\u5206\u5e2e\u52a9", "\u5efa\u7acb\u65b0\u5e10\u53f7", "\u8bbe\u7f6e\u5e10\u53f7", "\u66f4\u6539\u5bc6\u7801", "\u627e\u56de\u5bc6\u7801", "\u66f4\u6539\u4e2a\u4eba\u4fe1\u606f", "\u624b\u673a\u6e38\u620f\u73a9\u5bb6\u901a\u8fc7\u9ad8", "\u5206\u699c\u4e0a\u4f20\u624b\u673a\u6e38\u620f\u5206\u6570\uff0c\u67e5\u5bfb\u6e38\u620f\u5206\u6570\u548c\u73a9\u5bb6\u6392\u540d\u4fe1\u606f\uff0c\u73a9\u5bb6\u53ea\u9700\u901a\u8fc7\u9ad8\u5206\u699c\u4e2d\u201c\u521b\u5efa\u65b0\u7528\u6237\u201d\u529f\u80fd\u952e\u6ce8\u518c\u5e10\u6237\uff0c\u4fbf\u53ef\u4eab\u53d7\u8fd9\u4e00\u514d\u8d39\u7684\u670d\u52a1\uff0c\u6211\u4eec\u7684\u4e92\u52a8\u7f51\u7ad9totalpoints.com\u66f4\u4e3a\u73a9\u5bb6\u63d0\u4f9b\u66f4\u4e30\u5bcc\u7684\u4fe1\u606f\u548c\u670d\u52a1\u3002"}, {"Laden...", "W\ufffdhlen", "Zur\ufffdck", "Weiter", "Ende", "Start", "Spiel", "\ufffdbe", "Hilfe", "Level:", "Arbeite:", "Fluzeuge", "abzufertigen:", "Einstellungen", "Verloren!", "Abbruch!", "Fliege jedes Flugzeug an ihr Flugziel.", "Das L kennzeichnet die landebahn. Flugzeuge mit diesem Flugziel m\ufffdssen auf diesem Flugplatz landen.", "Das Flugziel dieses Flugzeugs ist neben dem Flugzeugwahlfen abgebildet.", "Dr\ufffdcke die AUF und AB taste um ein Flugzeug zu w\ufffdhlen.", "Dr\ufffdcke Pfeil RECHTS und Pfeil LINKS um das Flugzeug zu drehen.", "Zum landen: Du must dein Flugzeug in einer Linie mit der Landebahn bringen.", "Der Pilot wird das Flugzeug automatisch landen. Viel Gl\ufffdck!", "Nachste", "GAME OVER - Du hast ein Flugzeug verloren", "GAME OVER - Du hast ein Flugzeug Abstr\ufffdrzen lassen", "Gratuliere du hast dieses Level bew\ufffdltigt", "Sound EIN", "Sound AUS", "Sprache"}, {"Chargement...", "Select", "Retour", "Continuar", "Sortir", "D\ufffdmarrer", "Jouer", "Pratique", "Aide", "Niveau:", "Occup\ufffd:", "Atterissage", "r\ufffdussi:", "Param\ufffdtres", "Avion Perdu!", "Avion crash\ufffd!", "Faites voler chaque avion jusqu'\ufffd leur destination.", "Le L indique la piste de d\ufffdcollage et d'atterrissage. Les avions avec cette destination doivent atterrir \ufffd cet a\ufffdroport.", "La destination de l'avion est montr\ufffde \ufffd c\ufffdt\ufffd de la bo\ufffdte de s\ufffdlection d'avion.", "Appuyez sur les fleches HAUT ou BAS pour changer la s\ufffdlection de l'avion.", "Utilisez les fl\ufffdches droite ou gauche pour faire tourner l'avion.", "Attemir: vous devez faire aligner l'avion avec la piste d'attemissage \ufffd una distance s\ufffdre.", "Le pilote posera l'avion automatiquement. Bonne chance!", "Continuar", "GAME OVER - Vous avez perdu un avion", "GAME OVER - Vous vous \ufffdtes crash\ufffd", "F\ufffdlicitations - Vous avez termin\ufffd le niveau", "Son ON", "Son OFF", "Langue"}, {"Caricamento...", "Seleziona", "Indietro", "Continua", "Esci", "Inizia", "Gioca", "Pratica", "Aiuto", "Livello:", "Traffico:", "# aerei", "", "Impostazioni", "Perso!", "Distrutto!", "Guida ogni aereo alla propria destinazione.", "La L indica la pista, gli aerei con questa destinazione devono atterrare in questo aeroporto.", "La destinazione dell'aereo \ufffd segnalata vicino al box di selezione dell'aereo stesso.", "Premi i tasti SU e GI\ufffd per cambiare l'aereo selezionato.", "Usa i tasti DESTRA e SINISTRA per ruotare l'aereo.", "Per atterrare: devi avere l'aereo allineato con la pista e ad una distanza di sicurezza.", "Il pilota far\ufffd atterrare l'aereo automaticamente", "Continua", "GAME OVER - Hai perso un aereo", "GAME OVER - Hai distrutto un aereo", "Congratulazioni - Hai completato il livello", "Sonoro ON", "Sonoro OFF", "Lingua"}, {"Cargando...", "Seleccion", "Atr\ufffds", "Continuar", "Salir", "Continuar", "Jugar", "Practicar", "Ayuda", "Nivel:", "Congesti\ufffdn:", "Aviones", "a controlar:", "Ajustes", "Avi\ufffdn perdido!", "estrellado avi\ufffdn!", "Pilota cada avi\ufffdn a su destino respectivo.", "La letra L indica la pista de aterrizaje, aviones con este destino deben de aterrizar en este aeropuerto.", "El destino del avi\ufffdn aperece junto a la caja de selecci\ufffdn.", "Pulsa las teclas con las flechas ARRIBA y ABAJO para cambiar el avi\ufffdn seleccionado.", "Pulsa las teclas con las flechas DERECHA e IZQUIERDA para rotar la direcci\ufffdn del avi\ufffdn.", "Para aterrizar: El avi\ufffdn ha de estar alineado con la pista de aterrizaje y a una distancia prudente.", "El piloto autom\ufffdtico aterrizar\ufffd el avi\ufffdn autom\ufffdticamente. Buena Suerte!", "Continuar", "GAME OVER - Has perdido un avi\ufffdn", "GAME OVER - Has estrellado un avi\ufffdn", "Felicidades - Has completado el nivel", "Sonido Activado", "Sonido Desactivado", "Idioma"}};
    }
}

