/*
 * Decompiled with CFR 0.152.
 */
package com.lunagames.atc;

public class Float {
    static final Float ERROR = new Float(-93242L);
    static final int ITNUM = 5;
    static final Float SQRT3 = new Float(1732050807568877294L, -18L);
    public static final Float PI = new Float(3141592653589793238L, -18L);
    public static final Float ZERO = new Float();
    public static final Float ONE = new Float(1L);
    public static final Float PIdiv2 = PI.Div(2L);
    public static final Float PIdiv4 = PIdiv2.Div(2L);
    public static final Float PIdiv6 = PIdiv2.Div(3L);
    public static final Float PIdiv12 = PIdiv6.Div(2L);
    public static final Float PImul2 = PI.Mul(2L);
    public static final Float PImul4 = PI.Mul(4L);
    public long m_Val;
    public long m_E;

    public Float() {
        this.m_E = 0L;
        this.m_Val = 0L;
    }

    public Float(long l) {
        this.m_Val = l;
        this.m_E = 0L;
    }

    public Float(long l, long l2) {
        this.m_Val = l;
        this.m_E = this.m_Val == 0L ? 0L : l2;
    }

    public Float(Float float_) {
        this.m_Val = float_.m_Val;
        this.m_E = this.m_Val == 0L ? 0L : float_.m_E;
    }

    public long toLong() {
        long l = this.m_E;
        long l2 = this.m_Val;
        while (l != 0L) {
            if (l < 0L) {
                l2 /= 10L;
                ++l;
                continue;
            }
            l2 *= 10L;
            --l;
        }
        return (int)l2;
    }

    public String toShortString() {
        Long l = new Long(this.m_Val);
        String string = l.toString();
        int n = string.length() + (int)this.m_E;
        if (this.m_Val < 0L ? n > 1 : n > 0) {
            return string.substring(0, n);
        }
        return "0";
    }

    public String toString() {
        if (this.Equal(ERROR)) {
            return "NaN";
        }
        Long l = new Long(this.m_Val);
        String string = l.toString();
        int n = string.length();
        boolean bl = false;
        if (this.m_Val < 0L) {
            bl = true;
            string = string.substring(1, n);
            --n;
        }
        if (this.m_E < 0L) {
            int n2 = (int)Math.abs(this.m_E);
            if (n2 < n) {
                string = string.substring(0, n - n2) + "." + string.substring(n - n2);
            } else {
                for (int i = 0; i < n2 - n; ++i) {
                    string = "0" + string;
                }
                string = "0." + string;
            }
            if (bl) {
                string = "-" + string;
            }
        } else {
            int n3 = 0;
            while ((long)n3 < this.m_E) {
                string = string + "0";
                ++n3;
            }
            if (bl) {
                string = "-" + string;
            }
        }
        return string;
    }

    public Float Add(Float float_) {
        if (float_.Equal(ZERO)) {
            return new Float(this);
        }
        long l = this.m_E;
        long l2 = float_.m_E;
        long l3 = this.m_Val;
        long l4 = float_.m_Val;
        while (l != l2) {
            if (l > l2) {
                if (Math.abs(l3) < 92233720368547758L) {
                    l3 *= 10L;
                    --l;
                    continue;
                }
                l4 /= 10L;
                ++l2;
                continue;
            }
            if (l >= l2) continue;
            if (Math.abs(l4) < 92233720368547758L) {
                l4 *= 10L;
                --l2;
                continue;
            }
            l3 /= 10L;
            ++l;
        }
        if (l3 > 0L && l4 > Long.MAX_VALUE - l3 || l3 < 0L && l4 < Long.MIN_VALUE - l3) {
            l3 /= 10L;
            ++l;
            l4 /= 10L;
            ++l2;
        }
        if (l3 > 0L && l4 > Long.MAX_VALUE - l3) {
            return new Float(ERROR);
        }
        if (l3 < 0L && l4 < Long.MIN_VALUE - l3) {
            return new Float(ERROR);
        }
        return new Float(l3 + l4, l);
    }

    public Float Sub(Float float_) {
        if (float_.Equal(ZERO)) {
            return new Float(this.m_Val, this.m_E);
        }
        return this.Add(new Float(-float_.m_Val, float_.m_E));
    }

    public Float Mul(long l) {
        return this.Mul(new Float(l, 0L));
    }

    public Float Mul(Float float_) {
        if (float_.Equal(ONE)) {
            return new Float(this);
        }
        if (float_.Equal(ZERO) || this.Equal(ZERO)) {
            return new Float(ZERO);
        }
        while (true) {
            if (Math.abs(float_.m_Val) > Math.abs(this.m_Val)) {
                if (Long.MAX_VALUE / Math.abs(this.m_Val) >= Math.abs(float_.m_Val)) break;
                float_.m_Val /= 10L;
                ++float_.m_E;
                continue;
            }
            if (Long.MAX_VALUE / Math.abs(float_.m_Val) >= Math.abs(this.m_Val)) break;
            this.m_Val /= 10L;
            ++this.m_E;
        }
        long l = this.m_E + float_.m_E;
        long l2 = this.m_Val * float_.m_Val;
        return new Float(l2, l);
    }

    public Float Div(long l) {
        return this.Div(new Float(l, 0L));
    }

    public Float Div(Float float_) {
        if (float_.Equal(ONE)) {
            return new Float(this);
        }
        long l = this.m_E;
        long l2 = float_.m_E;
        long l3 = this.m_Val;
        if (l3 == 0L) {
            return new Float(ZERO);
        }
        long l4 = float_.m_Val;
        if (l4 == 0L) {
            return new Float(ERROR);
        }
        long l5 = 0L;
        while ((l3 %= l4) != 0L && Math.abs(l5 += l3 / l4) <= 0xCCCCCCCCCCCCCCCL) {
            if (Math.abs(l3) > 0xCCCCCCCCCCCCCCCL) {
                l4 /= 10L;
                ++l2;
            } else {
                l3 *= 10L;
                --l;
            }
            l5 *= 10L;
        }
        Float float_2 = new Float(l5, l - l2);
        float_2.RemoveZero();
        return float_2;
    }

    public void RemoveZero() {
        if (this.m_Val == 0L) {
            return;
        }
        while (this.m_Val % 10L == 0L) {
            this.m_Val /= 10L;
            ++this.m_E;
        }
    }

    public boolean Great(Float float_) {
        long l = this.m_E;
        long l2 = float_.m_E;
        long l3 = this.m_Val;
        long l4 = float_.m_Val;
        while (l != l2) {
            if (l > l2) {
                if (Math.abs(l3) < 92233720368547758L) {
                    l3 *= 10L;
                    --l;
                    continue;
                }
                l4 /= 10L;
                ++l2;
                continue;
            }
            if (l >= l2) continue;
            if (Math.abs(l4) < 92233720368547758L) {
                l4 *= 10L;
                --l2;
                continue;
            }
            l3 /= 10L;
            ++l;
        }
        return l3 > l4;
    }

    public boolean Less(long l) {
        return this.Less(new Float(l, 0L));
    }

    public boolean Less(Float float_) {
        long l = this.m_E;
        long l2 = float_.m_E;
        long l3 = this.m_Val;
        long l4 = float_.m_Val;
        while (l != l2) {
            if (l > l2) {
                if (Math.abs(l3) < 92233720368547758L) {
                    l3 *= 10L;
                    --l;
                    continue;
                }
                l4 /= 10L;
                ++l2;
                continue;
            }
            if (l >= l2) continue;
            if (Math.abs(l4) < 92233720368547758L) {
                l4 *= 10L;
                --l2;
                continue;
            }
            l3 /= 10L;
            ++l;
        }
        return l3 < l4;
    }

    public boolean Equal(Float float_) {
        long l = this.m_E;
        long l2 = float_.m_E;
        long l3 = this.m_Val;
        long l4 = float_.m_Val;
        while (l != l2) {
            if (l > l2) {
                if (Math.abs(l3) < 92233720368547758L) {
                    l3 *= 10L;
                    --l;
                    continue;
                }
                l4 /= 10L;
                ++l2;
                continue;
            }
            if (l >= l2) continue;
            if (Math.abs(l4) < 92233720368547758L) {
                l4 *= 10L;
                --l2;
                continue;
            }
            l3 /= 10L;
            ++l;
        }
        return l3 == l4;
    }

    public Float Neg() {
        return new Float(-this.m_Val, this.m_E);
    }

    public static Float sin(Float float_) {
        while (float_.Great(PI)) {
            float_ = float_.Sub(PImul2);
        }
        while (float_.Less(PI.Neg())) {
            float_ = float_.Add(PImul2);
        }
        Float float_2 = float_.Mul(float_.Mul(float_));
        Float float_3 = float_2.Div(6L);
        Float float_4 = float_.Mul(float_.Mul(float_2));
        Float float_5 = float_4.Div(120L);
        Float float_6 = float_.Mul(float_.Mul(float_4));
        Float float_7 = float_6.Div(5040L);
        Float float_8 = float_.Mul(float_.Mul(float_6));
        Float float_9 = float_8.Div(362880L);
        Float float_10 = float_.Sub(float_3).Add(float_5).Sub(float_7).Add(float_9);
        if (float_10.Less(ONE.Neg())) {
            return new Float(-1L);
        }
        if (float_10.Great(ONE)) {
            return new Float(1L);
        }
        return float_10;
    }

    public static Float cos(Float float_) {
        while (float_.Great(PI)) {
            float_ = float_.Sub(PImul2);
        }
        while (float_.Less(PI.Neg())) {
            float_ = float_.Add(PImul2);
        }
        Float float_2 = float_.Mul(float_);
        Float float_3 = float_2.Div(2L);
        Float float_4 = float_2.Mul(float_2);
        Float float_5 = float_4.Div(24L);
        Float float_6 = float_2.Mul(float_4);
        Float float_7 = float_6.Div(720L);
        Float float_8 = float_4.Mul(float_4);
        Float float_9 = float_8.Div(40320L);
        Float float_10 = ONE.Sub(float_3).Add(float_5).Sub(float_7).Add(float_9);
        if (float_10.Less(-1L)) {
            return new Float(-1L);
        }
        if (float_10.Great(ONE)) {
            return new Float(1L);
        }
        return float_10;
    }

    public static Float sqrt(Float float_) {
        int n = 0;
        boolean bl = false;
        if (float_.Less(ZERO) || float_.Equal(ZERO)) {
            return new Float(ZERO);
        }
        if (float_.Equal(ONE)) {
            return new Float(ONE);
        }
        if (float_.Less(ONE)) {
            float_ = ONE.Div(float_);
            bl = true;
        }
        while (float_.Great(new Float(16L))) {
            ++n;
            float_ = float_.Div(16L);
        }
        Float float_2 = new Float(2L);
        for (int i = 5; i > 0; --i) {
            Float float_3 = float_.Div(float_2);
            float_2 = float_2.Add(float_3);
            float_2 = float_2.Mul(new Float(5L, -1L));
        }
        while (n > 0) {
            --n;
            float_2 = float_2.Mul(4L);
        }
        if (bl) {
            float_2 = ONE.Div(float_2);
        }
        return float_2;
    }

    public static Float tan(Float float_) {
        Float float_2 = Float.cos(float_);
        if (float_2.Equal(ZERO)) {
            return new Float(ERROR);
        }
        return Float.sin(float_).Div(float_2);
    }

    public static Float acos(Float float_) {
        return PIdiv2.Sub(Float.asin(float_));
    }

    public static Float asin(Float float_) {
        if (float_.Less(ONE.Neg()) || float_.Great(ONE)) {
            return new Float(ERROR);
        }
        if (float_.Equal(ONE.Neg())) {
            return PIdiv2.Neg();
        }
        if (float_.Equal(ONE)) {
            return PIdiv2;
        }
        return Float.atan(float_.Div(Float.sqrt(ONE.Sub(float_.Mul(float_)))));
    }

    public static Float atan(Float float_) {
        Float float_2;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (float_.Less(ZERO)) {
            float_ = float_.Neg();
            bl = true;
        }
        if (float_.Great(ONE)) {
            float_ = ONE.Div(float_);
            bl2 = true;
        }
        while (float_.Great(PIdiv12)) {
            ++n;
            float_2 = float_.Add(SQRT3);
            float_2 = ONE.Div(float_2);
            float_ = float_.Mul(SQRT3);
            float_ = float_.Sub(ONE);
            float_ = float_.Mul(float_2);
        }
        Float float_3 = float_.Mul(float_);
        float_2 = float_3.Add(new Float(14087812L, -7L));
        float_2 = new Float(55913709L, -8L).Div(float_2);
        float_2 = float_2.Add(new Float(60310579L, -8L));
        float_2 = float_2.Sub(float_3.Mul(new Float(5160454L, -8L)));
        float_2 = float_2.Mul(float_);
        while (n > 0) {
            float_2 = float_2.Add(PIdiv6);
            --n;
        }
        if (bl2) {
            float_2 = PIdiv2.Sub(float_2);
        }
        if (bl) {
            float_2 = float_2.Neg();
        }
        return float_2;
    }

    public static Float atan2(Float float_, Float float_2) {
        if (float_2.Equal(ZERO)) {
            return new Float(ERROR);
        }
        return Float.atan(float_.Div(float_2));
    }
}

