/*
 * Decompiled with CFR 0.152.
 */
public class Alphabeta_HH
extends SearchEngine
implements HistoryHeuristic {
    CHESSMOVE m_cmBestMove = new CHESSMOVE();

    public byte[][] SearchAGoodMove(byte[][] position) {
        this.CurPosition = position;
        this.m_nMaxDepth = this.m_nSearchDepth;
        this.ResetHistoryTable();
        this.alphabeta(this.m_nMaxDepth, -20000, 20000);
        this.MakeMove(this.m_cmBestMove);
        return this.CurPosition;
    }

    int alphabeta(int depth, int alpha, int beta) {
        int i = this.IsGameOver(this.CurPosition, depth);
        if (i != 0) {
            return i;
        }
        if (depth <= 0) {
            return this.m_Eval.Eveluate(this.CurPosition, (this.m_nMaxDepth - depth) % 2 == 1);
        }
        int Count = this.m_MG.CreatePossibleMove(this.CurPosition, depth, (this.m_nMaxDepth - depth) % 2);
        i = 0;
        while (i < Count) {
            this.m_MG.m_MoveList[depth][i].Score = this.GetHistoryScore(this.m_MG.m_MoveList[depth][i]);
            ++i;
        }
        this.MergeSort(this.m_MG.m_MoveList[depth], Count, false);
        int bestmove = -1;
        i = 0;
        while (i < Count) {
            byte type = this.MakeMove(this.m_MG.m_MoveList[depth][i]);
            int score = -this.alphabeta(depth - 1, -beta, -alpha);
            this.UnMakeMove(this.m_MG.m_MoveList[depth][i], type);
            if (score > alpha) {
                alpha = score;
                if (depth == this.m_nMaxDepth) {
                    this.m_cmBestMove = this.m_MG.m_MoveList[depth][i];
                }
                bestmove = i;
            }
            if (alpha >= beta) {
                bestmove = i;
                break;
            }
            ++i;
        }
        if (bestmove != -1) {
            this.EnterHistoryScore(this.m_MG.m_MoveList[depth][bestmove], depth);
        }
        return alpha;
    }

    public void HistoryHeuristic() {
        int i = 0;
        while (i < 100) {
            HistoryHeuristic.m_TargetBuff[i] = new CHESSMOVE();
            ++i;
        }
    }

    public void ResetHistoryTable() {
        int i = 0;
        while (i < 90) {
            int j = 0;
            while (j < 90) {
                HistoryHeuristic.m_HistoryTable[i][j] = 43690;
                ++j;
            }
            ++i;
        }
    }

    public int GetHistoryScore(CHESSMOVE move) {
        int nFrom = move.From.y * 9 + move.From.x;
        int nTo = move.To.y * 9 + move.To.x;
        return HistoryHeuristic.m_HistoryTable[nFrom][nTo];
    }

    public void EnterHistoryScore(CHESSMOVE move, int depth) {
        int nFrom = move.From.y * 9 + move.From.x;
        int nTo = move.To.y * 9 + move.To.x;
        int[] nArray = HistoryHeuristic.m_HistoryTable[nFrom];
        int n = nTo;
        nArray[n] = nArray[n] + (2 << depth);
    }

    public void Merge(CHESSMOVE[] source, CHESSMOVE[] target, int l, int m, int r) {
        int i = l;
        int j = m + 1;
        int k = l;
        while (i <= m && j <= r) {
            target[k++] = source[i].Score <= source[j].Score ? source[i++] : source[j++];
        }
        if (i > m) {
            int q = j;
            while (q <= r) {
                target[k++] = source[q];
                ++q;
            }
        } else {
            int q = i;
            while (q <= m) {
                target[k++] = source[q];
                ++q;
            }
        }
    }

    public void Merge_A(CHESSMOVE[] source, CHESSMOVE[] target, int l, int m, int r) {
        int i = l;
        int j = m + 1;
        int k = l;
        while (i <= m && j <= r) {
            target[k++] = source[i].Score >= source[j].Score ? source[i++] : source[j++];
        }
        if (i > m) {
            int q = j;
            while (q <= r) {
                target[k++] = source[q];
                ++q;
            }
        } else {
            int q = i;
            while (q <= m) {
                target[k++] = source[q];
                ++q;
            }
        }
    }

    public void MergePass(CHESSMOVE[] source, CHESSMOVE[] target, int s, int n, boolean direction) {
        int i = 0;
        while (i <= n - 2 * s) {
            if (direction) {
                this.Merge(source, target, i, i + s - 1, i + 2 * s - 1);
            } else {
                this.Merge_A(source, target, i, i + s - 1, i + 2 * s - 1);
            }
            i += 2 * s;
        }
        if (i + s < n) {
            if (direction) {
                this.Merge(source, target, i, i + s - 1, n - 1);
            } else {
                this.Merge_A(source, target, i, i + s - 1, n - 1);
            }
        } else {
            int j = i;
            while (j <= n - 1) {
                target[j] = source[j];
                ++j;
            }
        }
    }

    public void MergeSort(CHESSMOVE[] source, int n, boolean direction) {
        int s = 1;
        while (s < n) {
            this.MergePass(source, HistoryHeuristic.m_TargetBuff, s, n, direction);
            s += s;
            this.MergePass(HistoryHeuristic.m_TargetBuff, source, s, n, direction);
            s += s;
        }
    }
}

