/*
 * Decompiled with CFR 0.152.
 */
public class MoveGenerator {
    private int m_nMoveCount;
    public CHESSMOVE[][] m_MoveList = new CHESSMOVE[10][80];

    public MoveGenerator() {
        int i = 0;
        while (i < 10) {
            int j = 0;
            while (j < 80) {
                this.m_MoveList[i][j] = new CHESSMOVE();
                ++j;
            }
            ++i;
        }
    }

    int AddMove(int nFromX, int nFromY, int nToX, int nToY, int nPly) {
        this.m_MoveList[nPly][this.m_nMoveCount].From.x = (byte)nFromX;
        this.m_MoveList[nPly][this.m_nMoveCount].From.y = (byte)nFromY;
        this.m_MoveList[nPly][this.m_nMoveCount].To.x = (byte)nToX;
        this.m_MoveList[nPly][this.m_nMoveCount].To.y = (byte)nToY;
        ++this.m_nMoveCount;
        return this.m_nMoveCount;
    }

    int CreatePossibleMove(byte[][] position, int nPly, int nSide) {
        this.m_nMoveCount = 0;
        int i = 0;
        while (i < 10) {
            int j = 0;
            while (j < 9) {
                if (position[i][j] != 0) {
                    byte nChessID = position[i][j];
                    if (!(nSide == 0 && Define.IsRed(nChessID) || nSide != 0 && Define.IsBlack(nChessID))) {
                        switch (nChessID) {
                            case 1: 
                            case 8: {
                                this.Gen_KingMove(position, i, j, nPly);
                                break;
                            }
                            case 12: {
                                this.Gen_RBishopMove(position, i, j, nPly);
                                break;
                            }
                            case 5: {
                                this.Gen_BBishopMove(position, i, j, nPly);
                                break;
                            }
                            case 6: 
                            case 13: {
                                this.Gen_ElephantMove(position, i, j, nPly);
                                break;
                            }
                            case 3: 
                            case 10: {
                                this.Gen_HorseMove(position, i, j, nPly);
                                break;
                            }
                            case 2: 
                            case 9: {
                                this.Gen_CarMove(position, i, j, nPly);
                                break;
                            }
                            case 14: {
                                this.Gen_RPawnMove(position, i, j, nPly);
                                break;
                            }
                            case 7: {
                                this.Gen_BPawnMove(position, i, j, nPly);
                                break;
                            }
                            case 4: 
                            case 11: {
                                this.Gen_CanonMove(position, i, j, nPly);
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return this.m_nMoveCount;
    }

    void Gen_KingMove(byte[][] position, int i, int j, int nPly) {
        int x;
        int y = 0;
        while (y < 3) {
            x = 3;
            while (x < 6) {
                if (this.IsValidMove(position, j, i, x, y)) {
                    this.AddMove(j, i, x, y, nPly);
                }
                ++x;
            }
            ++y;
        }
        y = 7;
        while (y < 10) {
            x = 3;
            while (x < 6) {
                if (this.IsValidMove(position, j, i, x, y)) {
                    this.AddMove(j, i, x, y, nPly);
                }
                ++x;
            }
            ++y;
        }
    }

    void Gen_RBishopMove(byte[][] position, int i, int j, int nPly) {
        int y = 7;
        while (y < 10) {
            int x = 3;
            while (x < 6) {
                if (this.IsValidMove(position, j, i, x, y)) {
                    this.AddMove(j, i, x, y, nPly);
                }
                ++x;
            }
            ++y;
        }
    }

    void Gen_BBishopMove(byte[][] position, int i, int j, int nPly) {
        int y = 0;
        while (y < 3) {
            int x = 3;
            while (x < 6) {
                if (this.IsValidMove(position, j, i, x, y)) {
                    this.AddMove(j, i, x, y, nPly);
                }
                ++x;
            }
            ++y;
        }
    }

    void Gen_ElephantMove(byte[][] position, int i, int j, int nPly) {
        int x = j + 2;
        int y = i + 2;
        if (x < 9 && y < 10 && this.IsValidMove(position, j, i, x, y)) {
            this.AddMove(j, i, x, y, nPly);
        }
        x = j + 2;
        y = i - 2;
        if (x < 9 && y >= 0 && this.IsValidMove(position, j, i, x, y)) {
            this.AddMove(j, i, x, y, nPly);
        }
        x = j - 2;
        y = i + 2;
        if (x >= 0 && y < 10 && this.IsValidMove(position, j, i, x, y)) {
            this.AddMove(j, i, x, y, nPly);
        }
        x = j - 2;
        y = i - 2;
        if (x >= 0 && y >= 0 && this.IsValidMove(position, j, i, x, y)) {
            this.AddMove(j, i, x, y, nPly);
        }
    }

    void Gen_HorseMove(byte[][] position, int i, int j, int nPly) {
        int x = j + 2;
        int y = i + 1;
        if (x < 9 && y < 10 && this.IsValidMove(position, j, i, x, y)) {
            this.AddMove(j, i, x, y, nPly);
        }
        x = j + 2;
        y = i - 1;
        if (x < 9 && y >= 0 && this.IsValidMove(position, j, i, x, y)) {
            this.AddMove(j, i, x, y, nPly);
        }
        x = j - 2;
        y = i + 1;
        if (x >= 0 && y < 10 && this.IsValidMove(position, j, i, x, y)) {
            this.AddMove(j, i, x, y, nPly);
        }
        x = j - 2;
        y = i - 1;
        if (x >= 0 && y >= 0 && this.IsValidMove(position, j, i, x, y)) {
            this.AddMove(j, i, x, y, nPly);
        }
        x = j + 1;
        y = i + 2;
        if (x < 9 && y < 10 && this.IsValidMove(position, j, i, x, y)) {
            this.AddMove(j, i, x, y, nPly);
        }
        x = j - 1;
        y = i + 2;
        if (x >= 0 && y < 10 && this.IsValidMove(position, j, i, x, y)) {
            this.AddMove(j, i, x, y, nPly);
        }
        x = j + 1;
        y = i - 2;
        if (x < 9 && y >= 0 && this.IsValidMove(position, j, i, x, y)) {
            this.AddMove(j, i, x, y, nPly);
        }
        x = j - 1;
        y = i - 2;
        if (x >= 0 && y >= 0 && this.IsValidMove(position, j, i, x, y)) {
            this.AddMove(j, i, x, y, nPly);
        }
    }

    void Gen_RPawnMove(byte[][] position, int i, int j, int nPly) {
        byte nChessID = position[i][j];
        int y = i - 1;
        int x = j;
        if (y > 0 && !Define.IsSameSide(nChessID, position[y][x])) {
            this.AddMove(j, i, x, y, nPly);
        }
        if (i < 5) {
            y = i;
            x = j + 1;
            if (x < 9 && !Define.IsSameSide(nChessID, position[y][x])) {
                this.AddMove(j, i, x, y, nPly);
            }
            if ((x = j - 1) >= 0 && !Define.IsSameSide(nChessID, position[y][x])) {
                this.AddMove(j, i, x, y, nPly);
            }
        }
    }

    void Gen_BPawnMove(byte[][] position, int i, int j, int nPly) {
        byte nChessID = position[i][j];
        int y = i + 1;
        int x = j;
        if (y < 10 && !Define.IsSameSide(nChessID, position[y][x])) {
            this.AddMove(j, i, x, y, nPly);
        }
        if (i > 4) {
            y = i;
            x = j + 1;
            if (x < 9 && !Define.IsSameSide(nChessID, position[y][x])) {
                this.AddMove(j, i, x, y, nPly);
            }
            if ((x = j - 1) >= 0 && !Define.IsSameSide(nChessID, position[y][x])) {
                this.AddMove(j, i, x, y, nPly);
            }
        }
    }

    void Gen_CarMove(byte[][] position, int i, int j, int nPly) {
        byte nChessID = position[i][j];
        int x = j + 1;
        int y = i;
        while (x < 9) {
            if (position[y][x] != 0) {
                if (Define.IsSameSide(nChessID, position[y][x])) break;
                this.AddMove(j, i, x, y, nPly);
                break;
            }
            this.AddMove(j, i, x, y, nPly);
            ++x;
        }
        x = j - 1;
        y = i;
        while (x >= 0) {
            if (position[y][x] != 0) {
                if (Define.IsSameSide(nChessID, position[y][x])) break;
                this.AddMove(j, i, x, y, nPly);
                break;
            }
            this.AddMove(j, i, x, y, nPly);
            --x;
        }
        x = j;
        y = i + 1;
        while (y < 10) {
            if (position[y][x] != 0) {
                if (Define.IsSameSide(nChessID, position[y][x])) break;
                this.AddMove(j, i, x, y, nPly);
                break;
            }
            this.AddMove(j, i, x, y, nPly);
            ++y;
        }
        x = j;
        y = i - 1;
        while (y >= 0) {
            if (position[y][x] != 0) {
                if (Define.IsSameSide(nChessID, position[y][x])) break;
                this.AddMove(j, i, x, y, nPly);
                break;
            }
            this.AddMove(j, i, x, y, nPly);
            --y;
        }
    }

    void Gen_CanonMove(byte[][] position, int i, int j, int nPly) {
        byte nChessID = position[i][j];
        int x = j + 1;
        int y = i;
        boolean flag = false;
        while (x < 9) {
            if (position[y][x] == 0) {
                if (!flag) {
                    this.AddMove(j, i, x, y, nPly);
                }
            } else if (!flag) {
                flag = true;
            } else {
                if (Define.IsSameSide(nChessID, position[y][x])) break;
                this.AddMove(j, i, x, y, nPly);
                break;
            }
            ++x;
        }
        x = j - 1;
        flag = false;
        while (x >= 0) {
            if (position[y][x] == 0) {
                if (!flag) {
                    this.AddMove(j, i, x, y, nPly);
                }
            } else if (!flag) {
                flag = true;
            } else {
                if (Define.IsSameSide(nChessID, position[y][x])) break;
                this.AddMove(j, i, x, y, nPly);
                break;
            }
            --x;
        }
        x = j;
        y = i + 1;
        flag = false;
        while (y < 10) {
            if (position[y][x] == 0) {
                if (!flag) {
                    this.AddMove(j, i, x, y, nPly);
                }
            } else if (!flag) {
                flag = true;
            } else {
                if (Define.IsSameSide(nChessID, position[y][x])) break;
                this.AddMove(j, i, x, y, nPly);
                break;
            }
            ++y;
        }
        y = i - 1;
        flag = false;
        while (y >= 0) {
            if (position[y][x] == 0) {
                if (!flag) {
                    this.AddMove(j, i, x, y, nPly);
                }
            } else if (!flag) {
                flag = true;
            } else {
                if (Define.IsSameSide(nChessID, position[y][x])) break;
                this.AddMove(j, i, x, y, nPly);
                break;
            }
            --y;
        }
    }

    boolean IsValidMove(byte[][] position, int nFromX, int nFromY, int nToX, int nToY) {
        if (nFromY == nToY && nFromX == nToX) {
            return false;
        }
        byte nMoveChessID = position[nFromY][nFromX];
        byte nTargetID = position[nToY][nToX];
        if (Define.IsSameSide(nMoveChessID, nTargetID)) {
            return false;
        }
        switch (nMoveChessID) {
            case 1: {
                if (nTargetID == 8) {
                    if (nFromX != nToX) {
                        return false;
                    }
                    int i = nFromY + 1;
                    while (i < nToY) {
                        if (position[i][nFromX] != 0) {
                            return false;
                        }
                        ++i;
                    }
                    break;
                }
                if (nToY > 2 || nToX > 5 || nToX < 3) {
                    return false;
                }
                if (Define.abs(nFromY - nToY) + Define.abs(nToX - nFromX) <= 1) break;
                return false;
            }
            case 12: {
                if (nToY < 7 || nToX > 5 || nToX < 3) {
                    return false;
                }
                if (Define.abs(nFromY - nToY) == 1 && Define.abs(nToX - nFromX) == 1) break;
                return false;
            }
            case 5: {
                if (nToY > 2 || nToX > 5 || nToX < 3) {
                    return false;
                }
                if (Define.abs(nFromY - nToY) == 1 && Define.abs(nToX - nFromX) == 1) break;
                return false;
            }
            case 13: {
                if (nToY < 5) {
                    return false;
                }
                if (Define.abs(nFromX - nToX) != 2 || Define.abs(nFromY - nToY) != 2) {
                    return false;
                }
                if (position[(nFromY + nToY) / 2][(nFromX + nToX) / 2] == 0) break;
                return false;
            }
            case 6: {
                if (nToY > 4) {
                    return false;
                }
                if (Define.abs(nFromX - nToX) != 2 || Define.abs(nFromY - nToY) != 2) {
                    return false;
                }
                if (position[(nFromY + nToY) / 2][(nFromX + nToX) / 2] == 0) break;
                return false;
            }
            case 7: {
                if (nToY < nFromY) {
                    return false;
                }
                if (nFromY < 5 && nFromY == nToY) {
                    return false;
                }
                if (nToY - nFromY + Define.abs(nToX - nFromX) <= 1) break;
                return false;
            }
            case 14: {
                if (nToY > nFromY) {
                    return false;
                }
                if (nFromY > 4 && nFromY == nToY) {
                    return false;
                }
                if (nFromY - nToY + Define.abs(nToX - nFromX) <= 1) break;
                return false;
            }
            case 8: {
                if (nTargetID == 1) {
                    if (nFromX != nToX) {
                        return false;
                    }
                    int i = nFromY - 1;
                    while (i > nToY) {
                        if (position[i][nFromX] != 0) {
                            return false;
                        }
                        --i;
                    }
                    break;
                }
                if (nToY < 7 || nToX > 5 || nToX < 3) {
                    return false;
                }
                if (Define.abs(nFromY - nToY) + Define.abs(nToX - nFromX) <= 1) break;
                return false;
            }
            case 2: 
            case 9: {
                if (nFromY != nToY && nFromX != nToX) {
                    return false;
                }
                if (nFromY == nToY) {
                    if (nFromX < nToX) {
                        int i = nFromX + 1;
                        while (i < nToX) {
                            if (position[nFromY][i] != 0) {
                                return false;
                            }
                            ++i;
                        }
                    } else {
                        int i = nToX + 1;
                        while (i < nFromX) {
                            if (position[nFromY][i] != 0) {
                                return false;
                            }
                            ++i;
                        }
                    }
                } else if (nFromY < nToY) {
                    int j = nFromY + 1;
                    while (j < nToY) {
                        if (position[j][nFromX] != 0) {
                            return false;
                        }
                        ++j;
                    }
                } else {
                    int j = nToY + 1;
                    while (j < nFromY) {
                        if (position[j][nFromX] != 0) {
                            return false;
                        }
                        ++j;
                    }
                }
                break;
            }
            case 3: 
            case 10: {
                int j;
                int i;
                if (!(Define.abs(nToX - nFromX) == 1 && Define.abs(nToY - nFromY) == 2 || Define.abs(nToX - nFromX) == 2 && Define.abs(nToY - nFromY) == 1)) {
                    return false;
                }
                if (nToX - nFromX == 2) {
                    i = nFromX + 1;
                    j = nFromY;
                } else if (nFromX - nToX == 2) {
                    i = nFromX - 1;
                    j = nFromY;
                } else if (nToY - nFromY == 2) {
                    i = nFromX;
                    j = nFromY + 1;
                } else if (nFromY - nToY == 2) {
                    i = nFromX;
                    j = nFromY - 1;
                } else {
                    return false;
                }
                if (position[j][i] == 0) break;
                return false;
            }
            case 4: 
            case 11: {
                if (nFromY != nToY && nFromX != nToX) {
                    return false;
                }
                if (position[nToY][nToX] == 0) {
                    if (nFromY == nToY) {
                        if (nFromX < nToX) {
                            int i1 = nFromX + 1;
                            while (i1 < nToX) {
                                if (position[nFromY][i1] != 0) {
                                    return false;
                                }
                                ++i1;
                            }
                        } else {
                            int i2 = nToX + 1;
                            while (i2 < nFromX) {
                                if (position[nFromY][i2] != 0) {
                                    return false;
                                }
                                ++i2;
                            }
                        }
                    } else if (nFromY < nToY) {
                        int j1 = nFromY + 1;
                        while (j1 < nToY) {
                            if (position[j1][nFromX] != 0) {
                                return false;
                            }
                            ++j1;
                        }
                    } else {
                        int j2 = nToY + 1;
                        while (j2 < nFromY) {
                            if (position[j2][nFromX] != 0) {
                                return false;
                            }
                            ++j2;
                        }
                    }
                    break;
                }
                int count = 0;
                if (nFromY == nToY) {
                    if (nFromX < nToX) {
                        int i3 = nFromX + 1;
                        while (i3 < nToX) {
                            if (position[nFromY][i3] != 0) {
                                ++count;
                            }
                            ++i3;
                        }
                        if (count == true) break;
                        return false;
                    }
                    int i4 = nToX + 1;
                    while (i4 < nFromX) {
                        if (position[nFromY][i4] != 0) {
                            ++count;
                        }
                        ++i4;
                    }
                    if (count == true) break;
                    return false;
                }
                if (nFromY < nToY) {
                    int j3 = nFromY + 1;
                    while (j3 < nToY) {
                        if (position[j3][nFromX] != 0) {
                            ++count;
                        }
                        ++j3;
                    }
                    if (count == true) break;
                    return false;
                }
                int j4 = nToY + 1;
                while (j4 < nFromY) {
                    if (position[j4][nFromX] != 0) {
                        ++count;
                    }
                    ++j4;
                }
                if (count == true) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

