/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;

public class NegaScout_TT_HH
extends SearchEngine
implements HistoryHeuristic,
TranspositionTable {
    CHESSMOVE m_cmBestMove = new CHESSMOVE();
    ChessPosition m_HashKey32 = new ChessPosition();

    public NegaScout_TT_HH() {
        this.InitializeHashKey();
    }

    public void TranspositionTable() {
    }

    public byte[][] SearchAGoodMove(byte[][] position) {
        this.CurPosition = position;
        this.m_nMaxDepth = this.m_nSearchDepth;
        this.CalculateInitHashKey(this.CurPosition);
        this.ResetHistoryTable();
        this.NegaScout(this.m_nMaxDepth, -20000, 20000);
        this.MakeMove(this.m_cmBestMove);
        return this.CurPosition;
    }

    int NegaScout(int depth, int alpha, int beta) {
        int i = this.IsGameOver(this.CurPosition, depth);
        if (i != 0) {
            return i;
        }
        int side = (this.m_nMaxDepth - depth) % 2;
        int score = this.LookUpHashTable(alpha, beta, depth, side);
        if (score != 66666) {
            return score;
        }
        if (depth <= 0) {
            score = this.m_Eval.Eveluate(this.CurPosition, side != 0);
            this.EnterHashTable(0, (short)score, (short)depth, side);
            return score;
        }
        int Count = this.m_MG.CreatePossibleMove(this.CurPosition, depth, side);
        i = 0;
        while (i < Count) {
            this.m_MG.m_MoveList[depth][i].Score = this.GetHistoryScore(this.m_MG.m_MoveList[depth][i]);
            ++i;
        }
        this.MergeSort(this.m_MG.m_MoveList[depth], Count, false);
        int bestmove = -1;
        int a2 = alpha;
        int b = beta;
        boolean eval_is_exact = false;
        i = 0;
        while (i < Count) {
            this.Hash_MakeMove(this.m_MG.m_MoveList[depth][i], this.CurPosition);
            byte type = this.MakeMove(this.m_MG.m_MoveList[depth][i]);
            int t = -this.NegaScout(depth - 1, -b, -a2);
            if (t > a2 && t < beta && i > 0) {
                a2 = -this.NegaScout(depth - 1, -beta, -t);
                eval_is_exact = true;
                if (depth == this.m_nMaxDepth) {
                    this.m_cmBestMove = this.m_MG.m_MoveList[depth][i];
                }
                bestmove = i;
            }
            this.Hash_UnMakeMove(this.m_MG.m_MoveList[depth][i], type, this.CurPosition);
            this.UnMakeMove(this.m_MG.m_MoveList[depth][i], type);
            if (a2 < t) {
                eval_is_exact = true;
                a2 = t;
                if (depth == this.m_nMaxDepth) {
                    this.m_cmBestMove = this.m_MG.m_MoveList[depth][i];
                }
            }
            if (a2 >= beta) {
                this.EnterHashTable(1, (short)a2, (short)depth, side);
                this.EnterHistoryScore(this.m_MG.m_MoveList[depth][i], depth);
                return a2;
            }
            b = a2 + 1;
            ++i;
        }
        if (bestmove != -1) {
            this.EnterHistoryScore(this.m_MG.m_MoveList[depth][bestmove], depth);
        }
        if (eval_is_exact) {
            this.EnterHashTable(0, (short)a2, (short)depth, side);
        } else {
            this.EnterHashTable(2, (short)a2, (short)depth, side);
        }
        return a2;
    }

    public void HistoryHeuristic() {
        int i = 0;
        while (i < 100) {
            HistoryHeuristic.m_TargetBuff[i] = new CHESSMOVE();
            ++i;
        }
    }

    public void ResetHistoryTable() {
        int i = 0;
        while (i < 90) {
            int j = 0;
            while (j < 90) {
                HistoryHeuristic.m_HistoryTable[i][j] = 43690;
                ++j;
            }
            ++i;
        }
    }

    public int GetHistoryScore(CHESSMOVE move) {
        int nFrom = move.From.y * 9 + move.From.x;
        int nTo = move.To.y * 9 + move.To.x;
        return HistoryHeuristic.m_HistoryTable[nFrom][nTo];
    }

    public void EnterHistoryScore(CHESSMOVE move, int depth) {
        int nFrom = move.From.y * 9 + move.From.x;
        int nTo = move.To.y * 9 + move.To.x;
        int[] nArray = HistoryHeuristic.m_HistoryTable[nFrom];
        int n = nTo;
        nArray[n] = nArray[n] + (2 << depth);
    }

    public void Merge(CHESSMOVE[] source, CHESSMOVE[] target, int l, int m, int r) {
        int i = l;
        int j = m + 1;
        int k = l;
        while (i <= m && j <= r) {
            target[k++] = source[i].Score <= source[j].Score ? source[i++] : source[j++];
        }
        if (i > m) {
            int q = j;
            while (q <= r) {
                target[k++] = source[q];
                ++q;
            }
        } else {
            int q = i;
            while (q <= m) {
                target[k++] = source[q];
                ++q;
            }
        }
    }

    public void Merge_A(CHESSMOVE[] source, CHESSMOVE[] target, int l, int m, int r) {
        int i = l;
        int j = m + 1;
        int k = l;
        while (i <= m && j <= r) {
            target[k++] = source[i].Score >= source[j].Score ? source[i++] : source[j++];
        }
        if (i > m) {
            int q = j;
            while (q <= r) {
                target[k++] = source[q];
                ++q;
            }
        } else {
            int q = i;
            while (q <= m) {
                target[k++] = source[q];
                ++q;
            }
        }
    }

    public void MergePass(CHESSMOVE[] source, CHESSMOVE[] target, int s, int n, boolean direction) {
        int i = 0;
        while (i <= n - 2 * s) {
            if (direction) {
                this.Merge(source, target, i, i + s - 1, i + 2 * s - 1);
            } else {
                this.Merge_A(source, target, i, i + s - 1, i + 2 * s - 1);
            }
            i += 2 * s;
        }
        if (i + s < n) {
            if (direction) {
                this.Merge(source, target, i, i + s - 1, n - 1);
            } else {
                this.Merge_A(source, target, i, i + s - 1, n - 1);
            }
        } else {
            int j = i;
            while (j <= n - 1) {
                target[j] = source[j];
                ++j;
            }
        }
    }

    public void MergeSort(CHESSMOVE[] source, int n, boolean direction) {
        int s = 1;
        while (s < n) {
            this.MergePass(source, HistoryHeuristic.m_TargetBuff, s, n, direction);
            s += s;
            this.MergePass(HistoryHeuristic.m_TargetBuff, source, s, n, direction);
            s += s;
        }
    }

    public void InitializeHashKey() {
        TranspositionTable.m_pTT[0] = new Hashtable();
        TranspositionTable.m_pTT[1] = new Hashtable();
    }

    public void CalculateInitHashKey(byte[][] CurPosition) {
        this.m_HashKey32.Init(CurPosition);
    }

    public void Hash_MakeMove(CHESSMOVE move, byte[][] CurPosition) {
        this.m_HashKey32.Hash_MakeMove(move, CurPosition);
    }

    public void Hash_UnMakeMove(CHESSMOVE move, byte nChessID, byte[][] CurPosition) {
        this.m_HashKey32.Hash_UnMakeMove(move, nChessID, CurPosition);
    }

    public int LookUpHashTable(int alpha, int beta, int depth, int TableNo) {
        HashKey keys = new HashKey();
        keys.key = this.m_HashKey32.m_HashKey64;
        HashItem pht = (HashItem)TranspositionTable.m_pTT[TableNo].get(keys);
        if (pht == null) {
            return 66666;
        }
        if (pht.depth >= depth) {
            switch (pht.entry_type) {
                default: {
                    break;
                }
                case 0: {
                    return pht.eval;
                }
                case 1: {
                    if (pht.eval < beta) break;
                    return pht.eval;
                }
                case 2: {
                    if (pht.eval > alpha) break;
                    return pht.eval;
                }
            }
        }
        return 66666;
    }

    public void EnterHashTable(int entry_type, short eval, short depth, int TableNo) {
        HashKey keys = new HashKey();
        keys.key = this.m_HashKey32.m_HashKey64;
        HashItem pht = (HashItem)TranspositionTable.m_pTT[TableNo].get(keys);
        if (pht == null) {
            pht = new HashItem();
            pht.entry_type = entry_type;
            pht.eval = eval;
            pht.depth = depth;
            if (TranspositionTable.m_pTT[TableNo].size() >= 1024) {
                HashKey delkeys = (HashKey)TranspositionTable.m_pTT[TableNo].keys().nextElement();
                TranspositionTable.m_pTT[TableNo].remove(delkeys);
            }
            TranspositionTable.m_pTT[TableNo].put(keys, pht);
            return;
        }
        pht.entry_type = entry_type;
        pht.eval = eval;
        pht.depth = depth;
    }
}

