/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class FiveCanvas
extends Canvas
implements CommandListener {
    public static int BLACK = 0;
    public static int WHITE = 0xFFFFFF;
    public static int RED = 0xFF0000;
    public static int GREEN = 65280;
    public static int BLUE = 255;
    public static int WOOD = 16764960;
    private FiveMIDlet midFive;
    private Reg reg;
    private Command cmdStop;
    private Command cmdNew;
    private Command cmdUndo;
    private FiveLogic logic;
    private int borderSize;
    private boolean computerFirst;
    private int degree;
    private int cavWidth;
    private int cavHeight;
    private int cWidth;
    private int cHeight;
    private Font font;
    private int fWidth;
    private int fHeight;
    private int borderX;
    private int borderY;
    private int borderLength;
    private int gridLength;
    private int stoneLength;
    private int statusY;
    private String status;
    private int statusColor;
    private boolean statusUpSide;
    private final Image[] imgStatus = new Image[4];
    private int statusImage;
    public static int THINK = 0;
    public static int SMILE = 1;
    public static int CRY = 2;
    public static int NONE = 3;
    private boolean isColor;

    static {
        BLACK = 0;
        WHITE = 0xFFFFFF;
        RED = 0xFF0000;
        GREEN = 65280;
        BLUE = 255;
        WOOD = 16764960;
        THINK = 0;
        SMILE = 1;
        CRY = 2;
        NONE = 3;
    }

    public FiveCanvas(FiveMIDlet m, Reg r) {
        this.midFive = m;
        this.reg = r;
        this.cmdNew = new Command("\u91cd\u73a9", 4, 2);
        this.cmdStop = new Command("\u9000\u51fa", 2, 1);
        this.cmdUndo = new Command("\u6094\u68cb", 1, 3);
        this.addCommand(this.cmdNew);
        this.addCommand(this.cmdStop);
        this.setCommandListener(this);
        this.cavWidth = this.getWidth();
        this.cavHeight = this.getHeight();
        this.status = "";
        this.statusColor = 0;
        this.statusUpSide = true;
        int i = 0;
        while (i < 4) {
            this.imgStatus[i] = Image.createImage((int)1, (int)1);
            ++i;
        }
        try {
            this.imgStatus[0] = Image.createImage((String)"/Think.png");
        }
        catch (IOException iOException) {}
        try {
            this.imgStatus[1] = Image.createImage((String)"/Smile.png");
        }
        catch (IOException iOException) {}
        try {
            this.imgStatus[2] = Image.createImage((String)"/Cry.png");
        }
        catch (IOException iOException) {}
        this.statusImage = 3;
        this.isColor = Display.getDisplay((MIDlet)this.midFive).numColors() > 2;
    }

    private void calcSize() {
        this.font = Font.getDefaultFont();
        this.fWidth = this.font.charWidth('\u5b57');
        this.fHeight = this.font.getHeight();
        boolean bl = this.statusUpSide = this.cavHeight > this.cavWidth;
        if (this.statusUpSide) {
            this.cWidth = this.cavWidth;
            this.cHeight = this.cavHeight - this.fHeight;
        } else {
            this.cWidth = this.cavWidth - this.fWidth;
            this.cHeight = this.cavHeight;
        }
        this.borderLength = this.cWidth <= this.cHeight ? this.cWidth : this.cHeight;
        this.gridLength = this.borderLength / this.borderSize;
        this.borderLength = this.gridLength * this.borderSize;
        this.borderX = (this.cWidth - this.borderLength) / 2;
        this.borderY = (this.cHeight - this.borderLength) / 2;
        if (this.statusUpSide) {
            this.borderY += this.fHeight;
        }
        this.stoneLength = this.gridLength - 2;
    }

    public void paint(Graphics g) {
        int cLast;
        int manColor;
        int computerColor;
        int x;
        int y;
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.cavWidth, this.cavHeight);
        if (this.isColor) {
            g.setColor(4321837);
            g.fillRect(this.borderX, this.borderY, this.borderLength, this.borderLength);
        }
        g.setColor(this.isColor ? 255 : 0);
        int r = 0;
        while (r < this.borderSize) {
            int x1 = this.borderX + this.gridLength / 2;
            int x2 = x1 + this.borderLength - this.gridLength;
            y = this.borderY + r * this.gridLength + this.gridLength / 2;
            g.drawLine(x1, y, x2, y);
            ++r;
        }
        int c = 0;
        while (c < this.borderSize) {
            x = this.borderX + c * this.gridLength + this.gridLength / 2;
            int y1 = this.borderY + this.gridLength / 2;
            int y2 = y1 + this.borderLength - this.gridLength;
            g.drawLine(x, y1, x, y2);
            ++c;
        }
        if (this.computerFirst) {
            computerColor = 0;
            manColor = 0xFFFFFF;
        } else {
            computerColor = 0xFFFFFF;
            manColor = 0;
        }
        Dot triedDot = this.logic.triedDot();
        int triedRow = triedDot.row;
        int triedCol = triedDot.col;
        int r2 = 0;
        while (r2 < this.borderSize) {
            int c2 = 0;
            while (c2 < this.borderSize) {
                int stone;
                if ((r2 != triedRow || c2 != triedCol) && (stone = this.logic.stones()[r2][c2]) != 0) {
                    x = this.xByCol(c2) - this.stoneLength / 2;
                    y = this.yByRow(r2) - this.stoneLength / 2;
                    g.setColor(stone != 1 ? manColor : computerColor);
                    g.fillArc(x, y, this.stoneLength, this.stoneLength, 0, 360);
                    g.setColor(0);
                    g.drawArc(x, y, this.stoneLength, this.stoneLength, 0, 360);
                }
                ++c2;
            }
            ++r2;
        }
        Dot lastDot = this.logic.lastDot();
        int lastRow = lastDot.row;
        int lastCol = lastDot.col;
        if (this.isColor) {
            cLast = 0xFF0000;
        } else {
            cLast = 0;
            switch (this.logic.stones()[lastRow][lastCol]) {
                case 1: {
                    cLast = manColor;
                    break;
                }
                case 2: {
                    cLast = computerColor;
                    break;
                }
            }
        }
        g.setColor(cLast);
        x = this.xByCol(lastCol) - 3;
        y = this.yByRow(lastRow) - 3;
        g.drawRect(x, y, 6, 6);
        g.setFont(this.font);
        g.setColor(this.isColor ? this.statusColor : 0);
        if (this.statusUpSide) {
            g.drawImage(this.imgStatus[this.statusImage], 0, 0, 20);
            x = this.imgStatus[this.statusImage].getWidth();
            g.drawString(this.status, x, 0, 20);
        } else {
            x = this.cWidth + this.fWidth;
            g.drawImage(this.imgStatus[this.statusImage], x, 0, 24);
            x = this.cWidth + this.fWidth / 2;
            y = this.imgStatus[this.statusImage].getHeight();
            int i = 0;
            while (i < this.status.length()) {
                char c3 = this.status.charAt(i);
                g.drawChar(c3, x, y, 17);
                y += this.fHeight;
                ++i;
            }
        }
    }

    private int xByCol(int col) {
        return this.borderX + col * this.gridLength + this.gridLength / 2;
    }

    private int yByRow(int row) {
        return this.borderY + row * this.gridLength + this.gridLength / 2;
    }

    protected void keyPressed(int keyCode) {
        if (!this.logic.gameEnd() && !this.logic.thinking()) {
            int bs = this.borderSize;
            Dot lastDot = this.logic.lastDot();
            int r = lastDot.row;
            int c = lastDot.col;
            this.repaintAt(r, c);
            int ga = this.getGameAction(keyCode);
            if (ga == 2 || keyCode == 52) {
                if (--c < 0) {
                    c = bs - 1;
                }
                lastDot.setRowCol(r, c);
                this.repaintAt(r, c);
            } else if (ga == 5 || keyCode == 54) {
                if (++c >= bs) {
                    c = 0;
                }
                lastDot.setRowCol(r, c);
                this.repaintAt(r, c);
            } else if (ga == 1 || keyCode == 50) {
                if (--r < 0) {
                    r = bs - 1;
                }
                lastDot.setRowCol(r, c);
                this.repaintAt(r, c);
            } else if (ga == 6 || keyCode == 56) {
                if (++r >= bs) {
                    r = 0;
                }
                lastDot.setRowCol(r, c);
                this.repaintAt(r, c);
            } else if (ga == 8 || keyCode == 53) {
                this.logic.manGo(r, c);
            }
        }
    }

    protected void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    protected void pointerPressed(int x, int y) {
        if (!this.logic.gameEnd() && !this.logic.thinking()) {
            int row = (y - this.borderY) / this.gridLength;
            int col = (x - this.borderX) / this.gridLength;
            this.logic.manGo(row, col);
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (!this.logic.thinking()) {
            if (c == this.cmdStop) {
                this.midFive.backHome();
            } else if (c == this.cmdNew) {
                this.newStage();
            } else if (c == this.cmdUndo && !this.logic.undo()) {
                this.setStatus("\u4e0d\u80fd\u6094\u68cb!");
            }
        }
    }

    public void setOptions(int borderSize, boolean computerFirst, int degree) {
        this.borderSize = borderSize;
        this.computerFirst = computerFirst;
        this.degree = degree;
    }

    public boolean newStage() {
        this.addCommand(this.cmdUndo);
        this.addCommand(this.cmdStop);
        this.removeCommand(this.cmdNew);
        this.calcSize();
        this.logic = new FiveLogic(this, this.borderSize, this.computerFirst, this.degree);
        if (this.computerFirst) {
            this.logic.computerGo();
        } else {
            this.setStatus("\u8bf7\u4e0b\u5b50:");
        }
        this.repaint();
        return true;
    }

    public void notifyGameEnd() {
        this.addCommand(this.cmdNew);
        this.addCommand(this.cmdStop);
        this.removeCommand(this.cmdUndo);
    }

    public void setStatus(String s) {
        this.setStatus(s, 0, 3);
    }

    public void setStatus(String s, int color, int image) {
        int h;
        int w;
        int y;
        int x;
        this.status = s;
        this.statusColor = color;
        this.statusImage = image;
        if (this.statusUpSide) {
            x = 0;
            y = 0;
            w = this.cavWidth;
            h = this.fHeight;
        } else {
            x = this.cWidth;
            y = 0;
            w = this.fWidth;
            h = this.cavHeight;
        }
        this.repaint(x, y, w, h);
    }

    public void repaintAt(int row, int col) {
        int pW;
        int pX = this.borderX + (col - 1) * this.gridLength;
        int pY = this.borderY + (row - 1) * this.gridLength;
        int pH = pW = this.gridLength * 2;
        this.repaint(pX, pY, pW, pH);
    }
}

