/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Stack;

public class FiveLogic {
    private FiveCanvas cavFive;
    private int borderSize = 11;
    private boolean computerFirst = true;
    private int degree = 1;
    public static int STONE_NONE = 0;
    public static int STONE_COMPUTER = 1;
    public static int STONE_MAN = 2;
    private int[][] stones;
    private Dot lastDot;
    private int[] stoneCounter;
    private Stack steps;
    private Dot triedDot;
    private static int GAIN_BY_COMPUTER = 5;
    private static int GAIN_BY_NONE = 1;
    private boolean endOfGame;
    private boolean computerWon;
    private boolean thinking;
    private Random rnd;

    static {
        STONE_NONE = 0;
        STONE_COMPUTER = 1;
        STONE_MAN = 2;
        GAIN_BY_COMPUTER = 5;
        GAIN_BY_NONE = 1;
    }

    public FiveLogic(FiveCanvas cav, int bSize, boolean cFirst, int deg) {
        this.cavFive = cav;
        this.borderSize = bSize;
        this.computerFirst = cFirst;
        this.degree = deg;
        this.stones = new int[bSize][bSize];
        int r = 0;
        while (r < this.borderSize) {
            int c = 0;
            while (c < this.borderSize) {
                this.stones[r][c] = 0;
                ++c;
            }
            ++r;
        }
        this.lastDot = new Dot(this.borderSize);
        this.stoneCounter = new int[3];
        this.stoneCounter[1] = 0;
        this.stoneCounter[2] = 0;
        this.stoneCounter[0] = this.borderSize * this.borderSize;
        this.steps = new Stack();
        this.triedDot = new Dot(-1, -1);
        this.endOfGame = false;
        this.thinking = false;
        this.rnd = new Random();
    }

    public int[][] stones() {
        return this.stones;
    }

    public Dot lastDot() {
        return this.lastDot;
    }

    public Dot triedDot() {
        return this.triedDot;
    }

    public boolean gameEnd() {
        return this.endOfGame;
    }

    public boolean computerWon() {
        return this.computerWon;
    }

    public boolean thinking() {
        return this.thinking;
    }

    private boolean endOfGame() {
        this.endOfGame = false;
        int r = 0;
        while (r < this.borderSize) {
            int c = 0;
            while (c < this.borderSize) {
                if (this.stones[r][c] != 0 && this.existNLineWithMinFree(r, c, 5, 0, -1) != -1) {
                    this.endOfGame = true;
                    this.computerWon = this.stones[r][c] == 1;
                    break;
                }
                ++c;
            }
            if (this.endOfGame) break;
            ++r;
        }
        if (this.endOfGame) {
            this.cavFive.notifyGameEnd();
        }
        return this.endOfGame;
    }

    public void manGo(int row, int col) {
        if (row >= 0 && row < this.borderSize && col >= 0 && col < this.borderSize && this.stones[row][col] == 0) {
            this.goAt(row, col, 2);
            if (this.endOfGame()) {
                if (this.computerWon) {
                    this.cavFive.setStatus("\u4f60\u8f93\u4e86!", 0xFF0000, 2);
                } else {
                    this.cavFive.setStatus("\u4f60\u8d62\u4e86!", 65280, 1);
                }
            } else {
                this.computerGo();
            }
        }
    }

    private void goAt(int row, int col, int playerStone) {
        int lastRow = this.lastDot.row;
        int lastCol = this.lastDot.col;
        this.stones[row][col] = playerStone;
        this.lastDot.setRowCol(row, col);
        this.cavFive.repaintAt(lastRow, lastCol);
        this.cavFive.repaintAt(row, col);
        switch (playerStone) {
            case 1: {
                this.stoneCounter[1] = this.stoneCounter[1] + 1;
                break;
            }
            case 2: {
                this.stoneCounter[2] = this.stoneCounter[2] + 1;
                break;
            }
        }
        this.stoneCounter[0] = this.stoneCounter[0] - 1;
        if (this.steps.size() > 10) {
            this.steps.removeElementAt(0);
        }
        this.steps.push(new Dot(row, col));
    }

    public boolean undo() {
        if (this.steps.size() >= 3) {
            Dot d = new Dot();
            d.copyFrom((Dot)this.steps.pop());
            this.stones[d.row][d.col] = 0;
            this.cavFive.repaintAt(d.row, d.col);
            d.copyFrom((Dot)this.steps.pop());
            this.stones[d.row][d.col] = 0;
            this.cavFive.repaintAt(d.row, d.col);
            d.copyFrom((Dot)this.steps.peek());
            this.lastDot.copyFrom(d);
            this.cavFive.repaintAt(d.row, d.col);
            return true;
        }
        return false;
    }

    public void computerGo() {
        this.cavFive.setStatus("\u601d\u8003\u4e2d...", 0, 0);
        this.cavFive.serviceRepaints();
        this.think();
    }

    public void think() {
        this.thinking = true;
        Dot dc = null;
        dc = this.thinkInNumber(1, 5);
        if (dc == null && (dc = this.thinkInNumber(2, 5)) == null && (dc = this.to4B(1)) == null && (dc = this.to4B(2)) == null && (dc = this.toDouble4S_3B_2N1B(1, true)) == null && (dc = this.toDouble4S_3B_2N1B(2, true)) == null && (dc = this.toDouble4S_3B_2N1B(1, false)) == null && (dc = this.toDouble4S_3B_2N1B(2, false)) == null && (dc = this.toSingle4S_3B_2N1B(1)) == null) {
            dc = this.toSingle4S_3B_2N1B(2);
        }
        if (dc == null) {
            dc = this.maxGainedDot();
        }
        if (dc == null || this.stoneCounter[0] == 0) {
            this.cavFive.setStatus("\u5e73\u5c40!", 255, 3);
        } else {
            System.out.println("Gone!");
            this.goAt(dc.row, dc.col, 1);
            if (this.endOfGame()) {
                if (this.computerWon) {
                    this.cavFive.setStatus("\u4f60\u8f93\u4e86!", 0xFF0000, 2);
                } else {
                    this.cavFive.setStatus("\u4f60\u8d62\u4e86 !", 65280, 1);
                }
            } else {
                this.cavFive.setStatus("\u8bf7\u4e0b\u5b50...");
            }
        }
        this.thinking = false;
    }

    private Dot to4B(int playerStone) {
        if (this.stoneCounter[playerStone] < 3) {
            return null;
        }
        Dot dot = null;
        int maxGain = 0;
        int r = 1;
        while (r < this.borderSize - 1) {
            int c = 1;
            while (c < this.borderSize - 1) {
                if (this.stones[r][c] == 0) {
                    int[] cd = this.connectedIn8D(playerStone, r, c);
                    int[] ed = this.expandedIn8D(playerStone, r, c);
                    int i = 0;
                    while (i < 4) {
                        int gain;
                        if (ed[i] > cd[i] && ed[i + 4] > cd[i + 4] && cd[i] + cd[i + 4] + 1 >= 4 && ((gain = this.gainAt(r, c)) > maxGain || gain > 0 && gain == maxGain && this.randomTrue())) {
                            maxGain = gain;
                            dot = new Dot(r, c);
                        }
                        ++i;
                    }
                }
                ++c;
            }
            ++r;
        }
        return dot;
    }

    private Dot toSingle4S_3B_2N1B(int playerStone) {
        if (this.stoneCounter[playerStone] < 2) {
            return null;
        }
        Dot dot = null;
        int r = 0;
        while (r < this.borderSize) {
            int c = 0;
            while (c < this.borderSize) {
                if (this.stones[r][c] == 0 && this.find4S_3B_2N1BAt(r, c, playerStone, -1) != -1) {
                    dot = new Dot(r, c);
                    break;
                }
                ++c;
            }
            if (dot != null) break;
            ++r;
        }
        return dot;
    }

    private Dot toDouble4S_3B_2N1B(int playerStone, boolean only4S) {
        if (this.stoneCounter[playerStone] < 4) {
            return null;
        }
        Dot dot = null;
        int rTest = 0;
        while (rTest < this.borderSize) {
            int cTest = 0;
            while (cTest < this.borderSize) {
                int[] cd;
                if (this.stones[rTest][cTest] == 0 && (cd = this.connectedIn8D(playerStone, rTest, cTest))[0] + cd[1] + cd[2] + cd[3] + cd[4] + cd[5] + cd[6] + cd[7] > 0) {
                    this.triedDot.setRowCol(rTest, cTest);
                    this.stones[rTest][cTest] = playerStone;
                    boolean found = false;
                    int dFirst = this.find4S_3B_2N1B(playerStone, -1, rTest, cTest, only4S);
                    if (dFirst != -1 && this.find4S_3B_2N1B(playerStone, dFirst, rTest, cTest, false) != -1) {
                        found = true;
                    }
                    this.stones[rTest][cTest] = 0;
                    this.triedDot.setRowCol(-1, -1);
                    if (found) {
                        dot = new Dot(rTest, cTest);
                        break;
                    }
                }
                ++cTest;
            }
            if (dot != null) break;
            ++rTest;
        }
        return dot;
    }

    private int find4SAt(int row, int col, int playerStone, int exceptDirection) {
        int dFond = -1;
        int[] cd = this.connectedIn8D(playerStone, row, col);
        int[] ed = this.expandedIn8D(playerStone, row, col);
        int d = 0;
        while (d < 4) {
            if (d != exceptDirection && this.stones[row][col] == playerStone) {
                boolean b4S;
                int nConnect = cd[d] + cd[d + 4] + 1;
                int nFree1 = ed[d] - cd[d];
                int nFree2 = ed[d + 4] - cd[d + 4];
                boolean bl = b4S = nConnect >= 4 && (nFree1 >= 1 || nFree2 >= 1);
                if (b4S) {
                    dFond = d;
                    break;
                }
            }
            ++d;
        }
        return dFond;
    }

    private int find4S_3B_2N1BAt(int row, int col, int playerStone, int exceptDirection) {
        int dFond = -1;
        int[] cd = this.connectedIn8D(playerStone, row, col);
        int[] ed = this.expandedIn8D(playerStone, row, col);
        int d = 0;
        while (d < 4) {
            if (d != exceptDirection) {
                if (this.stones[row][col] == playerStone) {
                    boolean b3B;
                    int nConnect = cd[d] + cd[d + 4] + 1;
                    int nFree1 = ed[d] - cd[d];
                    int nFree2 = ed[d + 4] - cd[d + 4];
                    boolean b4S = nConnect >= 4 && (nFree1 >= 1 || nFree2 >= 1);
                    boolean bl = b3B = nConnect >= 3 && nFree1 >= 1 && nFree2 >= 1;
                    if (b4S || b3B) {
                        dFond = d;
                        break;
                    }
                }
                if (this.stones[row][col] == 0) {
                    boolean bSFree;
                    int nFree1 = ed[d] - cd[d];
                    int nFree2 = ed[d + 4] - cd[d + 4];
                    boolean b2N1 = cd[d] >= 2 && cd[d + 4] >= 1 || cd[d] >= 1 && cd[d + 4] >= 2;
                    boolean bl = bSFree = nFree1 >= 1 && nFree2 >= 1;
                    if (b2N1 && bSFree) {
                        dFond = d;
                        break;
                    }
                }
            }
            ++d;
        }
        return dFond;
    }

    private int find4S_3B_2N1B(int playerStone, int exceptDirection, int rTest, int cTest, boolean only4S) {
        int cMax;
        int cMin;
        int rMax;
        int dFond = -1;
        int rMin = rTest - 3;
        if (rMin < 0) {
            rMin = 0;
        }
        if ((rMax = rTest + 3) > this.borderSize) {
            rMax = this.borderSize;
        }
        if ((cMin = cTest - 3) < 0) {
            cMin = 0;
        }
        if ((cMax = cTest + 3) > this.borderSize) {
            cMax = this.borderSize;
        }
        int r = rMin;
        while (r < rMax) {
            int c = cMin;
            while (c < cMax) {
                if ((this.stones[r][c] == playerStone || this.stones[r][c] == 0) && (dFond = only4S ? this.find4SAt(r, c, playerStone, exceptDirection) : this.find4S_3B_2N1BAt(r, c, playerStone, exceptDirection)) != -1) break;
                ++c;
            }
            if (dFond != -1) break;
            ++r;
        }
        return dFond;
    }

    private Dot thinkInNumber(int stonePlayer, int nl) {
        if (this.stoneCounter[stonePlayer] < nl - 1) {
            return null;
        }
        int maxGain = 0;
        Dot dot = null;
        int r = 0;
        while (r < this.borderSize) {
            int c = 0;
            while (c < this.borderSize) {
                int gain = this.thinkInNumberAt(stonePlayer, r, c, nl);
                if (gain > maxGain || gain > 0 && gain == maxGain && this.randomTrue()) {
                    maxGain = gain;
                    dot = new Dot(r, c);
                }
                ++c;
            }
            ++r;
        }
        return dot;
    }

    private int thinkInNumberAt(int lineStone, int row, int col, int nl) {
        int lines = 0;
        int otherGain = 0;
        if (this.stones[row][col] == 0) {
            int[] cd = this.connectedIn8D(lineStone, row, col);
            int[] ed = this.expandedIn8D(lineStone, row, col);
            int i = 0;
            while (i < 4) {
                if (ed[i] + ed[i + 4] + 1 >= 5) {
                    int l = cd[i] + cd[i + 4] + 1;
                    if (l >= nl) {
                        ++lines;
                    } else {
                        otherGain += 2 ^ l;
                    }
                }
                ++i;
            }
        }
        return lines <= 0 ? 0 : lines * 32 + otherGain;
    }

    private int[] expandedIn8D(int stone, int row, int col) {
        int[] ed = new int[8];
        int d = 0;
        while (d < 8) {
            ed[d] = this.expandedIn1D(stone, row, col, d);
            ++d;
        }
        return ed;
    }

    private int expandedIn1D(int stone, int row, int col, int direction) {
        int n = 0;
        int cn = 0;
        Dot d = new Dot(row, col);
        while (cn < 4) {
            d.copyFrom(this.forwardOneStep(d, direction));
            if (!d.inBorder(this.borderSize)) break;
            int st = this.stones[d.row][d.col];
            if (st == 0) {
                ++cn;
            }
            if (st != stone && st != 0) break;
            ++n;
        }
        return n;
    }

    private Dot maxGainedDot() {
        Dot dotWithMaxGain = null;
        int maxGain = 0;
        int r = 0;
        while (r < this.borderSize) {
            int c = 0;
            while (c < this.borderSize) {
                int gain = this.gainAt(r, c);
                if (gain > maxGain || gain > 0 && gain == maxGain && this.randomTrue()) {
                    maxGain = gain;
                    dotWithMaxGain = new Dot(r, c);
                }
                ++c;
            }
            ++r;
        }
        return dotWithMaxGain;
    }

    private int gainAt(int row, int col) {
        if (this.stones[row][col] == 0) {
            int gain = 0;
            int d = 0;
            while (d < 8) {
                int gd = this.gainAtDirection(row, col, d);
                gain = gd == 0 ? (gain >>= 2) : (gain += gd);
                ++d;
            }
            if (gain < 1) {
                gain = 1;
            }
            return gain;
        }
        return 0;
    }

    private int gainAtDirection(int row, int col, int direction) {
        int gain = 0;
        Dot d = new Dot(row, col);
        int step = 0;
        while (true) {
            int stone;
            d.copyFrom(this.forwardOneStep(d, direction));
            ++step;
            if (!d.inBorder(this.borderSize) || (stone = this.stones[d.row][d.col]) == 2) break;
            int gainByStone = stone != 1 ? 1 : 5;
            gain += this.gainByStep(step) * gainByStone;
        }
        return gain;
    }

    private int gainByStep(int step) {
        int gain = (this.borderSize - step) / 2;
        if (gain < 1) {
            gain = 1;
        }
        return gain;
    }

    private int exist2N1(int row, int col, int playerStone, int exceptDirection) {
        int[] cd = this.connectedIn8D(playerStone, row, col);
        int[] ed = this.expandedIn8D(playerStone, row, col);
        int existDirection = -1;
        int i = 0;
        while (i < 4) {
            if (i != exceptDirection && (cd[i] >= 2 && cd[i + 4] >= 1 || cd[i] >= 1 && cd[i + 4] >= 2) && ed[i] - cd[i] + (ed[i + 4] - cd[i + 4]) > 0) {
                existDirection = i;
                break;
            }
            ++i;
        }
        return existDirection;
    }

    private int existNLineWithMinFree(int row, int col, int n, int minFree, int exceptDirection) {
        int stone = this.stones[row][col];
        int[] cd = this.connectedIn8D(stone, row, col);
        int[] ed = this.expandedIn8D(stone, row, col);
        int existDirection = -1;
        int i = 0;
        while (i < 4) {
            if (i != exceptDirection && cd[i] + cd[i + 4] + 1 >= n && ed[i] - cd[i] + (ed[i + 4] - cd[i + 4]) >= minFree) {
                existDirection = i;
                break;
            }
            ++i;
        }
        return existDirection;
    }

    private int[] connectedIn8D(int stone, int row, int col) {
        int[] cd = new int[8];
        int d = 0;
        while (d < 8) {
            cd[d] = this.connectedIn1D(stone, row, col, d);
            ++d;
        }
        return cd;
    }

    private int connectedIn1D(int stone, int row, int col, int direction) {
        int n = 0;
        Dot d = new Dot(row, col);
        while (true) {
            d.copyFrom(this.forwardOneStep(d, direction));
            if (!d.inBorder(this.borderSize) || this.stones[d.row][d.col] != stone) break;
            ++n;
        }
        return n;
    }

    private Dot forwardOneStep(Dot d, int direction) {
        int r = d.row;
        int c = d.col;
        switch (direction) {
            case 0: {
                ++c;
                break;
            }
            case 1: {
                --r;
                ++c;
                break;
            }
            case 2: {
                --r;
                break;
            }
            case 3: {
                --r;
                --c;
                break;
            }
            case 4: {
                --c;
                break;
            }
            case 5: {
                ++r;
                --c;
                break;
            }
            case 6: {
                ++r;
                break;
            }
            case 7: {
                ++r;
                ++c;
                break;
            }
        }
        return new Dot(r, c);
    }

    private boolean randomTrue() {
        return this.rnd.nextInt() % 2 == 0;
    }
}

