/*
 * Decompiled with CFR 0.152.
 */
package com.md;

import java.util.Random;

public class Horse {
    public static final int STRAIGHT = 0;
    public static final int LEFT = -2;
    public static final int RIGHT = 2;
    public static final int CONSTANT = 0;
    public static final int ACCELERATING = 1;
    public static final int DECELERATING = -1;
    public static Random random = new Random(System.currentTimeMillis());
    protected int[] topSpeedAdjustment;
    public static final int EMPTY = 0;
    public static final int MAX_ENERGY = 180;
    public static final int EDGE = 4;
    public static final Horse[] ALL_HORSES = new Horse[]{new Horse("(\u7a7a)", 0, 0, 0, 0, 0, 0, 1, 0), new Horse("\u6bcd\u4eb2\u7684\u4e73\u6c41", 539, 25, 1, 70, 40, 1, 20, 1), new Horse("\u80af\u5854\u57fa\u65cb\u98ce", 955, 40, 1, 90, 80, 2, 4, 2), new Horse("\u9189\u9b3c\u6731\u8482", 705, 29, 1, 80, 74, 3, 16, 3), new Horse("\u6770\u6cfd\u8d1d\u5c14", 812, 35, 1, 90, 80, 1, 8, 4), new Horse("\u94a2\u94c1\u745e\u5c14\u987f", 795, 35, 1, 92, 85, 2, 7, 0), new Horse("\u55b7\u5c04\u6597\u58eb", 845, 37, 1, 93, 80, 3, 6, 1), new Horse("\u6f58\u8da3\u4e0e\u6731\u8482", 923, 38, 1, 93, 85, 1, 5, 2), new Horse("\u8df3\u8dc3\u7684\u52a0\u6d1b", 980, 40, 1, 90, 82, 2, 4, 3), new Horse("\u873b\u8713", 760, 30, 1, 80, 70, 3, 8, 4), new Horse("\u6539\u9769\u8005", 888, 37, 1, 90, 77, 1, 7, 0), new Horse("\u6bdb\u831b\u8349", 120, 20, 1, 40, 30, 2, 40, 0), new Horse("\u65af\u6d1b\u4f10\u514b\u864e", 975, 40, 1, 90, 80, 3, 4, 1), new Horse("\u6e38\u620f\u65f6\u95f4", 695, 34, 1, 90, 70, 1, 14, 2), new Horse("\u4ea8\u5229\u516b\u4e16", 683, 28, 1, 75, 65, 2, 12, 3), new Horse("\u65e0\u6240\u70ab\u8000", 905, 38, 1, 90, 80, 3, 6, 4), new Horse("\u9a6c\u8fbe\u52a0\u65af\u52a0\u5723\u6b4c", 968, 40, 1, 90, 75, 1, 4, 0), new Horse("\u5170\u8349", 911, 38, 1, 92, 80, 2, 8, 1), new Horse("\u6ce5\u6d46", 833, 35, 1, 84, 70, 3, 16, 2), new Horse("\u55a7\u95f9\u7684\u9152\u4f1a", 893, 37, 1, 90, 82, 1, 12, 3), new Horse("\u5c0f\u4e0d\u70b9", 901, 38, 1, 87, 67, 2, 8, 4)};
    public boolean playerHorse;
    public boolean onCurvedTrack;
    public String name;
    public int speed;
    public int imageIndex;
    public int acceleration;
    public int price;
    private int odds;
    public int silk;
    public int step;
    protected int trackPosition;
    public int trackPixelPosition;
    protected int currentTrackSegment;
    protected boolean collisionOnRight;
    public int horizontalPosition;
    public int energy;
    public int stamina;
    public int conditioning;
    public int topSpeed;
    public int topSpeedWhenRested;
    public int whips;
    public int direction;
    public int accelerationState;
    public int horizonPerspective;
    protected boolean laggingTooMuch;
    protected long lastUpdate;
    protected long lastSlowUpdate;
    private int lastStep;
    private static long SLOW_UPDATE_FREQUENCY = 100L;

    public Horse(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.name = string;
        this.price = n;
        this.topSpeedWhenRested = n2;
        this.acceleration = n3;
        this.stamina = n4;
        this.conditioning = n5;
        this.imageIndex = n6;
        this.odds = n7;
        this.silk = n8;
        this.topSpeedAdjustment = new int[12];
        this.resetSpeedAdjustments();
        this.lastUpdate = System.currentTimeMillis();
        this.energy = 180;
        this.topSpeed = n2;
        this.playerHorse = false;
    }

    public static Horse[] getHorsesForLevel(int n) {
        int[] nArray = null;
        switch (n) {
            case 0: {
                nArray = new int[]{3, 9, 11, 14, 1};
                break;
            }
            case 1: {
                nArray = new int[]{3, 9, 15, 14, 1};
                break;
            }
            case 2: {
                nArray = new int[]{3, 9, 15, 14, 6};
                break;
            }
            case 3: {
                nArray = new int[]{12, 9, 15, 14, 6};
                break;
            }
            case 4: {
                nArray = new int[]{12, 16, 15, 14, 6};
            }
        }
        Horse[] horseArray = new Horse[6];
        for (int i = 0; i < 5; ++i) {
            horseArray[i + 1] = ALL_HORSES[nArray[i]].copy();
            horseArray[i + 1].topSpeed = horseArray[i + 1].topSpeedWhenRested * horseArray[i + 1].stamina / 100;
        }
        return horseArray;
    }

    public int getRandomizedOdds() {
        Random random = new Random(System.currentTimeMillis());
        return this.odds + Math.abs(random.nextInt() % 8);
    }

    protected void resetSpeedAdjustments() {
        for (int i = 0; i < this.topSpeedAdjustment.length; ++i) {
            this.topSpeedAdjustment[i] = Math.abs(random.nextInt() % 3) - 2;
            if (i < this.topSpeedAdjustment.length / 2) {
                int n = i;
                this.topSpeedAdjustment[n] = this.topSpeedAdjustment[n] + 2;
                continue;
            }
            int n = i;
            this.topSpeedAdjustment[n] = this.topSpeedAdjustment[n] - 2;
        }
    }

    public void reset() {
        this.accelerationState = 1;
        this.onCurvedTrack = false;
        this.speed = 0;
        this.trackPixelPosition = 0;
        this.trackPosition = 0;
        this.lastStep = 0;
        this.energy = 180;
        this.resetSpeedAdjustments();
        this.playerHorse = false;
    }

    public Horse copy() {
        return new Horse(this.name, this.price, this.topSpeedWhenRested, this.acceleration, this.stamina, this.conditioning, this.imageIndex, this.odds, this.silk);
    }

    public void updatePosition(long l) {
        long l2 = l - this.lastUpdate;
        this.trackPosition = (int)((long)this.trackPosition + l2 * (long)this.speed);
        this.trackPixelPosition = this.trackPosition >> 10;
        if (this.trackPixelPosition > this.lastStep + 1) {
            ++this.step;
            this.step %= 4;
            this.lastStep = this.trackPixelPosition;
        }
        this.lastUpdate = l;
        if (this.playerHorse) {
            this.topSpeed = (this.topSpeedWhenRested * 3 + this.topSpeedWhenRested * this.energy / 180 >> 2) + this.whips;
        } else {
            this.topSpeed = this.topSpeedWhenRested * this.stamina / 100;
            this.topSpeed += this.topSpeedAdjustment[this.currentTrackSegment];
            if (this.laggingTooMuch) {
                this.topSpeed += 4;
            }
        }
        long l3 = l - this.lastSlowUpdate;
        if (l3 > SLOW_UPDATE_FREQUENCY) {
            if ((this.horizontalPosition < 4 || this.horizontalPosition > 156) && this.speed > 20 && this.playerHorse) {
                --this.speed;
            }
            this.speed += this.accelerationState * this.acceleration;
            if (this.whips > 0) {
                this.speed += 1 * this.acceleration * 2;
                --this.whips;
            }
            this.currentTrackSegment = this.trackPosition * 12 / 2000000;
            if (this.currentTrackSegment >= 12) {
                this.currentTrackSegment = 11;
            }
            this.speed = Math.min(this.topSpeed, this.speed);
            this.speed = Math.max(0, this.speed);
            if (this.playerHorse) {
                boolean bl = this.onCurvedTrack = this.currentTrackSegment == 3 || this.currentTrackSegment == 4 || this.currentTrackSegment == 7 || this.currentTrackSegment == 8;
                if (this.speed > 0) {
                    this.horizontalPosition += this.direction * 2;
                    this.horizontalPosition = Math.max(0, this.horizontalPosition);
                    this.horizontalPosition = Math.min(160, this.horizontalPosition);
                    if (this.onCurvedTrack && this.playerHorse) {
                        if (!this.collisionOnRight) {
                            ++this.horizontalPosition;
                        }
                        this.horizonPerspective += this.speed;
                    }
                }
                if (this.speed < this.conditioning * this.topSpeed / 100) {
                    this.energy += 2;
                    this.energy = Math.min(180, this.energy);
                } else if (this.speed > this.stamina * this.topSpeed / 100) {
                    --this.energy;
                    this.energy = Math.max(0, this.energy);
                }
            }
            this.lastSlowUpdate = l;
        }
    }

    public void whip() {
        ++this.whips;
    }
}

