/*
 * Decompiled with CFR 0.152.
 */
package com.md;

import com.md.Horse;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Preferences {
    private String recordStoreName;
    private Hashtable properties;
    private boolean loaded;
    private boolean dirty;

    public Preferences(String string, boolean bl) throws RecordStoreException {
        this.recordStoreName = string;
        this.properties = new Hashtable();
        this.dirty = false;
        this.loaded = false;
        if (bl) {
            this.load();
            this.loaded = true;
        }
    }

    public int getHorseCount() {
        return this.getIntPreference("horsecount", 0);
    }

    public void setHorseCount(int n) {
        this.setPreference("horsecount", n);
    }

    public int getMoney() {
        return this.getIntPreference("money", 800);
    }

    public void setMoney(int n) {
        this.setPreference("money", n);
    }

    public int getWager() {
        return this.getIntPreference("wager", 0);
    }

    public void setWager(int n) {
        this.setPreference("wager", n);
    }

    public Horse getHorseInPaddock(int n) {
        return Horse.ALL_HORSES[this.getIntPreference("horse" + n, 0)];
    }

    public void setHorseInPaddock(int n, int n2) {
        this.setPreference("horse" + n, n2);
    }

    public int getSelectedPaddock() {
        return this.getIntPreference("selectedPaddock", 0);
    }

    public void setSelectedPaddock(int n) {
        this.setPreference("selectedPaddock", n);
    }

    public void setSilk(int n) {
        this.setPreference("silk", n);
    }

    public int getSilk() {
        return this.getIntPreference("silk", 0);
    }

    public void setLevel(int n) {
        this.setPreference("level", Math.min(n, 4));
    }

    public int getLevel() {
        return this.getIntPreference("level", 0);
    }

    public void setOdds(int n) {
        this.setPreference("odds", n);
    }

    public int getOdds() {
        return this.getIntPreference("odds", 0);
    }

    protected String getPreference(String string, String string2) {
        String string3 = this.getPreference(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    protected String getPreference(String string) {
        return (String)this.properties.get(string);
    }

    protected int getIntPreference(String string, int n) {
        String string2 = this.getPreference(string);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    protected boolean getBooleanPreference(String string, boolean bl) {
        String string2 = this.getPreference(string);
        if (string2 == null) {
            return bl;
        }
        return string2.toLowerCase().equals("true");
    }

    protected void setPreference(String string, String string2) {
        this.properties.put(string, string2);
        this.dirty = true;
    }

    protected void setPreference(String string, int n) {
        this.setPreference(string, Integer.toString(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() throws RecordStoreException {
        RecordStore recordStore = null;
        RecordEnumeration recordEnumeration = null;
        try {
            recordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
            recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                byte[] byArray = recordEnumeration.nextRecord();
                String string = new String(byArray);
                int n = string.indexOf(124);
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                this.setPreference(string2, string3);
            }
        }
        finally {
            if (recordEnumeration != null) {
                recordEnumeration.destroy();
            }
            if (recordStore != null) {
                recordStore.closeRecordStore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws RecordStoreException {
        RecordStore recordStore = null;
        RecordEnumeration recordEnumeration = null;
        try {
            recordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
            recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                recordStore.deleteRecord(n);
            }
            Enumeration enumeration = this.properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = this.getPreference(string);
                String string3 = string + "|" + string2;
                byte[] byArray = string3.getBytes();
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            this.dirty = false;
        }
        finally {
            if (recordEnumeration != null) {
                recordEnumeration.destroy();
            }
            if (recordStore != null) {
                recordStore.closeRecordStore();
            }
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

