/*
 * Decompiled with CFR 0.152.
 */
package com.md;

import com.md.Horse;
import com.md.Preferences;

public class Race {
    public static final int COLLISION_TOLERANCE = 18;
    public static final int STATE_BEFORE_RACE = 0;
    public static final int STATE_COUNTDOWN = 1;
    public static final int STATE_RACING = 2;
    public static final int STATE_PAUSED = 3;
    public static final int STATE_AFTER_RACE = 4;
    public static final int TRACK_LENGTH = 2000000;
    public static final int TRACK_PIXEL_LENGTH = 1953;
    public static final int TRACK_WIDTH = 160;
    public static final int TRACK_SEGMENTS = 12;
    public int state;
    private long startTime;
    private long lastUpdateTime;
    private int pausedState;
    private long pauseTime;
    public int horizonPosition;
    public int playerRank;
    public int odds;
    public int wager;
    public Preferences savedGame;
    public Horse[] horses;

    public Race(Preferences preferences) {
        this.doCreate(preferences);
    }

    public void setup(Preferences preferences) {
        this.doCreate(this.savedGame);
    }

    private void doCreate(Preferences preferences) {
        if (preferences == null) {
            return;
        }
        this.savedGame = preferences;
        this.wager = preferences.getWager();
        Horse horse = preferences.getHorseInPaddock(preferences.getSelectedPaddock());
        int n = preferences.getLevel();
        if (horse.price > 800) {
            n = Math.max(n, 1);
        }
        if (horse.price > 900) {
            n = Math.max(n, 2);
        }
        this.horses = Horse.getHorsesForLevel(n);
        this.horses[0] = horse;
        for (int i = 0; i < this.horses.length; ++i) {
            this.horses[i].reset();
            this.horses[i].horizontalPosition = 10 + this.horses.length * 20 - i * 20;
        }
        this.horses[0].playerHorse = true;
        this.horses[0].accelerationState = 0;
        this.horses[0].playerHorse = true;
        this.horses[0].silk = preferences.getSilk();
        System.out.println("Race doCreate OK");
    }

    public void updateState() {
        long l = System.currentTimeMillis();
        long l2 = l - this.startTime;
        if (this.state == 1 && l2 > 3000L) {
            this.state = 2;
        }
    }

    public long getTimeSinceStart() {
        return System.currentTimeMillis() - this.startTime;
    }

    public void start() {
        this.state = 1;
        this.lastUpdateTime = this.startTime = System.currentTimeMillis();
    }

    public void pause() {
        this.pausedState = this.state;
        this.pauseTime = System.currentTimeMillis();
        this.state = 3;
    }

    public void resume() {
        this.state = this.pausedState;
        long l = System.currentTimeMillis() - this.pauseTime;
        this.startTime += l;
        this.lastUpdateTime += l;
        for (int i = 0; i < this.horses.length; ++i) {
            this.horses[i].lastSlowUpdate += l;
            this.horses[i].lastUpdate += l;
        }
    }

    public Horse getHorse(int n) {
        return this.horses[n];
    }

    public void updatePositions() {
        Horse horse = this.horses[0];
        if (this.state != 2) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = l - this.lastUpdateTime;
        this.playerRank = 1;
        for (int i = 0; i < this.horses.length; ++i) {
            int n;
            this.horses[i].updatePosition(l);
            this.horses[i].laggingTooMuch = false;
            int n2 = this.horses[i].trackPixelPosition - horse.trackPixelPosition;
            if (n2 > 0) {
                ++this.playerRank;
                this.horses[i].accelerationState = n2 > 488 ? -1 : (n2 > 244 ? 0 : 1);
            } else if (n2 < -244) {
                this.horses[i].laggingTooMuch = true;
            }
            if (this.horses[0].trackPixelPosition > 1953) {
                this.state = 4;
            }
            horse.collisionOnRight = false;
            if (i <= 0 || Math.abs(n = this.horses[i].horizontalPosition - horse.horizontalPosition) >= 18) continue;
            if (n2 > 5 && n2 <= 15) {
                horse.speed = Math.min(this.horses[i].speed - 1, horse.speed);
            } else if (n2 > -35 && n2 < -30) {
                this.horses[i].speed = Math.min(this.horses[i].speed, horse.speed - 1);
                if (this.horses[i].speed > 1) {
                    this.horses[i].speed -= 2;
                }
            }
            if (n2 < -30 || n2 >= 15) continue;
            if (n < 0) {
                if (horse.direction != -2) continue;
                horse.direction = 0;
                continue;
            }
            if (horse.onCurvedTrack) {
                horse.direction = -2;
                continue;
            }
            if (horse.direction != 2) continue;
            horse.direction = 0;
        }
        this.lastUpdateTime = l;
    }
}

