/*
 * Decompiled with CFR 0.152.
 */
package com.ui;

import com.md.Horse;
import com.md.Preferences;
import com.md.Race;
import com.ui.BettingMenu;
import com.ui.MainMenu;
import com.ui.MobileCrownMenu;
import com.ui.PaddockMenu;
import com.ui.RaceCanvas;
import com.ui.RunningCanvas;
import com.ui.SilkMenu;
import com.ui.VerticalMenu;
import java.util.Random;
import javax.microedition.rms.RecordStoreException;

public class GameSetupMenu
extends VerticalMenu {
    protected boolean forMobileCrown;
    protected Preferences savedGame;
    private final int PADDOCK;
    private final int CHOOSE_SILK;
    private final int PLACE_BET;
    private final int ENTER_RACE;
    private final int QUIT;
    private Race race = null;
    private RaceCanvas raceCanvas = null;

    private GameSetupMenu(RunningCanvas runningCanvas, String[] stringArray) {
        super(runningCanvas, stringArray);
        this.PADDOCK = 0;
        this.CHOOSE_SILK = 1;
        this.PLACE_BET = 2;
        this.ENTER_RACE = 3;
        this.QUIT = 4;
    }

    public static GameSetupMenu create(MainMenu mainMenu) {
        Random random = new Random(System.currentTimeMillis());
        GameSetupMenu gameSetupMenu = new GameSetupMenu(mainMenu, new String[]{"\u4e0b\u6ce8", "\u8fdb\u5165\u6bd4\u8d5b", "\u9000\u51fa"});
        gameSetupMenu.forMobileCrown = false;
        try {
            gameSetupMenu.savedGame = new Preferences("not used", false);
            gameSetupMenu.savedGame.setLevel(Math.abs(random.nextInt()) % 5);
            if (gameSetupMenu.savedGame.getLevel() < 2) {
                gameSetupMenu.savedGame.setHorseInPaddock(0, 10);
            } else {
                gameSetupMenu.savedGame.setHorseInPaddock(0, 16);
            }
            gameSetupMenu.savedGame.setHorseInPaddock(0, 16);
            gameSetupMenu.savedGame.setSelectedPaddock(0);
            gameSetupMenu.savedGame.setWager(0);
            Horse horse = gameSetupMenu.savedGame.getHorseInPaddock(gameSetupMenu.savedGame.getSelectedPaddock());
            gameSetupMenu.savedGame.setOdds(horse.getRandomizedOdds());
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return gameSetupMenu;
    }

    public static GameSetupMenu create(MobileCrownMenu mobileCrownMenu) {
        GameSetupMenu gameSetupMenu = new GameSetupMenu(mobileCrownMenu, new String[]{"\u8d5b\u9a6c\u573a", "\u9009\u62e9\u961f\u670d", "\u4e0b\u6ce8", "\u8fdb\u5165\u6bd4\u8d5b", "\u9000\u51fa"});
        gameSetupMenu.forMobileCrown = true;
        gameSetupMenu.savedGame = mobileCrownMenu.preferences;
        return gameSetupMenu;
    }

    public void itemSelected() {
        int n = this.selectedIndex;
        if (!this.forMobileCrown) {
            n += 2;
        }
        Horse horse = this.savedGame.getHorseInPaddock(this.savedGame.getSelectedPaddock());
        switch (n) {
            case 0: {
                PaddockMenu paddockMenu = new PaddockMenu(this);
                paddockMenu.start(this.display);
                break;
            }
            case 1: {
                SilkMenu silkMenu = new SilkMenu((RunningCanvas)this, this.savedGame);
                silkMenu.start(this.display);
                break;
            }
            case 2: {
                new BettingMenu(this, this.savedGame.getOdds(), this.savedGame.getWager()).start(this.display);
                break;
            }
            case 3: {
                if (this.forMobileCrown && horse == Horse.ALL_HORSES[0]) {
                    String[] stringArray = new String[]{"\u5728\u8fdb\u5165\u6bd4\u8d5b\u524d\u4f60\u5fc5\u987b", "\u4ece\u9a6c\u573a\u4e2d\u9009\u62e9\u4e00\u5339\u9a6c"};
                    MainMenu.txtViewer.setup(stringArray, this, true);
                    MainMenu.txtViewer.start(this.display);
                    break;
                }
                System.gc();
                this.race = new Race(this.savedGame);
                if (this.forMobileCrown) {
                    this.raceCanvas = null;
                    if (this.raceCanvas == null) {
                        this.raceCanvas = new RaceCanvas(this, this.race);
                    } else {
                        this.raceCanvas.pause = true;
                        this.raceCanvas.release();
                        this.raceCanvas.doCreateUseRace(this, this.race);
                        this.raceCanvas.pause = false;
                    }
                } else {
                    this.raceCanvas = null;
                    if (this.raceCanvas == null) {
                        this.raceCanvas = new RaceCanvas(this.returnCanvas, this.race);
                    } else {
                        System.out.println("RaceCanvas release and doCreateUseRace");
                        this.raceCanvas.pause = true;
                        this.raceCanvas.release();
                        this.raceCanvas.doCreateUseRace(this.returnCanvas, this.race);
                        this.raceCanvas.pause = false;
                    }
                }
                String string = "\u6309\u786e\u5b9a\u952e\u7ee7\u7eed";
                String string2 = "";
                String[][] stringArrayArray = new String[][]{{"\u6b22\u8fce\u6765\u5230\u98ce\u4fe1\u5b50", "\u9ad8\u5730\uff0c\u738b\u8005\u8fd0\u52a8", "\u7684\u8bde\u751f\u5730\u3002", "", string, string2}, {"\u5361\u6797\u7279\u6e29\u6cc9\u7684\u6c34", "\u80fd\u591f\u5b89\u629a\u8d5b\u9a6c\u7684", "\u795e\u7ecf\u3002", "", string, string2}, {"\u8700\u8475\u5cf0\u7684\u9ad8\u6d77\u62d4", "\u4f1a\u8ba9\u4f60\u7684\u8d5b\u9a6c\u63d0", "\u524d\u5174\u594b\u8d77\u6765\u3002\u5b83", "\u51c6\u5907\u597d\u4e86\u5417\uff1f", "", string, string2}, {"\u5927\u9646\u7684\u6c14\u5019\u96be\u4ee5", "\u9884\u6599\u3002\u771f\u6b63\u7684\u738b", "\u8005\u4e4b\u5fc3\u4f1a\u6218\u80dc\u5929", "\u6c14\u7684\u3002", "", string, string2}, {"\u5927\u8d5b\u5c06\u5728\u83ab\u6bd4\u5df4", "\u514b\u516c\u56ed\u4e3e\u884c\u3002\u4e3a", "\u738b\u8005\u7684\u5956\u676f\u505a\u597d", "\u51c6\u5907\u4e86\u5417\uff1f", "", string, string2}};
                String[] stringArray = stringArrayArray[this.savedGame.getLevel()];
                MainMenu.txtViewer.setup(stringArray, this.raceCanvas, true);
                MainMenu.txtViewer.start(this.display);
            }
        }
    }
}

