/*
 * Decompiled with CFR 0.152.
 */
package com.ui;

import com.ui.ImageLoader;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicsUtil {
    private static GraphicsUtil INSTANCE;

    public static GraphicsUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GraphicsUtil();
        }
        return INSTANCE;
    }

    private GraphicsUtil() {
    }

    public void resetTranslation(Graphics graphics) {
        graphics.translate(-graphics.getTranslateX(), -graphics.getTranslateY());
    }

    public Image loadKnownImage(String string) {
        try {
            return Image.createImage((String)string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Image loadClippedImage(String string, int n, int n2, int n3, int n4) {
        ImageLoader.createImage(string);
        Image image = (Image)ImageLoader.get(string);
        Image image2 = Image.createImage((int)n3, (int)n4);
        image2.getGraphics().drawImage(image, -n, -n2, 20);
        return Image.createImage((Image)image2);
    }

    public Image[] loadTiles(String string, int n, int n2) {
        Image image = this.loadKnownImage(string);
        Image[] imageArray = new Image[n * n2];
        int n3 = image.getHeight() / n2;
        int n4 = image.getWidth() / n;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Image image2 = Image.createImage((int)n4, (int)n3);
                image2.getGraphics().drawImage(image, -i * n4, -j * n3, 20);
                imageArray[i + n * j] = Image.createImage((Image)image2);
            }
        }
        return imageArray;
    }
}

