/*
 * Decompiled with CFR 0.152.
 */
package com.ui;

import com.md.Preferences;
import com.ui.GameSetupMenu;
import com.ui.GraphicsUtil;
import com.ui.MainMenu;
import com.ui.VerticalMenu;
import javax.microedition.rms.RecordStoreException;

public class MobileCrownMenu
extends VerticalMenu {
    Preferences preferences;
    GraphicsUtil gUtil = GraphicsUtil.getInstance();
    final String DB_NAME;

    public MobileCrownMenu(MainMenu mainMenu) {
        super(mainMenu, new String[]{"\u65b0\u6e38\u620f", "\u8bfb\u53d6", "\u4fdd\u5b58", "\u9000\u51fa"});
        this.DB_NAME = "Mobile Derby";
    }

    public void itemSelected() {
        int n = 5 - this.menuItems.length + this.selectedIndex;
        switch (n) {
            case 0: {
                this.continueGame();
                break;
            }
            case 1: {
                this.newGame();
                break;
            }
            case 2: {
                this.loadGame();
                break;
            }
            case 3: {
                this.saveGame();
            }
        }
    }

    public void newGame() {
        try {
            this.preferences = new Preferences("Mobile Derby", false);
            this.preferences.setMoney(800);
            this.preferences.setOdds(1);
            this.updateMenu();
            this.continueGame();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void saveGame() {
        this.stop();
        try {
            if (this.preferences == null) {
                this.preferences = new Preferences("Mobile Derby", true);
            }
            this.preferences.save();
            this.updateMenu();
            this.showSuccessfulAction("\u4fdd\u5b58");
        }
        catch (RecordStoreException recordStoreException) {
            this.handleException(recordStoreException);
        }
    }

    public void loadGame() {
        this.stop();
        try {
            this.preferences = new Preferences("Mobile Derby", true);
            this.updateMenu();
            this.showSuccessfulAction("\u52a0\u8f7d");
        }
        catch (RecordStoreException recordStoreException) {
            this.handleException(recordStoreException);
        }
    }

    public void showSuccessfulAction(String string) {
        String[] stringArray = new String[]{"", "", "\u6e38\u620f " + string, "\u6210\u529f", "", "", "\u6309\u786e\u5b9a\u952e\u7ee7\u7eed"};
        MainMenu.txtViewer.setup(stringArray, this, true);
        MainMenu.txtViewer.start(this.display);
    }

    public void continueGame() {
        GameSetupMenu gameSetupMenu = GameSetupMenu.create(this);
        gameSetupMenu.start(this.display);
    }

    protected void handleException(RecordStoreException recordStoreException) {
        String[] stringArray = new String[]{"Unable to", "access game", "records.", "Your phone may", "be low on memory."};
    }

    protected void updateMenu() {
        this.menuItems = this.preferences == null ? new String[]{"\u65b0\u6e38\u620f", "\u8bfb\u53d6", "\u4fdd\u5b58", "\u9000\u51fa"} : new String[]{"\u7ee7\u7eed", "\u65b0\u6e38\u620f", "\u8bfb\u53d6", "\u4fdd\u5b58", "\u9000\u51fa"};
        this.returnItemIndex = this.menuItems.length - 1;
    }
}

