/*
 * Decompiled with CFR 0.152.
 */
package com.ui;

import com.md.Horse;
import com.md.Preferences;
import com.ui.CommonImages;
import com.ui.GameSetupMenu;
import com.ui.ImageLoader;
import com.ui.RunningCanvas;
import com.ui.ShopForHorseMenu;
import com.ui.TextViewerCanvas;
import com.ui.VerticalMenu;
import com.ui.ViewHorseMenu;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PaddockMenu
extends VerticalMenu {
    Horse[] horses;
    Preferences savedGame;
    int totalHorseCount;
    ViewHorseMenu viewHorseMenu;
    private Image kbd;

    public PaddockMenu(GameSetupMenu gameSetupMenu) {
        super(gameSetupMenu, new String[]{"\u67e5\u770b\u9a6c\u5339", "\u8d5b\u9a6c\u5546\u5e97", "\u5e2e\u52a9", "\u63a5\u53d7"});
        this.savedGame = gameSetupMenu.savedGame;
        this.updateMenu();
        this.imageChoices = new Image[3];
        this.imageCaptions = new String[3];
        this.horses = new Horse[3];
        this.selectedIndex = -1;
        this.returnItemIndex = -2;
        this.totalHorseCount = this.savedGame.getHorseCount();
        ImageLoader.createImage("/kbd.png");
        this.kbd = (Image)ImageLoader.get("/kbd.png");
    }

    protected void paint(Graphics graphics) {
        for (int i = 0; i < 3; ++i) {
            this.horses[i] = this.savedGame.getHorseInPaddock(i);
            this.imageChoices[i] = CommonImages.getInstance().horseImages[this.horses[i].imageIndex];
            this.imageCaptions[i] = this.horses[i].name;
        }
        super.paint(graphics);
        graphics.drawImage(this.kbd, 0, 190, 0);
    }

    public void itemSelected() {
        RunningCanvas runningCanvas = null;
        int n = 5 - this.menuItems.length + this.selectedIndex;
        switch (n) {
            case 0: {
                --this.totalHorseCount;
                this.savedGame.setHorseCount(this.totalHorseCount);
                this.savedGame.setHorseInPaddock(this.selectedImageIndex, 0);
                runningCanvas = this;
                break;
            }
            case 1: {
                this.viewHorseMenu = new ViewHorseMenu(this, this.horses);
                this.viewHorseMenu.selectedHorseIndex = this.selectedImageIndex;
                runningCanvas = this.viewHorseMenu;
                break;
            }
            case 2: {
                runningCanvas = new ShopForHorseMenu(this, this.savedGame, this.selectedImageIndex);
                break;
            }
            case 3: {
                String[] stringArray = new String[]{"\u5f53\u4f60\u7b2c\u4e00\u6b21\u8fdb\u9a6c\u53a9\u65f6\uff0c\u4f60", "\u5fc5\u987b\u5165\u8d2d\u4e70\u4e00\u5339\u65b0\u7684\u8d5b\u9a6c\u3002", "\u5728\u770b\u8fc7\u53ef\u9009\u8d5b\u9a6c\u7684\u5217\u8868\u5e76", "\u4e14\u8d2d\u4e70\u4e00\u5339\u4e4b\u540e\uff0c\u5b83\u5c06\u51fa", "\u73b0\u5728\u4f60\u7684\u9a6c\u53a9\u91cc\u9ad8\u4eae\u5ea6\u663e", "\u793a\uff0c\u5e76\u4e14\u9009\u62e9\u2018\u63a5\u53d7\u2019\u83dc", "\u5355\u9009\u9879\u3002\u4f60\u53ef\u4ee5\u5728\u4efb\u610f\u7ed9", "\u5b9a\u65f6\u95f4\u91cc\u4fdd\u6301\u4e09\u5339\u9a6c\u7684\u6570", "\u91cf\uff0c\u653e\u5f03\u4e00\u5339\u8d5b\u9a6c\u53ef\u4ee5\u5f97", "\u5230\u5176\u4ed6\u7684\u8d5b\u9a6c\u3002\u8d44\u91d1\u8db3\u591f", "\u8d2d\u4e70\u5176\u4ed6\u8d5b\u9a6c\u7684\u65f6\u5019\uff0c\u653e", "\u5f03\u9009\u9879\u624d\u662f\u53ef\u7528\u7684\u3002"};
                runningCanvas = new TextViewerCanvas(stringArray, this, false, false);
                break;
            }
            case 4: {
                this.savedGame.setSelectedPaddock(this.selectedImageIndex);
                Horse horse = this.savedGame.getHorseInPaddock(this.savedGame.getSelectedPaddock());
                this.savedGame.setOdds(horse.getRandomizedOdds());
                runningCanvas = this.returnCanvas;
            }
        }
        this.updateMenu();
        runningCanvas.start(this.display);
    }

    protected void updateMenu() {
        boolean bl = false;
        if (this.savedGame.getMoney() > 600 && this.savedGame.getHorseInPaddock(this.selectedImageIndex) != Horse.ALL_HORSES[0]) {
            bl = true;
        }
        this.menuItems = bl ? new String[]{"\u653e\u5f03\u8d5b\u9a6c", "\u67e5\u770b\u8d5b\u9a6c", "\u8d2d\u4e70\u8d5b\u9a6c", "\u5e2e\u52a9", "\u63a5\u53d7"} : new String[]{"\u67e5\u770b\u8d5b\u9a6c", "\u8d2d\u4e70\u8d5b\u9a6c", "\u5e2e\u52a9", "\u63a5\u53d7"};
    }

    public void start(Display display) {
        this.selectedIndex = -1;
        this.selectedImageIndex = this.savedGame.getSelectedPaddock();
        this.updateMenu();
        if (this.viewHorseMenu != null) {
            this.selectedImageIndex = this.viewHorseMenu.selectedHorseIndex;
            this.viewHorseMenu = null;
        }
        super.start(display);
    }
}

