/*
 * Decompiled with CFR 0.152.
 */
package com.ui;

import com.ui.Colors;
import com.ui.ImageLoader;
import com.ui.RunningCanvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ProgressScreen
extends RunningCanvas {
    private String message;
    private Image icon;
    private int barHeight;
    private int totalHeight;
    private Font font;
    private Image kbd;

    public ProgressScreen(String string, Image image) {
        this.message = string;
        this.icon = image;
        this.font = Font.getFont((int)64, (int)1, (int)0);
        this.barHeight = 10;
        this.totalHeight = this.font.getBaselinePosition() + 2 + this.barHeight;
        if (image != null) {
            this.totalHeight += image.getHeight() + 2;
        }
        ImageLoader.createImage("/kbd.png");
        this.kbd = (Image)ImageLoader.get("/kbd.png");
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(Colors.BLACK);
        graphics.fillRect(0, 0, 240, 190);
        graphics.setColor(Colors.DEFAULT_FONT_COLOR);
        int n = 120;
        graphics.translate(0, (190 - this.totalHeight) / 2);
        if (this.icon != null) {
            graphics.drawImage(this.icon, n, 0, 17);
            graphics.translate(0, this.icon.getHeight());
        }
        graphics.translate(0, 2);
        graphics.setFont(this.font);
        graphics.drawString(this.message, n, 0, 17);
        graphics.translate(0, this.font.getBaselinePosition() + 2);
        int n2 = 210;
        graphics.setColor(Colors.DARK_GREEN);
        graphics.fillRect(15, 5, n2, this.barHeight);
        graphics.setColor(Colors.BLACK);
        graphics.fillRect(16, 6, n2 - 2, this.barHeight - 2);
        int n3 = (int)(System.currentTimeMillis() / 100L % (long)(n2 - 10));
        graphics.setColor(Colors.GREEN);
        graphics.fillRect(16 + n3, 6, 8, this.barHeight - 2);
        graphics.drawImage(this.kbd, 0, 190, 0);
    }
}

