/*
 * Decompiled with CFR 0.152.
 */
package com.ui;

import com.md.Horse;
import com.md.Race;
import com.ui.Colors;
import com.ui.GraphicsMemento;
import com.ui.GraphicsUtil;
import com.ui.HorseSprite;
import com.ui.ImageLoader;
import com.ui.MainMenu;
import com.ui.PauseMenu;
import com.ui.Point;
import com.ui.RunningCanvas;
import com.ui.TiledImage;
import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RaceCanvas
extends RunningCanvas
implements CommandListener {
    protected Command cmdRight;
    protected Command cmdStub;
    protected Image mygrass;
    public boolean pause;
    protected RunningCanvas returnCanvas;
    protected Race race;
    protected static final int GRASS_HEIGHT = 50;
    protected static final int PLAYER_HORSE = 0;
    GraphicsUtil gUtil = GraphicsUtil.getInstance();
    protected Image grass;
    protected Image finishLine;
    protected Image background;
    protected Image statusTrim;
    protected Image tree;
    protected Image balloonImage;
    protected Point balloonLocation;
    protected Image straightTrack;
    protected Image curvedTrack;
    protected TiledImage countdown;
    protected TiledImage startingGate;
    protected HorseSprite[] nearHorseSprites;
    protected HorseSprite[] farHorseSprites;
    protected int[] straightTrackX;
    protected int[] curvedTrackX;
    protected Image lowerStatusBackground;
    protected Image upperStatusBackground;
    protected Point lowerStatusLocation;
    protected Point speedLocation;
    protected Point racePositionLocation;
    public int[] leftSideTreeLocations;
    public int[] rightSideTreeLocations;
    protected Random random;
    Horse playerHorse;
    int[] trackLineColors;
    GraphicsMemento gMemento;
    Font smallFont = Font.getFont((int)32, (int)0, (int)8);
    Image bottomEdge;
    private Image kbd;
    StringBuffer speedBuf = new StringBuffer(64);

    public RaceCanvas(RunningCanvas runningCanvas, Race race) {
        this.returnCanvas = runningCanvas;
        this.race = race;
        this.delay = 20L;
        this.random = new Random(System.currentTimeMillis());
        ImageLoader.createImage("/mygrass.png");
        this.mygrass = (Image)ImageLoader.get("/mygrass.png");
        ImageLoader.createImage("/kbd.png");
        this.kbd = (Image)ImageLoader.get("/kbd.png");
        ImageLoader.createImage("/finishLine.png");
        this.finishLine = (Image)ImageLoader.get("/finishLine.png");
        ImageLoader.createImage("/status_trim.png");
        this.statusTrim = (Image)ImageLoader.get("/status_trim.png");
        ImageLoader.createImage("/tree.png");
        this.tree = (Image)ImageLoader.get("/tree.png");
        ImageLoader.createImage("/straightTrack.png");
        this.straightTrack = (Image)ImageLoader.get("/straightTrack.png");
        ImageLoader.createImage("/curvedTrack.png");
        this.curvedTrack = (Image)ImageLoader.get("/curvedTrack.png");
        if (this.countdown == null) {
            this.countdown = new TiledImage(this.gUtil.loadKnownImage("/countdown.png"), 2, 2);
        }
        if (this.startingGate == null) {
            this.startingGate = new TiledImage(this.gUtil.loadKnownImage("/starting_gate.png"), 2, 1);
        }
        this.curvedTrackX = new int[]{0, 2, 4, 6, 9, 10, 13, 15, 17, 19, 22, 23, 26, 27, 29, 30, 32, 33, 35, 35, 36, 35, 36, 35, 34};
        this.straightTrackX = new int[]{0, 2, 5, 7, 10, 12, 15, 17, 20, 22, 25, 27, 30, 32, 35, 37, 40, 42, 45, 47, 50, 52, 55, 57, 60};
        this.leftSideTreeLocations = new int[]{5, 24, 30, 15, 20, 8, 20, 50};
        this.rightSideTreeLocations = new int[]{15, 8, 30, 12, 50, 10, 22, 40};
        this.playerHorse = race.getHorse(0);
        if (this.gMemento == null) {
            this.gMemento = new GraphicsMemento();
        }
        ImageLoader.createImage("/lowerStatus.png");
        this.lowerStatusBackground = (Image)ImageLoader.get("/lowerStatus.png");
        if (this.lowerStatusLocation == null) {
            this.lowerStatusLocation = new Point(240 - this.lowerStatusBackground.getWidth() - 2, 190 - this.lowerStatusBackground.getHeight() - 2);
        }
        this.setUpUpperStatus();
        if (this.trackLineColors == null) {
            this.trackLineColors = new int[this.curvedTrackX.length];
        }
        this.doCreateUseRace(runningCanvas, race);
        this.cmdStub = new Command("\u786e\u5b9a", 2, 1);
        this.cmdRight = new Command("\u8fd4\u56de", 2, 1);
        this.addCommand(this.cmdRight);
        this.setCommandListener(this);
    }

    public void doCreateUseRace(RunningCanvas runningCanvas, Race race) {
        int n;
        if (race == null || runningCanvas == null) {
            return;
        }
        this.returnCanvas = runningCanvas;
        int n2 = 0;
        ImageLoader.createImage("/horse_anims.png");
        Image image = (Image)ImageLoader.get("/horse_anims.png");
        ImageLoader.createImage("/horse_anims_far.png");
        Image image2 = (Image)ImageLoader.get("/horse_anims_far.png");
        ImageLoader.createImage("/silk_paper.png");
        Image image3 = (Image)ImageLoader.get("/silk_paper.png");
        this.nearHorseSprites = new HorseSprite[race.horses.length];
        this.farHorseSprites = new HorseSprite[race.horses.length];
        for (n = 0; n < race.horses.length; ++n) {
            this.nearHorseSprites[n] = new HorseSprite(image, image3, race.horses[n], n % 3);
            this.farHorseSprites[n] = new HorseSprite(image2, null, race.horses[n], n % 3);
        }
        n = this.random.nextInt() % 2 == 1 ? 1 : 0;
        String string = n != 0 ? "zeppellin" : "balloon";
        ImageLoader.createImage("/" + string + ".png");
        this.balloonImage = (Image)ImageLoader.get("/" + string + ".png");
        this.balloonLocation = new Point(this.random.nextInt() % 240, 20 + n2);
    }

    public void release() {
        this.background = null;
        this.nearHorseSprites = null;
        this.farHorseSprites = null;
        System.gc();
    }

    protected void paint(Graphics graphics) {
        try {
            this.drawAll(graphics);
            graphics.drawImage(this.kbd, 0, 190, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void drawAll(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Image image;
        int[] nArray;
        if (this.pause) {
            return;
        }
        if (this.race == null) {
            return;
        }
        this.race.updateState();
        this.race.updatePositions();
        long l = this.race.getTimeSinceStart();
        if (this.playerHorse.trackPixelPosition > 1953) {
            this.stop();
            this.showFinish();
            return;
        }
        if (this.playerHorse.onCurvedTrack) {
            nArray = this.curvedTrackX;
            image = this.curvedTrack;
        } else {
            nArray = this.straightTrackX;
            image = this.straightTrack;
        }
        int n7 = this.playerHorse.trackPixelPosition;
        int n8 = 140 + n7 % this.mygrass.getHeight();
        this.drawGrass(graphics, n8);
        int n9 = (this.playerHorse.horizonPerspective >> 5) % 70 - 70;
        this.drawBack(graphics, n9);
        graphics.drawImage(this.balloonImage, (this.playerHorse.horizonPerspective >> 5) + this.balloonLocation.x + ((int)l >> 11), this.balloonLocation.y, 20);
        int n10 = 120 - this.playerHorse.horizontalPosition - 10;
        graphics.drawImage(image, n10, 190, 36);
        graphics.setColor(Colors.DARK_BROWN);
        for (n6 = this.playerHorse.step; n6 < 25; n6 += 4) {
            graphics.fillRect(n10 + nArray[n6], 190 - (n6 + 1) * 2, 160 - n6 * 5, 2);
        }
        n6 = 1953 - n7;
        if (n6 < nArray.length * 2 && n6 >= 0) {
            n5 = n6 >> 1;
            n4 = 160 - n5 * 5;
            n3 = n10 + nArray[n5];
            graphics.setClip(n3, 0, n4, 190);
            graphics.drawImage(this.finishLine, n3, 190 - n6, 36);
            graphics.setClip(0, 0, 240, 190);
        }
        graphics.translate(0, 140);
        for (n5 = 0; n5 < this.leftSideTreeLocations.length; ++n5) {
            n4 = (n7 + n5 * 25) % 200;
            n3 = nArray.length - n4 / 2 - 1;
            if (n3 <= 0 || n3 >= nArray.length) continue;
            int n11 = n10 - this.leftSideTreeLocations[n5] + nArray[n3];
            graphics.drawImage(this.tree, n11, n4, 40);
            n4 = (n4 + 10) % 200;
            n11 = n10 + nArray[n3] + this.rightSideTreeLocations[n5] + 160 - n3 * 5;
            graphics.drawImage(this.tree, n11, n4, 36);
        }
        graphics.translate(0, -140);
        int n12 = this.straightTrackX.length * 2;
        for (n2 = 1; n2 < 6; ++n2) {
            n5 = this.race.horses[n2].trackPixelPosition - n7;
            if (n5 < -48 || n5 >= n12) continue;
            HorseSprite horseSprite = n5 < this.straightTrackX.length ? this.nearHorseSprites[n2] : this.farHorseSprites[n2];
            n4 = 190 - n5 - horseSprite.tiledImage.getTileHeight();
            int n13 = n5 >> 1;
            if (n13 < 0) {
                n13 = 0;
            }
            n3 = n10 + nArray[n13] + this.race.horses[n2].horizontalPosition - (this.race.horses[n2].horizontalPosition * n13 >> 5);
            int n14 = this.race.horses[n2].direction = this.playerHorse.onCurvedTrack ? -2 : 0;
            if (this.race.state == 2) {
                horseSprite.drawNext(graphics, n3, n4, this.race.horses[n2].speed);
                continue;
            }
            horseSprite.drawNext(graphics, n3, n4, 0);
        }
        graphics.setClip(0, 0, 240, 190);
        n2 = 110;
        int n15 = 150;
        this.nearHorseSprites[0].drawNext(graphics, n2, n15, this.playerHorse.speed);
        if (this.playerHorse.whips > 0) {
            graphics.setColor(Colors.WHITE);
            graphics.drawLine(n2 + 14, n15 + 6, n2 + 16, n15 + 8);
        }
        if (n7 < 48) {
            n = n10 + 10;
            int n16 = 0;
            for (int i = 5; i >= 0; --i) {
                n16 = this.race.getHorse(i) == null ? 0 : 1;
                this.startingGate.paint(graphics, n += 20, 190 + n7 - 48, n16, 0);
            }
        }
        if (l < 4000L) {
            this.countdown.paint(graphics, 110, 83, (int)l / 1000);
        }
        graphics.setClip(0, 0, 240, 210);
        graphics.drawImage(this.kbd, 0, 190, 0);
        this.gUtil.resetTranslation(graphics);
        graphics.translate(77, 1);
        graphics.drawImage(this.upperStatusBackground, 0, 0, 20);
        graphics.translate(13, 0);
        graphics.setColor(Colors.RED);
        n = 60 * this.playerHorse.energy / 180;
        graphics.fillRect(n, 7, 60 - n, 4);
        graphics.setColor(Colors.YELLOW);
        graphics.fillRect(this.playerHorse.speed * 60 / this.playerHorse.topSpeed, 1, 2, 4);
        this.gUtil.resetTranslation(graphics);
        this.speedBuf.delete(0, this.speedBuf.length());
        this.speedBuf.append(this.playerHorse.speed);
        graphics.setColor(0);
        graphics.drawString("\u901f\u5ea6", 0, 0, 20);
        graphics.setColor(255, 0, 0);
        graphics.drawString(this.speedBuf.toString(), 7, 19, 20);
        this.speedBuf.delete(0, this.speedBuf.length());
        graphics.setColor(0);
        graphics.drawString("\u540d\u6b21", 240, 0, 24);
        this.speedBuf.append(this.race.playerRank);
        graphics.setColor(255, 0, 0);
        graphics.drawString(this.speedBuf.toString(), 230, 19, 24);
        graphics.drawImage(this.kbd, 0, 190, 0);
    }

    private void drawGrass(Graphics graphics, int n) {
        int n2 = 190 - n;
        int n3 = this.mygrass.getWidth();
        for (int i = 0; i < 240; i += n3) {
            graphics.drawImage(this.mygrass, i, n, 20);
            graphics.drawImage(this.mygrass, i, n, 36);
            graphics.drawImage(this.mygrass, i, n + this.mygrass.getHeight(), 36);
        }
        graphics.setClip(0, 0, 240, 240);
        graphics.drawImage(this.kbd, 0, 190, 0);
    }

    private void drawBack(Graphics graphics, int n) {
        int n2 = 140;
        graphics.setClip(0, 0, 240, n2);
        ImageLoader.createImage("/background_" + this.race.savedGame.getLevel() + "_8bit.png");
        Image image = (Image)ImageLoader.get("/background_" + this.race.savedGame.getLevel() + "_8bit.png");
        int n3 = 310;
        for (int i = 0; i < n3; i += 70) {
            graphics.drawImage(image, i + n, 0, 20);
        }
        graphics.setClip(0, 0, 240, 190);
        graphics.drawImage(this.kbd, 0, 190, 0);
    }

    protected void showFinish() {
        boolean bl;
        this.nearHorseSprites = null;
        this.farHorseSprites = null;
        System.gc();
        int n = this.race.wager * this.race.savedGame.getOdds();
        boolean bl2 = bl = n > 200;
        if (!bl) {
            n = 200;
        }
        this.race.savedGame.setWager(0);
        if (this.race.playerRank <= 3) {
            this.race.savedGame.setLevel(this.race.savedGame.getLevel() + 1);
        }
        boolean bl3 = false;
        String[] stringArray = new String[]{};
        String string = "";
        String string2 = "";
        switch (this.race.playerRank) {
            case 1: {
                string = "\u7b2c\u4e00\u540d";
                string2 = "won";
                break;
            }
            case 2: {
                n /= 2;
                string = "\u7b2c\u4e8c\u540d";
                string2 = "placed";
                break;
            }
            case 3: {
                n /= 4;
                string = "\u7b2c\u4e09\u540d";
                string2 = "showed";
                break;
            }
            default: {
                bl3 = true;
                n = 0;
                stringArray = new String[]{"", "", "\u6bd4\u8d5b\u8f93\u4e86\uff0c", "\u795d\u4f60\u4e0b\u6b21\u597d\u8fd0"};
            }
        }
        if (!bl3) {
            stringArray = bl ? new String[]{"", "\u4f60\u662f" + string, "\u6839\u636e\u4f60\u9009", "\u62e9\u7684" + this.race.savedGame.getOdds() + ":1\u7684\u8d54\u7387", "\u548c$" + this.race.wager + "\u7684\u8d4c\u6ce8\u91d1,", "\u4f60\u5c06\u5f97\u5230$" + n} : new String[]{"", "", "\u4f60\u662f" + string, "\u4f60\u8d62\u4e86", "$" + n};
        }
        if (!bl3) {
            this.race.savedGame.setMoney(this.race.savedGame.getMoney() + n);
        } else {
            int n2 = this.race.savedGame.getMoney() - this.race.wager;
            if (n2 <= 0) {
                n2 = 0;
            }
            this.race.savedGame.setMoney(this.race.savedGame.getMoney() - this.race.wager);
        }
        this.race.savedGame.setOdds(this.playerHorse.getRandomizedOdds());
        MainMenu.txtViewer.setup(stringArray, this.returnCanvas, true);
        MainMenu.txtViewer.start(this.display);
    }

    protected void setUpUpperStatus() {
        Image image = Image.createImage((int)86, (int)13);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Colors.BROWN);
        graphics.translate(13, 0);
        graphics.fillRect(0, 0, 60, 13);
        graphics.drawImage(this.statusTrim, 0, 0, 24);
        graphics.drawImage(this.statusTrim, 60, 0, 20);
        graphics.setColor(Colors.YELLOW);
        graphics.fillRect(0, 7, 60, 4);
        graphics.setColor(Colors.BLUE);
        graphics.fillRect(0, 1, this.playerHorse.stamina * 60 / 100, 4);
        graphics.setColor(Colors.GREEN);
        graphics.fillRect(this.playerHorse.conditioning * 60 / 100, 1, 60 - this.playerHorse.conditioning * 60 / 100, 4);
        graphics.setColor(Colors.RED);
        graphics.fillRect(this.playerHorse.stamina * 60 / 100, 1, 60 - this.playerHorse.stamina * 60 / 100, 4);
        this.upperStatusBackground = Image.createImage((Image)image);
    }

    public void start(Display display) {
        if (this.race.state == 3) {
            this.race.resume();
        } else {
            this.race.start();
        }
        super.start(display);
    }

    protected void pause() {
        this.stop();
        this.race.pause();
    }

    protected void keyPressed(int n) {
        int n2;
        System.out.println("racecanvas");
        switch (n) {
            case 22: 
            case 35: 
            case 42: 
            case 48: {
                this.pause();
                new PauseMenu(this).start(this.display);
                return;
            }
        }
        try {
            n2 = this.getGameAction(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        if (this.race.state == 0 || this.race.state == 1) {
            return;
        }
        switch (n2) {
            case 8: {
                this.race.getHorse(0).whip();
                break;
            }
            case 1: {
                this.race.getHorse((int)0).accelerationState = 1;
                break;
            }
            case 6: {
                this.race.getHorse((int)0).accelerationState = -1;
                break;
            }
            case 2: {
                this.race.getHorse((int)0).direction = -2;
                break;
            }
            case 5: {
                this.race.getHorse((int)0).direction = 2;
            }
        }
    }

    protected void pointerPressed(int n, int n2) {
        System.out.println("x" + n + "y" + n2);
        this.repaint();
        int n3 = this.getPointerKey(n, n2);
        if (n3 == 22) {
            this.commandAction(this.cmdRight, null);
        } else if (n3 > -100) {
            this.keyPressed(n3);
        }
    }

    protected void pointerReleased(int n, int n2) {
        this.repaint();
        int n3 = this.getPointerKey(n, n2);
        if (n3 > -100) {
            this.keyReleased(n3);
        }
    }

    protected int getPointerKey(int n, int n2) {
        int n3 = 190;
        int n4 = -100;
        if (this.inRect(n, n2, 70, 215, 100, 25)) {
            n4 = -2;
        } else if (this.inRect(n, n2, 70, 190, 100, 25)) {
            n4 = -1;
        } else if (this.inRect(n, n2, 0, 190, 70, 50) || this.inRect(n, n2, 0, 170, 20, 20)) {
            n4 = -3;
        } else if (this.inRect(n, n2, 170, 190, 70, 50) || this.inRect(n, n2, 220, 170, 20, 20)) {
            n4 = -4;
        }
        return n4;
    }

    protected boolean inRect(int n, int n2, int n3, int n4, int n5, int n6) {
        return n > n3 && n < n3 + n5 && n2 > n4 && n2 < n4 + n6;
    }

    protected void keyReleased(int n) {
        int n2;
        try {
            n2 = this.getGameAction(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        switch (n2) {
            case 1: 
            case 6: {
                this.race.getHorse((int)0).accelerationState = 0;
                break;
            }
            case 2: 
            case 5: {
                this.race.getHorse((int)0).direction = 0;
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdRight) {
            this.keyPressed(22);
        } else if (command == this.cmdStub) {
            this.keyPressed(21);
        }
    }
}

