/*
 * Decompiled with CFR 0.152.
 */
package com.ui;

import com.ui.Colors;
import com.ui.GraphicsUtil;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public abstract class RunningCanvas
extends Canvas
implements Runnable {
    protected long delay = 200L;
    protected Display display;
    protected Thread runningThread;
    long[] milestones = new long[]{0L, 0L, 0L, 0L, 0L};
    long startTime;
    int numberOfPaints;
    long timeSpentPainting;
    public boolean running;
    protected boolean stop;

    public boolean isStopped() {
        return this.stop;
    }

    public void run() {
        try {
            long l = 0L;
            long l2 = 0L;
            this.running = true;
            while (!this.stop) {
                l = System.currentTimeMillis();
                this.repaint();
                l2 = System.currentTimeMillis();
                if (l2 - l >= this.delay) continue;
                try {
                    Thread.sleep(this.delay - (l2 - l));
                }
                catch (InterruptedException interruptedException) {}
            }
            this.running = false;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void start(Display display) {
        this.display = display;
        this.stop = false;
        if (this.runningThread != null && this.runningThread.isAlive()) {
            return;
        }
        display.setCurrent((Displayable)this);
        this.runningThread = new Thread(this);
        this.runningThread.start();
    }

    public void stop() {
        this.stop = true;
        while (this.running) {
        }
    }

    protected void recordStartPaint() {
        ++this.numberOfPaints;
        this.startTime = System.currentTimeMillis();
    }

    protected void recordAndDisplayFinishPaint(Graphics graphics) {
        GraphicsUtil graphicsUtil = GraphicsUtil.getInstance();
        long l = System.currentTimeMillis() - this.startTime;
        this.timeSpentPainting += l;
        long l2 = this.timeSpentPainting / (long)this.numberOfPaints;
        graphics.setColor(Colors.WHITE);
        Font font = Font.getFont((int)64, (int)0, (int)8);
        graphicsUtil.resetTranslation(graphics);
        graphics.drawString("\u65f6\u95f4 = " + l, 0, 190 - font.getHeight() * 2, 36);
        String string = "m[]=";
        long l3 = this.startTime;
        for (int i = 0; i < this.milestones.length; ++i) {
            string = string + Math.max(this.milestones[i] - l3, 0L);
            l3 = this.milestones[i];
            string = string + " ";
        }
        graphics.drawString(string, 0, 190 - font.getHeight(), 36);
        graphics.drawString("\u5e73\u5747 = " + l2, 0, 190, 36);
    }

    public int getGameAction(int n) {
        switch (n) {
            case 50: {
                return 1;
            }
            case 56: {
                return 6;
            }
            case 52: {
                return 2;
            }
            case 54: {
                return 5;
            }
            case 53: {
                return 8;
            }
        }
        return super.getGameAction(n);
    }
}

