/*
 * Decompiled with CFR 0.152.
 */
package com.ui;

import com.md.Horse;
import com.md.Preferences;
import com.ui.Colors;
import com.ui.CommonImages;
import com.ui.GraphicsUtil;
import com.ui.ImageLoader;
import com.ui.MainMenu;
import com.ui.RunningCanvas;
import com.ui.VerticalMenu;
import com.ui.ViewHorseMenu;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ShopForHorseMenu
extends VerticalMenu {
    private int totalHorseCount;
    boolean showMoney;
    int money;
    int paddockIndex;
    Image frame;
    Preferences savedGame;
    private Image kbd;

    public ShopForHorseMenu(RunningCanvas runningCanvas, Preferences preferences, int n) {
        super(runningCanvas, new String[]{"\u67e5\u770b\u8d5b\u9a6c", "\u73b0\u91d1", "\u8d2d\u4e70", "\u8fd4\u56de"});
        this.savedGame = preferences;
        this.paddockIndex = n;
        this.imageChoices = new Image[Horse.ALL_HORSES.length - 1];
        this.imageCaptions = new String[Horse.ALL_HORSES.length - 1];
        for (int i = 1; i < Horse.ALL_HORSES.length; ++i) {
            Horse horse = Horse.ALL_HORSES[i];
            this.imageChoices[i - 1] = CommonImages.getInstance().horseImages[horse.imageIndex];
            this.imageCaptions[i - 1] = horse.name;
        }
        this.selectedIndex = -1;
        this.money = preferences.getMoney();
        ImageLoader.createImage("/frame.png");
        this.frame = (Image)ImageLoader.get("/frame.png");
        ImageLoader.createImage("/kbd.png");
        this.kbd = (Image)ImageLoader.get("/kbd.png");
        this.totalHorseCount = preferences.getHorseCount();
    }

    protected void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.showMoney) {
            GraphicsUtil.getInstance().resetTranslation(graphics);
            graphics.setColor(Colors.BLACK);
            graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
            graphics.drawImage(this.frame, 120, 95, 3);
            graphics.drawString("$" + this.money, 120, 95, 65);
        }
        graphics.drawImage(this.kbd, 0, 190, 0);
    }

    public void itemSelected() {
        switch (this.selectedIndex) {
            case 0: {
                ViewHorseMenu viewHorseMenu = new ViewHorseMenu(this, Horse.ALL_HORSES);
                viewHorseMenu.minimumSelectedIndex = 1;
                viewHorseMenu.selectedHorseIndex = this.selectedImageIndex + 1;
                viewHorseMenu.start(this.display);
                break;
            }
            case 1: {
                this.showMoney = true;
                this.start(this.display);
                break;
            }
            case 2: {
                String[] stringArray;
                Horse horse = Horse.ALL_HORSES[this.selectedImageIndex + 1];
                if (this.money < horse.price) {
                    stringArray = new String[]{"\u4f60\u7684\u94b1\u4e0d\u591f\uff01"};
                } else {
                    ++this.totalHorseCount;
                    if (this.totalHorseCount > 3) {
                        stringArray = new String[]{"", "", "", "", "\u4f60\u5df2\u62e5\u6709\u8d85\u8fc7", "3\u5339\u9a6c,\u4e0d\u80fd", "\u7ee7\u7eed\u8d2d\u4e70"};
                    } else {
                        this.money -= horse.price;
                        this.savedGame.setMoney(this.money);
                        for (int i = 0; i < 3; ++i) {
                            if (this.savedGame.getHorseInPaddock(i) != Horse.ALL_HORSES[0]) continue;
                            this.savedGame.setHorseInPaddock(i, this.selectedImageIndex + 1);
                            this.savedGame.setSelectedPaddock(i);
                            break;
                        }
                        this.savedGame.setHorseCount(this.totalHorseCount);
                        stringArray = new String[]{"", "", "", "", "\u8d2d\u4e70\u6210\u529f\uff01"};
                    }
                }
                MainMenu.txtViewer1.setup(stringArray, this, true);
                MainMenu.txtViewer1.start(this.display);
            }
        }
    }

    protected void keyPressed(int n) {
        System.out.println("shopforhorse");
        if (this.showMoney) {
            this.showMoney = false;
        } else {
            super.keyPressed(n);
        }
    }
}

