/*
 * Decompiled with CFR 0.152.
 */
package com.ui;

import com.ui.Colors;
import com.ui.GraphicsUtil;
import com.ui.ImageLoader;
import com.ui.Point;
import com.ui.RunningCanvas;
import com.ui.TiledImage;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TextViewerCanvas
extends RunningCanvas
implements CommandListener {
    public Command cmdRight;
    public Command cmdStub;
    String[] textLines;
    RunningCanvas returnCanvas;
    int topLineIndex;
    int linesPerScreen;
    Font font;
    Point topArrowLocation;
    Point bottomArrowLocation;
    int textAnchor;
    int textX;
    final int UP_ARROW;
    final int DOWN_ARROW;
    TiledImage arrows;
    private Image kbd;
    boolean rob;

    public TextViewerCanvas(String[] stringArray, RunningCanvas runningCanvas, boolean bl, boolean bl2) {
        this.UP_ARROW = 2;
        this.DOWN_ARROW = 3;
        this.textLines = stringArray;
        this.returnCanvas = runningCanvas;
        this.arrows = new TiledImage(GraphicsUtil.getInstance().loadKnownImage("/arrows.png"), 4, 1);
        this.font = Font.getFont((int)64, (int)0, (int)16);
        this.linesPerScreen = 190 / this.font.getHeight();
        this.topArrowLocation = new Point(240 - this.arrows.getTileWidth(), 0);
        this.bottomArrowLocation = new Point(240 - this.arrows.getTileWidth(), 190 - this.arrows.getTileHeight());
        this.rob = bl2;
        ImageLoader.createImage("/kbd.png");
        this.kbd = (Image)ImageLoader.get("/kbd.png");
        if (bl) {
            this.textX = 120;
            this.textAnchor = 17;
        } else {
            this.textX = 0;
            this.textAnchor = 20;
        }
        this.cmdRight = new Command(" ", 2, 1);
        this.cmdStub = new Command("\u786e\u5b9a", 2, 1);
        if (!bl2) {
            this.cmdRight = new Command("\u8fd4\u56de", 2, 1);
            this.cmdStub = new Command("\u786e\u5b9a", 2, 1);
            this.addCommand(this.cmdRight);
            this.addCommand(this.cmdStub);
        } else {
            this.cmdRight = new Command(" ", 2, 1);
            this.cmdStub = new Command("\u786e\u5b9a", 2, 1);
            this.addCommand(this.cmdRight);
            this.addCommand(this.cmdStub);
        }
        this.setCommandListener(this);
    }

    public void setup(String[] stringArray, RunningCanvas runningCanvas, boolean bl) {
        this.topLineIndex = 0;
        this.textLines = stringArray;
        this.returnCanvas = runningCanvas;
        if (bl) {
            this.textX = 120;
            this.textAnchor = 17;
        } else {
            this.textX = 0;
            this.textAnchor = 20;
        }
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(Colors.BLACK);
        graphics.fillRect(0, 0, 240, 190);
        graphics.setColor(Colors.WHITE);
        GraphicsUtil.getInstance().resetTranslation(graphics);
        if (this.topLineIndex > 0) {
            this.arrows.paint(graphics, this.topArrowLocation.x, this.topArrowLocation.y, 2);
        }
        if (this.textLines.length > this.topLineIndex + this.linesPerScreen) {
            this.arrows.paint(graphics, this.bottomArrowLocation.x, this.bottomArrowLocation.y, 3);
        }
        graphics.setClip(0, 0, 240, 190);
        graphics.setFont(this.font);
        for (int i = this.topLineIndex; i < this.topLineIndex + this.linesPerScreen && i < this.textLines.length; ++i) {
            graphics.drawString(this.textLines[i], this.textX, 0, this.textAnchor);
            graphics.translate(0, this.font.getHeight());
        }
    }

    protected void keyPressed(int n) {
        int n2;
        System.out.println("textviewercanvas");
        if (System.currentTimeMillis() - this.startTime < 1000L) {
            return;
        }
        if (n == 22 || n == 21) {
            this.stop();
            this.returnCanvas.start(this.display);
            return;
        }
        try {
            n2 = this.getGameAction(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        switch (n2) {
            case 8: {
                this.stop();
                this.returnCanvas.start(this.display);
                break;
            }
            case 1: {
                this.topLineIndex = Math.max(--this.topLineIndex, 0);
                System.out.println("top line index = " + this.topLineIndex);
                break;
            }
            case 6: {
                if (this.textLines.length > this.topLineIndex + this.linesPerScreen) {
                    this.topLineIndex = Math.min(++this.topLineIndex, this.textLines.length - 1);
                }
                System.out.println("top line index = " + this.topLineIndex);
            }
        }
    }

    protected void pointerPressed(int n, int n2) {
        System.out.println("x" + n + "y" + n2);
        int n3 = this.getPointerKey(n, n2);
        if (n3 != 22 && n3 != 21 && n3 > -100) {
            this.keyPressed(n3);
        }
        if (n > 220 && n < 241 && n2 > 0 && n2 < 25) {
            this.topLineIndex = Math.max(--this.topLineIndex, 0);
            System.out.println("top line index = " + this.topLineIndex);
        } else if (n > 220 && n < 241 && n2 > 170 && n2 < 191 && this.textLines.length > this.topLineIndex + this.linesPerScreen) {
            this.topLineIndex = Math.min(++this.topLineIndex, this.textLines.length - 1);
        }
    }

    protected int getPointerKey(int n, int n2) {
        int n3 = 190;
        int n4 = -100;
        if (this.inRect(n, n2, 70, 215, 100, 25)) {
            n4 = -2;
        } else if (this.inRect(n, n2, 70, 190, 100, 25)) {
            n4 = -1;
        } else if (this.inRect(n, n2, 0, 190, 70, 50) || this.inRect(n, n2, 0, 170, 20, 20)) {
            n4 = -3;
        } else if (this.inRect(n, n2, 170, 190, 70, 50) || this.inRect(n, n2, 220, 170, 20, 20)) {
            n4 = -4;
        }
        return n4;
    }

    protected boolean inRect(int n, int n2, int n3, int n4, int n5, int n6) {
        return n > n3 && n < n3 + n5 && n2 > n4 && n2 < n4 + n6;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdRight) {
            if (!this.rob) {
                this.keyPressed(22);
            }
        } else if (command == this.cmdStub) {
            this.keyPressed(-5);
        }
    }
}

