/*
 * Decompiled with CFR 0.152.
 */
package com.ui;

import com.ui.GraphicsMemento;
import com.ui.ImageLoader;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledImage {
    private Image originalImage;
    private int tileWidth;
    private int tileHeight;
    private int horizontalTiles;
    private int verticalTiles;
    private GraphicsMemento graphicsMemento;
    int[] originalClipRect;
    private Image kbd;

    public TiledImage(Image image, int n, int n2) {
        this.originalImage = image;
        this.horizontalTiles = n;
        this.verticalTiles = n2;
        this.tileWidth = image.getWidth() / n;
        this.tileHeight = image.getHeight() / n2;
        this.kbd = (Image)ImageLoader.get("/kbd.png");
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setClip(n, n2, this.tileWidth, this.tileHeight);
        graphics.drawImage(this.originalImage, n - this.tileWidth * n3, n2 - this.tileHeight * n4, 20);
        graphics.drawImage(this.kbd, 0, 190, 0);
    }

    public void paint(Graphics graphics, int n, int n2, int n3) {
        this.paint(graphics, n, n2, n3 % this.horizontalTiles, n3 / this.horizontalTiles);
        graphics.drawImage(this.kbd, 0, 190, 0);
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }
}

