/*
 * Decompiled with CFR 0.152.
 */
package com.ui;

import com.ui.Colors;
import com.ui.CommonImages;
import com.ui.ImageLoader;
import com.ui.RunningCanvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class VerticalMenu
extends RunningCanvas
implements CommandListener {
    protected Command cmdRight;
    protected Command cmdStub;
    protected String[] menuItems;
    protected RunningCanvas returnCanvas;
    protected int returnItemIndex;
    protected Image[] imageChoices;
    protected String[] imageCaptions;
    protected Font font;
    protected int selectedIndex;
    protected int selectedImageIndex;
    protected int totalTextHeight;
    int skip;
    private Image kbd;
    private int xx;
    private int yy;

    public VerticalMenu(RunningCanvas runningCanvas, String[] stringArray) {
        this(runningCanvas, null, null, stringArray);
    }

    public VerticalMenu(RunningCanvas runningCanvas, Image[] imageArray, String[] stringArray, String[] stringArray2) {
        this.returnCanvas = runningCanvas;
        this.imageChoices = imageArray;
        this.imageCaptions = stringArray;
        this.menuItems = stringArray2;
        this.returnItemIndex = stringArray2.length - 1;
        this.font = Font.getFont((int)64, (int)0, (int)16);
        this.selectedIndex = 0;
        this.skip = this.font.getHeight() + 1 + 3;
        this.totalTextHeight = this.skip * stringArray2.length;
        ImageLoader.createImage("/kbd.png");
        this.kbd = (Image)ImageLoader.get("/kbd.png");
        this.cmdStub = new Command("\u786e\u5b9a", 2, 1);
        this.cmdRight = new Command("\u8fd4\u56de", 2, 1);
        this.addCommand(this.cmdRight);
        this.addCommand(this.cmdStub);
        this.setCommandListener(this);
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(Colors.BLACK);
        graphics.fillRect(0, 0, 240, 190);
        graphics.setFont(this.font);
        int n = 95 - this.totalTextHeight / 2 - 1;
        if (this.imageChoices != null) {
            n -= this.imageChoices[this.selectedImageIndex].getHeight() / 2;
            if (this.imageCaptions != null) {
                graphics.setColor(Colors.LIGHT_GRAY);
                graphics.drawString(this.imageCaptions[this.selectedImageIndex], 120, n - this.font.getHeight() - 2, 17);
            }
            graphics.drawImage(this.imageChoices[this.selectedImageIndex], 120, n, 17);
            if (this.selectedIndex == -1) {
                graphics.setColor(Colors.YELLOW);
                graphics.drawRect(120 - this.imageChoices[this.selectedImageIndex].getWidth() / 2 - 1, n - 1, this.imageChoices[this.selectedImageIndex].getWidth() + 2, this.imageChoices[this.selectedImageIndex].getHeight() + 2);
                if (this.selectedImageIndex > 0) {
                    graphics.drawImage(CommonImages.getInstance().leftArrow, 120 - this.imageChoices[this.selectedImageIndex].getWidth() / 2 - 3, n + this.imageChoices[this.selectedImageIndex].getHeight() / 2, 10);
                }
                if (this.selectedImageIndex < this.imageChoices.length - 1) {
                    graphics.drawImage(CommonImages.getInstance().rightArrow, 120 + this.imageChoices[this.selectedImageIndex].getWidth() / 2 + 3, n + this.imageChoices[this.selectedImageIndex].getHeight() / 2, 6);
                }
            }
            n += this.imageChoices[this.selectedImageIndex].getHeight() + 3;
        }
        graphics.translate(0, n);
        graphics.translate(0, 4);
        for (int i = 0; i < this.menuItems.length; ++i) {
            if (this.selectedIndex == i) {
                graphics.setColor(Colors.YELLOW);
            } else {
                graphics.setColor(Colors.WHITE);
            }
            graphics.drawString(this.menuItems[i], 120, 0, 17);
            graphics.translate(0, this.skip);
        }
        graphics.drawImage(this.kbd, 0, 190, 0);
    }

    protected void keyPressed(int n) {
        int n2;
        System.out.println("vertical" + this.menuItems.length);
        if (n == 21 && this.selectedIndex >= 0) {
            this.stop();
            if (this.selectedIndex == this.returnItemIndex) {
                this.returnCanvas.start(this.display);
            } else {
                this.itemSelected();
            }
            return;
        }
        if (n == 22) {
            this.stop();
            this.returnCanvas.start(this.display);
            return;
        }
        try {
            n2 = this.getGameAction(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        switch (n2) {
            case 8: {
                if (this.selectedIndex < 0) break;
                this.stop();
                if (this.selectedIndex == this.returnItemIndex) {
                    this.returnCanvas.start(this.display);
                    break;
                }
                this.itemSelected();
                break;
            }
            case 1: {
                int n3 = 0;
                if (this.imageChoices != null) {
                    n3 = -1;
                }
                if (this.selectedIndex > n3) {
                    --this.selectedIndex;
                    break;
                }
                if (this.selectedIndex == 0 && n3 == 0) {
                    this.selectedIndex = this.menuItems.length - 1;
                    break;
                }
                if (this.selectedIndex == -1 && n3 == -1) {
                    this.selectedIndex = this.menuItems.length - 1;
                    break;
                }
                if (this.selectedIndex != 0 || n3 != -1) break;
                this.selectedIndex = -1;
                break;
            }
            case 6: {
                if (this.imageChoices != null) {
                    if (this.selectedIndex < this.menuItems.length - 1) {
                        ++this.selectedIndex;
                        break;
                    }
                    if (this.selectedIndex != this.menuItems.length - 1) break;
                    this.selectedIndex = -1;
                    break;
                }
                if (this.selectedIndex < this.menuItems.length - 1) {
                    ++this.selectedIndex;
                    break;
                }
                if (this.selectedIndex != this.menuItems.length - 1) break;
                this.selectedIndex = 0;
                break;
            }
            case 5: {
                if (this.imageChoices == null || this.selectedIndex != -1 || this.selectedImageIndex >= this.imageChoices.length - 1) break;
                ++this.selectedImageIndex;
                this.updateMenu();
                break;
            }
            case 2: {
                if (this.imageChoices == null || this.selectedIndex != -1 || this.selectedImageIndex <= 0) break;
                --this.selectedImageIndex;
                this.updateMenu();
            }
        }
    }

    protected void pointerPressed(int n, int n2) {
        this.xx = n;
        this.yy = n2;
        System.out.println("x" + n + "y" + n2 + "sel" + this.selectedIndex);
        int n3 = this.getPointerKey(n, n2);
        if (n3 > -100) {
            this.keyPressed(n3);
        }
        if (this.imageChoices == null) {
            if (this.menuItems.length == 2) {
                if (n > 85 && n < 155 && n2 > 70 && n2 < 93) {
                    this.selectedIndex = 0;
                }
                if (n > 85 && n < 155 && n2 > 93 && n2 < 116) {
                    this.selectedIndex = 1;
                }
            }
            if (this.menuItems.length == 3) {
                if (n > 85 && n < 155 && n2 > 60 && n2 < 82) {
                    this.selectedIndex = 0;
                }
                if (n > 85 && n < 155 && n2 > 82 && n2 < 104) {
                    this.selectedIndex = 1;
                }
                if (n > 85 && n < 155 && n2 > 104 && n2 < 126) {
                    this.selectedIndex = 2;
                }
            }
            if (this.menuItems.length == 4) {
                if (n > 85 && n < 155 && n2 > 50 && n2 < 72) {
                    this.selectedIndex = 0;
                }
                if (n > 85 && n < 155 && n2 > 72 && n2 < 94) {
                    this.selectedIndex = 1;
                    for (int i = 0; i <= 2000; ++i) {
                        if (i != 2000) continue;
                        this.keyPressed(21);
                    }
                }
                if (n > 85 && n < 155 && n2 > 94 && n2 < 116) {
                    this.selectedIndex = 2;
                }
                if (n > 85 && n < 155 && n2 > 116 && n2 < 144) {
                    this.selectedIndex = 3;
                }
            }
            if (this.menuItems.length == 5 && this.menuItems[0] != "\u7ee7\u7eed") {
                if (n > 85 && n < 155 && n2 > 30 && n2 < 60) {
                    this.selectedIndex = 0;
                }
                if (n > 85 && n < 155 && n2 > 60 && n2 < 82) {
                    this.selectedIndex = 1;
                }
                if (n > 85 && n < 155 && n2 > 82 && n2 < 110) {
                    this.selectedIndex = 2;
                }
                if (n > 85 && n < 155 && n2 > 110 && n2 < 132) {
                    this.selectedIndex = 3;
                }
                if (n > 85 && n < 155 && n2 > 132 && n2 < 155) {
                    this.selectedIndex = 4;
                }
            }
            if (this.menuItems.length == 5 && this.menuItems[0] == "\u7ee7\u7eed") {
                if (n > 85 && n < 155 && n2 > 50 && n2 < 72) {
                    this.selectedIndex = 0;
                }
                if (n > 85 && n < 155 && n2 > 72 && n2 < 94) {
                    this.selectedIndex = 1;
                }
                if (n > 85 && n < 155 && n2 > 94 && n2 < 116) {
                    this.selectedIndex = 2;
                }
                if (n > 85 && n < 155 && n2 > 116 && n2 < 138) {
                    this.selectedIndex = 3;
                }
                if (n > 85 && n < 155 && n2 > 138 && n2 < 160) {
                    this.selectedIndex = 4;
                }
            }
        }
        this.repaint();
        if (this.imageChoices != null) {
            if (this.menuItems.length == 4) {
                if (n > 85 && n < 155 && n2 > 15 && n2 < 70) {
                    this.selectedIndex = -1;
                }
                if (n > 85 && n < 155 && n2 > 70 && n2 < 90) {
                    this.selectedIndex = 0;
                }
                if (n > 85 && n < 155 && n2 > 90 && n2 < 112) {
                    this.selectedIndex = 1;
                }
                if (n > 85 && n < 155 && n2 > 112 && n2 < 134) {
                    this.selectedIndex = 2;
                }
                if (n > 85 && n < 155 && n2 > 134 && n2 < 170) {
                    this.selectedIndex = 3;
                }
            }
            if (this.menuItems.length == 5) {
                if (n > 85 && n < 155 && n2 > 24 && n2 < 67) {
                    this.selectedIndex = -1;
                }
                if (n > 85 && n < 155 && n2 > 67 && n2 < 90) {
                    this.selectedIndex = 0;
                }
                if (n > 85 && n < 155 && n2 > 90 && n2 < 111) {
                    this.selectedIndex = 1;
                }
                if (n > 85 && n < 155 && n2 > 111 && n2 < 133) {
                    this.selectedIndex = 2;
                }
                if (n > 85 && n < 155 && n2 > 133 && n2 < 156) {
                    this.selectedIndex = 3;
                }
                if (n > 85 && n < 155 && n2 > 156 && n2 < 183) {
                    this.selectedIndex = 4;
                }
            }
            if (this.menuItems.length == 1) {
                if (n > 82 && n < 102 && n2 > 65 && n2 < 98) {
                    this.selectedIndex = -1;
                }
                if (n > 90 && n < 150 && n2 > 100 && n2 < 120) {
                    this.selectedIndex = 0;
                }
                if (n > 82 && n < 102 && n2 > 65 && n2 < 98) {
                    if (this.imageChoices != null && this.selectedIndex == -1 && this.selectedImageIndex > 0) {
                        --this.selectedImageIndex;
                        this.updateMenu();
                    }
                } else if (n > 136 && n < 156 && n2 > 65 && n2 < 98 && this.imageChoices != null && this.selectedIndex == -1 && this.selectedImageIndex < this.imageChoices.length - 1) {
                    ++this.selectedImageIndex;
                    this.updateMenu();
                }
            }
        }
        this.repaint();
    }

    protected void pointerReleased(int n, int n2) {
        if (this.imageChoices == null) {
            if (this.menuItems.length == 2) {
                if (n > 85 && n < 155 && n2 > 70 && n2 < 93) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 93 && n2 < 116) {
                    this.keyPressed(21);
                }
            }
            if (this.menuItems.length == 3) {
                if (n > 85 && n < 155 && n2 > 60 && n2 < 82) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 82 && n2 < 104) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 104 && n2 < 126) {
                    this.keyPressed(21);
                }
            }
            if (this.menuItems.length == 4) {
                if (n > 85 && n < 155 && n2 > 50 && n2 < 72) {
                    this.keyPressed(21);
                }
                if (n <= 85 || n >= 155 || n2 <= 72 || n2 < 94) {
                    // empty if block
                }
                if (n > 85 && n < 155 && n2 > 94 && n2 < 116) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 116 && n2 < 144) {
                    this.keyPressed(21);
                }
            }
            if (this.menuItems.length == 5 && this.menuItems[0] != "\u7ee7\u7eed") {
                if (n > 85 && n < 155 && n2 > 30 && n2 < 60) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 60 && n2 < 82) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 82 && n2 < 110) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 104 && n2 < 132) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 126 && n2 < 155) {
                    this.keyPressed(21);
                }
            }
            if (this.menuItems.length == 5 && this.menuItems[0] == "\u7ee7\u7eed") {
                if (n > 85 && n < 155 && n2 > 50 && n2 < 72) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 72 && n2 < 94) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 94 && n2 < 116) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 116 && n2 < 138) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 138 && n2 < 160) {
                    this.keyPressed(21);
                }
            }
        }
        if (this.imageChoices != null) {
            if (this.menuItems.length == 4) {
                if (n > 85 && n < 155 && n2 > 15 && n2 < 70) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 70 && n2 < 90) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 90 && n2 < 112) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 112 && n2 < 134) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 134 && n2 < 170) {
                    this.keyPressed(21);
                }
                if (n > 82 && n < 102 && n2 > 32 && n2 < 65) {
                    if (this.imageChoices != null && this.selectedIndex == -1 && this.selectedImageIndex > 0) {
                        --this.selectedImageIndex;
                        this.updateMenu();
                    }
                    return;
                }
                if (n > 136 && n < 156 && n2 > 32 && n2 < 65) {
                    if (this.imageChoices != null && this.selectedIndex == -1 && this.selectedImageIndex < this.imageChoices.length - 1) {
                        ++this.selectedImageIndex;
                        this.updateMenu();
                    }
                    return;
                }
            }
            if (this.menuItems.length == 5) {
                if (n > 85 && n < 155 && n2 > 24 && n2 < 67) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 67 && n2 < 90) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 90 && n2 < 111) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 111 && n2 < 133) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 133 && n2 < 156) {
                    this.keyPressed(21);
                }
                if (n > 85 && n < 155 && n2 > 156 && n2 < 183) {
                    this.keyPressed(21);
                }
                if (n > 82 && n < 102 && n2 > 13 && n2 < 65) {
                    if (this.imageChoices != null && this.selectedIndex == -1 && this.selectedImageIndex > 0) {
                        --this.selectedImageIndex;
                        this.updateMenu();
                    }
                    return;
                }
                if (n > 136 && n < 156 && n2 > 13 && n2 < 65) {
                    if (this.imageChoices != null && this.selectedIndex == -1 && this.selectedImageIndex < this.imageChoices.length - 1) {
                        ++this.selectedImageIndex;
                        this.updateMenu();
                    }
                    return;
                }
            }
            if (this.menuItems.length == 1) {
                if (n > 82 && n < 102 && n2 > 65 && n2 < 98) {
                    this.keyPressed(21);
                } else if (n > 90 && n < 150 && n2 > 100 && n2 < 120) {
                    this.keyPressed(21);
                }
            }
        }
        this.repaint();
    }

    protected int getPointerKey(int n, int n2) {
        int n3 = 190;
        int n4 = -100;
        if (this.inRect(n, n2, 70, 215, 100, 25)) {
            n4 = -2;
        } else if (this.inRect(n, n2, 70, 190, 100, 25)) {
            n4 = -1;
        } else if (this.inRect(n, n2, 0, 190, 70, 50) || this.inRect(n, n2, 0, 170, 20, 20)) {
            n4 = -3;
        } else if (this.inRect(n, n2, 170, 190, 70, 50) || this.inRect(n, n2, 220, 170, 20, 20)) {
            n4 = -4;
        }
        return n4;
    }

    protected boolean inRect(int n, int n2, int n3, int n4, int n5, int n6) {
        return n > n3 && n < n3 + n5 && n2 > n4 && n2 < n4 + n6;
    }

    protected void updateMenu() {
    }

    public abstract void itemSelected();

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdRight) {
            System.out.println("cmdRight is actived");
            this.keyPressed(22);
        } else if (command == this.cmdStub) {
            this.keyPressed(21);
        }
    }
}

