/*
 * Decompiled with CFR 0.152.
 */
package com.ui;

import com.md.Horse;
import com.ui.Colors;
import com.ui.CommonImages;
import com.ui.GraphicsUtil;
import com.ui.ImageLoader;
import com.ui.RunningCanvas;
import com.ui.VerticalMenu;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ViewHorseMenu
extends RunningCanvas
implements CommandListener {
    public Command cmdRight;
    public Command cmdStub;
    VerticalMenu parentMenu;
    Horse[] horses;
    int selectedHorseIndex;
    protected int minimumSelectedIndex;
    int startY;
    boolean canScroll;
    Font font;
    private Image kbd;

    public ViewHorseMenu(VerticalMenu verticalMenu, Horse[] horseArray) {
        this.parentMenu = verticalMenu;
        this.horses = horseArray;
        this.startY = 0;
        this.canScroll = false;
        this.font = Font.getFont((int)64, (int)0, (int)8);
        ImageLoader.createImage("/kbd.png");
        this.kbd = (Image)ImageLoader.get("/kbd.png");
        this.cmdRight = new Command("\u8fd4\u56de", 2, 1);
        this.cmdStub = new Command(" ", 2, 1);
        this.addCommand(this.cmdRight);
        this.addCommand(this.cmdStub);
        this.setCommandListener(this);
    }

    protected void paint(Graphics graphics) {
        Horse horse = this.horses[this.selectedHorseIndex];
        Image image = CommonImages.getInstance().horseImages[horse.imageIndex];
        graphics.setColor(Colors.BLACK);
        graphics.fillRect(0, 0, 240, 190);
        graphics.setColor(Colors.WHITE);
        int n = 120;
        graphics.translate(0, -this.startY);
        graphics.drawString(horse.name, n, 0, 17);
        graphics.translate(0, this.font.getHeight() + 2);
        graphics.drawImage(image, n, 0, 17);
        if (this.selectedHorseIndex > this.minimumSelectedIndex) {
            graphics.drawImage(CommonImages.getInstance().leftArrow, n - image.getWidth() / 2 - 3, image.getHeight() / 2, 10);
        }
        if (this.selectedHorseIndex < this.horses.length - 1) {
            graphics.drawImage(CommonImages.getInstance().rightArrow, n + image.getWidth() / 2 + 3, image.getHeight() / 2, 6);
        }
        graphics.translate(0, image.getHeight() + 2);
        graphics.drawString("\u4ef7\u683c - $" + horse.price, 0, 0, 20);
        graphics.translate(0, this.font.getHeight() + 2);
        graphics.drawString("\u6700\u5927\u901f\u5ea6", 0, 0, 20);
        graphics.translate(0, this.font.getHeight() + 2);
        graphics.setColor(Colors.YELLOW);
        graphics.fillRect(0, 0, horse.topSpeedWhenRested * 240 / 40, 5);
        graphics.translate(0, 5);
        graphics.setColor(Colors.WHITE);
        graphics.drawString("\u52a0\u901f\u6027\u80fd", 0, 0, 20);
        graphics.translate(0, this.font.getHeight() + 2);
        graphics.setColor(Colors.YELLOW);
        if (horse != Horse.ALL_HORSES[0]) {
            graphics.fillRect(0, 0, 238, 5);
        }
        graphics.translate(0, 5);
        graphics.setColor(Colors.WHITE);
        graphics.drawString("\u8010\u529b", 0, 0, 20);
        graphics.translate(0, this.font.getHeight() + 2);
        graphics.setColor(Colors.YELLOW);
        graphics.fillRect(0, 0, horse.stamina * 240 / 100, 5);
        graphics.translate(0, 5);
        graphics.setColor(Colors.WHITE);
        graphics.drawString("\u8bad\u7ec3", 0, 0, 20);
        graphics.translate(0, this.font.getHeight() + 2);
        graphics.setColor(Colors.YELLOW);
        graphics.fillRect(0, 0, horse.stamina * 240 / 100, 5);
        graphics.translate(0, 5);
        GraphicsUtil.getInstance().resetTranslation(graphics);
        if (this.startY > 0) {
            graphics.drawImage(CommonImages.getInstance().upArrow, 240, 0, 24);
        }
        if (graphics.getTranslateX() > 190) {
            this.canScroll = true;
            graphics.drawImage(CommonImages.getInstance().downArrow, 240, 190, 40);
        }
        graphics.drawImage(this.kbd, 0, 190, 0);
    }

    protected void keyPressed(int n) {
        int n2;
        System.out.println("viewhorse");
        if (n == 22) {
            this.stop();
            this.parentMenu.start(this.display);
            return;
        }
        try {
            n2 = this.getGameAction(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        switch (n2) {
            case 8: {
                this.stop();
                this.parentMenu.start(this.display);
                break;
            }
            case 1: {
                if (this.startY <= 0) break;
                this.startY -= 5;
                break;
            }
            case 6: {
                if (!this.canScroll) break;
                this.startY += 5;
                break;
            }
            case 5: {
                if (this.selectedHorseIndex >= this.horses.length - 1) break;
                ++this.selectedHorseIndex;
                ++this.parentMenu.selectedImageIndex;
                break;
            }
            case 2: {
                if (this.selectedHorseIndex <= this.minimumSelectedIndex) break;
                --this.selectedHorseIndex;
                --this.parentMenu.selectedImageIndex;
            }
        }
    }

    protected void pointerPressed(int n, int n2) {
        System.out.println("x" + n + "y" + n2);
        int n3 = this.getPointerKey(n, n2);
        if (n3 > -100) {
            this.keyPressed(n3);
        }
        if (n > 82 && n < 102 && n2 > 13 && n2 < 46) {
            if (this.selectedHorseIndex > this.minimumSelectedIndex) {
                --this.selectedHorseIndex;
                --this.parentMenu.selectedImageIndex;
            }
        } else if (n > 136 && n < 156 && n2 > 13 && n2 < 46 && this.selectedHorseIndex < this.horses.length - 1) {
            ++this.selectedHorseIndex;
            ++this.parentMenu.selectedImageIndex;
        }
    }

    protected int getPointerKey(int n, int n2) {
        int n3 = 190;
        int n4 = -100;
        if (this.inRect(n, n2, 70, 215, 100, 25)) {
            n4 = -2;
        } else if (this.inRect(n, n2, 70, 190, 100, 25)) {
            n4 = -1;
        } else if (this.inRect(n, n2, 0, 190, 70, 50) || this.inRect(n, n2, 0, 170, 20, 20)) {
            n4 = -3;
        } else if (this.inRect(n, n2, 170, 190, 70, 50) || this.inRect(n, n2, 220, 170, 20, 20)) {
            n4 = -4;
        }
        return n4;
    }

    protected boolean inRect(int n, int n2, int n3, int n4, int n5, int n6) {
        return n > n3 && n < n3 + n5 && n2 > n4 && n2 < n4 + n6;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdRight) {
            this.keyPressed(22);
        } else if (command == this.cmdStub) {
            // empty if block
        }
    }
}

