<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE xsl:stylesheet [ 
    <!ENTITY nbsp "&#160;">   <!-- white space in XSL -->
    <!ENTITY raquo "&#187;">   <!-- >> -->
    <!ENTITY laquo "&#171;">   <!-- << -->
    ]> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration="yes" indent="yes"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" />
    
<xsl:param name="ImagePageStartItem" select="'default'"/>

<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<xsl:if test="/Doc/TitleBarText[string(.)]">
	<title><xsl:value-of select="Doc/TitleBarText"/></title>
</xsl:if>
<link href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}css/stylesheet.css" rel="stylesheet" type="text/css" />
<script language="JavaScript1.1">
		var playing = 0
		var timeoutID = 0
		var slideShowNextLink = "<xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix"/><xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/NextSlideshowImagePagePath"/>"
		var slideShowDelay = <xsl:value-of select="/Doc/SlideshowDelay"/>

		// Browser detection	
		var agt = navigator.userAgent.toLowerCase();
		var is_ie = (agt.indexOf("msie") != -1);

		if (location.href.indexOf("?") != -1) {
			urlQuery = location.href.split("?")
			playing = parseInt(urlQuery[1])
		}
		
		if (playing == 1) {
			startSlideShow()
		}
	
		function slideShow() {
			window.location.href = slideShowNextLink + "?" + "1"
			timeoutID = setInterval("slideShow()", slideShowDelay);
		}

		function startSlideShow() {
			clearTimeout(timeoutID)
			timeoutID = setInterval("slideShow()", slideShowDelay);
		}

		function stopSlideShow() {
			clearTimeout(timeoutID)
			if (is_ie) {
				fakeTimeoutID = setInterval("redirectDelay()", 0);
			}
			else {
				redirectDelay();
			}
		}
		
		function redirectDelay() {
			tempArray = window.location.href.split("?")
			window.location.href = tempArray[0]
		}
</script>
</head>
<body>

<div class="imagenav">
	<div class="left"><strong><xsl:value-of select="/Doc/Translations/Slideshow"/>:&nbsp;</strong><a href="javascript:void(0)" name="slideShowControl" onclick="startSlideShow()"><xsl:value-of select="/Doc/Translations/Start"/></a>&nbsp;|&nbsp;<a href="javascript:void(0)" name="slideShowControl" onclick="stopSlideShow()"><xsl:value-of select="/Doc/Translations/Stop"/></a></div>
	<div class="right">
		<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/PreviousImagePagePath[string(.)]">
			<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/PreviousImagePagePath}" target="fullframe">&laquo;</a>&nbsp;&nbsp;|&nbsp;&nbsp;
		</xsl:if>
		<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/PreviousImagePagePath[.='']">
			&laquo;&nbsp;&nbsp;|&nbsp;&nbsp;
		</xsl:if>
		<a href="../../{/Doc/ImagePages/Page[1]/ImagePagePath}"><xsl:value-of select="/Doc/Translations/Home"/></a>&nbsp;&nbsp;|&nbsp;&nbsp;
		<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/NextImagePagePath[string(.)]">
		<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/NextImagePagePath}" target="fullframe">&raquo;</a>
		</xsl:if>
		<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/NextImagePagePath[.='']">
			&raquo;
		</xsl:if>
	</div>
	<div class="clearer">&nbsp;</div>
</div>

<div id="mainimage">
	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/FullSizeImagePath[string(.)]">
  		<a href="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/FullSizeImagePath}" target="_top"><img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePath}" width="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageWidth}" height="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageHeight}"/></a>
  </xsl:if>
  <xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/FullSizeImagePath[.='']">
  		<img src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePath}" width="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageWidth}" height="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImageHeight}"/>
  </xsl:if>
	
	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags[node()]">
  <div class="metabox">
		<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value[string(.)]">
			<strong><div class="imagemetatitle1"><xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value"/></div></strong>
		</xsl:if>
		<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value[string(.)]">
			<div class="imagemetatitle2"><xsl:value-of select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value"/></div>
	  </xsl:if>
	  <xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating">
		  <xsl:choose>
			  <xsl:when test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value[string(.)] or /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value[string(.)]">
			  <div class="imagemetatitle3">
			  	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 0">
	      		<img class="foo" src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_zero.gif"/>
	      	</xsl:if>
	      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 1">
	      		<img class="foo" src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_one.gif"/>
	      	</xsl:if>
	      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 2">
	      		<img class="foo" src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_two.gif"/>
	      	</xsl:if>
	      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 3">
	      		<img class="foo" src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_three.gif"/>
	      	</xsl:if>
	      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 4">
	      		<img class="foo" src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_four.gif"/>
	      	</xsl:if>
	      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 5">
	      		<img class="foo" src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_five.gif"/>
	      	</xsl:if>
		  	</div>
		  	</xsl:when>
		  	<xsl:otherwise>
			  <div class="imagemetatitle4">
			  	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 0">
	      		<img class="foo" src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_zero.gif"/>
	      	</xsl:if>
	      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 1">
	      		<img class="foo" src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_one.gif"/>
	      	</xsl:if>
	      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 2">
	      		<img class="foo" src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_two.gif"/>
	      	</xsl:if>
	      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 3">
	      		<img class="foo" src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_three.gif"/>
	      	</xsl:if>
	      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 4">
	      		<img class="foo" src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_four.gif"/>
	      	</xsl:if>
	      	<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating/Value = 5">
	      		<img class="foo" src="{/Doc/ImagePages/Page[$ImagePageStartItem]/ImagePagePathPrefix}resources/graf_star_five.gif"/>
	      	</xsl:if>
		  	</div>
		  	</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/FileName/Value[string(.)] or /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Date/Value[string(.)] or /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Rating">
		<br/><br/>
		</xsl:if>
	  <xsl:if test="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Tag and /Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Tag/Value[string(.)]">
	  <table>
			<xsl:for-each select="/Doc/ImagePages/Page[$ImagePageStartItem]/ImageTags/Tag">
				<xsl:if test="Value[string(.)]">
					<tr><td width="60%"><strong><xsl:value-of select="Name"/></strong></td><td><xsl:value-of select="Value"/></td></tr>
				</xsl:if>
			</xsl:for-each>
		</table>
		</xsl:if>
	</div>
  </xsl:if>
</div>
</body>
</html>

</xsl:template>
</xsl:stylesheet>