<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="iso-8859-1"/>
<xsl:template match="/">

/* CSS
--------------------------------------------------*/
body {
	color: #000000;
	font-family: Verdana, Helvetica, sans-serif;
	font-size: 10pt;
	margin: 0;
	padding: 0;
	background: #<xsl:value-of select="Doc/Colors/BackgroundColor/ColorValue"/>;
}

body,h1,h2,h3,h4,h5,h6,p,form,fieldset {
	margin: 0;
	padding: 0;
}

/* Links
--------------------------------------------------*/
a {
	text-decoration: underline;
	color: #000000;
}

a:hover {
	text-decoration: none;
	color: #000000;
}

a img {
	border: none;
}

/* IDs
--------------------------------------------------*/
#wrapper {
	background: transparent;
	width: 760px;
	padding: 0;
	margin: 10px;
}

#content {
	background: #<xsl:value-of select="Doc/Colors/InnerPageColor/ColorValue"/>;
}

#logohead {
	background: #<xsl:value-of select="Doc/Colors/HeaderLogoColor/ColorValue"/>;
	padding: 5px 5px 13px 5px;
}

#logofoot {
	background: #<xsl:value-of select="Doc/Colors/FooterLogoColor/ColorValue"/>;
	padding: 5px 5px 13px 5px;
}

#pagehead {
	background: #<xsl:value-of select="Doc/Colors/HeaderColor/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
	padding: 5px;
	font-size: <xsl:value-of select="Doc/Fonts/HeaderFont/Size"/>pt;
	margin-bottom: 10px;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/HeaderFont/Family"/>&quot;, Helvetica, sans-serif;
}

#pagehead a {
	color: #<xsl:value-of select="Doc/Fonts/HeaderFont/ColorValue"/>;
	text-decoration: none;
}

#pagehead a:hover {
	text-decoration: underline;
}

#pagehead p {
	line-height: 13pt;
}

#subhead {
	margin: 0 0 10px 0;
}

#pageband {
	background: transparent url(../resources/graf_bg_shade.jpg) repeat-x top;
	color: #000000;
	position: absolute;
	left: 0;
	width: 100%;
	height: 60px;
}

#pagefoot {
	background: #<xsl:value-of select="Doc/Colors/FooterColor/ColorValue"/>;
	color: #<xsl:value-of select="Doc/Fonts/FooterFont/ColorValue"/>;
	padding: 5px;
	font-size: <xsl:value-of select="Doc/Fonts/FooterFont/Size"/>pt;
	margin: 10px 0 10px 0;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/FooterFont/Family"/>&quot;, Helvetica, sans-serif;
}

#pagefoot a {
	color: #<xsl:value-of select="Doc/Fonts/FooterFont/ColorValue"/>;
	text-decoration: none;
}

#pagefoot a:hover {
	text-decoration: underline;
}

#mainimage {
	margin: 0;
	padding: 0;
	text-align: center;
}

#mainimage img {
	margin-bottom: 10px;
}

#altmainimage {
	padding: 10px 0 10px 0;
	margin: 0 0 10px 0;
	width: 740px;
	overflow: auto;
	text-align: center;
}

/* Classes
--------------------------------------------------*/
.low {
	display: none;
}

.smalltext {
	font-size: 8pt;
}

.clearer {
	clear: both;
	line-height: 0;
}

.left {
	float: left;
	clear: right;
}

.right {
	float: right;
}

.center {
	text-align: center;
}

.metatitle {
	margin-bottom: 10px;
}

.metatitle1 {
	font-size: 11pt;
	font-weight: bold;
	margin: 0;
	padding: 0;
	font-family: Arial, Helvetica, sans-serif;
	float: left;
}

.metatitle2 {
	margin-left: 10px;
	margin-top: 0.5em;
	float: left;
}

.metabox {
	background: #ffffff;
	padding: 5px;
	border: 1px solid #999999;
	text-align: left;
	font-size: 7pt;
	line-height: 12pt;
	width: 760px;
	margin: 0 auto;
}

.metaitem {
	margin-bottom: 4px;
}

.thumbcontainer {
	padding: 5px;
	background: #ffffff;
	height: auto;
}

.thumbmeta {
	margin-top: 5px;
	text-align: left;
	font-size: 7pt;
	line-height: 12pt;
}

.paginate {
	font-size: 8pt;
	padding-top: 10px;
	padding-bottom: 10px;
	margin: 0px;
	text-align: center;
}

.imagenav {
	width: 500px;
	padding: 5px;
	margin: 0 auto;
	font-size: 8pt;
}

.framediv {
	background: transparent;
}

#framedivleft {
	background: transparent;
	width: 150px;
	float: left;
	margin: 10px 5px;
	text-align: center;
	overflow: hidden;
}

/* IE FIX */
#framedivright {
	background: transparent;
	width: 570px;
	float: right;
	margin: 10px;
}

html>body #framedivright {
	width: 580px;
	margin: 10px 10px 10px 0;
}

/* Headings
--------------------------------------------------*/
h1 {
	font-size: 18pt;
	font-weight: bolder;
	margin: 10px 0 10px 0;
	padding: 5px 0 5px 0;
	font-family: Arial, Helvetica, sans-serif;
	text-align: center;
}

#subhead h1 {
	margin: 10px 0 0 0;
}

/* Images
--------------------------------------------------*/
/* Tables
--------------------------------------------------*/
caption {
	display: none;
}

td.thumbtable {
	padding: 5px;
}

</xsl:template>
</xsl:stylesheet>