<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="iso-8859-1"/>
<xsl:template match="/">

/* CSS
--------------------------------------------------*/
body {
	color: #000000;
	font-family: Verdana, Helvetica, sans-serif;
	font-size: 10pt;
	margin: 0;
	padding: 0;
	background: #<xsl:value-of select="Doc/Colors/InnerPageColor/ColorValue"/>;
}

body,h1,h2,h3,h4,h5,h6,p,form,fieldset {
	margin: 0;
	padding: 0;
}

/* Links
--------------------------------------------------*/
a {
	text-decoration: underline;
	color: #000000;
}

a:hover {
	text-decoration: none;
	color: #000000;
}

a img {
	border: none;
}

/* IDs
--------------------------------------------------*/
#mainimage {
	margin: 0;
	padding: 0;
	text-align: center;
}

#mainimage img {
	margin-bottom: 10px;
}

#altmainimage {
	padding: 10px 0 10px 0;
	margin: 0 0 10px 0;
	width: 740px;
	overflow: auto;
	text-align: center;
}

/* Classes
--------------------------------------------------*/
.low {
	display: none;
}

.smalltext {
	font-size: 8pt;
}

.clearer {
	clear: both;
	line-height: 0;
}

.left {
	float: left;
	clear: right;
}

.right {
	float: right;
}

.center {
	text-align: center;
}

.metatitle {
	margin-bottom: 10px;
}

.metatitle1 {
	font-size: 11pt;
	font-weight: bold;
	margin: 0;
	padding: 0;
	font-family: Arial, Helvetica, sans-serif;
	float: left;
}

.metatitle1 a {
	text-decoration: none;
}

.metatitle1 a:hover {
	color: #7ba9c4;
}

.metatitle2 {
	font-size: 70%;
	font-style: italic;
	margin-left: 10px;
	margin-top: 0.5em;
	float: left;
}

.metatitle3 {
	float: right;
}

.metabox {
	background: #fff;
	padding: 5px;
	border: 1px solid #999999;
	text-align: left;
	font-size: 7pt;
	line-height: 12pt;
	width: 760px;
	margin: 0 auto;
}

.metaitem {
	margin-bottom: 4px;
}

.thumbcontainer {
	padding: 5px;
	background: #<xsl:value-of select="Doc/Colors/ThumbnailColor/ColorValue"/>;
	height: auto;
	text-align: left;
	display: table-cell;
}

.thumbmeta {
	color: #<xsl:value-of select="Doc/Fonts/ThumbnailFont/ColorValue"/>;
	margin-top: 5px;
	text-align: left;
	font-family: &quot;<xsl:value-of select="Doc/Fonts/ThumbnailFont/Family"/>&quot;, Helvetica, sans-serif;
	font-size: <xsl:value-of select="Doc/Fonts/ThumbnailFont/Size"/>pt;
	line-height: 12pt;
	display: table-cell;
}

.paginate {
	font-size: 8pt;
	padding-top: 10px;
	padding-bottom: 10px;
	margin: 0px;
	text-align: center;
}

.paginate a {
	padding: 2px 6px;
	border: solid 1px #dddddd;
	background: #ffffff;
	text-decoration: none;
}

.paginate a:visited {
	padding: 2px 6px;
	border: solid 1px #dddddd;
	background: #ffffff;
	text-decoration: none;
}

.paginate .this-page {
	padding: 2px 6px;
	border-color: #999999;
	font-weight: bold;
	font-size: 13px;
	vertical-align: top;
	background: #ffffff;
}

.paginate a:hover {
	color: #ffffff;
	background: #7ba9c4;
	border-color: #003366;
	text-decoration: none;
}

.paginate .ranking {
	display: block;
	margin-top: 0.5em;
	font-weight: bold;
}

.paginate .ranking a {
	padding: 0;
	border: 0;
	background: transparent;
}

.paginate .ranking a:hover {
	text-decoration: underline;
	color: #ff6600;
	background: transparent;
}

.imagenav {
	width: 760px;
	padding: 5px;
	margin: 0 auto;
	font-size: 8pt;
}



/* Headings
--------------------------------------------------*/
h1 {
	font-size: 18pt;
	font-weight: bolder;
	margin: 10px 0 10px 0;
	padding: 5px 0 5px 0;
	font-family: Arial, Helvetica, sans-serif;
	text-align: center;
}

#subhead h1 {
	margin: 10px 0 0 0;
}

/* Images
--------------------------------------------------*/
/* Tables
--------------------------------------------------*/
caption {
	display: none;
}

td.thumbtable {
	padding: 5px;
}

</xsl:template>
</xsl:stylesheet>