<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE xsl:stylesheet [ 
    <!ENTITY nbsp "&#160;">   <!-- white space in XSL -->
    <!ENTITY raquo "&#187;">   <!-- >> -->
    ]> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration="yes" indent="yes"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" />

<xsl:param name="ThumbnailPageStartItem" select="'default'"/>

<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<xsl:if test="/Doc/TitleBarText[string(.)]">
	<title><xsl:value-of select="Doc/TitleBarText"/></title>
</xsl:if>
<link href="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}css/stylesheet.css" rel="stylesheet" type="text/css" />
</head>
<body>
<table width="100%"  border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td align="center" valign="middle"><table width="760" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td align="center" valign="middle"><div id="wrapper">
              
              <xsl:if test="/Doc/IncludeHeader = 1">
              <xsl:if test="/Doc/Header/UseImage = 1">
              <div id="logohead" class="left">
                <div class="infor">
                  <div class="xsnazzy"><b class="xtop"><b class="xb1"><xsl:text>&#09;</xsl:text></b><b class="xb2"><xsl:text>&#09;</xsl:text></b><b class="xb3"><xsl:text>&#09;</xsl:text></b><b class="xb4"><xsl:text>&#09;</xsl:text></b></b>
                    <div class="xboxcontent">
		                	<p><img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{/Doc/Header/ImagePath}"/></p>
		                </div>
		              	<b class="xbottom"><b class="xb4"><xsl:text>&#09;</xsl:text></b><b class="xb3"><xsl:text>&#09;</xsl:text></b><b class="xb2"><xsl:text>&#09;</xsl:text></b><b class="xb1"><xsl:text>&#09;</xsl:text></b></b> 
                  </div>
                </div>
              </div>
              </xsl:if>
              
              <xsl:if test="/Doc/Header/UseInfo = 1">
              <div id="pagehead" class="right">
								<div class="infor">
							  	<div class="xsnazzy"><b class="xtop"><b class="xb1"><xsl:text>&#09;</xsl:text></b><b class="xb2"><xsl:text>&#09;</xsl:text></b><b class="xb3"><xsl:text>&#09;</xsl:text></b><b class="xb4"><xsl:text>&#09;</xsl:text></b></b>
							    	<div class="xboxcontent">
							  			<xsl:if test="/Doc/Header/Text[string(.)]">
								      		<p><strong><xsl:value-of select="Doc/Header/Text"/></strong></p>
								      	</xsl:if>
								       	<xsl:if test="/Doc/Header/Author[string(.)]">
									    		<p><xsl:value-of select="Doc/Header/Author"/></p>
									    	</xsl:if>
									    	<xsl:if test="/Doc/Header/Date[string(.)]">
									    		<p><xsl:value-of select="Doc/Header/Date"/></p>
									    	</xsl:if>
												<xsl:if test="/Doc/Header/Email[string(.)]">
									    		<p><a href="mailto:{/Doc/Header/Email}"><xsl:value-of select="Doc/Header/Email"/></a></p>
									    	</xsl:if>
							      </div>
							      <b class="xbottom"><b class="xb4"><xsl:text>&#09;</xsl:text></b><b class="xb3"><xsl:text>&#09;</xsl:text></b><b class="xb2"><xsl:text>&#09;</xsl:text></b><b class="xb1"><xsl:text>&#09;</xsl:text></b></b> 
									</div>
								</div>
							</div>
							</xsl:if>
							</xsl:if>
              
              <div class="clearer">&nbsp;</div>
              
              <div class="infor">
                <div class="xsnazzy"><b class="xtop"><b class="xb1"><xsl:text>&#09;</xsl:text></b><b class="xb2"><xsl:text>&#09;</xsl:text></b><b class="xb3"><xsl:text>&#09;</xsl:text></b><b class="xb4"><xsl:text>&#09;</xsl:text></b></b>
                  <div class="xboxcontent">
                    <xsl:if test="/Doc/TitleBarText[string(.)]">
											<h1><xsl:value-of select="Doc/TitleBarText"/></h1>
										</xsl:if>
										
                    <table width="100%"  border="0" cellpadding="0" cellspacing="0">
                      <xsl:for-each select="Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/Row">
                      <tr align="center" valign="top">
                      	<xsl:for-each select="Column">
                        <td>
                        	<table border="0" cellspacing="0" cellpadding="0">
                            <tr>
                              <td align="center" valign="middle">
                              	<div class="thumbcontainer left">
                              		<a href="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{ImagePagePath}"><img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{ThumbnailPath}" border="0" width="{ThumbnailWidth}" height="{ThumbnailHeight}"/></a>
                                  <xsl:if test="ThumbnailTags[node()]">
														  			<div class="metabox">
															  		  <xsl:if test="ThumbnailTags/FileName/Value[string(.)]">
															  		  	<strong><xsl:value-of select="ThumbnailTags/FileName/Value"/></strong><br/>
															  		  </xsl:if>
															  		  <xsl:if test="ThumbnailTags/Date/Value[string(.)]">
															  		  	<xsl:value-of select="ThumbnailTags/Date/Value"/><br/>
																			</xsl:if>
																			<xsl:if test="ThumbnailTags/Rating">
															  		  	<xsl:if test="ThumbnailTags/Rating/Value = 0">
															        		<img class="foo" src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_zero.gif"/>
															        	</xsl:if>
															        	<xsl:if test="ThumbnailTags/Rating/Value = 1">
															        		<img class="foo" src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_one.gif"/>
															        	</xsl:if>
															        	<xsl:if test="ThumbnailTags/Rating/Value = 2">
															        		<img class="foo" src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_two.gif"/>
															        	</xsl:if>
															        	<xsl:if test="ThumbnailTags/Rating/Value = 3">
															        		<img class="foo" src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_three.gif"/>
															        	</xsl:if>
															        	<xsl:if test="ThumbnailTags/Rating/Value = 4">
															        		<img class="foo" src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_four.gif"/>
															        	</xsl:if>
															        	<xsl:if test="ThumbnailTags/Rating/Value = 5">
															        		<img class="foo" src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_five.gif"/>
															        	</xsl:if>
															  		  	<br/>
															  		  </xsl:if>
															  		  <xsl:if test="ThumbnailTags/Tag and ThumbnailTags/Tag/Value[string(.)]">
															  		  <xsl:for-each select="ThumbnailTags/Tag">
															  		  	<xsl:if test="Value[string(.)]">
														        			<em><xsl:value-of select="Name"/>&nbsp; : &nbsp;</em><xsl:value-of select="Value"/><br/>
														        		</xsl:if>
														        	</xsl:for-each>
														        	</xsl:if>
																		</div>
																	</xsl:if>
                                </div>
                            	</td>
                            </tr>
                          </table>
                        </td>
                        </xsl:for-each>
                      </tr>	
                      </xsl:for-each>
                      
                      <tr align="center" valign="top">
                        <td colspan="4">
                        	<div class="paginate"><xsl:value-of select="/Doc/Translations/Pages"/>:&nbsp;&nbsp;&nbsp;&nbsp;
                        	<xsl:for-each select="Doc/ThumbnailPages/Page">
												  	<xsl:if test="CurrentThumbnailPageNumber = $ThumbnailPageStartItem">
												  		<span class="this-page"><xsl:value-of select="CurrentThumbnailPageNumber"/></span>
												  	</xsl:if>
												  	<xsl:if test="CurrentThumbnailPageNumber != $ThumbnailPageStartItem">
												  		<a href="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{ThumbnailPagePath}"><xsl:value-of select="CurrentThumbnailPageNumber"/></a>
												  	</xsl:if>
												  </xsl:for-each>
												  </div>
                        </td>
                      </tr>
                      
                    </table>
                  </div>
                  <b class="xbottom"><b class="xb4"><xsl:text>&#09;</xsl:text></b><b class="xb3"><xsl:text>&#09;</xsl:text></b><b class="xb2"><xsl:text>&#09;</xsl:text></b><b class="xb1"><xsl:text>&#09;</xsl:text></b></b> 
              	</div>
              </div>
              
              <xsl:if test="/Doc/IncludeFooter = 1">
              <xsl:if test="/Doc/Footer/UseInfo = 1">
              <div id="pagefoot">
						    <div class="infor">
						      <div class="xsnazzy"><b class="xtop"><b class="xb1"><xsl:text>&#09;</xsl:text></b><b class="xb2"><xsl:text>&#09;</xsl:text></b><b class="xb3"><xsl:text>&#09;</xsl:text></b><b class="xb4"><xsl:text>&#09;</xsl:text></b></b>
						        <div class="xboxcontent">
						          <table width="100%"  border="0" cellspacing="0" cellpadding="0">
						            <tr>
						              <td>
						              	<xsl:if test="/Doc/Footer/Text[string(.)] or /Doc/Footer/Author[string(.)] or /Doc/Footer/Date[string(.)]">
						              		<p>
						              			<xsl:if test="/Doc/Footer/Text[string(.)]">
						              				<strong><xsl:value-of select="/Doc/Footer/Text"/></strong>
						              				<xsl:if test="/Doc/Footer/Author[string(.)] or /Doc/Footer/Date[string(.)]">
						              				&nbsp;&raquo;&nbsp;
						              				</xsl:if>
						              			</xsl:if>
						              			<xsl:if test="/Doc/Footer/Author[string(.)]">
						              				<xsl:value-of select="/Doc/Footer/Author"/>
						              				<xsl:if test="/Doc/Footer/Date[string(.)]">
						              				&nbsp;&raquo;&nbsp;
						              				</xsl:if>
						              			</xsl:if>
						              			<xsl:if test="/Doc/Footer/Date[string(.)]">
						              				<xsl:value-of select="/Doc/Footer/Date"/>
						              			</xsl:if>
						              		</p>
						              	</xsl:if>
						              </td>
						              <td align="right"><xsl:if test="/Doc/Footer/Email[string(.)]"><p><a href="mailto:{/Doc/Footer/Email}"><xsl:value-of select="/Doc/Footer/Email"/></a></p></xsl:if></td>
						            </tr>
						          </table>
						          <div class="clearer">&nbsp;</div>
						        </div>
						      	<b class="xbottom"><b class="xb4"><xsl:text>&#09;</xsl:text></b><b class="xb3"><xsl:text>&#09;</xsl:text></b><b class="xb2"><xsl:text>&#09;</xsl:text></b><b class="xb1"><xsl:text>&#09;</xsl:text></b></b> 
						    	</div>
						    </div>
						  </div>
						  </xsl:if>
						  
							<xsl:if test="/Doc/Footer/UseImage = 1">
						  	<div id="logofooter" class="center"><img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{/Doc/Footer/ImagePath}"/></div>
						  </xsl:if>
						  </xsl:if>
              
          	</div>
          </td>
        </tr>
      </table></td>
  </tr>
</table>
</body>
</html>

</xsl:template>
</xsl:stylesheet>