<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE xsl:stylesheet [ 
    <!ENTITY nbsp "&#160;">   <!-- white space in XSL -->
    <!ENTITY raquo "&#187;">   <!-- >> -->
    ]> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration="yes" indent="yes"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" />

<xsl:param name="ThumbnailPageStartItem" select="'default'"/>

<xsl:template match="/">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<xsl:if test="/Doc/TitleBarText[string(.)]">
		<title><xsl:value-of select="Doc/TitleBarText"/></title>
	</xsl:if>
	<link href="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}css/stylesheet.css" rel="stylesheet" type="text/css" />
</head>
<body>
<div id="wrapper">
	<xsl:if test="/Doc/IncludeHeader = 1">
  <xsl:if test="/Doc/Header/UseImage = 1">
  	<div id="logohead"><img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{/Doc/Header/ImagePath}"/></div>
  </xsl:if>
  
  <xsl:if test="/Doc/Header/UseInfo = 1">
  	<div id="pagehead">
  		<xsl:if test="/Doc/Header/Text[string(.)] or /Doc/Header/Author[string(.)] or /Doc/Header/Date[string(.)]">
    		<div class="left">
    			<xsl:if test="/Doc/Header/Text[string(.)]">
    				<xsl:value-of select="Doc/Header/Text"/>
    				<xsl:if test="/Doc/Header/Author[string(.)] or /Doc/Header/Date[string(.)]">
    				&nbsp;&raquo;&nbsp;
    				</xsl:if>
    			</xsl:if>
    			<xsl:if test="/Doc/Header/Author[string(.)]">
    				<xsl:value-of select="Doc/Header/Author"/>
    				<xsl:if test="/Doc/Header/Date[string(.)]">
    					&nbsp;&raquo;&nbsp;
    				</xsl:if>
    			</xsl:if>
    			<xsl:if test="/Doc/Header/Date[string(.)]">
    				<xsl:value-of select="Doc/Header/Date"/>
    			</xsl:if>
    		</div>
    	</xsl:if>
    	<xsl:if test="/Doc/Header/Email[string(.)]">
    		<div class="right"><a href="mailto:{/Doc/Header/Email}"><xsl:value-of select="Doc/Header/Email"/></a></div>
    	</xsl:if>
    	<div class="clearer">&nbsp;</div>
  	</div>
  </xsl:if>
  </xsl:if>
  
  <xsl:if test="/Doc/TitleBarText[string(.)]">
  <div id="title">
  	<h1><xsl:value-of select="Doc/TitleBarText"/></h1>
  </div>
  </xsl:if>
  
  <xsl:for-each select="Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/Row">
	  <table width="100%">
	    <caption>
	    Thumbnail Image Table
	    </caption>
	    
	    <tr valign="top">
	      <td width="24%" class="thumbtable">
	      	<a href="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{ImagePagePath}"><img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{ThumbnailPath}" class="thumbnail" border="0" width="{ThumbnailWidth}" height="{ThumbnailHeight}"/></a>
	      </td>
	      <td class="thumbtable" width="76%">
	      	<div class="metatitle">
	      		<xsl:if test="ThumbnailTags/FileName/Value[string(.)]">
		      		<h2 class="thumbmetatitle1"><a href="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{ImagePagePath}"><xsl:value-of select="ThumbnailTags/FileName/Value"/></a></h2>
		      	</xsl:if>
	        	<xsl:if test="ThumbnailTags/Date/Value[string(.)]">
		        	<span class="thumbmetatitle2"><xsl:value-of select="ThumbnailTags/Date/Value"/></span>
		        </xsl:if>
	        	<xsl:if test="ThumbnailTags/Rating">
			        <xsl:choose>
			        	<xsl:when test="ThumbnailTags/FileName/Value[string(.)] or ThumbnailTags/Date/Value[string(.)]">
				        	<span class="metatitle3">
				        	<xsl:if test="ThumbnailTags/Rating/Value = 0">
				        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_zero.gif"/>
				        	</xsl:if>
				        	<xsl:if test="ThumbnailTags/Rating/Value = 1">
				        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_one.gif"/>
				        	</xsl:if>
				        	<xsl:if test="ThumbnailTags/Rating/Value = 2">
				        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_two.gif"/>
				        	</xsl:if>
				        	<xsl:if test="ThumbnailTags/Rating/Value = 3">
				        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_three.gif"/>
				        	</xsl:if>
				        	<xsl:if test="ThumbnailTags/Rating/Value = 4">
				        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_four.gif"/>
				        	</xsl:if>
				        	<xsl:if test="ThumbnailTags/Rating/Value = 5">
				        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_five.gif"/>
				        	</xsl:if>
				          </span>
				      	</xsl:when>
				      	<xsl:otherwise>
				      		<span class="metatitle4">
				        	<xsl:if test="ThumbnailTags/Rating/Value = 0">
				        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_zero.gif"/>
				        	</xsl:if>
				        	<xsl:if test="ThumbnailTags/Rating/Value = 1">
				        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_one.gif"/>
				        	</xsl:if>
				        	<xsl:if test="ThumbnailTags/Rating/Value = 2">
				        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_two.gif"/>
				        	</xsl:if>
				        	<xsl:if test="ThumbnailTags/Rating/Value = 3">
				        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_three.gif"/>
				        	</xsl:if>
				        	<xsl:if test="ThumbnailTags/Rating/Value = 4">
				        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_four.gif"/>
				        	</xsl:if>
				        	<xsl:if test="ThumbnailTags/Rating/Value = 5">
				        		<img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}resources/graf_star_five.gif"/>
				        	</xsl:if>
				          </span>
				      	</xsl:otherwise>
				      </xsl:choose>
			        </xsl:if>
	        	<div class="clearer">&nbsp;</div>
	        </div>
	        <xsl:if test="ThumbnailTags/Tag">
			      <div class="metabox">
			      <table cellspacing="0">
			      	<xsl:for-each select="ThumbnailTags/Tag">
			      		<xsl:if test="Odd = 1">
			      			<tr><td width="30%"><div class="thumbmetaitem_alt"><strong><xsl:value-of select="Name"/></strong></div></td><td><div class="thumbmetaitem_alt"><xsl:value-of select="Value"/></div></td></tr>
			      		</xsl:if>
			      		<xsl:if test="Odd = 0">
			      			<tr><td width="30%"><div class="thumbmetaitem"><strong><xsl:value-of select="Name"/></strong></div></td><td><div class="thumbmetaitem"><xsl:value-of select="Value"/></div></td></tr>
			      		</xsl:if>
			      	</xsl:for-each>
			      </table>
						</div>
					</xsl:if>
		  	</td>
	    </tr>
	  </table>
	  
	  <div class="seppad">
	    <hr class="low" />
	  </div>
	</xsl:for-each>
  
  <div class="paginate"><xsl:value-of select="/Doc/Translations/Pages"/>:&nbsp;&nbsp;&nbsp;&nbsp; 
  	<xsl:for-each select="Doc/ThumbnailPages/Page">
  		<xsl:if test="CurrentThumbnailPageNumber = $ThumbnailPageStartItem">
  			<span class="this-page"><xsl:value-of select="CurrentThumbnailPageNumber"/></span>
  		</xsl:if>
  		<xsl:if test="CurrentThumbnailPageNumber != $ThumbnailPageStartItem">
  			<a href="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{ThumbnailPagePath}"><xsl:value-of select="CurrentThumbnailPageNumber"/></a>
  		</xsl:if>
  	</xsl:for-each>
  </div>
  
  <xsl:if test="/Doc/IncludeFooter = 1">
  <xsl:if test="/Doc/Footer/UseInfo = 1">
  	<div id="pagefoot">
  		<xsl:if test="/Doc/Footer/Text[string(.)] or /Doc/Footer/Author[string(.)] or /Doc/Footer/Date[string(.)]">
    		<div class="left">
    			<xsl:if test="/Doc/Footer/Text[string(.)]">
    				<xsl:value-of select="Doc/Footer/Text"/>
    				<xsl:if test="/Doc/Footer/Author[string(.)] or /Doc/Footer/Date[string(.)]">
    				&nbsp;&raquo;&nbsp;
    				</xsl:if>
    			</xsl:if>
    			<xsl:if test="/Doc/Footer/Author[string(.)]">
    				<xsl:value-of select="Doc/Footer/Author"/>
    				<xsl:if test="/Doc/Footer/Date[string(.)]">
    					&nbsp;&raquo;&nbsp;
    				</xsl:if>
    			</xsl:if>
    			<xsl:if test="/Doc/Footer/Date[string(.)]">
    				<xsl:value-of select="Doc/Footer/Date"/>
    			</xsl:if>
    		</div>
    	</xsl:if>
    	<xsl:if test="/Doc/Footer/Email[string(.)]">
    		<div class="right"><a href="mailto:{/Doc/Footer/Email}"><xsl:value-of select="Doc/Footer/Email"/></a></div>
    	</xsl:if>
    	<div class="clearer">&nbsp;</div>
  	</div>
  </xsl:if>
  
  <xsl:if test="/Doc/Footer/UseImage = 1">
  	<div id="logofoot"><img src="{/Doc/ThumbnailPages/Page[$ThumbnailPageStartItem]/ThumbnailPagePathPrefix}{/Doc/Footer/ImagePath}"/></div>
  </xsl:if>
  </xsl:if>
  
</div>
</body>
</html>

</xsl:template>
</xsl:stylesheet>